/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.feedbacks;

import com.intellij.designer.designSurface.feedbacks.RectangleFeedback;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class RoundRectangleFeedback
extends RectangleFeedback {
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private final int myRadius;

    public RoundRectangleFeedback(Color color, int line, int radius) {
        super(color, line);
        this.myRadius = radius;
    }

    @Override
    protected void paintFeedback(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(STROKE);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension size = this.getSize();
        g.drawRoundRect(0, 0, size.width - 1, size.height - 1, this.myRadius, this.myRadius);
        g2d.setStroke(oldStroke);
    }
}

