/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiEnumUtil {
    private JavaPsiEnumUtil() {
    }

    public static boolean isRestrictedStaticEnumField(@NotNull PsiField field, @NotNull PsiClass enumClass) {
        PsiClassType classType;
        PsiType type;
        if (field == null) {
            JavaPsiEnumUtil.$$$reportNull$$$0(0);
        }
        if (enumClass == null) {
            JavaPsiEnumUtil.$$$reportNull$$$0(1);
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        if (field.getContainingClass() != enumClass) {
            return false;
        }
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)field, JavaSdkVersion.JDK_1_6) && (type = field.getType()) instanceof PsiClassType && (classType = (PsiClassType)type).resolve() == enumClass) {
            return false;
        }
        return !PsiUtil.isCompileTimeConstant((PsiVariable)field);
    }

    @Nullable
    public static PsiClass getEnumClassForExpressionInInitializer(@NotNull PsiExpression expr) {
        PsiClass enumClass;
        if (expr == null) {
            JavaPsiEnumUtil.$$$reportNull$$$0(2);
        }
        if (PsiImplUtil.getSwitchLabel((PsiCaseLabelElement)expr) != null) {
            return null;
        }
        PsiMember constructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expr);
        if (constructorOrInitializer == null || constructorOrInitializer.hasModifierProperty("static")) {
            return null;
        }
        if (constructorOrInitializer instanceof PsiEnumConstantInitializer) {
            PsiEnumConstantInitializer initializer = (PsiEnumConstantInitializer)constructorOrInitializer;
            v0 = initializer;
        } else {
            v0 = enumClass = constructorOrInitializer.getContainingClass();
        }
        if (enumClass instanceof PsiEnumConstantInitializer) {
            enumClass = enumClass.getSuperClass();
        }
        return enumClass != null && enumClass.isEnum() ? enumClass : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiEnumUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRestrictedStaticEnumField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumClassForExpressionInInitializer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

