/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiVariableUtil {
    private JavaPsiVariableUtil() {
    }

    private static PsiVariable findSameNameSibling(@NotNull PsiVariable variable) {
        PsiElement[] children;
        if (variable == null) {
            JavaPsiVariableUtil.$$$reportNull$$$0(0);
        }
        PsiElement scope = variable.getParent();
        for (PsiElement child : children = scope.getChildren()) {
            if (!(child instanceof PsiVariable)) continue;
            PsiVariable psiVariable = (PsiVariable)child;
            if (child.equals((Object)variable) || !Objects.equals(variable.getName(), psiVariable.getName())) continue;
            return psiVariable;
        }
        return null;
    }

    private static PsiPatternVariable findSamePatternVariableInBranches(@NotNull PsiPatternVariable variable) {
        if (variable == null) {
            JavaPsiVariableUtil.$$$reportNull$$$0(1);
        }
        PsiPattern pattern = variable.getPattern();
        PatternResolveState hint = PatternResolveState.WHEN_TRUE;
        VariablesNotProcessor proc = new VariablesNotProcessor((PsiVariable)variable, false){

            protected boolean check(PsiVariable var, ResolveState state) {
                return var instanceof PsiPatternVariable && super.check(var, state);
            }
        };
        PsiPattern lastParent = pattern;
        for (PsiElement parent = lastParent.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiInstanceOfExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiDeconstructionList || parent instanceof PsiDeconstructionPattern)) {
                PsiPolyadicExpression expression;
                IElementType tokenType;
                if (parent instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent).getOperationTokenType().equals(JavaTokenType.EXCL)) {
                    hint = hint.invert();
                } else if (parent instanceof PsiPolyadicExpression && ((tokenType = (expression = (PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
                    PatternResolveState targetHint = PatternResolveState.fromBoolean((boolean)tokenType.equals(JavaTokenType.OROR));
                    if (hint == targetHint) {
                        for (PsiExpression operand : expression.getOperands()) {
                            if (operand == lastParent) break;
                            operand.processDeclarations((PsiScopeProcessor)proc, hint.putInto(ResolveState.initial()), null, (PsiElement)pattern);
                        }
                    }
                } else {
                    if (!(parent instanceof PsiConditionalExpression)) break;
                    PsiConditionalExpression conditional = (PsiConditionalExpression)parent;
                    PsiExpression thenExpression = conditional.getThenExpression();
                    if (lastParent == thenExpression) {
                        conditional.getCondition().processDeclarations((PsiScopeProcessor)proc, PatternResolveState.WHEN_FALSE.putInto(ResolveState.initial()), null, (PsiElement)pattern);
                        break;
                    }
                    if (lastParent != conditional.getElseExpression()) break;
                    conditional.getCondition().processDeclarations((PsiScopeProcessor)proc, PatternResolveState.WHEN_TRUE.putInto(ResolveState.initial()), null, (PsiElement)pattern);
                    if (thenExpression == null) break;
                    thenExpression.processDeclarations((PsiScopeProcessor)proc, hint.putInto(ResolveState.initial()), null, (PsiElement)pattern);
                    break;
                }
            }
            lastParent = parent;
        }
        return proc.size() > 0 ? (PsiPatternVariable)proc.getResult(0) : null;
    }

    @Nullable
    public static PsiVariable findPreviousVariableDeclaration(@NotNull PsiVariable variable) {
        if (variable == null) {
            JavaPsiVariableUtil.$$$reportNull$$$0(2);
        }
        if (variable instanceof ExternallyDefinedPsiElement || variable.isUnnamed()) {
            return null;
        }
        Object oldVariable = null;
        PsiElement declarationScope = null;
        if (variable instanceof PsiLocalVariable || variable instanceof PsiPatternVariable || variable instanceof PsiParameter && ((declarationScope = ((PsiParameter)variable).getDeclarationScope()) instanceof PsiCatchSection || declarationScope instanceof PsiForeachStatement || declarationScope instanceof PsiLambdaExpression)) {
            PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiFile.class, PsiMethod.class, PsiClassInitializer.class, PsiResourceList.class});
            VariablesNotProcessor proc = new VariablesNotProcessor(variable, false){

                protected boolean check(PsiVariable var, ResolveState state) {
                    return PsiUtil.isJvmLocalVariable((PsiElement)var) && super.check(var, state);
                }
            };
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            PsiScopesUtil.treeWalkUp((PsiScopeProcessor)proc, (PsiElement)identifier, (PsiElement)scope);
            if (scope instanceof PsiResourceList && proc.size() == 0) {
                scope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiFile.class, PsiMethod.class, PsiClassInitializer.class});
                PsiScopesUtil.treeWalkUp((PsiScopeProcessor)proc, (PsiElement)identifier, (PsiElement)scope);
            }
            if (proc.size() > 0) {
                oldVariable = proc.getResult(0);
            } else if (declarationScope instanceof PsiLambdaExpression) {
                oldVariable = JavaPsiVariableUtil.findSameNameSibling(variable);
            } else if (variable instanceof PsiPatternVariable) {
                oldVariable = JavaPsiVariableUtil.findSamePatternVariableInBranches((PsiPatternVariable)variable);
            }
        } else if (variable instanceof PsiField) {
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiField fieldByName = aClass.findFieldByName(variable.getName(), false);
            oldVariable = fieldByName != null && fieldByName != field ? fieldByName : (PsiVariable)ContainerUtil.find((Object[])aClass.getRecordComponents(), c -> field.getName().equals(c.getName()));
        } else {
            oldVariable = JavaPsiVariableUtil.findSameNameSibling(variable);
        }
        return oldVariable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "variable";
        objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiVariableUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSameNameSibling";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findSamePatternVariableInBranches";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPreviousVariableDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

