/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.java.codeserver.core.JpmsModuleInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaCompilerConfigurationProxy;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.JavaMultiReleaseUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 <2\u00020\u0001:\u0003:;<B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0002\u001a\u00020!H\u0002J(\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020&2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010*\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010+\u001a\u00020&H\u0002J\u0018\u0010,\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020&H\u0002J\u001a\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u001c2\b\u00100\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u00101\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\u001cH\u0002J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0005H\u00c6\u0003J\u001d\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u00105\u001a\u00020\u00132\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u00107\u001a\u000208H\u00d6\u0081\u0004J\n\u00109\u001a\u00020&H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006="}, d2={"Lcom/intellij/java/codeserver/core/JpmsModuleAccessInfo;", "", "current", "Lcom/intellij/java/codeserver/core/JpmsModuleInfo$CurrentModuleInfo;", "target", "Lcom/intellij/java/codeserver/core/JpmsModuleInfo$TargetModuleInfo;", "<init>", "(Lcom/intellij/java/codeserver/core/JpmsModuleInfo$CurrentModuleInfo;Lcom/intellij/java/codeserver/core/JpmsModuleInfo$TargetModuleInfo;)V", "getCurrent", "()Lcom/intellij/java/codeserver/core/JpmsModuleInfo$CurrentModuleInfo;", "getTarget", "()Lcom/intellij/java/codeserver/core/JpmsModuleInfo$TargetModuleInfo;", "checkAccess", "Lcom/intellij/java/codeserver/core/JpmsModuleAccessInfo$JpmsModuleAccessProblem;", "place", "Lcom/intellij/psi/PsiFileSystemItem;", "accessMode", "Lcom/intellij/java/codeserver/core/JpmsModuleAccessInfo$JpmsModuleAccessMode;", "isAccessible", "", "checkModuleAccess", "Lcom/intellij/psi/PsiElement;", "isExported", "accessibleFromJdkModules", "isJdkModule", "jpsModule", "Lcom/intellij/openapi/module/Module;", "psiModule", "Lcom/intellij/psi/PsiJavaModule;", "toLocalVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "inSameMultiReleaseModule", "Lcom/intellij/java/codeserver/core/JpmsModuleInfo;", "detectAutomaticModule", "hasUpgrade", "module", "targetName", "", "packageName", "isPatchedModule", "targetModuleName", "inAddedExports", "useName", "inAddedModules", "moduleName", "inAddedReads", "fromJavaModule", "toJavaModule", "isUnnamedModule", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "JpmsModuleAccessProblem", "JpmsModuleAccessMode", "Companion", "intellij.java.codeserver.core"})
@SourceDebugExtension(value={"SMAP\nJpmsModuleAccessInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpmsModuleAccessInfo.kt\ncom/intellij/java/codeserver/core/JpmsModuleAccessInfo\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n13225#2,2:314\n777#3:316\n873#3,2:317\n1586#3:319\n1661#3,3:320\n1404#3:323\n1496#3,5:324\n1807#3,3:329\n1404#3:332\n1496#3,5:333\n1807#3,3:338\n1404#3:341\n1496#3,5:342\n1807#3,2:347\n1809#3:350\n1807#3,3:351\n1807#3,3:354\n1#4:349\n*S KotlinDebug\n*F\n+ 1 JpmsModuleAccessInfo.kt\ncom/intellij/java/codeserver/core/JpmsModuleAccessInfo\n*L\n259#1:314,2\n278#1:316\n278#1:317,2\n279#1:319\n279#1:320,3\n280#1:323\n280#1:324,5\n281#1:329,3\n287#1:332\n287#1:333,5\n288#1:338,3\n295#1:341\n295#1:342,5\n296#1:347,2\n296#1:350\n198#1:351,3\n207#1:354,3\n*E\n"})
public final class JpmsModuleAccessInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JpmsModuleInfo.CurrentModuleInfo current;
    @NotNull
    private final JpmsModuleInfo.TargetModuleInfo target;
    @NotNull
    public static final String ALL_UNNAMED = "ALL-UNNAMED";
    @NotNull
    public static final String ALL_SYSTEM = "ALL-SYSTEM";
    @NotNull
    public static final String ALL_MODULE_PATH = "ALL-MODULE-PATH";
    @NotNull
    public static final String ADD_EXPORTS_OPTION = "--add-exports";
    @NotNull
    public static final String ADD_MODULES_OPTION = "--add-modules";
    @NotNull
    public static final String ADD_READS_OPTION = "--add-reads";

    public JpmsModuleAccessInfo(@NotNull JpmsModuleInfo.CurrentModuleInfo current, @NotNull JpmsModuleInfo.TargetModuleInfo target) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.current = current;
        this.target = target;
    }

    @NotNull
    public final JpmsModuleInfo.CurrentModuleInfo getCurrent() {
        return this.current;
    }

    @NotNull
    public final JpmsModuleInfo.TargetModuleInfo getTarget() {
        return this.target;
    }

    @Nullable
    public final JpmsModuleAccessProblem checkAccess(@NotNull PsiFileSystemItem place, @NotNull JpmsModuleAccessMode accessMode) {
        block18: {
            block14: {
                PsiJavaModule targetModule;
                block15: {
                    block17: {
                        Module currentJpsModule;
                        block16: {
                            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                            Intrinsics.checkNotNullParameter((Object)((Object)accessMode), (String)"accessMode");
                            targetModule = this.target.getModule();
                            if (targetModule == null) break block14;
                            if (Intrinsics.areEqual((Object)targetModule, (Object)this.current.getModule())) {
                                return null;
                            }
                            currentJpsModule = this.current.getJpsModule();
                            if (this.current.getModule() == null) {
                                VirtualFile origin;
                                PsiFile psiFile = targetModule.getContainingFile();
                                Object object = origin = psiFile != null ? psiFile.getVirtualFile() : null;
                                if (origin == null || currentJpsModule == null || ProjectFileIndex.getInstance((Project)currentJpsModule.getProject()).findContainingSdks(origin).isEmpty()) {
                                    return null;
                                }
                                if (!this.accessibleFromJdkModules((PsiElement)place, accessMode)) {
                                    String string = targetModule.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                    if (!this.inAddedModules(currentJpsModule, string)) {
                                        String string2 = targetModule.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                                        if (!this.hasUpgrade(currentJpsModule, string2, this.target.getPackageName(), place)) {
                                            return JpmsModuleAccessProblem.PACKAGE_NOT_IN_GRAPH;
                                        }
                                    }
                                }
                            }
                            if (targetModule instanceof LightJavaModule || JavaPsiModuleUtil.exports(targetModule, this.target.getPackageName(), this.current.getModule())) break block15;
                            if (currentJpsModule == null) break block16;
                            String string = targetModule.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            if (this.inAddedExports(currentJpsModule, string, this.target.getPackageName(), this.current.getName())) break block15;
                        }
                        if (currentJpsModule == null) break block17;
                        String string = targetModule.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (this.isPatchedModule(string, currentJpsModule, place)) break block15;
                    }
                    return this.current.getModule() == null ? JpmsModuleAccessProblem.FROM_UNNAMED : JpmsModuleAccessProblem.FROM_NAMED;
                }
                if (!(this.current.getModule() == null || Intrinsics.areEqual((Object)targetModule.getName(), (Object)"java.base") || this.isAccessible(accessMode) || this.inAddedReads(this.current.getModule(), targetModule))) {
                    return PsiNameHelper.isValidModuleName((String)targetModule.getName(), (PsiElement)((PsiElement)this.current.getModule())) ? JpmsModuleAccessProblem.PACKAGE_DOES_NOT_READ : JpmsModuleAccessProblem.PACKAGE_BAD_NAME;
                }
                break block18;
            }
            if (this.current.getModule() != null) {
                JpmsModuleInfo.TargetModuleInfoByJavaModule autoModule = new JpmsModuleInfo.TargetModuleInfoByJavaModule(this.detectAutomaticModule(this.target), this.target.getPackageName());
                if (autoModule.getModule() == null) {
                    return JpmsModuleAccessProblem.TO_UNNAMED;
                }
                if (!(new JpmsModuleAccessInfo(this.current, autoModule).isAccessible(accessMode) || this.inAddedReads(this.current.getModule(), null) || this.inSameMultiReleaseModule(this.current, this.target))) {
                    return JpmsModuleAccessProblem.TO_UNNAMED;
                }
            }
        }
        return null;
    }

    private final boolean isAccessible(JpmsModuleAccessMode accessMode) {
        return switch (WhenMappings.$EnumSwitchMapping$0[accessMode.ordinal()]) {
            case 1 -> this.isAccessible();
            case 2 -> this.isExported();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final JpmsModuleAccessProblem checkModuleAccess(@NotNull PsiElement place) {
        JpmsModuleInfo.TargetModuleInfoByJavaModule autoModule;
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        PsiJavaModule targetModule = this.target.getModule();
        if (targetModule != null) {
            if (Intrinsics.areEqual((Object)targetModule, (Object)this.current.getModule())) {
                return null;
            }
            Module currentJpsModule = this.current.getJpsModule();
            if (this.current.getModule() == null) {
                VirtualFile origin;
                PsiFile psiFile = targetModule.getContainingFile();
                Object object = origin = psiFile != null ? psiFile.getVirtualFile() : null;
                if (origin == null && targetModule instanceof LightJavaModule) {
                    origin = ((LightJavaModule)targetModule).getRootVirtualFile();
                }
                if (origin == null || currentJpsModule == null) {
                    return null;
                }
                if (ProjectFileIndex.getInstance((Project)currentJpsModule.getProject()).findContainingSdks(origin).isEmpty()) {
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)currentJpsModule);
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
                    GlobalSearchScope searchScope = globalSearchScope;
                    if (searchScope.contains(origin)) {
                        return null;
                    }
                    return JpmsModuleAccessProblem.JPS_DEPENDENCY_PROBLEM;
                }
                if (!this.accessibleFromJdkModules(place, JpmsModuleAccessMode.READ)) {
                    String string = targetModule.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!this.inAddedModules(currentJpsModule, string)) {
                        return JpmsModuleAccessProblem.NOT_IN_GRAPH;
                    }
                }
            }
            if (!(this.current.getModule() == null || Intrinsics.areEqual((Object)targetModule.getName(), (Object)"java.base") || this.isAccessible() || this.inAddedReads(this.current.getModule(), targetModule))) {
                return PsiNameHelper.isValidModuleName((String)targetModule.getName(), (PsiElement)((PsiElement)this.current.getModule())) ? JpmsModuleAccessProblem.DOES_NOT_READ : JpmsModuleAccessProblem.BAD_NAME;
            }
        } else if (!(this.current.getModule() == null || (autoModule = new JpmsModuleInfo.TargetModuleInfoByJavaModule(this.detectAutomaticModule(this.target), this.target.getPackageName())).getModule() == null || new JpmsModuleAccessInfo(this.current, autoModule).isAccessible() || this.inAddedReads(this.current.getModule(), null) || this.inSameMultiReleaseModule(this.current, this.target))) {
            return JpmsModuleAccessProblem.TO_UNNAMED;
        }
        return null;
    }

    public final boolean isExported() {
        PsiJavaModule psiJavaModule = this.target.getModule();
        if (psiJavaModule == null) {
            return false;
        }
        PsiJavaModule targetModule = psiJavaModule;
        if (!targetModule.isPhysical() || JavaPsiModuleUtil.exports(targetModule, this.target.getPackageName(), this.current.getModule())) {
            return true;
        }
        Module module = this.current.getJpsModule();
        if (module == null) {
            return false;
        }
        Module currentJpsModule = module;
        String string = targetModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.inAddedExports(currentJpsModule, string, this.target.getPackageName(), this.current.getName());
    }

    public final boolean isAccessible() {
        PsiJavaModule psiJavaModule = this.current.getModule();
        if (psiJavaModule == null) {
            return false;
        }
        PsiJavaModule currentModule = psiJavaModule;
        PsiJavaModule psiJavaModule2 = this.target.getModule();
        if (psiJavaModule2 == null) {
            return false;
        }
        PsiJavaModule targetModule = psiJavaModule2;
        return JavaPsiModuleUtil.reads(currentModule, targetModule);
    }

    private final boolean accessibleFromJdkModules(PsiElement place, JpmsModuleAccessMode accessMode) {
        PsiJavaModule javaSE;
        Module module = this.current.getJpsModule();
        if (module == null) {
            return false;
        }
        Module jpsModule = module;
        PsiJavaModule psiJavaModule = this.target.getModule();
        if (psiJavaModule == null) {
            return false;
        }
        PsiJavaModule targetModule = psiJavaModule;
        if (Intrinsics.areEqual((Object)targetModule.getName(), (Object)"java.base")) {
            return true;
        }
        if (!this.isJdkModule(jpsModule, targetModule)) {
            return false;
        }
        Function1 jdkModulePred = PsiUtil.isAvailable((JavaFeature)JavaFeature.AUTO_ROOT_MODULES, (PsiElement)place) ? JpmsModuleAccessInfo::accessibleFromJdkModules$lambda$0 : ((javaSE = (PsiJavaModule)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> JpmsModuleAccessInfo.accessibleFromJdkModules$lambda$1(place, jpsModule))) != null ? arg_0 -> JpmsModuleAccessInfo.accessibleFromJdkModules$lambda$2(javaSE, this, accessMode, jpsModule, arg_0) : JpmsModuleAccessInfo::accessibleFromJdkModules$lambda$3);
        Function1 noIncubatorPred = JpmsModuleAccessInfo::accessibleFromJdkModules$lambda$4;
        return (Boolean)jdkModulePred.invoke((Object)targetModule) != false && (Boolean)noIncubatorPred.invoke((Object)targetModule) != false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJdkModule(Module jpsModule, PsiJavaModule psiModule) {
        Sdk sdk = ModuleRootManager.getInstance((Module)jpsModule).getSdk();
        VirtualFile sdkHomePath = this.toLocalVirtualFile((VirtualFile)(sdk != null ? sdk.getHomeDirectory() : null));
        PsiFile psiFile = psiModule.getContainingFile();
        VirtualFile moduleFilePath = this.toLocalVirtualFile((VirtualFile)(psiFile != null ? psiFile.getVirtualFile() : null));
        if (sdkHomePath != null && moduleFilePath != null) {
            return VfsUtilCore.isAncestor((VirtualFile)sdkHomePath, (VirtualFile)moduleFilePath, (boolean)false);
        }
        String string = psiModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string, (String)"java.", (boolean)false, (int)2, null)) return true;
        String string2 = psiModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string2, (String)"jdk.", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final VirtualFile toLocalVirtualFile(VirtualFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = VfsUtilCore.getVirtualFileForJar((VirtualFile)file);
        if (virtualFile == null) {
            virtualFile = file;
        }
        return virtualFile;
    }

    private final boolean inSameMultiReleaseModule(JpmsModuleInfo current, JpmsModuleInfo target) {
        Module module = current.getJpsModule();
        if (module == null) {
            return false;
        }
        Module placeModule = module;
        Module module2 = target.getJpsModule();
        if (module2 == null) {
            return false;
        }
        Module targetModule = module2;
        return JavaMultiReleaseUtil.areMainAndAdditionalMultiReleaseModules((Module)targetModule, (Module)placeModule);
    }

    private final PsiJavaModule detectAutomaticModule(JpmsModuleInfo current) {
        Module module = current.getJpsModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        return JavaPsiFacade.getInstance((Project)module2.getProject()).findModule(LightJavaModule.moduleName((String)module2.getName()), GlobalSearchScope.moduleScope((Module)module2));
    }

    private final boolean hasUpgrade(Module module, String targetName, String packageName, PsiFileSystemItem place) {
        VirtualFile useVFile;
        PsiPackage target;
        if (PsiJavaModule.UPGRADEABLE.contains(targetName) && (target = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(packageName)) != null && (useVFile = place.getVirtualFile()) != null) {
            boolean bl;
            block2: {
                boolean test = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(useVFile);
                PsiDirectory[] psiDirectoryArray = target.getDirectories(module.getModuleWithDependenciesAndLibrariesScope(test));
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
                PsiDirectory[] dirs = psiDirectoryArray;
                ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)module.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
                ProjectFileIndex projectFileIndex2 = projectFileIndex;
                PsiDirectory[] $this$any$iv = dirs;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    PsiDirectory element$iv;
                    PsiDirectory it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!projectFileIndex2.findContainingSdks(it.getVirtualFile()).isEmpty()) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    private final boolean isPatchedModule(String targetModuleName, Module module, PsiFileSystemItem place) {
        VirtualFile virtualFile = place.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        VirtualFile virtualFile3 = ProjectRootManager.getInstance((Project)place.getProject()).getFileIndex().getSourceRootForFile(virtualFile2);
        if (virtualFile3 == null) {
            return false;
        }
        VirtualFile rootForFile = virtualFile3;
        return JavaCompilerConfigurationProxy.isPatchedModuleRoot((String)targetModuleName, (Module)module, (VirtualFile)rootForFile);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean inAddedExports(Module module, String targetName, String packageName, String useName) {
        boolean bl;
        block7: {
            void $this$any$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List options = JavaCompilerConfigurationProxy.getAdditionalOptions((Project)module.getProject(), (Module)module);
            if (options.isEmpty()) {
                return false;
            }
            String prefix = targetName + "/" + packageName + "=";
            List list = JavaCompilerConfigurationProxy.optionValues((List)options, (String)ADD_EXPORTS_OPTION);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"optionValues(...)");
            Iterable iterable = list;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                String string = it.substring(prefix.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collection.add(string);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$flatMapSequence = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl4 = false;
                String[] stringArray = new String[]{","};
                Sequence list$iv$iv = StringsKt.splitToSequence$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it2 = (String)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it2, (Object)useName)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean inAddedModules(Module module, String moduleName) {
        boolean bl;
        block4: {
            void $this$any$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            List options = JavaCompilerConfigurationProxy.getAdditionalOptions((Project)module.getProject(), (Module)module);
            List list = JavaCompilerConfigurationProxy.optionValues((List)options, (String)ADD_MODULES_OPTION);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"optionValues(...)");
            Iterable iterable = list;
            boolean $i$f$flatMapSequence = false;
            Iterator iterator = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                String[] stringArray = new String[]{","};
                Sequence list$iv$iv = StringsKt.splitToSequence$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)moduleName) || Intrinsics.areEqual((Object)it, (Object)ALL_SYSTEM) || Intrinsics.areEqual((Object)it, (Object)ALL_MODULE_PATH))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean inAddedReads(PsiJavaModule fromJavaModule, PsiJavaModule toJavaModule) {
        boolean bl;
        void $this$any$iv;
        Object object;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)fromJavaModule));
        if (module == null) {
            return false;
        }
        Module fromModule = module;
        List options = JavaCompilerConfigurationProxy.getAdditionalOptions((Project)fromModule.getProject(), (Module)fromModule);
        List list = JavaCompilerConfigurationProxy.optionValues((List)options, (String)ADD_READS_OPTION);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"optionValues(...)");
        Iterable iterable = list;
        boolean $i$f$flatMapSequence = false;
        Iterator iterator = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            String string = (String)t;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)string);
            object = new String[]{","};
            Sequence sequence = StringsKt.splitToSequence$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)sequence);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        iterator = $this$any$iv.iterator();
        do {
            List list2;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl3 = false;
            String[] stringArray = new String[]{"="};
            List list3 = list2 = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl4 = false;
            TuplesKt.to((Object)Character.valueOf(StringsKt.first((CharSequence)it)), (Object)Character.valueOf(StringsKt.last((CharSequence)it)));
            object = list2;
            String string = (String)object.get(0);
            String string2 = (String)object.get(1);
            if (Intrinsics.areEqual((Object)fromJavaModule.getName(), (Object)string)) {
                PsiJavaModule psiJavaModule = toJavaModule;
                if (Intrinsics.areEqual((Object)(psiJavaModule != null ? psiJavaModule.getName() : null), (Object)string2)) return true;
                if (Intrinsics.areEqual((Object)string2, (Object)ALL_UNNAMED) && this.isUnnamedModule(toJavaModule)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isUnnamedModule(PsiJavaModule module) {
        return module == null || module instanceof LightJavaModule;
    }

    @NotNull
    public final JpmsModuleInfo.CurrentModuleInfo component1() {
        return this.current;
    }

    @NotNull
    public final JpmsModuleInfo.TargetModuleInfo component2() {
        return this.target;
    }

    @NotNull
    public final JpmsModuleAccessInfo copy(@NotNull JpmsModuleInfo.CurrentModuleInfo current, @NotNull JpmsModuleInfo.TargetModuleInfo target) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new JpmsModuleAccessInfo(current, target);
    }

    public static /* synthetic */ JpmsModuleAccessInfo copy$default(JpmsModuleAccessInfo jpmsModuleAccessInfo, JpmsModuleInfo.CurrentModuleInfo currentModuleInfo, JpmsModuleInfo.TargetModuleInfo targetModuleInfo, int n, Object object) {
        if ((n & 1) != 0) {
            currentModuleInfo = jpmsModuleAccessInfo.current;
        }
        if ((n & 2) != 0) {
            targetModuleInfo = jpmsModuleAccessInfo.target;
        }
        return jpmsModuleAccessInfo.copy(currentModuleInfo, targetModuleInfo);
    }

    @NotNull
    public String toString() {
        return "JpmsModuleAccessInfo(current=" + this.current + ", target=" + this.target + ")";
    }

    public int hashCode() {
        int result = this.current.hashCode();
        result = result * 31 + this.target.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JpmsModuleAccessInfo)) {
            return false;
        }
        JpmsModuleAccessInfo jpmsModuleAccessInfo = (JpmsModuleAccessInfo)other;
        if (!Intrinsics.areEqual((Object)this.current, (Object)jpmsModuleAccessInfo.current)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.target, (Object)jpmsModuleAccessInfo.target);
    }

    private static final Module accessibleFromJdkModules$lambda$2$1(Module $jpsModule) {
        return $jpsModule;
    }

    private static final boolean accessibleFromJdkModules$lambda$0(PsiJavaModule module) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Iterable iterable = module.getExports();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getExports(...)");
            Iterable $this$any$iv = iterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiPackageAccessibilityStatement e = (PsiPackageAccessibilityStatement)element$iv;
                    boolean bl2 = false;
                    if (!e.getModuleNames().isEmpty()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final PsiJavaModule accessibleFromJdkModules$lambda$1(PsiElement $place, Module $jpsModule) {
        return JavaPsiFacade.getInstance((Project)$place.getProject()).findModule("java.se", $jpsModule.getModuleWithLibrariesScope());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean accessibleFromJdkModules$lambda$2(PsiJavaModule $javaSE, JpmsModuleAccessInfo this$0, JpmsModuleAccessMode $accessMode, Module $jpsModule, PsiJavaModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"java.", (boolean)false, (int)2, null)) {
            boolean bl;
            Iterable iterable = module.getExports();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getExports(...)");
            Iterable $this$any$iv = iterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiPackageAccessibilityStatement e = (PsiPackageAccessibilityStatement)element$iv;
                    boolean bl2 = false;
                    if (!e.getModuleNames().isEmpty()) continue;
                    return true;
                }
                bl = false;
            }
            if (bl) return true;
        }
        if (!new JpmsModuleAccessInfo(new JpmsModuleInfo.CurrentModuleInfo($javaSE, this$0.current.getName(), (Function0<? extends Module>)((Function0)() -> JpmsModuleAccessInfo.accessibleFromJdkModules$lambda$2$1($jpsModule))), this$0.target).isAccessible($accessMode)) return false;
        return true;
    }

    private static final boolean accessibleFromJdkModules$lambda$3(PsiJavaModule psiJavaModule) {
        Intrinsics.checkNotNullParameter((Object)psiJavaModule, (String)"<unused var>");
        return true;
    }

    private static final boolean accessibleFromJdkModules$lambda$4(PsiJavaModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return !module.doNotResolveByDefault();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/java/codeserver/core/JpmsModuleAccessInfo$Companion;", "", "<init>", "()V", "ALL_UNNAMED", "", "ALL_SYSTEM", "ALL_MODULE_PATH", "ADD_EXPORTS_OPTION", "ADD_MODULES_OPTION", "ADD_READS_OPTION", "intellij.java.codeserver.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/java/codeserver/core/JpmsModuleAccessInfo$JpmsModuleAccessMode;", "", "<init>", "(Ljava/lang/String;I)V", "READ", "EXPORT", "intellij.java.codeserver.core"})
    public static final class JpmsModuleAccessMode
    extends Enum<JpmsModuleAccessMode> {
        public static final /* enum */ JpmsModuleAccessMode READ = new JpmsModuleAccessMode();
        public static final /* enum */ JpmsModuleAccessMode EXPORT = new JpmsModuleAccessMode();
        private static final /* synthetic */ JpmsModuleAccessMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static JpmsModuleAccessMode[] values() {
            return (JpmsModuleAccessMode[])$VALUES.clone();
        }

        public static JpmsModuleAccessMode valueOf(String value) {
            return Enum.valueOf(JpmsModuleAccessMode.class, value);
        }

        @NotNull
        public static EnumEntries<JpmsModuleAccessMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = jpmsModuleAccessModeArray = new JpmsModuleAccessMode[]{JpmsModuleAccessMode.READ, JpmsModuleAccessMode.EXPORT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/java/codeserver/core/JpmsModuleAccessInfo$JpmsModuleAccessProblem;", "", "<init>", "(Ljava/lang/String;I)V", "FROM_NAMED", "FROM_UNNAMED", "TO_UNNAMED", "PACKAGE_BAD_NAME", "BAD_NAME", "PACKAGE_NOT_IN_GRAPH", "NOT_IN_GRAPH", "PACKAGE_DOES_NOT_READ", "DOES_NOT_READ", "JPS_DEPENDENCY_PROBLEM", "intellij.java.codeserver.core"})
    public static final class JpmsModuleAccessProblem
    extends Enum<JpmsModuleAccessProblem> {
        public static final /* enum */ JpmsModuleAccessProblem FROM_NAMED = new JpmsModuleAccessProblem();
        public static final /* enum */ JpmsModuleAccessProblem FROM_UNNAMED = new JpmsModuleAccessProblem();
        public static final /* enum */ JpmsModuleAccessProblem TO_UNNAMED = new JpmsModuleAccessProblem();
        public static final /* enum */ JpmsModuleAccessProblem PACKAGE_BAD_NAME = new JpmsModuleAccessProblem();
        public static final /* enum */ JpmsModuleAccessProblem BAD_NAME = new JpmsModuleAccessProblem();
        public static final /* enum */ JpmsModuleAccessProblem PACKAGE_NOT_IN_GRAPH = new JpmsModuleAccessProblem();
        public static final /* enum */ JpmsModuleAccessProblem NOT_IN_GRAPH = new JpmsModuleAccessProblem();
        public static final /* enum */ JpmsModuleAccessProblem PACKAGE_DOES_NOT_READ = new JpmsModuleAccessProblem();
        public static final /* enum */ JpmsModuleAccessProblem DOES_NOT_READ = new JpmsModuleAccessProblem();
        public static final /* enum */ JpmsModuleAccessProblem JPS_DEPENDENCY_PROBLEM = new JpmsModuleAccessProblem();
        private static final /* synthetic */ JpmsModuleAccessProblem[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static JpmsModuleAccessProblem[] values() {
            return (JpmsModuleAccessProblem[])$VALUES.clone();
        }

        public static JpmsModuleAccessProblem valueOf(String value) {
            return Enum.valueOf(JpmsModuleAccessProblem.class, value);
        }

        @NotNull
        public static EnumEntries<JpmsModuleAccessProblem> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = jpmsModuleAccessProblemArray = new JpmsModuleAccessProblem[]{JpmsModuleAccessProblem.FROM_NAMED, JpmsModuleAccessProblem.FROM_UNNAMED, JpmsModuleAccessProblem.TO_UNNAMED, JpmsModuleAccessProblem.PACKAGE_BAD_NAME, JpmsModuleAccessProblem.BAD_NAME, JpmsModuleAccessProblem.PACKAGE_NOT_IN_GRAPH, JpmsModuleAccessProblem.NOT_IN_GRAPH, JpmsModuleAccessProblem.PACKAGE_DOES_NOT_READ, JpmsModuleAccessProblem.DOES_NOT_READ, JpmsModuleAccessProblem.JPS_DEPENDENCY_PROBLEM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JpmsModuleAccessMode.values().length];
            try {
                nArray[JpmsModuleAccessMode.READ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JpmsModuleAccessMode.EXPORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

