/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.cache;

import com.intellij.application.options.codeStyle.cache.CodeStyleCachedValueProvider;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachedValueProviderKt;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachedValueProviderService;
import com.intellij.application.options.codeStyle.cache.TooFrequentCodeStyleComputationWatcher;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.FileCodeStyleProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u00015B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dJ\u0012\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u001fH\u0016J\u0006\u0010 \u001a\u00020\u001aJ'\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00022\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0000H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0014\u0010+\u001a\u00020\u00162\b\u0010,\u001a\u0004\u0018\u00010#H\u0096\u0082\u0004J\n\u0010-\u001a\u00020.H\u0096\u0080\u0004J\n\u0010/\u001a\u000200H\u0096\u0080\u0004J\u0012\u00101\u001a\u00020\u001a2\n\u00102\u001a\u000603j\u0002`4R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0016\u0010'\u001a\u0004\u0018\u00010(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00066"}, d2={"Lcom/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "fileSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "dataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "<init>", "(Ljava/util/function/Supplier;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/UserDataHolder;)V", "getFileSupplier", "()Ljava/util/function/Supplier;", "file", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "computation", "Lcom/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider$AsyncComputation;", "computationLock", "Ljava/util/concurrent/locks/Lock;", "isExpired", "", "()Z", "tryGetSettings", "scheduleWhenComputed", "", "runnable", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "cancelComputation", "getDependencies", "", "", "settings", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider$AsyncComputation;)[Ljava/lang/Object;", "logCached", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "equals", "other", "hashCode", "", "toString", "", "dumpState", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "AsyncComputation", "intellij.platform.codeStyle.impl"})
@SourceDebugExtension(value={"SMAP\nCodeStyleCachedValueProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeStyleCachedValueProvider.kt\ncom/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,348:1\n60#2,5:349\n60#2,5:354\n*S KotlinDebug\n*F\n+ 1 CodeStyleCachedValueProvider.kt\ncom/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider\n*L\n75#1:349,5\n103#1:354,5\n*E\n"})
public final class CodeStyleCachedValueProvider
implements CachedValueProvider<CodeStyleSettings> {
    @NotNull
    private final Supplier<VirtualFile> fileSupplier;
    @NotNull
    private final Project project;
    @NotNull
    private final UserDataHolder dataHolder;
    @NotNull
    private final AsyncComputation computation;
    @NotNull
    private final Lock computationLock;

    public CodeStyleCachedValueProvider(@NotNull Supplier<VirtualFile> fileSupplier, @NotNull Project project2, @NotNull UserDataHolder dataHolder) {
        Intrinsics.checkNotNullParameter(fileSupplier, (String)"fileSupplier");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        this.fileSupplier = fileSupplier;
        this.project = project2;
        this.dataHolder = dataHolder;
        this.computation = new AsyncComputation(this.project);
        this.computationLock = new ReentrantLock(){

            public boolean equals(Object other) {
                return other instanceof ReentrantLock;
            }
        };
    }

    @NotNull
    public final Supplier<VirtualFile> getFileSupplier() {
        return this.fileSupplier;
    }

    private final VirtualFile getFile() {
        VirtualFile virtualFile2 = this.fileSupplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"get(...)");
        return virtualFile2;
    }

    public final boolean isExpired() {
        return this.computation.isExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final CodeStyleSettings tryGetSettings() {
        if (this.computationLock.tryLock()) {
            try {
                CodeStyleSettings codeStyleSettings = (CodeStyleSettings)CachedValuesManager.getManager((Project)this.project).getCachedValue(this.dataHolder, (CachedValueProvider)this);
                return codeStyleSettings;
            }
            finally {
                this.computationLock.unlock();
            }
        }
        return null;
    }

    public final void scheduleWhenComputed(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.computation.schedule(runnable2);
    }

    @Nullable
    public CachedValueProvider.Result<CodeStyleSettings> compute() {
        CodeStyleSettings settings = null;
        try {
            settings = this.computation.getCurrentResult();
        }
        catch (ProcessCanceledException ignored) {
            this.computation.reset();
            Logger $this$debug_u24default$iv = CodeStyleCachedValueProviderKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger2 = $this$debug_u24default$iv;
                boolean bl = false;
                logger2.debug("Computation was cancelled for " + this.getFile().getName(), t$iv);
            }
            Object[] objectArray = new Object[]{ModificationTracker.EVER_CHANGED};
            return new CachedValueProvider.Result(null, objectArray);
        }
        if (settings != null) {
            this.logCached(settings);
            Object[] objectArray = this.getDependencies(settings, this.computation);
            return new CachedValueProvider.Result((Object)settings, Arrays.copyOf(objectArray, objectArray.length));
        }
        return null;
    }

    public final void cancelComputation() {
        this.computation.cancel();
    }

    private final Object[] getDependencies(CodeStyleSettings settings, AsyncComputation computation) {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        boolean bl = settings instanceof TransientCodeStyleSettings ? dependencies.addAll(((TransientCodeStyleSettings)settings).getDependencies()) : dependencies.add(settings.getModificationTracker());
        dependencies.add(computation.tracker);
        dependencies.add(() -> CodeStyleCachedValueProvider.getDependencies$lambda$0(this));
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)dependencies);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toObjectArray(...)");
        return objectArray;
    }

    private final void logCached(CodeStyleSettings settings) {
        Logger $this$debug_u24default$iv = CodeStyleCachedValueProviderKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug_u24default$iv;
            boolean bl = false;
            String string = "File: %s (%s), cached: %s, tracker: %d";
            Object[] objectArray = new Object[]{this.getFile().getName(), Integer.toHexString(this.getFile().hashCode()), settings, settings.getModificationTracker().getModificationCount()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger2.debug(string2, t$iv);
        }
    }

    private final PsiFile getPsiFile() {
        return this.getFile().isValid() ? PsiManager.getInstance((Project)this.project).findFile(this.getFile()) : null;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CodeStyleCachedValueProvider && Intrinsics.areEqual((Object)this.getFile(), (Object)((CodeStyleCachedValueProvider)other).getFile());
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    @NotNull
    public String toString() {
        return "CodeStyleCachedValueProvider@" + Integer.toHexString(super.hashCode()) + "(file=" + this.getFile() + ")";
    }

    public final void dumpState(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        sb.append("File: ").append(this.getFile().toString()).append('\n');
        sb.append("file.isValid == ").append(this.getFile().isValid()).append('\n');
        sb.append("Computation expired: ").append(this.isExpired()).append('\n');
        sb.append("Computation:\n");
        this.computation.dumpState(sb);
    }

    private static final long getDependencies$lambda$0(CodeStyleCachedValueProvider this$0) {
        return this$0.getFile().isValid() ? 0L : 1L;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u001bJ\u0012\u0010\u001f\u001a\u00020\u001b2\n\u0010 \u001a\u00060\u0013j\u0002`\u0014J\b\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u0004\u0018\u00010\tJ\u0006\u0010&\u001a\u00020\u001bJ\u0012\u0010'\u001a\u00020\u001b2\b\b\u0002\u0010(\u001a\u00020\u0019H\u0002J\u0014\u0010)\u001a\u00020\u00192\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010+\u001a\u00020,H\u0096\u0080\u0004J\u0012\u0010-\u001a\u00020\u001b2\n\u0010.\u001a\u00060/j\u0002`0R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u0012j\f\u0012\b\u0012\u00060\u0013j\u0002`\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00061"}, d2={"Lcom/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider$AsyncComputation;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider;Lcom/intellij/openapi/project/Project;)V", "isActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "currentResult", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "settingsManager", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsManager;", "kotlin.jvm.PlatformType", "tracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "job", "Lkotlinx/coroutines/Job;", "scheduledRunnables", "Ljava/util/ArrayList;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "Lkotlin/collections/ArrayList;", "oldTrackerSetting", "", "insideRestartedComputation", "", "start", "", "cancel", "isExpired", "()Z", "schedule", "runnable", "computeSettings", "getCurrentSettings", "file", "Lcom/intellij/psi/PsiFile;", "getCurrentResult", "reset", "notifyCachedValueComputed", "shouldFireEvent", "equals", "other", "hashCode", "", "dumpState", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.platform.codeStyle.impl"})
    @SourceDebugExtension(value={"SMAP\nCodeStyleCachedValueProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeStyleCachedValueProvider.kt\ncom/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider$AsyncComputation\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,348:1\n60#2,5:349\n60#2,5:356\n60#2,5:363\n60#2,5:368\n60#2,5:373\n60#2,5:378\n60#2,5:383\n60#2,5:388\n60#2,5:393\n60#2,5:398\n60#2,5:403\n60#2,5:408\n60#2,5:413\n60#2,5:418\n30#3,2:354\n30#3,2:361\n*S KotlinDebug\n*F\n+ 1 CodeStyleCachedValueProvider.kt\ncom/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider$AsyncComputation\n*L\n133#1:349,5\n150#1:356,5\n164#1:363,5\n196#1:368,5\n203#1:373,5\n205#1:378,5\n207#1:383,5\n211#1:388,5\n229#1:393,5\n245#1:398,5\n254#1:403,5\n264#1:408,5\n272#1:413,5\n299#1:418,5\n134#1:354,2\n156#1:361,2\n*E\n"})
    private final class AsyncComputation {
        @NotNull
        private final Project project;
        @NotNull
        private final AtomicBoolean isActive;
        @Nullable
        private volatile CodeStyleSettings currentResult;
        private final CodeStyleSettingsManager settingsManager;
        @JvmField
        @NotNull
        public final SimpleModificationTracker tracker;
        @Nullable
        private Job job;
        @NotNull
        private final ArrayList<Runnable> scheduledRunnables;
        private long oldTrackerSetting;
        private boolean insideRestartedComputation;

        public AsyncComputation(Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
            this.isActive = new AtomicBoolean();
            this.settingsManager = CodeStyleSettingsManager.getInstance((Project)this.project);
            this.tracker = new SimpleModificationTracker();
            this.scheduledRunnables = new ArrayList();
            this.currentResult = this.settingsManager.getCurrentSettings();
        }

        /*
         * WARNING - void declaration
         */
        private final void start() {
            Application app = ApplicationManager.getApplication();
            if ((app.isDispatchThread() || app.isWriteAccessAllowed()) && !app.isUnitTestMode() && !app.isHeadlessEnvironment()) {
                void $this$debug_u24default$iv;
                Logger logger2 = CodeStyleCachedValueProviderKt.access$getLOG$p();
                CodeStyleCachedValueProvider codeStyleCachedValueProvider = CodeStyleCachedValueProvider.this;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var7_13 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var7_13.debug("async for " + codeStyleCachedValueProvider.getFile().getName(), t$iv);
                }
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<CodeStyleCachedValueProviderService> serviceClass$iv = CodeStyleCachedValueProviderService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                this.job = BuildersKt.launch$default((CoroutineScope)((CodeStyleCachedValueProviderService)object).coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineName(CodeStyleCachedValueProvider.this.toString())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    boolean Z$0;
                    int label;
                    final /* synthetic */ AsyncComputation this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.application.options.codeStyle.cache.CodeStyleCachedValueProvider$AsyncComputation ), ()Ljava/lang/Boolean;)((AsyncComputation)this.this$0), (Continuation)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                success = (Boolean)v0;
                                v1 = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                                v2 = ModalityState.any();
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"any(...)");
                                this.Z$0 = success;
                                this.label = 2;
                                v3 = BuildersKt.withContext((CoroutineContext)v1.plus(ModalityKt.asContextElement((ModalityState)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, success != false, null){
                                    int label;
                                    final /* synthetic */ AsyncComputation this$0;
                                    final /* synthetic */ boolean $success;
                                    {
                                        this.this$0 = $receiver;
                                        this.$success = $success;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = CoroutinesKt.writeIntentReadAction(() -> start.1.invokeSuspend$lambda$0(this.this$0, this.$success), (Continuation)((Continuation)this));
                                                if (object2 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }

                                    private static final Unit invokeSuspend$lambda$0(AsyncComputation this$0, boolean $success) {
                                        AsyncComputation.access$notifyCachedValueComputed(this$0, $success);
                                        return Unit.INSTANCE;
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v3 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl27
                            }
                            case 2: {
                                success = this.Z$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl27:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final boolean invokeSuspend$lambda$0(AsyncComputation this$0) {
                        return AsyncComputation.access$computeSettings(this$0);
                    }
                }), (int)2, null);
            } else {
                void $this$debug_u24default$iv;
                Logger $this$service$iv = CodeStyleCachedValueProviderKt.access$getLOG$p();
                CodeStyleCachedValueProvider serviceClass$iv = CodeStyleCachedValueProvider.this;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var7_14 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var7_14.debug("sync for " + serviceClass$iv.getFile().getName(), t$iv);
                }
                Boolean success2 = (Boolean)app.runReadAction(this::computeSettings);
                if (app.isDispatchThread()) {
                    Intrinsics.checkNotNull((Object)success2);
                    this.notifyCachedValueComputed(success2);
                } else {
                    ComponentManager $this$service$iv2 = (ComponentManager)this.project;
                    boolean $i$f$service = false;
                    Class<CodeStyleCachedValueProviderService> serviceClass$iv2 = CodeStyleCachedValueProviderService.class;
                    Object object = $this$service$iv2.getService(serviceClass$iv2);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
                    }
                    CoroutineScope coroutineScope = ((CodeStyleCachedValueProviderService)object).coroutineScope;
                    CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                    ModalityState modalityState = ModalityState.any();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                    BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, success2, null){
                        int label;
                        final /* synthetic */ AsyncComputation this$0;
                        final /* synthetic */ Boolean $success;
                        {
                            this.this$0 = $receiver;
                            this.$success = $success;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Boolean bl = this.$success;
                                    Intrinsics.checkNotNull((Object)bl);
                                    AsyncComputation.access$notifyCachedValueComputed(this.this$0, bl);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void cancel() {
            void $this$debug_u24default$iv;
            Logger logger2 = CodeStyleCachedValueProviderKt.access$getLOG$p();
            CodeStyleCachedValueProvider codeStyleCachedValueProvider = CodeStyleCachedValueProvider.this;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                void var6_5 = $this$debug_u24default$iv;
                boolean bl = false;
                var6_5.debug("expire computation for " + codeStyleCachedValueProvider.getFile().getName(), t$iv);
            }
            Job job2 = this.job;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.currentResult = null;
        }

        public final boolean isExpired() {
            return this.currentResult == null;
        }

        public final void schedule(@NotNull Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            if (this.isActive.get()) {
                this.scheduledRunnables.add(ClientId.Companion.decorateRunnable(runnable2));
            } else {
                runnable2.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean computeSettings() {
            VirtualFile file2 = CodeStyleCachedValueProvider.this.getFile();
            PsiFile psiFile = CodeStyleCachedValueProvider.this.getPsiFile();
            if (psiFile == null || !psiFile.isValid()) {
                this.cancel();
                return false;
            }
            CodeStyleCachedValueProvider.this.computationLock.lock();
            try {
                Logger logger2;
                Logger $this$debug_u24default$iv = CodeStyleCachedValueProviderKt.access$getLOG$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger2 = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger2.debug("Computation started for " + file2.getName(), t$iv);
                }
                CodeStyleSettings currSettings = this.getCurrentSettings(psiFile);
                this.oldTrackerSetting = currSettings.getModificationTracker().getModificationCount();
                if (currSettings != this.settingsManager.getTemporarySettings()) {
                    TransientCodeStyleSettings modifiableSettings = new TransientCodeStyleSettings(CodeStyleCachedValueProvider.this.getFile(), this.project, currSettings);
                    modifiableSettings.applyIndentOptionsFromProviders(this.project, file2);
                    Logger $this$debug_u24default$iv2 = CodeStyleCachedValueProviderKt.access$getLOG$p();
                    Throwable t$iv2 = null;
                    boolean $i$f$debug2 = false;
                    if ($this$debug_u24default$iv2.isDebugEnabled()) {
                        logger2 = $this$debug_u24default$iv2;
                        boolean bl = false;
                        logger2.debug("Created TransientCodeStyleSettings for " + file2.getName(), t$iv2);
                    }
                    for (CodeStyleSettingsModifier modifier : CodeStyleSettingsModifier.EP_NAME.getExtensionList()) {
                        Logger $this$debug_u24default$iv3 = CodeStyleCachedValueProviderKt.access$getLOG$p();
                        Throwable t$iv3 = null;
                        boolean $i$f$debug3 = false;
                        if ($this$debug_u24default$iv3.isDebugEnabled()) {
                            logger2 = $this$debug_u24default$iv3;
                            boolean bl = false;
                            logger2.debug("Modifying " + file2.getName() + ": " + modifier.getClass().getName(), t$iv3);
                        }
                        if (modifier.modifySettingsAndUiCustomization(modifiableSettings, psiFile) || modifiableSettings.getModifier() != null) {
                            $this$debug_u24default$iv3 = CodeStyleCachedValueProviderKt.access$getLOG$p();
                            t$iv3 = null;
                            $i$f$debug3 = false;
                            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                                logger2 = $this$debug_u24default$iv3;
                                boolean bl = false;
                                logger2.debug("Modified " + file2.getName() + ": " + modifier.getClass().getName(), t$iv3);
                            }
                            currSettings = (CodeStyleSettings)modifiableSettings;
                        }
                        if (modifiableSettings.getModifier() == null) continue;
                        $this$debug_u24default$iv3 = CodeStyleCachedValueProviderKt.access$getLOG$p();
                        t$iv3 = null;
                        $i$f$debug3 = false;
                        if (!$this$debug_u24default$iv3.isDebugEnabled()) break;
                        logger2 = $this$debug_u24default$iv3;
                        boolean bl = false;
                        logger2.debug("Indenter for " + file2.getName() + ": " + modifier.getClass().getName(), t$iv3);
                        break;
                    }
                }
                if (this.currentResult != currSettings) {
                    this.currentResult = currSettings;
                    this.tracker.incModificationCount();
                    CodeStyleSettings cachedSettings = CodeStyleCachedValueProvider.this.tryGetSettings();
                    if (this.currentResult != cachedSettings) {
                        CodeStyleCachedValueProviderKt.access$getLOG$p().error("Cache corruption: check `isActive` protection inside the `getCurrentResult()`!");
                    }
                }
                Logger $this$debug_u24default$iv4 = CodeStyleCachedValueProviderKt.access$getLOG$p();
                Throwable t$iv4 = null;
                boolean $i$f$debug4 = false;
                if ($this$debug_u24default$iv4.isDebugEnabled()) {
                    logger2 = $this$debug_u24default$iv4;
                    boolean bl = false;
                    logger2.debug("Computation ended for " + file2.getName(), t$iv4);
                }
            }
            finally {
                CodeStyleCachedValueProvider.this.computationLock.unlock();
            }
            return true;
        }

        private final CodeStyleSettings getCurrentSettings(PsiFile file2) {
            CodeStyleSettings result2 = (CodeStyleSettings)FileCodeStyleProvider.EP_NAME.computeSafeIfAny(arg_0 -> AsyncComputation.getCurrentSettings$lambda$0(file2, arg_0));
            CodeStyleSettings codeStyleSettings = result2;
            if (codeStyleSettings == null) {
                CodeStyleSettings codeStyleSettings2 = this.settingsManager.getCurrentSettings();
                codeStyleSettings = codeStyleSettings2;
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings2, (String)"getCurrentSettings(...)");
            }
            return codeStyleSettings;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final CodeStyleSettings getCurrentResult() {
            if (this.isActive.compareAndSet(false, true)) {
                void $this$debug_u24default$iv;
                Logger logger2 = CodeStyleCachedValueProviderKt.access$getLOG$p();
                CodeStyleCachedValueProvider codeStyleCachedValueProvider = CodeStyleCachedValueProvider.this;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var6_5 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var6_5.debug("Computation initiated for " + codeStyleCachedValueProvider.getFile().getName(), t$iv);
                }
                this.start();
            }
            return this.currentResult;
        }

        /*
         * WARNING - void declaration
         */
        public final void reset() {
            void $this$debug_u24default$iv;
            this.scheduledRunnables.clear();
            this.isActive.set(false);
            Logger logger2 = CodeStyleCachedValueProviderKt.access$getLOG$p();
            CodeStyleCachedValueProvider codeStyleCachedValueProvider = CodeStyleCachedValueProvider.this;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                void var6_5 = $this$debug_u24default$iv;
                boolean bl = false;
                var6_5.debug("Computation reset for " + codeStyleCachedValueProvider.getFile().getName(), t$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void notifyCachedValueComputed(boolean shouldFireEvent) {
            Logger eventSettings;
            Object object;
            CodeStyleSettings codeStyleSettings = this.settingsManager.getCurrentSettings();
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCurrentSettings(...)");
            CodeStyleSettings currentProjectSettings = codeStyleSettings;
            long newTrackerSetting = currentProjectSettings.getModificationTracker().getModificationCount();
            if (this.oldTrackerSetting < newTrackerSetting && !this.insideRestartedComputation) {
                this.insideRestartedComputation = true;
                try {
                    void $this$debug_u24default$iv;
                    Logger logger2 = CodeStyleCachedValueProviderKt.access$getLOG$p();
                    CodeStyleCachedValueProvider codeStyleCachedValueProvider = CodeStyleCachedValueProvider.this;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var10_13 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var10_13.debug("restarted for " + codeStyleCachedValueProvider.getFile().getName(), t$iv);
                    }
                    this.start();
                }
                finally {
                    this.insideRestartedComputation = false;
                }
                return;
            }
            Object $this$debug_u24default$iv = CodeStyleCachedValueProviderKt.access$getLOG$p();
            CodeStyleCachedValueProvider codeStyleCachedValueProvider = CodeStyleCachedValueProvider.this;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                object = $this$debug_u24default$iv;
                boolean bl = false;
                object.debug("running scheduled runnables for " + codeStyleCachedValueProvider.getFile().getName(), t$iv);
            }
            Iterator<Runnable> iterator2 = this.scheduledRunnables.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            $this$debug_u24default$iv = iterator2;
            while ($this$debug_u24default$iv.hasNext()) {
                Object e = $this$debug_u24default$iv.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Runnable runnable2 = (Runnable)e;
                runnable2.run();
            }
            if (shouldFireEvent && !this.project.isDisposed() && !TooFrequentCodeStyleComputationWatcher.Companion.getInstance(this.project).isTooHighEvictionRateDetected() && Registry.Companion.is("code.style.cache.enable.change.events.on.settings.cached")) {
                eventSettings = Registry.Companion.is("code.style.cache.change.events.include.settings") ? this.currentResult : null;
                this.settingsManager.fireCodeStyleSettingsChanged(CodeStyleCachedValueProvider.this.getFile(), (CodeStyleSettings)eventSettings);
            }
            CodeStyleCachedValueProvider.this.computation.reset();
            eventSettings = CodeStyleCachedValueProviderKt.access$getLOG$p();
            codeStyleCachedValueProvider = CodeStyleCachedValueProvider.this;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                object = $this$debug_u24default$iv;
                boolean bl = false;
                object.debug("Computation finished normally for " + codeStyleCachedValueProvider.getFile().getName(), t$iv);
            }
        }

        static /* synthetic */ void notifyCachedValueComputed$default(AsyncComputation asyncComputation, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            asyncComputation.notifyCachedValueComputed(bl);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            AsyncComputation that = (AsyncComputation)other;
            return Intrinsics.areEqual((Object)this.project, (Object)that.project);
        }

        public int hashCode() {
            return this.project.hashCode();
        }

        public final void dumpState(@NotNull StringBuilder sb) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            sb.append("isActive: ").append(this.isActive.get()).append('\n');
            sb.append("computation tracker: ").append(this.tracker.getModificationCount()).append('\n');
            sb.append("oldTrackerSetting: ").append(this.oldTrackerSetting).append('\n');
            sb.append("insideRestartedComputation: ").append(this.insideRestartedComputation).append('\n');
            sb.append("Current result: ").append(this.currentResult).append('\n');
            sb.append("Scheduled runnables: ").append(this.scheduledRunnables.size()).append('\n');
            sb.append("Job: ").append(this.job).append('\n');
        }

        private static final CodeStyleSettings getCurrentSettings$lambda$0(PsiFile $file, FileCodeStyleProvider it) {
            return it.getSettings($file);
        }

        public static final /* synthetic */ void access$notifyCachedValueComputed(AsyncComputation $this, boolean shouldFireEvent) {
            $this.notifyCachedValueComputed(shouldFireEvent);
        }

        public static final /* synthetic */ boolean access$computeSettings(AsyncComputation $this) {
            return $this.computeSettings();
        }
    }
}

