/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.environment.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.intellij.ide.environment.EnvironmentKey;
import com.intellij.ide.environment.EnvironmentKeyKt;
import com.intellij.ide.environment.EnvironmentService;
import com.intellij.ide.environment.impl.BaseEnvironmentService;
import com.intellij.ide.environment.impl.EnvironmentUtil;
import com.intellij.ide.environment.impl.HeadlessEnvironmentService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.configuration.HeadlessLogging;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0002R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/environment/impl/HeadlessEnvironmentService;", "Lcom/intellij/ide/environment/impl/BaseEnvironmentService;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "configurationFileModel", "Lkotlinx/coroutines/Deferred;", "", "", "getEnvironmentValue", "key", "Lcom/intellij/ide/environment/EnvironmentKey;", "(Lcom/intellij/ide/environment/EnvironmentKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "defaultValue", "(Lcom/intellij/ide/environment/EnvironmentKey;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getEnvironmentValueOrNull", "getModelFromFile", "MissingEnvironmentKeyException", "EnvironmentKeyEntry", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHeadlessEnvironmentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeadlessEnvironmentService.kt\ncom/intellij/ide/environment/impl/HeadlessEnvironmentService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,105:1\n13#2:106\n13#2:107\n*S KotlinDebug\n*F\n+ 1 HeadlessEnvironmentService.kt\ncom/intellij/ide/environment/impl/HeadlessEnvironmentService\n*L\n43#1:106\n50#1:107\n*E\n"})
public final class HeadlessEnvironmentService
extends BaseEnvironmentService {
    @NotNull
    private final Deferred<Map<String, String>> configurationFileModel;

    public HeadlessEnvironmentService(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.configurationFileModel = BuildersKt.async((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends String>>, Object>(this, null){
            int label;
            final /* synthetic */ HeadlessEnvironmentService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return HeadlessEnvironmentService.access$getModelFromFile(this.this$0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object getEnvironmentValue(@NotNull EnvironmentKey key, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof getEnvironmentValue.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ HeadlessEnvironmentService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getEnvironmentValue(null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = key;
                $continuation.label = 1;
                v0 = this.getEnvironmentValueOrNull(key, (Continuation<? super String>)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                key = (EnvironmentKey)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = (String)v0;
                if (v1 == null) {
                    $this$getEnvironmentValue_u24lambda_u240 = this;
                    $i$a$-run-HeadlessEnvironmentService$getEnvironmentValue$2 = false;
                    throwable = new MissingEnvironmentKeyException(key);
                    HeadlessLogging.INSTANCE.logFatalError((Throwable)new MissingEnvironmentKeyException(key));
                    throw throwable;
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object getEnvironmentValue(@NotNull EnvironmentKey key, @NotNull String defaultValue, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof getEnvironmentValue.3)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ HeadlessEnvironmentService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getEnvironmentValue(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)key);
                $continuation.L$1 = defaultValue;
                $continuation.label = 1;
                v0 = this.getEnvironmentValueOrNull(key, (Continuation<? super String>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                defaultValue = (String)$continuation.L$1;
                key = (EnvironmentKey)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((v1 = (String)v0) == null) {
                    v1 = defaultValue;
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getEnvironmentValueOrNull(EnvironmentKey key, Continuation<? super String> $completion) {
        if (!($completion instanceof getEnvironmentValueOrNull.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ HeadlessEnvironmentService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HeadlessEnvironmentService.access$getEnvironmentValueOrNull(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    BaseEnvironmentService.getLOG().warn("Access to environment parameters in the IDE with UI must be delegated to the user");
                }
                this.checkKeyRegistered(key);
                valueFromEnvironmentVariable = System.getProperty(key.getId());
                if (valueFromEnvironmentVariable != null) {
                    $i$f$logger = false;
                    v0 = Logger.getInstance(EnvironmentService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                    v0.info("Obtained value for " + key.getId() + " from a system property: " + valueFromEnvironmentVariable);
                    return valueFromEnvironmentVariable;
                }
                $continuation.L$0 = key;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)valueFromEnvironmentVariable);
                $continuation.label = 1;
                v1 = this.configurationFileModel.await((Continuation)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl35
            }
            case 1: {
                valueFromEnvironmentVariable = (String)$continuation.L$1;
                key = (EnvironmentKey)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                if ((valueFromConfigurationFile = (String)(mapping = (Map)v1).get(key.getId())) != null) {
                    $i$f$logger = false;
                    v2 = Logger.getInstance(EnvironmentService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    v2.info("Obtained value for " + key.getId() + " from the configuration file: " + valueFromConfigurationFile);
                    return valueFromConfigurationFile;
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Map<String, String> getModelFromFile() {
        Object object;
        Path path = EnvironmentUtil.INSTANCE.getPathToConfigurationFile();
        if (path == null) {
            return MapsKt.emptyMap();
        }
        Path pathToFile = path;
        ObjectMapper objectMapper = new ObjectMapper();
        CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, EnvironmentKeyEntry.class);
        Intrinsics.checkNotNullExpressionValue((Object)collectionType, (String)"constructCollectionType(...)");
        CollectionType deserializedType = collectionType;
        try {
            object = objectMapper.readValue(pathToFile.toFile(), (JavaType)deserializedType);
            Intrinsics.checkNotNull((Object)object);
            object = (List)object;
        }
        catch (IOException e) {
            BaseEnvironmentService.getLOG().warn((Throwable)e);
            return MapsKt.emptyMap();
        }
        Object list2 = object;
        Map mapping = new LinkedHashMap();
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            EnvironmentKeyEntry jsonEntry = (EnvironmentKeyEntry)iterator2.next();
            String key = jsonEntry.getKey();
            String value = jsonEntry.getValue();
            if (key == null || value == null) {
                BaseEnvironmentService.getLOG().warn("Malformed JSON entry in " + pathToFile + ": " + key + ", " + value);
                continue;
            }
            if (((CharSequence)value).length() == 0) continue;
            mapping.put(key, value);
        }
        return mapping;
    }

    public static final /* synthetic */ Object access$getEnvironmentValueOrNull(HeadlessEnvironmentService $this, EnvironmentKey key, Continuation $completion) {
        return $this.getEnvironmentValueOrNull(key, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Map access$getModelFromFile(HeadlessEnvironmentService $this) {
        return $this.getModelFromFile();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0003\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/environment/impl/HeadlessEnvironmentService$EnvironmentKeyEntry;", "", "<init>", "()V", "description", "getDescription$annotations", "getDescription", "()Ljava/lang/Object;", "setDescription", "(Ljava/lang/Object;)V", "key", "", "getKey", "()Ljava/lang/String;", "setKey", "(Ljava/lang/String;)V", "value", "getValue", "setValue", "intellij.platform.ide.impl"})
    private static final class EnvironmentKeyEntry {
        @Nullable
        private Object description;
        @Nullable
        private String key;
        @Nullable
        private String value;

        @Nullable
        public final Object getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable Object object) {
            this.description = object;
        }

        public static /* synthetic */ void getDescription$annotations() {
        }

        @Nullable
        public final String getKey() {
            return this.key;
        }

        public final void setKey(@Nullable String string) {
            this.key = string;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        public final void setValue(@Nullable String string) {
            this.value = string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/environment/impl/HeadlessEnvironmentService$MissingEnvironmentKeyException;", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "key", "Lcom/intellij/ide/environment/EnvironmentKey;", "<init>", "(Lcom/intellij/ide/environment/EnvironmentKey;)V", "getKey", "()Lcom/intellij/ide/environment/EnvironmentKey;", "intellij.platform.ide.impl"})
    public static final class MissingEnvironmentKeyException
    extends CancellationException {
        @NotNull
        private final EnvironmentKey key;

        public MissingEnvironmentKeyException(@NotNull EnvironmentKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(StringsKt.trimMargin$default((String)("Missing value for the environment key '" + key.getId() + "'\n      |The value can be set as a system property (`-D" + key.getId() + "=<value>` in the VM options),\n      |or as an entry in the JSON configuration file (the command-line starter `./idea.sh generateEnvironmentKeysFile`).\n      |\n      |Description of " + key.getId() + ":\n      |" + EnvironmentKeyKt.getDescription((EnvironmentKey)key) + "\n      |"), null, (int)1, null));
            this.key = key;
        }

        @NotNull
        public final EnvironmentKey getKey() {
            return this.key;
        }
    }
}

