/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.MarketplaceTabSearchSortByOptions;
import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u000b2\u00020\u0001:\u0003\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0014R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/plugins/newui/SearchQueryParser;", "", "<init>", "()V", "searchQuery", "", "addToSearchQuery", "", "query", "Marketplace", "Installed", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public abstract class SearchQueryParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @Nullable
    public String searchQuery;

    protected void addToSearchQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.searchQuery = this.searchQuery == null ? query : this.searchQuery + " " + query;
    }

    @JvmStatic
    @NotNull
    public static final String getTagQuery(@NotNull String tag) {
        return Companion.getTagQuery(tag);
    }

    @JvmStatic
    @NotNull
    public static final String wrapAttribute(@NotNull String value) {
        return Companion.wrapAttribute(value);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0004J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/plugins/newui/SearchQueryParser$Companion;", "", "<init>", "()V", "splitQuery", "", "", "query", "getTagQuery", "tag", "wrapAttribute", "value", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final List<String> splitQuery(@NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            List words = new ArrayList();
            int length = query.length();
            int index = 0;
            block0: while (index < length) {
                char startCh;
                if ((startCh = query.charAt(index++)) == ' ') continue;
                if (startCh == '\"') {
                    int end = StringsKt.indexOf$default((CharSequence)query, (char)'\"', (int)index, (boolean)false, (int)4, null);
                    if (end == -1) break;
                    String string = query.substring(index, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    words.add(string);
                    index = end + 1;
                    continue;
                }
                int start2 = index - 1;
                while (index <= length) {
                    char nextCh;
                    if (index == length) {
                        String string = query.substring(start2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        words.add(string);
                        continue block0;
                    }
                    if ((nextCh = query.charAt(index++)) != ':' && nextCh != ' ' && index != length) continue;
                    String string = query.substring(start2, nextCh == ' ' ? index - 1 : index);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    words.add(string);
                    continue block0;
                }
            }
            return words;
        }

        @JvmStatic
        @NotNull
        public final String getTagQuery(@NotNull String tag) {
            String string;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            if (StringsKt.indexOf$default((CharSequence)tag, (char)' ', (int)0, (boolean)false, (int)6, null) == -1) {
                string = tag;
            } else {
                String string2 = StringUtil.wrapWithDoubleQuote((String)tag);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wrapWithDoubleQuote(...)");
            }
            return "/tag:" + string;
        }

        @JvmStatic
        @NotNull
        public final String wrapAttribute(@NotNull String value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (StringUtil.containsAnyChar((String)value, (String)" ,:")) {
                String string2 = StringUtil.wrapWithDoubleQuote((String)value);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wrapWithDoubleQuote(...)");
            } else {
                string = value;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0014R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/plugins/newui/SearchQueryParser$Installed;", "Lcom/intellij/ide/plugins/newui/SearchQueryParser;", "query", "", "<init>", "(Ljava/lang/String;)V", "vendors", "", "tags", "enabled", "", "disabled", "bundled", "updatedBundled", "userInstalled", "invalid", "needUpdate", "attributes", "parse", "", "handleAttribute", "name", "value", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static class Installed
    extends SearchQueryParser {
        @JvmField
        @NotNull
        public final Set<String> vendors;
        @JvmField
        @NotNull
        public final Set<String> tags;
        @JvmField
        public boolean enabled;
        @JvmField
        public boolean disabled;
        @JvmField
        public boolean bundled;
        @JvmField
        public boolean updatedBundled;
        @JvmField
        public boolean userInstalled;
        @JvmField
        public boolean invalid;
        @JvmField
        public boolean needUpdate;
        @JvmField
        public boolean attributes;

        public Installed(@NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.vendors = new HashSet();
            this.tags = new HashSet();
            this.parse(query);
        }

        private final void parse(String query) {
            List<String> words = Companion.splitQuery(query);
            int size2 = words.size();
            if (size2 == 0) {
                return;
            }
            int index = 0;
            while (index < size2) {
                String name2;
                if (StringsKt.startsWith$default((String)(name2 = words.get(index++)), (String)"/", (boolean)false, (int)2, null)) {
                    if (Intrinsics.areEqual((Object)name2, (Object)SearchWords.VENDOR.getValue()) || Intrinsics.areEqual((Object)name2, (Object)SearchWords.TAG.getValue())) {
                        if (index < size2) {
                            this.handleAttribute(name2, words.get(index++));
                            continue;
                        }
                        this.addToSearchQuery(query);
                        break;
                    }
                    this.handleAttribute(name2, "");
                    continue;
                }
                this.addToSearchQuery(name2);
            }
            this.attributes = this.enabled || this.disabled || this.bundled || this.updatedBundled || this.userInstalled || this.invalid || this.needUpdate;
        }

        protected void handleAttribute(@NotNull String name2, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)"/enabled", (Object)name2)) {
                this.enabled = true;
            } else if (Intrinsics.areEqual((Object)"/disabled", (Object)name2)) {
                this.disabled = true;
            } else if (Intrinsics.areEqual((Object)"/bundled", (Object)name2)) {
                this.bundled = true;
            } else if (Intrinsics.areEqual((Object)"/updatedBundled", (Object)name2)) {
                this.updatedBundled = true;
            } else if (Intrinsics.areEqual((Object)"/downloaded", (Object)name2) || Intrinsics.areEqual((Object)"/userInstalled", (Object)name2)) {
                this.userInstalled = true;
            } else if (Intrinsics.areEqual((Object)"/invalid", (Object)name2)) {
                this.invalid = true;
            } else if (Intrinsics.areEqual((Object)"/outdated", (Object)name2)) {
                this.needUpdate = true;
            } else if (Intrinsics.areEqual((Object)SearchWords.VENDOR.getValue(), (Object)name2)) {
                this.vendors.add(value);
            } else if (Intrinsics.areEqual((Object)SearchWords.TAG.getValue(), (Object)name2)) {
                this.tags.add(value);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0014R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/plugins/newui/SearchQueryParser$Marketplace;", "Lcom/intellij/ide/plugins/newui/SearchQueryParser;", "query", "", "<init>", "(Ljava/lang/String;)V", "vendors", "", "tags", "repositories", "sortBy", "Lcom/intellij/ide/plugins/MarketplaceTabSearchSortByOptions;", "suggested", "", "internal", "staffPicks", "getStaffPicks", "()Z", "setStaffPicks", "(Z)V", "parse", "", "addToSearchQuery", "handleAttribute", "name", "value", "urlQuery", "getUrlQuery", "()Ljava/lang/String;", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static class Marketplace
    extends SearchQueryParser {
        @JvmField
        @NotNull
        public final Set<String> vendors;
        @JvmField
        @NotNull
        public final Set<String> tags;
        @JvmField
        @NotNull
        public final Set<String> repositories;
        @JvmField
        @Nullable
        public MarketplaceTabSearchSortByOptions sortBy;
        @JvmField
        public boolean suggested;
        @JvmField
        public boolean internal;
        private boolean staffPicks;

        public Marketplace(@NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.vendors = new HashSet();
            this.tags = new HashSet();
            this.repositories = new HashSet();
            this.parse(query);
        }

        public final boolean getStaffPicks() {
            return this.staffPicks;
        }

        public final void setStaffPicks(boolean bl) {
            this.staffPicks = bl;
        }

        private final void parse(String query) {
            List<String> words = Companion.splitQuery(query);
            int size2 = words.size();
            if (size2 == 0) {
                return;
            }
            if (size2 == 1) {
                this.addToSearchQuery(words.get(0));
                return;
            }
            int index = 0;
            while (index < size2) {
                String name2;
                if (StringsKt.endsWith$default((String)(name2 = words.get(index++)), (String)":", (boolean)false, (int)2, null)) {
                    if (index < size2) {
                        this.handleAttribute(name2, words.get(index++));
                        continue;
                    }
                    this.addToSearchQuery(query);
                    return;
                }
                this.addToSearchQuery(name2);
            }
        }

        @Override
        protected void addToSearchQuery(@NotNull String query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            String string = query;
            if (Intrinsics.areEqual((Object)string, (Object)SearchWords.SUGGESTED.getValue())) {
                this.suggested = true;
            } else if (Intrinsics.areEqual((Object)string, (Object)SearchWords.INTERNAL.getValue())) {
                this.internal = true;
            } else if (Intrinsics.areEqual((Object)string, (Object)SearchWords.STAFF_PICKS.getValue())) {
                this.staffPicks = true;
            } else {
                super.addToSearchQuery(query);
            }
        }

        protected void handleAttribute(@NotNull String name2, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = name2;
            if (Intrinsics.areEqual((Object)string, (Object)SearchWords.TAG.getValue())) {
                this.tags.add(value);
            } else if (Intrinsics.areEqual((Object)string, (Object)SearchWords.SORT_BY.getValue())) {
                this.sortBy = MarketplaceTabSearchSortByOptions.Companion.getByQueryOrNull(value);
            } else if (Intrinsics.areEqual((Object)string, (Object)SearchWords.REPOSITORY.getValue())) {
                this.repositories.add(value);
            } else if (Intrinsics.areEqual((Object)string, (Object)SearchWords.VENDOR.getValue())) {
                this.vendors.add(value);
            }
        }

        @NotNull
        public final String getUrlQuery() {
            StringBuilder url = new StringBuilder();
            if (this.sortBy != null) {
                MarketplaceTabSearchSortByOptions marketplaceTabSearchSortByOptions = this.sortBy;
                Intrinsics.checkNotNull((Object)((Object)marketplaceTabSearchSortByOptions));
                url.append(marketplaceTabSearchSortByOptions.getMpParameter());
            }
            if (this.staffPicks) {
                if (!(((CharSequence)url).length() == 0)) {
                    url.append("&");
                }
                url.append("is_featured_search=true");
            }
            for (String tag : this.tags) {
                if (!(((CharSequence)url).length() == 0)) {
                    url.append("&");
                }
                url.append("tags=").append(URLUtil.encodeURIComponent((String)tag));
            }
            for (String vendor : this.vendors) {
                if (!(((CharSequence)url).length() == 0)) {
                    url.append("&");
                }
                url.append("organization=").append(URLUtil.encodeURIComponent((String)vendor));
            }
            if (this.searchQuery != null) {
                if (!(((CharSequence)url).length() == 0)) {
                    url.append("&");
                }
                StringBuilder stringBuilder = url.append("search=");
                String string = this.searchQuery;
                Intrinsics.checkNotNull((Object)string);
                stringBuilder.append(URLUtil.encodeURIComponent((String)string));
            }
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

