/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\b\u0010\u000f\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/application/impl/OTelReadWriteActionsMonitor;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "meter", "Lio/opentelemetry/api/metrics/Meter;", "<init>", "(Lio/opentelemetry/api/metrics/Meter;)V", "batchCallback", "Lio/opentelemetry/api/metrics/BatchCallback;", "readActionsExecuted", "Ljava/util/concurrent/atomic/AtomicInteger;", "writeActionsExecuted", "readActionExecuted", "", "writeActionExecuted", "close", "intellij.platform.ide.impl"})
public final class OTelReadWriteActionsMonitor
implements AutoCloseable {
    @NotNull
    private final BatchCallback batchCallback;
    @NotNull
    private final AtomicInteger readActionsExecuted;
    @NotNull
    private final AtomicInteger writeActionsExecuted;

    public OTelReadWriteActionsMonitor(@NotNull Meter meter) {
        Intrinsics.checkNotNullParameter((Object)meter, (String)"meter");
        this.readActionsExecuted = new AtomicInteger();
        this.writeActionsExecuted = new AtomicInteger();
        ObservableLongMeasurement raExecutionsCounter = meter.counterBuilder("ReadAction.executionsCount").setDescription("Total read actions executed").buildObserver();
        ObservableLongMeasurement waExecutionCounter = meter.counterBuilder("WriteAction.executionsCount").setDescription("Total write actions executed").buildObserver();
        ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{waExecutionCounter};
        BatchCallback batchCallback = meter.batchCallback(() -> OTelReadWriteActionsMonitor._init_$lambda$0(raExecutionsCounter, this, waExecutionCounter), (ObservableMeasurement)raExecutionsCounter, observableMeasurementArray);
        Intrinsics.checkNotNullExpressionValue((Object)batchCallback, (String)"batchCallback(...)");
        this.batchCallback = batchCallback;
    }

    public final void readActionExecuted() {
        this.readActionsExecuted.incrementAndGet();
    }

    public final void writeActionExecuted() {
        this.writeActionsExecuted.incrementAndGet();
    }

    @Override
    public void close() {
        this.batchCallback.close();
    }

    private static final void _init_$lambda$0(ObservableLongMeasurement $raExecutionsCounter, OTelReadWriteActionsMonitor this$0, ObservableLongMeasurement $waExecutionCounter) {
        $raExecutionsCounter.record((long)this$0.readActionsExecuted.get());
        $waExecutionCounter.record((long)this$0.writeActionsExecuted.get());
    }
}

