/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.SharedAdjustableUndoableActionsHolder;
import com.intellij.openapi.command.impl.SharedUndoRedoSnapshot;
import com.intellij.openapi.command.impl.SharedUndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoCapabilities;
import com.intellij.openapi.command.impl.UndoRedoList;
import com.intellij.openapi.command.impl.UndoRedoSet;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.MutableActionChangeRange;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class UndoSharedState {
    @NotNull
    private final SharedAdjustableUndoableActionsHolder adjustableActions;
    @NotNull
    private final SharedUndoRedoStacksHolder undoStacks;
    @NotNull
    private final SharedUndoRedoStacksHolder redoStacks;

    UndoSharedState(@NotNull UndoCapabilities undoCapabilities) {
        if (undoCapabilities == null) {
            UndoSharedState.$$$reportNull$$$0(0);
        }
        this.adjustableActions = new SharedAdjustableUndoableActionsHolder();
        this.undoStacks = new SharedUndoRedoStacksHolder(this.adjustableActions, undoCapabilities, true);
        this.redoStacks = new SharedUndoRedoStacksHolder(this.adjustableActions, undoCapabilities, false);
    }

    @NotNull
    SharedUndoRedoSnapshot getSharedUndoRedoSnapshot(@NotNull DocumentReference reference) {
        if (reference == null) {
            UndoSharedState.$$$reportNull$$$0(1);
        }
        return new SharedUndoRedoSnapshot(((UndoRedoSet)this.adjustableActions.getStack(reference)).snapshot(), ((UndoRedoList)this.undoStacks.getStack(reference)).snapshot(), ((UndoRedoList)this.redoStacks.getStack(reference)).snapshot());
    }

    void resetLocalHistory(@NotNull DocumentReference reference, @NotNull SharedUndoRedoSnapshot snapshot2) {
        if (reference == null) {
            UndoSharedState.$$$reportNull$$$0(2);
        }
        if (snapshot2 == null) {
            UndoSharedState.$$$reportNull$$$0(3);
        }
        ((UndoRedoSet)this.adjustableActions.getStack(reference)).resetTo(snapshot2.getActionsHolderSnapshot());
        ((UndoRedoList)this.undoStacks.getStack(reference)).resetTo(snapshot2.getSharedUndoStack());
        ((UndoRedoList)this.redoStacks.getStack(reference)).resetTo(snapshot2.getSharedRedoStack());
    }

    void clearDocumentReferences(@NotNull Document document2) {
        if (document2 == null) {
            UndoSharedState.$$$reportNull$$$0(4);
        }
        this.undoStacks.clearDocumentReferences(document2);
        this.redoStacks.clearDocumentReferences(document2);
    }

    void trimSharedStacks(@NotNull DocumentReference docRef) {
        if (docRef == null) {
            UndoSharedState.$$$reportNull$$$0(5);
        }
        this.redoStacks.trimStacks(Collections.singleton(docRef));
        this.undoStacks.trimStacks(Collections.singleton(docRef));
    }

    void trimStacks(@NotNull Collection<? extends DocumentReference> references) {
        if (references == null) {
            UndoSharedState.$$$reportNull$$$0(6);
        }
        this.undoStacks.trimStacks(references);
        this.redoStacks.trimStacks(references);
    }

    void addAction(@NotNull UndoableAction action2) {
        if (action2 == null) {
            UndoSharedState.$$$reportNull$$$0(7);
        }
        if (action2 instanceof AdjustableUndoableAction) {
            AdjustableUndoableAction adjustable = (AdjustableUndoableAction)action2;
            DocumentReference[] affected = action2.getAffectedDocuments();
            if (affected == null) {
                return;
            }
            this.adjustableActions.addAction(adjustable);
            for (DocumentReference reference : affected) {
                for (MutableActionChangeRange changeRange : adjustable.getChangeRanges(reference)) {
                    this.undoStacks.addToStack(reference, changeRange.toImmutable(false));
                    this.redoStacks.addToStack(reference, changeRange.toImmutable(true));
                }
            }
        }
    }

    @NotNull
    SharedAdjustableUndoableActionsHolder getAdjustableActions() {
        SharedAdjustableUndoableActionsHolder sharedAdjustableUndoableActionsHolder = this.adjustableActions;
        if (sharedAdjustableUndoableActionsHolder == null) {
            UndoSharedState.$$$reportNull$$$0(8);
        }
        return sharedAdjustableUndoableActionsHolder;
    }

    @NotNull
    SharedUndoRedoStacksHolder getUndoStacks() {
        SharedUndoRedoStacksHolder sharedUndoRedoStacksHolder = this.undoStacks;
        if (sharedUndoRedoStacksHolder == null) {
            UndoSharedState.$$$reportNull$$$0(9);
        }
        return sharedUndoRedoStacksHolder;
    }

    @NotNull
    SharedUndoRedoStacksHolder getRedoStacks() {
        SharedUndoRedoStacksHolder sharedUndoRedoStacksHolder = this.redoStacks;
        if (sharedUndoRedoStacksHolder == null) {
            UndoSharedState.$$$reportNull$$$0(10);
        }
        return sharedUndoRedoStacksHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoCapabilities";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRef";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoSharedState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoSharedState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustableActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoStacks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedoStacks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSharedUndoRedoSnapshot";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetLocalHistory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "trimSharedStacks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "trimStacks";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

