/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.util.ArrayUtilRt;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CaretData {
    private static final CaretData NULL_CARET = new CaretData(-1, -1, ArrayUtilRt.EMPTY_INT_ARRAY, ArrayUtilRt.EMPTY_INT_ARRAY);
    private final int caretRowStart;
    private final int caretRowEnd;
    private final int[] selectionStarts;
    private final int[] selectionEnds;

    @NotNull
    public static CaretData createCaretData(@NotNull Document document2, @NotNull CaretModel caretModel) {
        if (document2 == null) {
            CaretData.$$$reportNull$$$0(0);
        }
        if (caretModel == null) {
            CaretData.$$$reportNull$$$0(1);
        }
        int caretRowStart = caretModel.getVisualLineStart();
        int caretRowEnd = caretModel.getVisualLineEnd();
        if (caretRowEnd == document2.getTextLength() && document2.getLineCount() > 0 && caretRowEnd > document2.getLineStartOffset(document2.getLineCount() - 1)) {
            ++caretRowEnd;
        }
        List carets = caretModel.getAllCarets();
        int caretCount = carets.size();
        int[] selectionStarts = new int[caretCount];
        int[] selectionEnds = new int[caretCount];
        for (int i2 = 0; i2 < caretCount; ++i2) {
            Caret caret = (Caret)carets.get(i2);
            selectionStarts[i2] = caret.getSelectionStart();
            selectionEnds[i2] = caret.getSelectionEnd();
        }
        return new CaretData(caretRowStart, caretRowEnd, selectionStarts, selectionEnds);
    }

    @NotNull
    static CaretData getNullCaret() {
        CaretData caretData = NULL_CARET;
        if (caretData == null) {
            CaretData.$$$reportNull$$$0(2);
        }
        return caretData;
    }

    static CaretData copyOf(CaretData original, boolean omitCaretRowData) {
        if (original == null || !omitCaretRowData) {
            return original;
        }
        return new CaretData(-1, -1, original.selectionStarts, original.selectionEnds);
    }

    CaretData(int caretRowStart, int caretRowEnd, int[] selectionStarts, int[] selectionEnds) {
        this.caretRowStart = caretRowStart;
        this.caretRowEnd = caretRowEnd;
        this.selectionStarts = selectionStarts;
        this.selectionEnds = selectionEnds;
    }

    int caretRowStart() {
        return this.caretRowStart;
    }

    int caretRowEnd() {
        return this.caretRowEnd;
    }

    int selectionsSize() {
        return this.selectionStarts.length;
    }

    int selectionStart(int index, boolean reverse) {
        return this.selectionStarts[reverse ? this.selectionStarts.length - 1 - index : index];
    }

    int selectionEnd(int index, boolean reverse) {
        return this.selectionEnds[reverse ? this.selectionStarts.length - 1 - index : index];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/CaretData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/CaretData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullCaret";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCaretData";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

