/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.CaretSelection;
import com.intellij.openapi.editor.impl.view.SelectionLinePainterKt;
import java.awt.geom.Point2D;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0011\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0086\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c2\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c2\u0003J-\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001c\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/editor/impl/view/CaretLineSelections;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "line", "", "selections", "", "Lcom/intellij/openapi/editor/impl/view/CaretSelection;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;ILjava/util/List;)V", "trimToLine", "selection", "get", "index", "hasSelectionEnd", "", "left", "pos", "", "selectionContaining", "containsPosition", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSelectionLinePainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLinePainter.kt\ncom/intellij/openapi/editor/impl/view/CaretLineSelections\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,575:1\n1#2:576\n*E\n"})
final class CaretLineSelections {
    @NotNull
    private final EditorImpl editor;
    private final int line;
    @NotNull
    private final List<CaretSelection> selections;

    public CaretLineSelections(@NotNull EditorImpl editor2, int line, @NotNull List<CaretSelection> selections) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(selections, (String)"selections");
        this.editor = editor2;
        this.line = line;
        this.selections = selections;
    }

    private final CaretSelection trimToLine(CaretSelection selection) {
        int columnEnd = EditorUtil.getLastVisualLineColumnNumber(this.editor, this.line);
        return new CaretSelection(this.editor, SelectionLinePainterKt.access$max(selection.getStart(), new VisualPosition(this.line, 0, selection.getStart().leansRight)), SelectionLinePainterKt.access$min(selection.getEnd(), new VisualPosition(this.line, columnEnd, selection.getEnd().leansRight)));
    }

    @NotNull
    public final CaretSelection get(int index) {
        return this.trimToLine(this.selections.get(index));
    }

    public final boolean hasSelectionEnd(boolean left, double pos) {
        if (this.selections.isEmpty()) {
            return false;
        }
        Pair pair = new Pair((Object)0, (Object)this.selections.size());
        int lo = ((Number)pair.component1()).intValue();
        int hi = ((Number)pair.component2()).intValue();
        while (lo + 1 != hi) {
            Point2D boundary;
            int mid = (lo + hi) / 2;
            Intrinsics.checkNotNullExpressionValue((Object)this.editor.visualPositionToPoint2D(left ? this.get(mid).getStart() : this.get(mid).getEnd()), (String)"visualPositionToPoint2D(...)");
            if (boundary.getX() <= pos + 0.01) {
                lo = mid;
                continue;
            }
            hi = mid;
        }
        return Math.abs(this.editor.visualPositionToPoint2D(left ? this.get(lo).getStart() : this.get(lo).getEnd()).getX() - pos) < 0.01;
    }

    @Nullable
    public final CaretSelection selectionContaining(double pos) {
        CaretSelection caretSelection;
        if (this.selections.isEmpty()) {
            return null;
        }
        Pair pair = new Pair((Object)0, (Object)this.selections.size());
        int lo = ((Number)pair.component1()).intValue();
        int hi = ((Number)pair.component2()).intValue();
        while (lo + 1 != hi) {
            int mid = (lo + hi) / 2;
            CaretSelection selection = this.get(mid);
            Pair pair2 = new Pair((Object)this.editor.visualPositionToPoint2D(selection.getStart()), (Object)this.editor.visualPositionToPoint2D(selection.getEnd()));
            Object object = pair2.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            Point2D start2 = (Point2D)object;
            Object object2 = pair2.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component2(...)");
            Point2D end = (Point2D)object2;
            if (end.getX() < pos - 0.01) {
                lo = mid;
                continue;
            }
            if (start2.getX() > pos + 0.01) {
                hi = mid;
                continue;
            }
            return selection;
        }
        CaretSelection it = caretSelection = this.get(lo);
        boolean bl = false;
        return it.contains(pos) ? caretSelection : null;
    }

    public final boolean containsPosition(double pos) {
        return this.selectionContaining(pos) != null;
    }

    private final EditorImpl component1() {
        return this.editor;
    }

    private final int component2() {
        return this.line;
    }

    private final List<CaretSelection> component3() {
        return this.selections;
    }

    @NotNull
    public final CaretLineSelections copy(@NotNull EditorImpl editor2, int line, @NotNull List<CaretSelection> selections) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(selections, (String)"selections");
        return new CaretLineSelections(editor2, line, selections);
    }

    public static /* synthetic */ CaretLineSelections copy$default(CaretLineSelections caretLineSelections, EditorImpl editorImpl, int n, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            editorImpl = caretLineSelections.editor;
        }
        if ((n2 & 2) != 0) {
            n = caretLineSelections.line;
        }
        if ((n2 & 4) != 0) {
            list2 = caretLineSelections.selections;
        }
        return caretLineSelections.copy(editorImpl, n, list2);
    }

    @NotNull
    public String toString() {
        return "CaretLineSelections(editor=" + this.editor + ", line=" + this.line + ", selections=" + this.selections + ")";
    }

    public int hashCode() {
        int result2 = this.editor.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.line);
        result2 = result2 * 31 + ((Object)this.selections).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CaretLineSelections)) {
            return false;
        }
        CaretLineSelections caretLineSelections = (CaretLineSelections)other;
        if (!Intrinsics.areEqual((Object)this.editor, (Object)caretLineSelections.editor)) {
            return false;
        }
        if (this.line != caretLineSelections.line) {
            return false;
        }
        return Intrinsics.areEqual(this.selections, caretLineSelections.selections);
    }
}

