/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserPanel;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserDialogHelper;
import com.intellij.openapi.fileChooser.impl.FileChooserPanelImpl;
import com.intellij.openapi.fileChooser.impl.FileChooserUsageCollector;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NewFileChooserDialogImpl
extends DialogWrapper
implements FileChooserDialog,
PathChooserDialog {
    private final FileChooserDescriptor myDescriptor;
    private Project myProject;
    private FileChooserPanelImpl myPanel;
    private final FileChooserDialogHelper myHelper;
    private VirtualFile[] myChosenFiles = VirtualFile.EMPTY_ARRAY;

    NewFileChooserDialogImpl(FileChooserDescriptor descriptor2, @Nullable Component parent, @Nullable Project project2) {
        super(project2, parent, true, DialogWrapper.IdeModalityType.IDE);
        this.myDescriptor = descriptor2;
        this.myProject = project2;
        this.myHelper = new FileChooserDialogHelper(descriptor2);
        this.setTitle(Objects.requireNonNullElseGet(descriptor2.getTitle(), () -> UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0])));
        this.init();
    }

    public VirtualFile @NotNull [] choose(@Nullable Project project2, VirtualFile ... toSelect) {
        if (toSelect == null) {
            NewFileChooserDialogImpl.$$$reportNull$$$0(0);
        }
        if (this.myProject == null) {
            this.myProject = project2;
        }
        this.myPanel.load(FileChooserUtil.getInitialPath(this.myDescriptor, this.myProject, toSelect.length > 0 ? toSelect[0] : null));
        this.show();
        FileChooserUsageCollector.log(this, this.myDescriptor, this.myChosenFiles);
        if (this.myChosenFiles == null) {
            NewFileChooserDialogImpl.$$$reportNull$$$0(1);
        }
        return this.myChosenFiles;
    }

    public void choose(@Nullable VirtualFile toSelect, @NotNull Consumer<? super List<VirtualFile>> callback) {
        if (callback == null) {
            NewFileChooserDialogImpl.$$$reportNull$$$0(2);
        }
        this.myPanel.load(FileChooserUtil.getInitialPath(this.myDescriptor, this.myProject, toSelect));
        this.show();
        FileChooserUsageCollector.log(this, this.myDescriptor, this.myChosenFiles);
        if (this.myChosenFiles.length != 0) {
            callback.consume(List.of(this.myChosenFiles));
        } else if (callback instanceof FileChooser.FileChooserConsumer) {
            ((FileChooser.FileChooserConsumer)callback).cancelled();
        }
    }

    protected JComponent createCenterPanel() {
        Path[] recentPaths = (Path[])FileChooserUtil.getRecentPaths().stream().map(NioFiles::toPath).filter(Objects::nonNull).toArray(Path[]::new);
        this.myPanel = new FileChooserPanelImpl(this.myDescriptor, this::doOKAction, x$0 -> this.setErrorText((String)x$0), recentPaths);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)600, (int)450));
        JLabel dndLabel = new JLabel(UIBundle.message((String)"file.chooser.tooltip.drag.drop", (Object[])new Object[0]), 0);
        dndLabel.setFont((Font)JBUI.Fonts.miniFont());
        dndLabel.setForeground(UIUtil.getLabelDisabledForeground());
        ChooserDialogPanel panel2 = new ChooserDialogPanel();
        panel2.add((Component)((Object)this.myPanel), "Center");
        panel2.add((Component)dndLabel, "South");
        return panel2;
    }

    protected void doOKAction() {
        List<Path> paths = this.myPanel.chosenPaths();
        if (paths.isEmpty()) {
            Messages.showWarningDialog((Component)((Object)this.myPanel), (String)UIBundle.message((String)"file.chooser.nothing.selected", (Object[])new Object[0]), (String)this.getTitle());
            return;
        }
        this.myChosenFiles = this.myHelper.selectedFiles(paths, (Component)((Object)this.myPanel), this.getTitle());
        if (this.myChosenFiles.length == 0) {
            return;
        }
        FileChooserUtil.updateRecentPaths(this.myProject, this.myChosenFiles[0]);
        super.doOKAction();
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myPanel);
        this.myPanel = null;
        super.dispose();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel != null ? this.myPanel.getPreferredFocusedComponent() : null;
    }

    protected String getDimensionServiceKey() {
        return "FileChooserDialogImpl";
    }

    protected String getHelpId() {
        return "select.path.dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/impl/NewFileChooserDialogImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/impl/NewFileChooserDialogImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "choose";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private final class ChooserDialogPanel
    extends JPanel
    implements UiDataProvider {
        private ChooserDialogPanel() {
            super(new BorderLayout());
            this.setDropTarget(new DropTarget(this, 1, new ChooserDropTarget()));
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ChooserDialogPanel.$$$reportNull$$$0(0);
            }
            sink.set(FileChooserPanel.DATA_KEY, (Object)NewFileChooserDialogImpl.this.myPanel);
            DataSink.uiDataSnapshot((DataSink)sink, dataId -> NewFileChooserDialogImpl.this.myDescriptor.getUserData(dataId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/openapi/fileChooser/impl/NewFileChooserDialogImpl$ChooserDialogPanel", "uiDataSnapshot"));
        }
    }

    private final class ChooserDropTarget
    extends DropTargetAdapter {
        private ChooserDropTarget() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (FileCopyPasteUtil.isFileListFlavorAvailable(e.getCurrentDataFlavors())) {
                e.acceptDrag(1);
            } else {
                e.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            this.dragEnter(e);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            this.dragEnter(e);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            e.acceptDrop(1);
            List<Path> paths = FileCopyPasteUtil.getFiles(e.getTransferable());
            if (paths != null && !paths.isEmpty()) {
                NewFileChooserDialogImpl.this.myPanel.load(paths.get(0));
                e.dropComplete(true);
            } else {
                e.dropComplete(false);
            }
        }
    }
}

