/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.FileDropManager;
import com.intellij.openapi.editor.FileDropManagerKt;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J#\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorTabbedContainerTransferHandler;", "Ljavax/swing/TransferHandler;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/EditorWindow;)V", "importData", "", "comp", "Ljavax/swing/JComponent;", "t", "Ljava/awt/datatransfer/Transferable;", "canImport", "transferFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "(Ljavax/swing/JComponent;[Ljava/awt/datatransfer/DataFlavor;)Z", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditorTabbedContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTabbedContainer.kt\ncom/intellij/openapi/fileEditor/impl/EditorTabbedContainerTransferHandler\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,763:1\n30#2,2:764\n*S KotlinDebug\n*F\n+ 1 EditorTabbedContainer.kt\ncom/intellij/openapi/fileEditor/impl/EditorTabbedContainerTransferHandler\n*L\n503#1:764,2\n*E\n"})
final class EditorTabbedContainerTransferHandler
extends TransferHandler {
    @NotNull
    private final EditorWindow window;

    public EditorTabbedContainerTransferHandler(@NotNull EditorWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.window = window;
    }

    @Override
    public boolean importData(@NotNull JComponent comp, @NotNull Transferable t) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        DataFlavor[] dataFlavorArray = t.getTransferDataFlavors();
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
        if (FileDropManagerKt.containsFileDropTargets(dataFlavorArray)) {
            ComponentManager $this$service$iv = (ComponentManager)this.window.getManager().getProject();
            boolean $i$f$service = false;
            Class<FileDropManager> serviceClass$iv = FileDropManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((FileDropManager)object).scheduleDrop(t, null, this.window);
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(@NotNull JComponent comp, @NotNull DataFlavor[] transferFlavors) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNullParameter((Object)transferFlavors, (String)"transferFlavors");
        return FileDropManagerKt.containsFileDropTargets(transferFlavors);
    }
}

