/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayDeque;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PlatformVirtualFileManager
extends VirtualFileManagerImpl {
    public PlatformVirtualFileManager() {
        super(Collections.emptyList());
    }

    protected final long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        }
        RefreshSession session = RefreshQueue.getInstance().createSession(asynchronous, true, postAction);
        session.addAllFiles(ManagingFS.getInstance().getRoots());
        session.launch();
        super.doRefresh(asynchronous, postAction);
        return 0L;
    }

    public final long getModificationCount() {
        return ManagingFS.getInstance().getFilesystemModificationCount();
    }

    public final long getStructureModificationCount() {
        return ManagingFS.getInstance().getStructureModificationCount();
    }

    public final VirtualFile findFileById(int id2) {
        return ManagingFS.getInstance().findFileById(id2);
    }

    public final int[] listAllChildIds(int id2) {
        IntOpenHashSet result2 = new IntOpenHashSet();
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        queue.add(id2);
        FSRecordsImpl vfsPeer = FSRecords.getInstance();
        while (!queue.isEmpty()) {
            int recordId = (Integer)queue.poll();
            if (!result2.add(recordId)) continue;
            ProgressManager.checkCanceled();
            vfsPeer.forEachChildOf(recordId, childId -> {
                queue.add(childId);
                return false;
            });
        }
        return result2.toIntArray();
    }

    @NotNull
    public final CharSequence getVFileName(int nameId) {
        String string = FSRecords.getInstance().getNameByNameId(nameId);
        if (string == null) {
            PlatformVirtualFileManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    public final int storeName(@NotNull String name2) {
        if (name2 == null) {
            PlatformVirtualFileManager.$$$reportNull$$$0(1);
        }
        return FSRecords.getInstance().getNameId(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/PlatformVirtualFileManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/PlatformVirtualFileManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "storeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

