/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.persistent.InvertedNameIndex;
import com.intellij.util.SystemProperties;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class DefaultInMemoryInvertedNameIndex
implements InvertedNameIndex {
    private final boolean CHECK_CONSISTENCY = SystemProperties.getBooleanProperty((String)"idea.vfs.name.index.check.consistency", (boolean)false);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Int2IntMap singularMapping = new Int2IntOpenHashMap();
    private final Int2ObjectMap<int[]> multiMapping = new Int2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public boolean forEachFileIds(@NotNull IntCollection nameIds, @NotNull IntPredicate fileIdProcessor) {
        if (nameIds == null) {
            DefaultInMemoryInvertedNameIndex.$$$reportNull$$$0(0);
        }
        if (fileIdProcessor == null) {
            DefaultInMemoryInvertedNameIndex.$$$reportNull$$$0(1);
        }
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.processData(nameIds, fileIdProcessor);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private boolean processData(@NotNull IntCollection nameIds, @NotNull IntPredicate processor2) {
        if (nameIds == null) {
            DefaultInMemoryInvertedNameIndex.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            DefaultInMemoryInvertedNameIndex.$$$reportNull$$$0(3);
        }
        IntIterator it = nameIds.iterator();
        while (it.hasNext()) {
            int nameId = it.nextInt();
            int single = this.singularMapping.get(nameId);
            if (single != 0) {
                if (processor2.test(single)) continue;
                return false;
            }
            int[] multi = (int[])this.multiMapping.get(nameId);
            if (multi == null) continue;
            if (multi.length == 2) {
                if (!processor2.test(multi[0])) {
                    return false;
                }
                if (processor2.test(multi[1])) continue;
                return false;
            }
            int len = multi[0];
            for (int i2 = 1; i2 <= len; ++i2) {
                if (processor2.test(multi[i2])) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFileName(int fileId, int oldNameId, int newNameId) {
        if (oldNameId == newNameId) {
            return;
        }
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            if (oldNameId != 0) {
                this.deleteDataInner(fileId, oldNameId);
            }
            if (newNameId != 0) {
                this.updateDataInner(fileId, newNameId);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private void updateDataInner(int fileId, int nameId) {
        if (nameId == 0) {
            throw new IllegalArgumentException("nameId can't be NULL_ID(0)");
        }
        int single = this.singularMapping.get(nameId);
        int[] multi = (int[])this.multiMapping.get(nameId);
        if (single == 0 && multi == null) {
            this.singularMapping.put(nameId, fileId);
        } else if (multi == null) {
            this.multiMapping.put(nameId, (Object)new int[]{single, fileId});
            this.singularMapping.remove(nameId);
        } else if (multi.length == 2) {
            this.multiMapping.put(nameId, (Object)new int[]{3, multi[0], multi[1], fileId, 0});
        } else if (multi[multi.length - 1] == 0) {
            multi[0] = multi[0] + 1;
            multi[multi[0]] = fileId;
        } else {
            int[] next = Arrays.copyOf(multi, multi.length * 2 + 1);
            next[0] = next[0] + 1;
            next[next[0]] = fileId;
            this.multiMapping.put(nameId, (Object)next);
        }
        if (this.CHECK_CONSISTENCY) {
            this.checkConsistency(nameId);
        }
    }

    private void deleteDataInner(int fileId, int nameId) {
        int single = this.singularMapping.get(nameId);
        int[] multi = (int[])this.multiMapping.get(nameId);
        if (single == fileId) {
            this.singularMapping.remove(nameId);
        } else if (multi != null) {
            if (multi.length == 2) {
                if (multi[0] == fileId) {
                    this.multiMapping.remove(nameId);
                    this.singularMapping.put(nameId, multi[1]);
                } else if (multi[1] == fileId) {
                    this.multiMapping.remove(nameId);
                    this.singularMapping.put(nameId, multi[0]);
                }
            } else {
                boolean found = false;
                int len = multi[0];
                for (int i2 = 1; i2 <= len; ++i2) {
                    if (found) {
                        multi[i2 - 1] = multi[i2];
                        continue;
                    }
                    if (multi[i2] != fileId) continue;
                    found = true;
                    multi[0] = multi[0] - 1;
                }
                if (found) {
                    int len2 = multi[0];
                    if (len2 == 0) {
                        this.multiMapping.remove(nameId);
                    } else if (len2 == 1) {
                        this.multiMapping.remove(nameId);
                        this.singularMapping.put(nameId, multi[1]);
                    } else if (len2 == 2) {
                        this.multiMapping.put(nameId, (Object)new int[]{multi[1], multi[2]});
                    } else {
                        multi[len2 + 1] = 0;
                    }
                }
            }
        }
        if (this.CHECK_CONSISTENCY) {
            this.checkConsistency(nameId);
        }
    }

    @Override
    @VisibleForTesting
    public void clear() {
        this.rwLock.writeLock().lock();
        try {
            this.singularMapping.clear();
            this.multiMapping.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    @VisibleForTesting
    public void checkConsistency() {
        this.rwLock.readLock().lock();
        try {
            IntIterator keyIt1 = this.singularMapping.keySet().intIterator();
            while (keyIt1.hasNext()) {
                this.checkConsistency(keyIt1.nextInt());
            }
            IntIterator keyIt2 = this.multiMapping.keySet().intIterator();
            while (keyIt2.hasNext()) {
                this.checkConsistency(keyIt2.nextInt());
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void checkConsistency(int nameId) {
        int single = this.singularMapping.get(nameId);
        int[] multi = (int[])this.multiMapping.get(nameId);
        if (single != 0 && multi != null) {
            throw new AssertionError((Object)"both single- and multi- entries present");
        }
        if (multi != null) {
            if (multi.length == 2) {
                if (multi[0] == 0 || multi[1] == 0) {
                    throw new AssertionError((Object)"zero non-free entry");
                }
                if (multi[0] == multi[1]) {
                    throw new AssertionError((Object)"duplicate multi entries");
                }
            } else {
                if (multi.length == 0 || multi[0] <= 0 || multi[0] + 1 > multi.length) {
                    throw new AssertionError((Object)"incorrect multi entries number");
                }
                IntArraySet set = new IntArraySet();
                int len = multi[0];
                for (int i2 = 1; i2 < multi.length; ++i2) {
                    if (i2 <= len) {
                        if (multi[i2] == 0) {
                            throw new AssertionError((Object)"zero non-free entry");
                        }
                        if (!set.add(multi[i2])) {
                            throw new AssertionError((Object)"duplicate entries");
                        }
                        continue;
                    }
                    if (multi[i2] != 0) {
                        throw new AssertionError((Object)"non-zero free entry");
                    }
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIdProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/DefaultInMemoryInvertedNameIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachFileIds";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

