/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.PinActiveTabAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentLabel;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SingleContentLayout;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.NewUiValue;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001:\b01234567B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0002J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020\u0013H\u0002J$\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020\u0013H\u0016J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,H\u0014J\u001c\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020#2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010#H\u0003R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0018\u00010\u000bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout;", "Lcom/intellij/openapi/wm/impl/content/TabContentLayout;", "ui", "Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;", "<init>", "(Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;)V", "closeCurrentContentAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getCloseCurrentContentAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "tabAdapter", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter;", "toolbars", "", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$ToolbarType;", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "wrapper", "Ljavax/swing/JComponent;", "update", "", "rebuild", "getSupplier", "Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;", "Lcom/intellij/ui/content/Content;", "getSingleContentOrNull", "findTopLevelContentManager", "Lcom/intellij/ui/content/impl/ContentManagerImpl;", "tryUpdateContentView", "initSingleContentView", "content", "supplier", "updateSingleContentView", "resetSingleContentView", "createToolbar", "place", "", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "target", "isToDrawTabs", "Lcom/intellij/openapi/wm/impl/content/TabContentLayout$TabsDrawMode;", "layout", "updateIdLabel", "label", "Lcom/intellij/openapi/wm/impl/content/BaseLabel;", "createProcessName", "title", "prefix", "TabAdapter", "ExtendedTitleActionsGroup", "CloseCurrentContentAction", "SubContent", "HorizontalTabLayoutWithHiddenControl", "MyInvisibleAction", "MyRedispatchMouseEventListener", "ToolbarType", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSingleContentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,770:1\n1#2:771\n18#3:772\n221#4,2:773\n221#4,2:775\n1915#5,2:777\n*S KotlinDebug\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout\n*L\n115#1:772\n170#1:773,2\n198#1:775,2\n212#1:777,2\n*E\n"})
public final class SingleContentLayout
extends TabContentLayout {
    @NotNull
    private final AnAction closeCurrentContentAction;
    @Nullable
    private TabAdapter tabAdapter;
    @NotNull
    private final Map<ToolbarType, ActionToolbar> toolbars;
    @Nullable
    private JComponent wrapper;

    public SingleContentLayout(@NotNull ToolWindowContentUi ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        super(ui);
        this.closeCurrentContentAction = (AnAction)new CloseCurrentContentAction();
        this.toolbars = new LinkedHashMap();
    }

    @NotNull
    public final AnAction getCloseCurrentContentAction() {
        return this.closeCurrentContentAction;
    }

    @Override
    public void update() {
        super.update();
        this.tryUpdateContentView();
    }

    @Override
    public void rebuild() {
        super.rebuild();
        if (this.isSingleContentView && Registry.Companion.is("debugger.new.tool.window.layout.dnd", false)) {
            this.resetSingleContentView();
        }
        this.tryUpdateContentView();
    }

    private final SingleContentSupplier getSupplier(Content $this$getSupplier) {
        return SingleContentSupplier.Companion.getSupplierFrom($this$getSupplier);
    }

    @Nullable
    public final SingleContentSupplier getSupplier() {
        Content content2 = this.getSingleContentOrNull();
        return content2 != null ? this.getSupplier(content2) : null;
    }

    private final Content getSingleContentOrNull() {
        Object object;
        if (Registry.Companion.is("debugger.new.tool.window.layout.dnd", false)) {
            Content[] contentArray = this.ui.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Content content2 = (Content)ArraysKt.singleOrNull((Object[])contentArray);
            if (content2 != null) {
                Content content3;
                Content it = content3 = content2;
                boolean bl = false;
                object = !(it instanceof SubContent) ? content3 : null;
            } else {
                object = null;
            }
        } else {
            Object object2 = this.findTopLevelContentManager();
            object = object2 != null && (object2 = ((ContentManagerImpl)object2).getContentsRecursively()) != null ? (Content)CollectionsKt.singleOrNull((List)object2) : null;
        }
        return object;
    }

    private final ContentManagerImpl findTopLevelContentManager() {
        InternalDecoratorImpl internalDecoratorImpl = InternalDecoratorImpl.Companion.findTopLevelDecorator(this.ui.getComponent());
        ContentManager contentManager = internalDecoratorImpl != null ? internalDecoratorImpl.getContentManager() : null;
        return contentManager instanceof ContentManagerImpl ? (ContentManagerImpl)contentManager : null;
    }

    private final void tryUpdateContentView() {
        ToolWindowEx toolwindow;
        SingleContentSupplier contentSupplier;
        Content currentContent;
        Content content2 = currentContent = this.getSingleContentOrNull();
        SingleContentSupplier singleContentSupplier = contentSupplier = content2 != null ? this.getSupplier(content2) : null;
        if (contentSupplier != null) {
            if (this.isSingleContentView) {
                this.updateSingleContentView(currentContent, contentSupplier);
            } else {
                this.initSingleContentView(currentContent, contentSupplier);
            }
        } else if (this.isSingleContentView) {
            this.resetSingleContentView();
        }
        ToolWindow $this$asSafely$iv = this.ui.getWindow();
        boolean $i$f$asSafely = false;
        ToolWindow toolWindow2 = $this$asSafely$iv;
        if (!(toolWindow2 instanceof ToolWindowEx)) {
            toolWindow2 = null;
        }
        if ((toolwindow = (ToolWindowEx)toolWindow2) != null) {
            ActionGroup group2;
            ToolWindowEx.ToolWindowDecoration toolWindowDecoration = toolwindow.getDecoration();
            Object object = group2 = toolWindowDecoration != null ? toolWindowDecoration.getActionGroup() : null;
            if (this.isSingleContentView) {
                if (!(group2 instanceof ExtendedTitleActionsGroup)) {
                    AnAction[] anActionArray = new AnAction[2];
                    anActionArray[0] = new PinActiveTabAction();
                    Intrinsics.checkNotNullExpressionValue((Object)Separator.create(), (String)"create(...)");
                    toolwindow.setAdditionalGearActions((ActionGroup)new ExtendedTitleActionsGroup(group2, anActionArray));
                }
            } else if (group2 instanceof ExtendedTitleActionsGroup) {
                toolwindow.setAdditionalGearActions(((ExtendedTitleActionsGroup)group2).getOriginActions());
            }
        }
    }

    private final void initSingleContentView(Content content2, SingleContentSupplier supplier) {
        NonOpaquePanel nonOpaquePanel;
        Object object;
        Object it;
        TabAdapter tabAdapter;
        JBTabs jBTabs = supplier.getTabs();
        JBTabPainter jBTabPainter = this.tabPainter;
        Intrinsics.checkNotNullExpressionValue((Object)jBTabPainter, (String)"tabPainter");
        ToolWindowContentUi toolWindowContentUi = this.ui;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi, (String)"ui");
        TabAdapter tabAdapter2 = tabAdapter = new TabAdapter(content2, jBTabs, jBTabPainter, toolWindowContentUi);
        SingleContentLayout singleContentLayout = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)content2), (Disposable)((Disposable)it));
        this.ui.getTabComponent().add((Component)it);
        singleContentLayout.tabAdapter = tabAdapter;
        boolean bl2 = this.toolbars.isEmpty();
        if (_Assertions.ENABLED && !bl2) {
            it = "Assertion failed";
            throw new AssertionError(it);
        }
        ActionGroup actionGroup = supplier.getToolbarActions();
        if (actionGroup != null) {
            ActionGroup mainActionGroup = actionGroup;
            boolean bl3 = false;
            this.toolbars.put(ToolbarType.MAIN, this.createToolbar(supplier.getMainToolbarPlace(), mainActionGroup, content2.getComponent()));
        }
        if (!NewUiValue.isEnabled()) {
            ActionToolbar actionToolbar2;
            it = this;
            boolean bl4 = false;
            DefaultActionGroup contentActions = new DefaultActionGroup();
            contentActions.add(this.closeCurrentContentAction);
            contentActions.add((AnAction)Separator.create());
            contentActions.addAll((Collection)supplier.getContentActions());
            contentActions.add((AnAction)new MyInvisibleAction());
            object = this.toolbars;
            ToolbarType toolbarType = ToolbarType.CLOSE_GROUP;
            ActionToolbar $this$initSingleContentView_u24lambda_u242_u240 = actionToolbar2 = this.createToolbar(supplier.getContentToolbarPlace(), (ActionGroup)contentActions, content2.getComponent());
            boolean bl5 = false;
            $this$initSingleContentView_u24lambda_u242_u240.setReservePlaceAutoPopupIcon(false);
            $this$initSingleContentView_u24lambda_u242_u240.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
            object.put(toolbarType, actionToolbar2);
        }
        Map<ToolbarType, ActionToolbar> $this$forEach$iv = this.toolbars;
        boolean $i$f$forEach22 = false;
        for (Map.Entry<ToolbarType, ActionToolbar> element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl6 = false;
            ActionToolbar toolbar2 = object.getValue();
            this.ui.getTabComponent().add(toolbar2.getComponent());
        }
        NonOpaquePanel $i$f$forEach22 = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(0, 0, 2, null));
        singleContentLayout = this;
        boolean bl7 = false;
        new MyRedispatchMouseEventListener((Function1<? super MouseEvent, Unit>)((Function1)arg_0 -> SingleContentLayout.initSingleContentView$lambda$4$0(this, arg_0))).installOn((Component)it);
        MouseDragHelper.setComponentDraggable((JComponent)((JComponent)it), (boolean)true);
        ToolWindowContentUi.initMouseListeners((JComponent)it, this.ui, true);
        this.ui.getTabComponent().add((Component)it);
        singleContentLayout.wrapper = (JComponent)nonOpaquePanel;
        this.isSingleContentView = true;
        supplier.init(this.toolbars.get((Object)ToolbarType.MAIN), this.toolbars.get((Object)ToolbarType.CLOSE_GROUP));
        supplier.customize(this.wrapper);
    }

    private final void updateSingleContentView(Content content2, SingleContentSupplier supplier) {
        TabAdapter tabAdapter = this.tabAdapter;
        if (!Intrinsics.areEqual((Object)(tabAdapter != null ? tabAdapter.getJbTabs() : null), (Object)supplier.getTabs())) {
            this.resetSingleContentView();
            this.initSingleContentView(content2, supplier);
        } else {
            Map<ToolbarType, ActionToolbar> $this$forEach$iv = this.toolbars;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ToolbarType, ActionToolbar>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<ToolbarType, ActionToolbar> element$iv;
                Map.Entry<ToolbarType, ActionToolbar> entry = element$iv = iterator2.next();
                boolean bl = false;
                ActionToolbar toolbar2 = entry.getValue();
                toolbar2.updateActionsImmediately();
            }
            supplier.customize(this.wrapper);
            this.ui.getTabComponent().repaint();
        }
    }

    private final void resetSingleContentView() {
        block3: {
            TabAdapter tabAdapter = this.tabAdapter;
            if (tabAdapter == null) {
                throw new IllegalStateException("Adapter must not be null".toString());
            }
            TabAdapter adapter = tabAdapter;
            this.tabAdapter = null;
            this.ui.getTabComponent().remove((Component)((Object)adapter));
            Disposer.dispose((Disposable)adapter);
            Iterable $this$forEach$iv = this.toolbars.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ActionToolbar it = (ActionToolbar)element$iv;
                boolean bl = false;
                this.ui.getTabComponent().remove(it.getComponent());
            }
            this.toolbars.clear();
            JComponent jComponent = this.wrapper;
            if (jComponent == null) {
                throw new IllegalStateException("Wrapper must not be null".toString());
            }
            this.ui.getTabComponent().remove(jComponent);
            this.wrapper = null;
            this.isSingleContentView = false;
            SingleContentSupplier singleContentSupplier = this.getSupplier(adapter.getContent());
            if (singleContentSupplier == null) break block3;
            singleContentSupplier.reset();
        }
    }

    private final ActionToolbar createToolbar(String place, ActionGroup group2, JComponent target) {
        ActionToolbar actionToolbar2 = ActionManager.getInstance().createActionToolbar(place, group2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        ActionToolbar toolbar2 = actionToolbar2;
        toolbar2.setTargetComponent(target);
        toolbar2.getComponent().setOpaque(false);
        return toolbar2;
    }

    static /* synthetic */ ActionToolbar createToolbar$default(SingleContentLayout singleContentLayout, String string, ActionGroup actionGroup, JComponent jComponent, int n, Object object) {
        if ((n & 4) != 0) {
            jComponent = null;
        }
        return singleContentLayout.createToolbar(string, actionGroup, jComponent);
    }

    @Override
    @NotNull
    protected TabContentLayout.TabsDrawMode isToDrawTabs() {
        TabContentLayout.TabsDrawMode tabsDrawMode;
        if (this.isSingleContentView) {
            tabsDrawMode = TabContentLayout.TabsDrawMode.HIDE;
        } else {
            TabContentLayout.TabsDrawMode tabsDrawMode2 = super.isToDrawTabs();
            tabsDrawMode = tabsDrawMode2;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)tabsDrawMode2), (String)"isToDrawTabs(...)");
        }
        return tabsDrawMode;
    }

    @Override
    public void layout() {
        block5: {
            Object object;
            super.layout();
            if (!this.isSingleContentView) break block5;
            JPanel jPanel = this.ui.getTabComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getTabComponent(...)");
            JPanel component2 = jPanel;
            int labelWidth = this.idLabel.getX() + this.idLabel.getWidth();
            Ref.IntRef tabsWidth = new Ref.IntRef();
            Object object2 = this.tabAdapter;
            tabsWidth.element = object2 != null && (object2 = object2.getPreferredSize()) != null ? ((Dimension)object2).width : 0;
            Ref.IntRef mainToolbarWidth = new Ref.IntRef();
            Object object3 = this.toolbars.get((Object)ToolbarType.MAIN);
            mainToolbarWidth.element = object3 != null && (object3 = object3.getComponent()) != null && (object3 = ((JComponent)object3).getPreferredSize()) != null ? ((Dimension)object3).width : 0;
            Object object4 = this.toolbars.get((Object)ToolbarType.CLOSE_GROUP);
            int contentToolbarWidth = object4 != null && (object4 = object4.getComponent()) != null && (object4 = ((JComponent)object4).getPreferredSize()) != null ? ((Dimension)object4).width : 0;
            Object object5 = this.tabAdapter;
            int minTabWidth = object5 != null && (object5 = ((TabAdapter)object5).getMinimumSize()) != null ? ((Dimension)object5).width : 0;
            int fixedWidth = labelWidth + mainToolbarWidth.element + contentToolbarWidth;
            int freeWidth = component2.getBounds().width - fixedWidth;
            if (freeWidth < minTabWidth) {
                mainToolbarWidth.element += freeWidth - minTabWidth;
            }
            tabsWidth.element = Math.max(minTabWidth, Math.min(freeWidth, tabsWidth.element));
            int wrapperWidth = Math.max(0, freeWidth - tabsWidth.element);
            Ref.IntRef x = new Ref.IntRef();
            x.element = labelWidth;
            if (Registry.Companion.is("debugger.toolbar.before.tabs")) {
                SingleContentLayout.layout$computeMainToolbarBounds(this, x, component2, mainToolbarWidth);
                SingleContentLayout.layout$computeTabsBounds(this, x, tabsWidth, component2);
            } else {
                SingleContentLayout.layout$computeTabsBounds(this, x, tabsWidth, component2);
                SingleContentLayout.layout$computeMainToolbarBounds(this, x, component2, mainToolbarWidth);
            }
            JComponent jComponent = this.wrapper;
            if (jComponent != null) {
                JComponent jComponent2;
                JComponent $this$layout_u24lambda_u242 = jComponent2 = jComponent;
                boolean bl = false;
                $this$layout_u24lambda_u242.setBounds(new Rectangle(x.element, 0, wrapperWidth, component2.getHeight()));
                x.element += wrapperWidth;
            }
            if ((object = this.toolbars.get((Object)ToolbarType.CLOSE_GROUP)) != null && (object = object.getComponent()) != null) {
                Object object6;
                Object $this$layout_u24lambda_u243 = object6 = object;
                boolean bl = false;
                int height = ((JComponent)$this$layout_u24lambda_u243).getPreferredSize().height;
                ((Component)$this$layout_u24lambda_u243).setBounds(new Rectangle(x.element, (component2.getHeight() - height) / 2, contentToolbarWidth, height));
                x.element += contentToolbarWidth;
            }
        }
    }

    @Override
    protected void updateIdLabel(@NotNull BaseLabel label2) {
        Icon icon2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        super.updateIdLabel(label2);
        if (!this.isSingleContentView) {
            label2.setIcon(null);
            label2.setToolTipText(null);
        } else if (this.tabs.size() == 1) {
            label2.setIcon(((ContentTabLabel)this.tabs.get(0)).getContent().getIcon());
            String displayName = ((ContentTabLabel)this.tabs.get(0)).getContent().getDisplayName();
            object = this.ui.window.getStripeTitle();
            Intrinsics.checkNotNull((Object)displayName);
            String string = displayName;
            label2.setText(this.createProcessName(string, (String)object));
            label2.setToolTipText(displayName);
        }
        object = this.ui.window.getComponent().getClientProperty("HeaderIcon");
        Icon icon3 = icon2 = object instanceof Icon ? (Icon)object : null;
        if (icon2 != null) {
            label2.setIcon(icon2);
            label2.setHorizontalTextPosition(2);
        }
    }

    @NlsSafe
    private final String createProcessName(String title2, String prefix) {
        Object object;
        block4: {
            block3: {
                object = prefix;
                if (object == null) break block3;
                String it = object;
                boolean bl = false;
                Object object2 = ExperimentalUI.Companion.isNewUI() ? it : it + ":";
                object = object2;
                if (object2 != null) break block4;
            }
            object = title2;
        }
        return object;
    }

    static /* synthetic */ String createProcessName$default(SingleContentLayout singleContentLayout, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return singleContentLayout.createProcessName(string, string2);
    }

    private static final Unit initSingleContentView$lambda$4$0(SingleContentLayout this$0, MouseEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!SwingUtilities.isLeftMouseButton(e)) break block1;
            Container container = this$0.ui.getTabComponent().getParent();
            if (container != null) {
                Container westPanel = container;
                boolean bl = false;
                westPanel.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, westPanel));
            }
        }
        return Unit.INSTANCE;
    }

    private static final void layout$computeMainToolbarBounds(SingleContentLayout this$0, Ref.IntRef x, JPanel component2, Ref.IntRef mainToolbarWidth) {
        block0: {
            Object object;
            Object object2 = this$0.toolbars.get((Object)ToolbarType.MAIN);
            if (object2 == null || (object2 = object2.getComponent()) == null) break block0;
            Object $this$layout_u24computeMainToolbarBounds_u24lambda_u240 = object = object2;
            boolean bl = false;
            int height = ((JComponent)$this$layout_u24computeMainToolbarBounds_u24lambda_u240).getPreferredSize().height;
            ((Component)$this$layout_u24computeMainToolbarBounds_u24lambda_u240).setBounds(new Rectangle(x.element, (component2.getHeight() - height) / 2, mainToolbarWidth.element, height));
            x.element += mainToolbarWidth.element;
        }
    }

    private static final void layout$computeTabsBounds(SingleContentLayout this$0, Ref.IntRef x, Ref.IntRef tabsWidth, JPanel component2) {
        block0: {
            TabAdapter tabAdapter;
            TabAdapter tabAdapter2 = this$0.tabAdapter;
            if (tabAdapter2 == null) break block0;
            TabAdapter $this$layout_u24computeTabsBounds_u24lambda_u241 = tabAdapter = tabAdapter2;
            boolean bl = false;
            $this$layout_u24computeTabsBounds_u24lambda_u241.setBounds(new Rectangle(x.element, 0, tabsWidth.element, component2.getHeight()));
            x.element += tabsWidth.element;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$CloseCurrentContentAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/openapi/wm/impl/content/SingleContentLayout;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isPinned", "", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nSingleContentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout$CloseCurrentContentAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,770:1\n1#2:771\n*E\n"})
    private final class CloseCurrentContentAction
    extends DumbAwareAction {
        public CloseCurrentContentAction() {
            super(CommonBundle.messagePointer((String)"action.close", (Object[])new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block2: {
                Content content2;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    content2 = SingleContentLayout.this.getSingleContentOrNull();
                    if (content2 == null || !content2.isPinned()) break block1;
                    content2.setPinned(false);
                    break block2;
                }
                Content content3 = content2;
                if (content3 == null) break block2;
                Content it = content3;
                boolean bl = false;
                ContentManager contentManager = it.getManager();
                if (contentManager != null) {
                    contentManager.removeContent(it, true);
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Content content2 = SingleContentLayout.this.getSingleContentOrNull();
            e.getPresentation().setEnabledAndVisible(content2 != null ? content2.isCloseable() : false);
            if (this.isPinned()) {
                e.getPresentation().setIcon(AllIcons.General.Pin_tab);
                e.getPresentation().setText(IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]));
            } else {
                e.getPresentation().setIcon(AllIcons.Actions.Cancel);
                e.getPresentation().setText(CommonBundle.message((String)"action.close", (Object[])new Object[0]));
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        private final boolean isPinned() {
            Content content2 = SingleContentLayout.this.getSingleContentOrNull();
            return content2 != null ? content2.isPinned() : false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$ExtendedTitleActionsGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "originActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "extendedActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/openapi/actionSystem/ActionGroup;[Lcom/intellij/openapi/actionSystem/AnAction;)V", "getOriginActions", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nSingleContentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout$ExtendedTitleActionsGroup\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,770:1\n14060#2,2:771\n1#3:773\n*S KotlinDebug\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout$ExtendedTitleActionsGroup\n*L\n574#1:771,2\n*E\n"})
    public static final class ExtendedTitleActionsGroup
    extends DefaultActionGroup {
        @Nullable
        private final ActionGroup originActions;

        public ExtendedTitleActionsGroup(@Nullable ActionGroup originActions, AnAction ... extendedActions) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)extendedActions, (String)"extendedActions");
                this.originActions = originActions;
                AnAction[] $this$forEach$iv = extendedActions;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    AnAction element$iv;
                    AnAction p0 = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    this.add(p0);
                }
                ActionGroup actionGroup = this.originActions;
                if (actionGroup == null) break block1;
                ActionGroup p0 = actionGroup;
                boolean bl = false;
                this.addAll(p0);
            }
        }

        @Nullable
        public final ActionGroup getOriginActions() {
            return this.originActions;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$HorizontalTabLayoutWithHiddenControl;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "selected", "Lkotlin/Function0;", "Ljavax/swing/JComponent;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getSelected", "()Lkotlin/jvm/functions/Function0;", "control", "Ljava/awt/Component;", "addLayoutComponent", "", "comp", "constraints", "", "removeLayoutComponent", "preferredLayoutSize", "Ljava/awt/Dimension;", "parent", "Ljava/awt/Container;", "layoutContainer", "Companion", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nSingleContentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout$HorizontalTabLayoutWithHiddenControl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,770:1\n1#2:771\n1313#3,3:772\n1342#3,2:775\n1915#4,2:777\n1915#4,2:779\n*S KotlinDebug\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout$HorizontalTabLayoutWithHiddenControl\n*L\n664#1:772,3\n677#1:775,2\n709#1:777,2\n714#1:779,2\n*E\n"})
    private static final class HorizontalTabLayoutWithHiddenControl
    extends AbstractLayoutManager {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function0<JComponent> selected;
        @Nullable
        private Component control;
        @NotNull
        public static final String CONTROL = "ControlComponent";

        public HorizontalTabLayoutWithHiddenControl(@NotNull Function0<? extends JComponent> selected) {
            Intrinsics.checkNotNullParameter(selected, (String)"selected");
            this.selected = selected;
        }

        @NotNull
        public final Function0<JComponent> getSelected() {
            return this.selected;
        }

        public void addLayoutComponent(@Nullable Component comp, @Nullable Object constraints) {
            if (Intrinsics.areEqual((Object)constraints, (Object)CONTROL)) {
                boolean bl;
                boolean bl2 = bl = this.control == null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Cannot add a second control component";
                    throw new AssertionError((Object)string);
                }
                this.control = comp;
            }
            super.addLayoutComponent(comp, constraints);
        }

        public void removeLayoutComponent(@Nullable Component comp) {
            if (this.control == comp) {
                this.control = null;
            }
            super.removeLayoutComponent(comp);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container parent) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Component[] componentArray = parent.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])componentArray), arg_0 -> HorizontalTabLayoutWithHiddenControl.preferredLayoutSize$lambda$0(this, arg_0)), HorizontalTabLayoutWithHiddenControl::preferredLayoutSize$lambda$1);
            Dimension initial$iv = new Dimension();
            boolean $i$f$fold = false;
            Dimension accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void size2;
                Dimension dimension;
                Dimension dimension2 = (Dimension)element$iv;
                Dimension acc = accumulator$iv;
                boolean bl = false;
                Dimension $this$preferredLayoutSize_u24lambda_u242_u240 = dimension = acc;
                boolean bl2 = false;
                $this$preferredLayoutSize_u24lambda_u242_u240.width += size2.width;
                $this$preferredLayoutSize_u24lambda_u242_u240.height = Math.max(acc.height, Math.max(size2.height, parent.getHeight()));
                accumulator$iv = dimension;
            }
            return accumulator$iv;
        }

        public void layoutContainer(@NotNull Container parent) {
            block7: {
                Component it;
                Component it2;
                Sequence children2;
                int eachX;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                    eachX = 0;
                    boolean canFitAllComponents = parent.getPreferredSize().width <= parent.getBounds().width;
                    Component[] componentArray = parent.getComponents();
                    Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                    children2 = SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])componentArray), arg_0 -> HorizontalTabLayoutWithHiddenControl.layoutContainer$lambda$0(this, arg_0));
                    if (!canFitAllComponents) break block6;
                    Sequence $this$forEach$iv = children2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Component it3 = (Component)element$iv;
                        boolean bl = false;
                        Dimension dim = it3.getPreferredSize();
                        it3.setBounds(new Rectangle(eachX, 0, dim.width, parent.getHeight()));
                        eachX += dim.width;
                    }
                    Component component2 = this.control;
                    if (component2 == null) break block7;
                    component2.setBounds(new Rectangle(0, 0, 0, 0));
                    break block7;
                }
                List toLayout = SequencesKt.toMutableList((Sequence)children2);
                List toRemove = new ArrayList();
                Iterable element$iv = toLayout;
                int it3 = 0;
                for (Object dim : element$iv) {
                    Component component3 = (Component)dim;
                    int n = it3;
                    boolean bl = false;
                    int n2 = it2.getPreferredSize().width;
                    it3 = n + n2;
                }
                int requiredWidth = it3;
                JComponent selected = (JComponent)this.selected.invoke();
                Serializable serializable = this.control;
                int toFitWidth = parent.getBounds().width - (serializable != null && (serializable = serializable.getPreferredSize()) != null ? ((Dimension)serializable).width : 0);
                while (requiredWidth > toFitWidth && toLayout.size() > 1) {
                    Component component4;
                    if (!Intrinsics.areEqual((Object)CollectionsKt.first((List)toLayout), (Object)selected)) {
                        requiredWidth -= ((Component)CollectionsKt.first((List)toLayout)).getPreferredSize().width + 1;
                        ((Collection)toRemove).add(CollectionsKt.first((List)toLayout));
                        component4 = (Component)toLayout.removeFirst();
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)CollectionsKt.last((List)toLayout), (Object)selected)) break;
                    requiredWidth -= ((Component)CollectionsKt.last((List)toLayout)).getPreferredSize().width + 1;
                    ((Collection)toRemove).add(CollectionsKt.last((List)toLayout));
                    component4 = (Component)toLayout.removeLast();
                }
                Iterable $this$forEach$iv = toLayout;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    it = (Component)element$iv2;
                    boolean bl = false;
                    Dimension prefSize = it.getPreferredSize();
                    it.setBounds(new Rectangle(eachX, 0, Math.min(prefSize.width, toFitWidth), parent.getHeight()));
                    eachX += prefSize.width;
                }
                $this$forEach$iv = toRemove;
                $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    it = (Component)element$iv3;
                    boolean bl = false;
                    it.setBounds(new Rectangle(0, 0, 0, 0));
                }
                Component component5 = this.control;
                if (component5 == null) break block7;
                it2 = component5;
                boolean bl = false;
                Dimension controlPrefSize = it2.getPreferredSize();
                it2.setBounds(new Rectangle(new Point(toFitWidth, (parent.getHeight() - controlPrefSize.height) / 2), controlPrefSize));
            }
        }

        private static final boolean preferredLayoutSize$lambda$0(HorizontalTabLayoutWithHiddenControl this$0, Component it) {
            return it == this$0.control;
        }

        private static final Dimension preferredLayoutSize$lambda$1(Component it) {
            return it.getPreferredSize();
        }

        private static final boolean layoutContainer$lambda$0(HorizontalTabLayoutWithHiddenControl this$0, Component it) {
            return it == this$0.control;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$HorizontalTabLayoutWithHiddenControl$Companion;", "", "<init>", "()V", "CONTROL", "", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$MyInvisibleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "intellij.platform.ide.impl"})
    public static final class MyInvisibleAction
    extends DumbAwareAction
    implements CustomComponentAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            throw new IllegalStateException("An operation is not supported".toString());
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            return (JComponent)new NonOpaquePanel();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$MyRedispatchMouseEventListener;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "redispatch", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getRedispatch", "()Lkotlin/jvm/functions/Function1;", "installOn", "component", "Ljava/awt/Component;", "mouseClicked", "e", "mousePressed", "mouseReleased", "mouseEntered", "mouseExited", "mouseDragged", "mouseMoved", "intellij.platform.ide.impl"})
    private static final class MyRedispatchMouseEventListener
    implements MouseListener,
    MouseMotionListener {
        @NotNull
        private final Function1<MouseEvent, Unit> redispatch;

        public MyRedispatchMouseEventListener(@NotNull Function1<? super MouseEvent, Unit> redispatch) {
            Intrinsics.checkNotNullParameter(redispatch, (String)"redispatch");
            this.redispatch = redispatch;
        }

        @NotNull
        public final Function1<MouseEvent, Unit> getRedispatch() {
            return this.redispatch;
        }

        public final void installOn(@NotNull Component component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            component2.addMouseListener(this);
            component2.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$SubContent;", "Lcom/intellij/ui/content/impl/ContentImpl;", "supplier", "Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "<init>", "(Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;Lcom/intellij/ui/tabs/TabInfo;)V", "getSupplier", "()Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;", "getInfo", "()Lcom/intellij/ui/tabs/TabInfo;", "pcs", "Ljava/beans/PropertyChangeSupport;", "addPropertyChangeListener", "", "l", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "isSelected", "", "isCloseable", "getIcon", "Ljavax/swing/Icon;", "intellij.platform.ide.impl"})
    public static final class SubContent
    extends ContentImpl {
        @NotNull
        private final SingleContentSupplier supplier;
        @NotNull
        private final TabInfo info;
        @NotNull
        private final PropertyChangeSupport pcs;

        public SubContent(@NotNull SingleContentSupplier supplier, @NotNull TabInfo info) {
            Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            super(info.getComponent(), info.getText(), false);
            this.supplier = supplier;
            this.info = info;
            this.pcs = new PropertyChangeSupport((Object)this);
        }

        @NotNull
        public final SingleContentSupplier getSupplier() {
            return this.supplier;
        }

        @NotNull
        public final TabInfo getInfo() {
            return this.info;
        }

        @Override
        public void addPropertyChangeListener(@Nullable PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        @Override
        public void removePropertyChangeListener(@Nullable PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        @Override
        public boolean isSelected() {
            return Intrinsics.areEqual((Object)this.supplier.getTabs().getSelectedInfo(), (Object)this.info);
        }

        @Override
        public boolean isCloseable() {
            return this.supplier.isClosable(this.info);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.info.getIcon();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00bf\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0003\u001c\u001f\"\b\u0080\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001IB'\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010$\u001a\u00020%2\u000e\u0010&\u001a\n0\u0017R\u00060\u0000R\u00020\u0018H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020(J\u001e\u0010*\u001a\u00020(2\u0014\u0010\u0015\u001a\u0010\u0012\f\u0012\n0\u0017R\u00060\u0000R\u00020\u00180+H\u0002J\b\u0010,\u001a\u00020(H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020%2\u0006\u00101\u001a\u000202H\u0002J\u001e\u00103\u001a\u00020(2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207J\u0014\u00109\u001a\u0004\u0018\u00010:2\b\u0010;\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020>H\u0014J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020HH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\f\u0012\n0\u0017R\u00060\u0000R\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#\u00a8\u0006J"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter;", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "Lcom/intellij/ui/tabs/TabsListener;", "Ljava/beans/PropertyChangeListener;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/ui/tabs/impl/MorePopupAware;", "Lcom/intellij/openapi/Disposable;", "content", "Lcom/intellij/ui/content/Content;", "jbTabs", "Lcom/intellij/ui/tabs/JBTabs;", "tabPainter", "Lcom/intellij/ui/tabs/JBTabPainter;", "twcui", "Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;", "<init>", "(Lcom/intellij/openapi/wm/impl/content/SingleContentLayout;Lcom/intellij/ui/content/Content;Lcom/intellij/ui/tabs/JBTabs;Lcom/intellij/ui/tabs/JBTabPainter;Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;)V", "getContent", "()Lcom/intellij/ui/content/Content;", "getJbTabs", "()Lcom/intellij/ui/tabs/JBTabs;", "labels", "", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$MyContentTabLabel;", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout;", "popupToolbar", "Ljavax/swing/JComponent;", "popupHandler", "com/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$popupHandler$1", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$popupHandler$1;", "closeHandler", "com/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$closeHandler$1", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$closeHandler$1;", "containerListener", "com/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$containerListener$1", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$containerListener$1;", "retrieveInfo", "Lcom/intellij/ui/tabs/TabInfo;", "label", "checkAndUpdate", "", "updateTabs", "updateLabels", "", "dispose", "getMinimumSize", "Ljava/awt/Dimension;", "copyValues", "from", "to", "Lcom/intellij/openapi/wm/impl/content/ContentLabel;", "showPopup", "component", "Ljava/awt/Component;", "x", "", "y", "getPopupMenu", "Lcom/intellij/openapi/actionSystem/ActionPopupMenu;", "tabs", "paintComponent", "g", "Ljava/awt/Graphics;", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "canShowMorePopup", "", "showMorePopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "MyContentTabLabel", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nSingleContentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,770:1\n777#2:771\n873#2,2:772\n1586#2:774\n1661#2,3:775\n1915#2,2:778\n777#2:780\n873#2,2:781\n1586#2:783\n1661#2,3:784\n1915#2,2:787\n1220#2,2:789\n1249#2,4:791\n1915#2,2:795\n1915#2,2:798\n777#2:801\n873#2,2:802\n1586#2:804\n1661#2,3:805\n13#3:797\n1#4:800\n*S KotlinDebug\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter\n*L\n400#1:771\n400#1:772,2\n401#1:774\n401#1:775,3\n412#1:778,2\n418#1:780\n418#1:781,2\n420#1:783\n420#1:784,3\n427#1:787,2\n433#1:789,2\n433#1:791,4\n437#1:795,2\n484#1:798,2\n548#1:801\n548#1:802,2\n549#1:804\n549#1:805,3\n460#1:797\n*E\n"})
    public final class TabAdapter
    extends NonOpaquePanel
    implements TabsListener,
    PropertyChangeListener,
    UiDataProvider,
    MorePopupAware,
    Disposable {
        @NotNull
        private final Content content;
        @NotNull
        private final JBTabs jbTabs;
        @NotNull
        private final JBTabPainter tabPainter;
        @NotNull
        private final ToolWindowContentUi twcui;
        @NotNull
        private final List<MyContentTabLabel> labels;
        @NotNull
        private final JComponent popupToolbar;
        @NotNull
        private final popupHandler.1 popupHandler;
        @NotNull
        private final closeHandler.1 closeHandler;
        @NotNull
        private final containerListener.1 containerListener;

        /*
         * WARNING - void declaration
         */
        public TabAdapter(@NotNull Content content2, @NotNull JBTabs jbTabs, @NotNull JBTabPainter tabPainter, ToolWindowContentUi twcui) {
            void $this$_init__u24lambda_u240;
            ActionToolbar actionToolbar2;
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)jbTabs, (String)"jbTabs");
            Intrinsics.checkNotNullParameter((Object)tabPainter, (String)"tabPainter");
            Intrinsics.checkNotNullParameter((Object)twcui, (String)"twcui");
            this.content = content2;
            this.jbTabs = jbTabs;
            this.tabPainter = tabPainter;
            this.twcui = twcui;
            this.labels = new ArrayList();
            this.popupHandler = new PopupHandler(this){
                final /* synthetic */ TabAdapter this$0;
                {
                    this.this$0 = $receiver;
                }

                public void invokePopup(Component comp, int x, int y) {
                    Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                    this.this$0.showPopup(comp, x, y);
                }
            };
            this.closeHandler = new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                        MyContentTabLabel tabLabel;
                        Component component2 = e.getComponent();
                        MyContentTabLabel myContentTabLabel = tabLabel = component2 instanceof MyContentTabLabel ? (MyContentTabLabel)component2 : null;
                        if (tabLabel != null && tabLabel.getContent().isCloseable()) {
                            tabLabel.closeContent();
                        }
                    }
                }
            };
            this.containerListener = new ContainerListener(this){
                final /* synthetic */ TabAdapter this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentAdded(ContainerEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.update(e);
                }

                public void componentRemoved(ContainerEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.update(e);
                }

                private final void update(ContainerEvent e) {
                    if (e.getChild() instanceof TabLabel) {
                        TabAdapter.access$checkAndUpdate(this.this$0);
                    }
                }
            };
            this.updateTabs();
            this.jbTabs.addListener(new TabsListener(){

                public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    this.checkAndUpdate();
                }

                public void tabRemoved(TabInfo tabToRemove) {
                    Intrinsics.checkNotNullParameter((Object)tabToRemove, (String)"tabToRemove");
                    this.checkAndUpdate();
                }

                public void tabsMoved() {
                    this.checkAndUpdate();
                }
            }, (Disposable)this);
            this.jbTabs.getComponent().addContainerListener(this.containerListener);
            AnAction tabList = ActionManager.getInstance().getAction("TabList");
            AnAction[] anActionArray = new AnAction[]{tabList, Separator.create(), new MyInvisibleAction()};
            DefaultActionGroup tabListGroup = new DefaultActionGroup(anActionArray);
            ActionToolbar actionToolbar3 = actionToolbar2 = SingleContentLayout.this.createToolbar("ToolwindowPopup", (ActionGroup)tabListGroup, (JComponent)((Object)this));
            TabAdapter tabAdapter = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.setReservePlaceAutoPopupIcon(false);
            $this$_init__u24lambda_u240.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
            JComponent jComponent = actionToolbar2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            tabAdapter.popupToolbar = jComponent;
            this.setLayout((LayoutManager)((Object)new HorizontalTabLayoutWithHiddenControl((Function0<? extends JComponent>)((Function0)() -> TabAdapter._init_$lambda$1(this)))));
            if (this.twcui.dropOverIndex != -1 && Registry.Companion.is("debugger.new.tool.window.layout.dnd", false)) {
                this.add(SingleContentLayout.this.dropOverPlaceholder, RangesKt.coerceAtMost((int)this.twcui.dropOverIndex, (int)this.getComponentCount()));
            }
            this.add(this.popupToolbar, "ControlComponent");
        }

        @NotNull
        public final Content getContent() {
            return this.content;
        }

        @NotNull
        public final JBTabs getJbTabs() {
            return this.jbTabs;
        }

        private final TabInfo retrieveInfo(MyContentTabLabel label2) {
            return label2.getContent().getInfo();
        }

        /*
         * WARNING - void declaration
         */
        private final void checkAndUpdate() {
            void $this$mapTo$iv$iv;
            Collection destination$iv$iv;
            Iterable $this$filter$iv;
            Content currentContent = SingleContentLayout.this.getSingleContentOrNull();
            SingleContentSupplier currentSupplier = currentContent != null ? SingleContentLayout.this.getSupplier(currentContent) : null;
            Object object = currentSupplier;
            if (object != null && (object = object.getTabs()) != null && (object = object.getTabs()) != null) {
                void $this$filterTo$iv$iv;
                $this$filter$iv = (Iterable)object;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TabInfo it = (TabInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isHidden())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
            } else {
                return;
            }
            List src = (List)destination$iv$iv;
            Iterable $this$map$iv = this.labels;
            boolean $i$f$map = false;
            $this$filter$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                MyContentTabLabel myContentTabLabel = (MyContentTabLabel)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(this.retrieveInfo((MyContentTabLabel)p0));
            }
            List dst = (List)destination$iv$iv2;
            if (!ContainerUtil.equalsIdentity((List)src, (List)dst)) {
                this.updateTabs();
            }
            SingleContentLayout.this.updateSingleContentView(currentContent, currentSupplier);
            this.updateLabels(this.labels);
            this.revalidate();
        }

        /*
         * WARNING - void declaration
         */
        public final void updateTabs() {
            void $this$filterTo$iv$iv;
            Object info;
            CollectionsKt.removeAll(this.labels, arg_0 -> TabAdapter.updateTabs$lambda$0(this, arg_0));
            List list2 = this.jbTabs.getTabs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach22 = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                info = (TabInfo)element$iv;
                boolean bl = false;
                info.getChangeSupport().removePropertyChangeListener(this);
                info.getChangeSupport().addPropertyChangeListener(this);
            }
            Content $i$f$forEach22 = SingleContentLayout.this.getSingleContentOrNull();
            if ($i$f$forEach22 == null || (object = SingleContentLayout.this.getSupplier($i$f$forEach22)) == null) {
                return;
            }
            Object supplier = object;
            List list3 = this.jbTabs.getTabs();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getTabs(...)");
            Iterable $this$filter$iv = list3;
            boolean $i$f$filter2 = false;
            info = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TabInfo it = (TabInfo)element$iv$iv;
                boolean bl = false;
                if (!(!it.isHidden())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List visibleTabs = (List)destination$iv$iv;
            if (visibleTabs.size() > 1 || this.twcui.dropOverIndex != -1 && Registry.Companion.is("debugger.new.tool.window.layout.dnd", false)) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$filter$iv = visibleTabs;
                SingleContentLayout $i$f$filter2 = SingleContentLayout.this;
                List<MyContentTabLabel> list4 = this.labels;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    MyContentTabLabel myContentTabLabel;
                    void info2;
                    TabInfo bl = (TabInfo)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)info2);
                    SubContent content2 = new SubContent((SingleContentSupplier)supplier, (TabInfo)info2);
                    supplier.addSubContent((TabInfo)info2, content2);
                    MyContentTabLabel $this$updateTabs_u24lambda_u243_u240 = myContentTabLabel = new MyContentTabLabel(content2, $i$f$filter2);
                    boolean bl3 = false;
                    $this$updateTabs_u24lambda_u243_u240.addMouseListener(this.closeHandler);
                    collection.add(myContentTabLabel);
                }
                list4.addAll((List)destination$iv$iv2);
                Iterable $this$forEach$iv2 = this.labels;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Component p0 = (Component)element$iv;
                    boolean bl = false;
                    this.add(p0);
                }
            }
            this.updateLabels(this.labels);
        }

        /*
         * WARNING - void declaration
         */
        private final void updateLabels(List<MyContentTabLabel> labels) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = labels;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                MyContentTabLabel myContentTabLabel = (MyContentTabLabel)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.getContent().getInfo(), element$iv$iv);
            }
            destination$iv$iv.forEach((arg_0, arg_1) -> TabAdapter.updateLabels$lambda$1((Function2)new Function2<TabInfo, ContentLabel, Unit>((Object)this){

                public final void invoke(TabInfo p0, ContentLabel p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    TabAdapter.access$copyValues((TabAdapter)this.receiver, p0, p1);
                }
            }, arg_0, arg_1));
        }

        public void dispose() {
            List list2 = this.jbTabs.getTabs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTabs(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TabInfo it = (TabInfo)element$iv;
                boolean bl = false;
                it.getChangeSupport().removePropertyChangeListener(this);
            }
            this.jbTabs.getComponent().removeContainerListener(this.containerListener);
        }

        @NotNull
        public Dimension getMinimumSize() {
            if (this.isMinimumSizeSet()) {
                Dimension dimension = super.getMinimumSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getMinimumSize(...)");
                return dimension;
            }
            int minWidth = this.labels.isEmpty() ? 0 : this.popupToolbar.getPreferredSize().width;
            return new Dimension(minWidth, 0);
        }

        private final void copyValues(TabInfo from, ContentLabel to) {
            to.setIcon(from.getIcon());
            to.setText(from.getText());
        }

        public final void showPopup(@NotNull Component component2, int x, int y) {
            SingleContentSupplier supplier;
            TabInfo info;
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            ContentTabLabel contentTabLabel = component2 instanceof ContentTabLabel ? (ContentTabLabel)component2 : null;
            Content content2 = contentTabLabel != null ? contentTabLabel.getContent() : null;
            SubContent subContent = content2 instanceof SubContent ? (SubContent)content2 : null;
            Object object = info = subContent != null ? subContent.getInfo() : null;
            if (info == null) {
                boolean $i$f$logger = false;
                Logger logger2 = Logger.getInstance(SingleContentLayout.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.warn("Cannot resolve label popup component. Event will be ignored");
                return;
            }
            content2 = SingleContentLayout.this.getSingleContentOrNull();
            SingleContentSupplier singleContentSupplier = supplier = content2 != null ? SingleContentLayout.this.getSupplier(content2) : null;
            ActionPopupMenu actionPopupMenu = this.getPopupMenu((JBTabs)(singleContentSupplier != null ? singleContentSupplier.getTabs() : null));
            if (actionPopupMenu == null) {
                return;
            }
            ActionPopupMenu toShow = actionPopupMenu;
            toShow.setTargetComponent((JComponent)component2);
            JBPopupMenu.showAt((RelativePoint)new RelativePoint(component2, new Point(x, y)), (JPopupMenu)toShow.getComponent());
        }

        private final ActionPopupMenu getPopupMenu(JBTabs tabs) {
            JBTabsImpl jBTabsImpl = tabs instanceof JBTabsImpl ? (JBTabsImpl)tabs : null;
            if (jBTabsImpl == null) {
                return null;
            }
            JBTabsImpl jbTabsImpl = jBTabsImpl;
            ActionGroup actionGroup = jbTabsImpl.getPopupGroup();
            if (actionGroup == null) {
                return null;
            }
            ActionGroup popup2 = actionGroup;
            String string = jbTabsImpl.getPopupPlace();
            if (string == null) {
                string = "unknown";
            }
            String popupPlace = string;
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.addAll(popup2);
            group2.addSeparator();
            group2.addAll(jbTabsImpl.getNavigationActions());
            return ActionManager.getInstance().createActionPopupMenu(popupPlace, (ActionGroup)group2);
        }

        /*
         * WARNING - void declaration
         */
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (g instanceof Graphics2D) {
                void $this$forEach$iv;
                Iterable iterable = this.labels;
                SingleContentLayout singleContentLayout = SingleContentLayout.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MyContentTabLabel comp = (MyContentTabLabel)element$iv;
                    boolean bl = false;
                    Rectangle labelBounds = comp.getBounds();
                    if (Intrinsics.areEqual((Object)this.jbTabs.getSelectedInfo(), (Object)this.retrieveInfo(comp))) {
                        JBTabsPosition jBTabsPosition = singleContentLayout.getTabsPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)jBTabsPosition, (String)"getTabsPosition(...)");
                        Graphics2D graphics2D = (Graphics2D)g;
                        Intrinsics.checkNotNull((Object)labelBounds);
                        this.tabPainter.paintSelectedTab(jBTabsPosition, graphics2D, labelBounds, 1, null, this.twcui.window.isActive(), comp.isHovered());
                        continue;
                    }
                    JBTabsPosition jBTabsPosition = singleContentLayout.getTabsPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)jBTabsPosition, (String)"getTabsPosition(...)");
                    Graphics2D graphics2D = (Graphics2D)g;
                    Intrinsics.checkNotNull((Object)labelBounds);
                    this.tabPainter.paintTab(jBTabsPosition, graphics2D, labelBounds, 1, null, this.twcui.window.isActive(), comp.isHovered());
                }
            }
            super.paintComponent(g);
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            Object object = evt.getSource();
            TabInfo tabInfo = object instanceof TabInfo ? (TabInfo)object : null;
            if (tabInfo == null) {
                throw new IllegalStateException("Bad event source".toString());
            }
            TabInfo source = tabInfo;
            if (Intrinsics.areEqual((Object)"hidden", (Object)evt.getPropertyName())) {
                Object object2 = evt.getNewValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean isHidden = (Boolean)object2;
                ClientProperty.put((JComponent)source.getComponent(), SingleContentSupplier.DRAGGED_OUT_KEY, (Object)(isHidden ? Boolean.valueOf(true) : null));
                this.checkAndUpdate();
            } else {
                Object v2;
                block5: {
                    Iterable iterable = this.labels;
                    for (Object t : iterable) {
                        MyContentTabLabel it = (MyContentTabLabel)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getContent().getInfo(), (Object)source)) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                MyContentTabLabel label2 = v2;
                if (label2 != null) {
                    this.copyValues(source, label2);
                }
            }
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey dataKey = MorePopupAware.KEY;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"KEY");
            sink.set(dataKey, (Object)this);
        }

        public boolean canShowMorePopup() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public JBPopup showMorePopup() {
            void $this$mapTo$iv$iv;
            MyContentTabLabel it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.labels;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MyContentTabLabel)element$iv$iv;
                boolean bl = false;
                if (!(it.getBounds().width <= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                it = (MyContentTabLabel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getContent());
            }
            List contentToShow = (List)destination$iv$iv;
            BaseListPopupStep<SubContent> step2 = new BaseListPopupStep<SubContent>((List<SubContent>)contentToShow, this){
                final /* synthetic */ TabAdapter this$0;
                {
                    this.this$0 = $receiver;
                    super(null, $contentToShow);
                }

                public PopupStep<?> onChosen(SubContent selectedValue, boolean finalChoice) {
                    Intrinsics.checkNotNullParameter((Object)((Object)selectedValue), (String)"selectedValue");
                    this.this$0.getJbTabs().select(selectedValue.getInfo(), true);
                    return BaseListPopupStep.FINAL_CHOICE;
                }

                public Icon getIconFor(SubContent value) {
                    Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                    return value.getIcon();
                }

                public String getTextFor(SubContent value) {
                    Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                    return value.getDisplayName();
                }
            };
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
            ListPopup popup2 = listPopup;
            popup2.show(RelativePoint.getSouthWestOf((JComponent)this.popupToolbar));
            return (JBPopup)popup2;
        }

        private static final JComponent _init_$lambda$1(TabAdapter this$0) {
            Object v0;
            block1: {
                Iterable iterable = this$0.labels;
                for (Object t : iterable) {
                    MyContentTabLabel it = (MyContentTabLabel)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getContent().getInfo(), (Object)this$0.jbTabs.getSelectedInfo())) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private static final boolean updateTabs$lambda$0(TabAdapter this$0, MyContentTabLabel it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.remove(it);
            return true;
        }

        private static final void updateLabels$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        public static final /* synthetic */ void access$copyValues(TabAdapter $this, TabInfo from, ContentLabel to) {
            $this.copyValues(from, to);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$MyContentTabLabel;", "Lcom/intellij/openapi/wm/impl/content/ContentTabLabel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "content", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$SubContent;", "layout", "Lcom/intellij/openapi/wm/impl/content/TabContentLayout;", "<init>", "(Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter;Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$SubContent;Lcom/intellij/openapi/wm/impl/content/TabContentLayout;)V", "selectContent", "", "closeContent", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getContent", "intellij.platform.ide.impl"})
        @SourceDebugExtension(value={"SMAP\nSingleContentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleContentLayout.kt\ncom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$MyContentTabLabel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,770:1\n1#2:771\n*E\n"})
        private final class MyContentTabLabel
        extends ContentTabLabel
        implements UiDataProvider {
            public MyContentTabLabel(@NotNull SubContent content2, TabContentLayout layout2) {
                Intrinsics.checkNotNullParameter((Object)((Object)content2), (String)"content");
                Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
                super(content2, layout2);
                this.addMouseListener((MouseListener)((Object)TabAdapter.this.popupHandler));
            }

            @Override
            protected void selectContent() {
                TabInfo tabInfo = TabAdapter.this.retrieveInfo(this);
                TabAdapter tabAdapter = TabAdapter.this;
                TabInfo it = tabInfo;
                boolean bl = false;
                tabAdapter.getJbTabs().select(it, true);
            }

            @Override
            public void closeContent() {
                block0: {
                    TabInfo tabInfo = TabAdapter.this.retrieveInfo(this);
                    SingleContentLayout singleContentLayout = SingleContentLayout.this;
                    TabInfo info = tabInfo;
                    boolean bl = false;
                    Object object = singleContentLayout.getSingleContentOrNull();
                    if (object == null || (object = singleContentLayout.getSupplier((Content)object)) == null) break block0;
                    object.close(info);
                }
            }

            public void uiDataSnapshot(@NotNull DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                JBTabs jBTabs = TabAdapter.this.getJbTabs();
                sink.set(JBTabsEx.NAVIGATION_ACTIONS_KEY, (Object)(jBTabs instanceof JBTabsEx ? (JBTabsEx)jBTabs : null));
                DataSink.Companion.uiDataSnapshot(sink, (Object)TabAdapter.this.retrieveInfo(this).getComponent());
            }

            @Override
            @NotNull
            public SubContent getContent() {
                Content content2 = super.getContent();
                Intrinsics.checkNotNull((Object)content2, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.content.SingleContentLayout.SubContent");
                return (SubContent)content2;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$ToolbarType;", "", "<init>", "(Ljava/lang/String;I)V", "MAIN", "CLOSE_GROUP", "intellij.platform.ide.impl"})
    private static final class ToolbarType
    extends Enum<ToolbarType> {
        public static final /* enum */ ToolbarType MAIN = new ToolbarType();
        public static final /* enum */ ToolbarType CLOSE_GROUP = new ToolbarType();
        private static final /* synthetic */ ToolbarType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ToolbarType[] values() {
            return (ToolbarType[])$VALUES.clone();
        }

        public static ToolbarType valueOf(String value) {
            return Enum.valueOf(ToolbarType.class, value);
        }

        @NotNull
        public static EnumEntries<ToolbarType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = toolbarTypeArray = new ToolbarType[]{ToolbarType.MAIN, ToolbarType.CLOSE_GROUP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

