/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.header;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeaderKt;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.WindowDecorations;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J2\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0 \"\u00020\u001b2\u000e\b\u0004\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0003H\u0082\b\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\u001eJ\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020\u001eJ8\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010*\u001a\u00020+H\u0016J\b\u00104\u001a\u00020\u0004H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00065"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomFrameTopBorder;", "Ljavax/swing/border/Border;", "isTopNeeded", "Lkotlin/Function0;", "", "isBottomNeeded", "header", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;)V", "bottomBorderWidthLogicalPx", "", "defaultActiveBorder", "Ljava/awt/Color;", "inactiveColor", "menuBarBorderColor", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "colorizationAffectsBorders", "activeColor", "calculateAffectsBorders", "calculateActiveBorderColor", "calculateWindowBorderThicknessInLogicalPx", "", "listeners", "", "Lkotlin/Pair;", "", "Ljava/beans/PropertyChangeListener;", "listenForPropertyChanges", "", "propertyNames", "", "action", "([Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "addNotify", "removeNotify", "repaintBorder", "shouldDrawTopBorder", "getShouldDrawTopBorder", "()Z", "paintBorder", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "getBorderInsets", "Ljava/awt/Insets;", "isBorderOpaque", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nCustomHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomHeader.kt\ncom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomFrameTopBorder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,459:1\n387#1,7:461\n387#1,7:468\n13#2:460\n*S KotlinDebug\n*F\n+ 1 CustomHeader.kt\ncom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomFrameTopBorder\n*L\n397#1:461,7\n403#1:468,7\n376#1:460\n*E\n"})
public final class CustomFrameTopBorder
implements Border {
    @JvmField
    @NotNull
    public final Function0<Boolean> isTopNeeded;
    @JvmField
    @NotNull
    public final Function0<Boolean> isBottomNeeded;
    @JvmField
    @NotNull
    public final CustomHeader header;
    private final int bottomBorderWidthLogicalPx;
    @NotNull
    private final Color defaultActiveBorder;
    @NotNull
    private final Color inactiveColor;
    @NotNull
    private final JBColor menuBarBorderColor;
    private boolean colorizationAffectsBorders;
    @NotNull
    private Color activeColor;
    @NotNull
    private final List<Pair<String, PropertyChangeListener>> listeners;

    public CustomFrameTopBorder(@NotNull Function0<Boolean> isTopNeeded, @NotNull Function0<Boolean> isBottomNeeded, @NotNull CustomHeader header) {
        Intrinsics.checkNotNullParameter(isTopNeeded, (String)"isTopNeeded");
        Intrinsics.checkNotNullParameter(isBottomNeeded, (String)"isBottomNeeded");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        this.isTopNeeded = isTopNeeded;
        this.isBottomNeeded = isBottomNeeded;
        this.header = header;
        this.bottomBorderWidthLogicalPx = JBUI.scale((int)1);
        this.defaultActiveBorder = new Color(0x707070);
        this.inactiveColor = new Color(0xAAAAAA);
        JBColor jBColor = JBColor.namedColor((String)"MenuBar.borderColor", (Color)((Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        this.menuBarBorderColor = jBColor;
        this.activeColor = this.defaultActiveBorder;
        this.listeners = new ArrayList();
    }

    public /* synthetic */ CustomFrameTopBorder(Function0 function0, Function0 function02, CustomHeader customHeader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = CustomFrameTopBorder::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            function02 = CustomFrameTopBorder::_init_$lambda$1;
        }
        this((Function0<Boolean>)function0, (Function0<Boolean>)function02, customHeader);
    }

    private final boolean calculateAffectsBorders() {
        if (SystemInfoRt.isWindows) {
            long windowsBuild;
            Long l = SystemInfo.getWinBuildNumber();
            long l2 = windowsBuild = l != null ? l : 0L;
            if (windowsBuild < 17763L) {
                return true;
            }
        }
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.dwm.colorizationColor.affects.borders");
        return bl != null ? bl : true;
    }

    private final Color calculateActiveBorderColor() {
        if (!this.colorizationAffectsBorders) {
            return this.defaultActiveBorder;
        }
        try {
            Integer colorizationColorBalance;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Color colorizationColor = (Color)toolkit.getDesktopProperty("win.dwm.colorizationColor");
            if (colorizationColor != null && (colorizationColorBalance = (Integer)toolkit.getDesktopProperty("win.dwm.colorizationColorBalance")) != null) {
                if (colorizationColorBalance > 100) {
                    colorizationColorBalance = 100;
                }
                if (colorizationColorBalance < 0) {
                    colorizationColorBalance = 100;
                }
                return switch (colorizationColorBalance) {
                    case 0 -> new Color(0xD9D9D9);
                    case 100 -> colorizationColor;
                    default -> {
                        float alpha = (float)colorizationColorBalance.intValue() / 100.0f;
                        float remainder = 1.0f - alpha;
                        int r = MathKt.roundToInt((float)((float)colorizationColor.getRed() * alpha + (float)217 * remainder));
                        int g = MathKt.roundToInt((float)((float)colorizationColor.getGreen() * alpha + (float)217 * remainder));
                        int b = MathKt.roundToInt((float)((float)colorizationColor.getBlue() * alpha + (float)217 * remainder));
                        yield new Color(r, g, b);
                    }
                };
            }
            Color color = colorizationColor;
            if (color == null && (color = (Color)toolkit.getDesktopProperty("win.frame.activeBorderColor")) == null) {
                color = (Color)this.menuBarBorderColor;
            }
            return color;
        }
        catch (Throwable t) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(CustomHeader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error(t);
            return this.defaultActiveBorder;
        }
    }

    private final double calculateWindowBorderThicknessInLogicalPx() {
        return (double)CustomHeaderKt.access$getWindowBorderThicknessInPhysicalPx() / (double)JBUIScale.sysScale((Component)this.header.window);
    }

    private final void listenForPropertyChanges(String[] propertyNames, Function0<Unit> action2) {
        boolean $i$f$listenForPropertyChanges = false;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PropertyChangeListener listener2 = new PropertyChangeListener(action2){
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$action = $action;
            }

            public final void propertyChange(PropertyChangeEvent it) {
                this.$action.invoke();
            }
        };
        for (String property : propertyNames) {
            toolkit.addPropertyChangeListener(property, listener2);
            this.listeners.add((Pair<String, PropertyChangeListener>)TuplesKt.to((Object)property, (Object)listener2));
        }
    }

    public final void addNotify() {
        CustomFrameTopBorder this_$iv;
        String[] propertyNames$iv;
        this.colorizationAffectsBorders = this.calculateAffectsBorders();
        CustomFrameTopBorder customFrameTopBorder = this;
        String[] stringArray = new String[]{"win.dwm.colorizationColor.affects.borders"};
        boolean $i$f$listenForPropertyChanges = false;
        Toolkit toolkit$iv = Toolkit.getDefaultToolkit();
        PropertyChangeListener listener$iv = new PropertyChangeListener(this){
            final /* synthetic */ CustomFrameTopBorder this$0;
            {
                this.this$0 = customFrameTopBorder;
            }

            public final void propertyChange(PropertyChangeEvent it) {
                boolean bl = false;
                CustomFrameTopBorder.access$setColorizationAffectsBorders$p(this.this$0, CustomFrameTopBorder.access$calculateAffectsBorders(this.this$0));
                CustomFrameTopBorder.access$setActiveColor$p(this.this$0, CustomFrameTopBorder.access$calculateActiveBorderColor(this.this$0));
            }
        };
        for (String property$iv : propertyNames$iv) {
            toolkit$iv.addPropertyChangeListener(property$iv, listener$iv);
            this_$iv.listeners.add((Pair<String, PropertyChangeListener>)TuplesKt.to((Object)property$iv, (Object)listener$iv));
        }
        this.activeColor = this.calculateActiveBorderColor();
        this_$iv = this;
        propertyNames$iv = new String[]{"win.dwm.colorizationColor", "win.dwm.colorizationColorBalance", "win.frame.activeBorderColor"};
        $i$f$listenForPropertyChanges = false;
        toolkit$iv = Toolkit.getDefaultToolkit();
        listener$iv = new PropertyChangeListener(this){
            final /* synthetic */ CustomFrameTopBorder this$0;
            {
                this.this$0 = customFrameTopBorder;
            }

            public final void propertyChange(PropertyChangeEvent it) {
                boolean bl = false;
                CustomFrameTopBorder.access$setActiveColor$p(this.this$0, CustomFrameTopBorder.access$calculateActiveBorderColor(this.this$0));
            }
        };
        for (String property$iv : propertyNames$iv) {
            toolkit$iv.addPropertyChangeListener(property$iv, listener$iv);
            this_$iv.listeners.add((Pair<String, PropertyChangeListener>)TuplesKt.to((Object)property$iv, (Object)listener$iv));
        }
    }

    public final void removeNotify() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        for (Pair<String, PropertyChangeListener> pair : this.listeners) {
            String propertyName = (String)pair.component1();
            PropertyChangeListener listener2 = (PropertyChangeListener)pair.component2();
            toolkit.removePropertyChangeListener(propertyName, listener2);
        }
        this.listeners.clear();
    }

    public final void repaintBorder() {
        Insets borderInsets = this.getBorderInsets(this.header);
        double thickness = this.calculateWindowBorderThicknessInLogicalPx();
        this.header.repaint(0, 0, this.header.getWidth(), (int)Math.ceil(thickness));
        this.header.repaint(0, this.header.getHeight() - borderInsets.bottom, this.header.getWidth(), borderInsets.bottom);
    }

    private final boolean getShouldDrawTopBorder() {
        boolean drawTopBorderActive = this.header.isActive && (this.colorizationAffectsBorders || UIUtil.isUnderIntelliJLaF());
        boolean drawTopBorderInactive = !this.header.isActive && UIUtil.isUnderIntelliJLaF();
        return drawTopBorderActive || drawTopBorderInactive;
    }

    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        double thickness = this.calculateWindowBorderThicknessInLogicalPx();
        if (((Boolean)this.isTopNeeded.invoke()).booleanValue() && this.getShouldDrawTopBorder()) {
            g.setColor(this.header.isActive ? this.activeColor : this.inactiveColor);
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y, (double)width, (double)y, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)thickness);
        }
        if (((Boolean)this.isBottomNeeded.invoke()).booleanValue()) {
            g.setColor((Color)this.menuBarBorderColor);
            int y1 = y + height - this.bottomBorderWidthLogicalPx;
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y1, (double)width, (double)y1);
        }
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        double thickness = this.calculateWindowBorderThicknessInLogicalPx();
        int top = (Boolean)this.isTopNeeded.invoke() != false && (this.colorizationAffectsBorders || StartupUiUtil.isUnderIntelliJLaF()) ? (int)Math.ceil(thickness) : 0;
        int bottom = (Boolean)this.isBottomNeeded.invoke() != false ? this.bottomBorderWidthLogicalPx : 0;
        WindowDecorations.CustomTitleBar customTitleBar = this.header.getCustomTitleBar();
        int left = customTitleBar != null ? (int)customTitleBar.getLeftInset() : 0;
        WindowDecorations.CustomTitleBar customTitleBar2 = this.header.getCustomTitleBar();
        int right = customTitleBar2 != null ? (int)customTitleBar2.getRightInset() : 0;
        return new Insets(top, left, bottom, right);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    private static final boolean _init_$lambda$0() {
        return true;
    }

    private static final boolean _init_$lambda$1() {
        return false;
    }

    public static final /* synthetic */ void access$setColorizationAffectsBorders$p(CustomFrameTopBorder $this, boolean bl) {
        $this.colorizationAffectsBorders = bl;
    }

    public static final /* synthetic */ boolean access$calculateAffectsBorders(CustomFrameTopBorder $this) {
        return $this.calculateAffectsBorders();
    }

    public static final /* synthetic */ void access$setActiveColor$p(CustomFrameTopBorder $this, Color color) {
        $this.activeColor = color;
    }

    public static final /* synthetic */ Color access$calculateActiveBorderColor(CustomFrameTopBorder $this) {
        return $this.calculateActiveBorderColor();
    }
}

