/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.i18n;

import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\u001a%\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a\u001c\u0010\u0007\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"format", "", "raw", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "charAtIs", "", "i", "", "c", "", "intellij.platform.syntax.i18n"})
public final class FormatKt {
    @NotNull
    public static final String format(@NotNull String raw, @NotNull Object[] params) {
        StringBuilder builder = new StringBuilder(raw.length() + 16 * params.length);
        boolean inQuote = false;
        StringBuilder indexBuilder = null;
        int i2 = -1;
        block5: while (++i2 < raw.length()) {
            char c = raw.charAt(i2);
            switch (c) {
                case '\'': {
                    if (indexBuilder != null) {
                        throw new IllegalArgumentException("Index expression must not contain single quotes: " + raw + ", position " + i2);
                    }
                    if (FormatKt.charAtIs(raw, i2 + 1, '\'')) {
                        builder.append(c);
                        ++i2;
                        continue block5;
                    }
                    inQuote = !inQuote;
                    continue block5;
                }
                case '{': {
                    if (inQuote) {
                        builder.append(c);
                        continue block5;
                    }
                    indexBuilder = new StringBuilder();
                    continue block5;
                }
                case '}': {
                    if (inQuote) {
                        builder.append(c);
                        continue block5;
                    }
                    if (indexBuilder == null) {
                        builder.append(c);
                        continue block5;
                    }
                    Integer injectionIndex = StringsKt.toIntOrNull((String)indexBuilder.toString());
                    StringBuilder stringBuilder = injectionIndex != null && injectionIndex >= 0 && injectionIndex < params.length ? builder.append(params[injectionIndex]) : builder.append('{').append((CharSequence)indexBuilder).append('}');
                    indexBuilder = null;
                    continue block5;
                }
            }
            if (indexBuilder != null) {
                indexBuilder.append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static final boolean charAtIs(String $this$charAtIs, int i2, char c) {
        return i2 < $this$charAtIs.length() && $this$charAtIs.charAt(i2) == c;
    }
}

