/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.StoredPropertyBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\b\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\b\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0096\u0082\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u0096\u0080\u0004R\u001c\u0010\u0003\u001a\u00028\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/serialization/stateProperties/ObjectStateStoredPropertyBase;", "T", "Lcom/intellij/openapi/components/StoredPropertyBase;", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "setValue", "Ljava/lang/Object;", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "thisRef", "Lcom/intellij/openapi/components/BaseState;", "(Lcom/intellij/openapi/components/BaseState;)Ljava/lang/Object;", "", "newValue", "(Lcom/intellij/openapi/components/BaseState;Ljava/lang/Object;)V", "", "other", "Lcom/intellij/openapi/components/StoredProperty;", "equals", "", "hashCode", "", "toString", "", "intellij.platform.objectSerializer"})
@ApiStatus.Internal
public abstract class ObjectStateStoredPropertyBase<T>
extends StoredPropertyBase<T> {
    private T value;

    public ObjectStateStoredPropertyBase(T value) {
        this.value = value;
    }

    protected final T getValue() {
        return this.value;
    }

    protected final void setValue(T t) {
        this.value = t;
    }

    @NotNull
    public JsonSchemaType getJsonType() {
        return JsonSchemaType.OBJECT;
    }

    public T getValue(@NotNull BaseState thisRef) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        return this.value;
    }

    public void setValue(@NotNull BaseState thisRef, T newValue) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        if (!Intrinsics.areEqual(this.value, newValue)) {
            T v = this.value;
            if (v instanceof BaseState) {
                thisRef.addModificationCount(((BaseState)v).getModificationCount() + 1L);
            } else {
                thisRef.intIncrementModificationCount();
            }
            this.value = newValue;
        }
    }

    public boolean setValue(@NotNull StoredProperty<T> other) {
        boolean bl;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        T newValue = ((ObjectStateStoredPropertyBase)other).value;
        if (Intrinsics.areEqual(newValue, this.value)) {
            bl = false;
        } else {
            this.value = newValue;
            bl = true;
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ObjectStateStoredPropertyBase && Intrinsics.areEqual(this.value, ((ObjectStateStoredPropertyBase)((Object)other)).value);
    }

    public int hashCode() {
        T t = this.value;
        return t != null ? t.hashCode() : 0;
    }

    @NotNull
    public String toString() {
        String string;
        String string2 = this.getName();
        if (this.isEqualToDefault()) {
            string = "";
        } else {
            string = this.value;
            if (string == null || (string = string.toString()) == null) {
                string = super.toString();
            }
        }
        return string2 + " = " + string;
    }
}

