/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.NotPatchedIconRegistry;
import com.intellij.ide.ui.NotRoamableUiSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0005H\u0002\u001a(\u0010\n\u001a\u00020\u000b2\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r0\rH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "resetLafSettingsToDefault", "", "patchUiDefaultsForNewUi", "reflectivePathPrefix", "", "iconPathPrefix", "createPathPatcher", "Lcom/intellij/openapi/util/IconPathPatcher;", "paths", "", "Ljava/lang/ClassLoader;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nExperimentalUIImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExperimentalUIImpl.kt\ncom/intellij/ui/ExperimentalUIImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,298:1\n13#2:299\n*S KotlinDebug\n*F\n+ 1 ExperimentalUIImpl.kt\ncom/intellij/ui/ExperimentalUIImplKt\n*L\n31#1:299\n*E\n"})
public final class ExperimentalUIImplKt {
    @NotNull
    private static final String reflectivePathPrefix = "com.intellij.icons.AllIcons.";
    @NotNull
    private static final String iconPathPrefix = "expui/";

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ExperimentalUI.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return logger2;
    }

    private static final void resetLafSettingsToDefault() {
        LafManager lafManager = LafManager.getInstance();
        UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = lafManager.getDefaultLightLaf();
        if (uIThemeLookAndFeelInfo == null) {
            return;
        }
        UIThemeLookAndFeelInfo defaultLightLaf = uIThemeLookAndFeelInfo;
        UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo2 = lafManager.getDefaultDarkLaf();
        if (uIThemeLookAndFeelInfo2 == null) {
            return;
        }
        UIThemeLookAndFeelInfo defaultDarkLaf = uIThemeLookAndFeelInfo2;
        UIThemeLookAndFeelInfo laf = JBColor.isBright() ? defaultLightLaf : defaultDarkLaf;
        lafManager.setCurrentUIThemeLookAndFeel(laf);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNull((Object)editorColorsManager, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl");
        EditorColorsManagerImpl editorColorsManager2 = (EditorColorsManagerImpl)editorColorsManager;
        String editorSchemeId = laf.getEditorSchemeId();
        if (editorSchemeId == null && !ExperimentalUI.Companion.isNewUI() && Intrinsics.areEqual((Object)"Darcula", (Object)laf.getName())) {
            editorSchemeId = "Darcula";
        }
        String string = editorSchemeId;
        EditorColorsScheme scheme = string == null ? null : editorColorsManager2.getScheme(string);
        editorColorsManager2.setGlobalScheme(scheme, true);
        ExperimentalUIImplKt.getLOG().info("=== UI: reset laf (" + laf + " | " + editorSchemeId + " | " + scheme + ") ===");
        if (lafManager.getAutodetect()) {
            lafManager.setPreferredLightLaf(defaultLightLaf);
            lafManager.setPreferredDarkLaf(defaultDarkLaf);
            lafManager.resetPreferredEditorColorScheme();
        }
    }

    private static final void patchUiDefaultsForNewUi() {
        if (SystemInfo.isJetBrainsJvm && EarlyAccessRegistryManager.INSTANCE.getBoolean("ide.experimental.ui.inter.font") && UISettings.Companion.getInstance().getOverrideLafFonts()) {
            NotRoamableUiSettings.Companion.getInstance().setOverrideLafFonts(false);
        }
    }

    private static final IconPathPatcher createPathPatcher(Map<ClassLoader, ? extends Map<String, String>> paths) {
        return new IconPathPatcher(paths){
            private final boolean dumpNotPatchedIcons;
            final /* synthetic */ Map<ClassLoader, Map<String, String>> $paths;
            {
                this.$paths = $paths;
                this.dumpNotPatchedIcons = Boolean.parseBoolean(System.getProperty("ide.experimental.ui.dump.not.patched.icons"));
            }

            private final boolean getUseReflectivePath() {
                return Boolean.parseBoolean(System.getProperty("ide.experimental.ui.use.reflective.path", "true"));
            }

            public String patchPath(String path, ClassLoader classLoader) {
                Object object;
                Object object2;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        object2 = classLoader;
                        if (object2 == null) break block5;
                        object = object2;
                        Map<ClassLoader, Map<String, String>> map2 = this.$paths;
                        ClassLoader it = object;
                        boolean bl = false;
                        Map<String, String> map3 = map2.get(classLoader);
                        object2 = map3;
                        if (map3 != null) break block6;
                    }
                    return null;
                }
                Object mappings = object2;
                object = new char[1];
                object[0] = 47;
                String patchedPath = (String)mappings.get(StringsKt.trimStart((String)path, (char[])object));
                if (patchedPath == null && this.dumpNotPatchedIcons) {
                    NotPatchedIconRegistry.INSTANCE.registerNotPatchedIcon(path, classLoader);
                }
                if (patchedPath != null && this.getUseReflectivePath() && !(classLoader instanceof PluginAwareClassLoader) && StringsKt.startsWith$default((String)patchedPath, (String)"expui/", (boolean)false, (int)2, null) && !PluginManagerCore.isRunningFromSources()) {
                    StringBuilder builder = new StringBuilder(28 + patchedPath.length());
                    builder.append("com.intellij.icons.AllIcons.");
                    builder.append(patchedPath, 6, patchedPath.length() - 4);
                    return this.toReflectivePath(builder).toString();
                }
                return patchedPath;
            }

            private final StringBuilder toReflectivePath(StringBuilder name2) {
                int index = 28;
                name2.setCharAt(index, Character.toTitleCase(name2.charAt(index)));
                int appendIndex = ++index;
                block4: while (index < name2.length()) {
                    char c = name2.charAt(index);
                    if (index == 28 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c)) {
                        name2.setCharAt(appendIndex++, c);
                        ++index;
                        continue;
                    }
                    switch (c) {
                        case '-': {
                            if (++index == name2.length()) break block4;
                            name2.setCharAt(appendIndex++, Character.toUpperCase(name2.charAt(index)));
                            break;
                        }
                        case '/': {
                            name2.setCharAt(appendIndex++, '.');
                            if (++index == name2.length()) break block4;
                            name2.setCharAt(appendIndex++, Character.toUpperCase(name2.charAt(index)));
                            break;
                        }
                        default: {
                            name2.setCharAt(appendIndex++, '_');
                        }
                    }
                    ++index;
                }
                name2.setLength(appendIndex);
                if (name2.charAt(name2.length() - 3) == '.') {
                    name2.setCharAt(name2.length() - 1, Character.toUpperCase(name2.charAt(name2.length() - 1)));
                }
                return name2;
            }

            public ClassLoader getContextClassLoader(String path, ClassLoader originalClassLoader) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return originalClassLoader;
            }
        };
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return ExperimentalUIImplKt.getLOG();
    }

    public static final /* synthetic */ void access$patchUiDefaultsForNewUi() {
        ExperimentalUIImplKt.patchUiDefaultsForNewUi();
    }

    public static final /* synthetic */ void access$resetLafSettingsToDefault() {
        ExperimentalUIImplKt.resetLafSettingsToDefault();
    }

    public static final /* synthetic */ IconPathPatcher access$createPathPatcher(Map paths) {
        return ExperimentalUIImplKt.createPathPatcher(paths);
    }
}

