/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.headertoolbar.MainToolbarKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.sun.jna.Pointer;
import java.awt.Color;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\b\u0010\f\u001a\u00020\u0007H\u0002J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u0012\u0012\u000e\u0012\f0 \u00a2\u0006\u0002\b!\u00a2\u0006\u0002\b\"0\u001fH\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/ui/mac/MacFullScreenControlsManager;", "", "<init>", "()V", "enabled", "", "configureEnable", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "block", "Lkotlin/Function0;", "configureColors", "updateColors", "frame", "Ljavax/swing/JFrame;", "updateForCompactMode", "updateForPresentationMode", "configureForLightEdit", "enterFullScreen", "configureForEmptyToolbarHeader", "enter", "isEmptyGroup", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "configureForDistractionFreeMode", "updateForNewMainToolbar", "show", "updateForDistractionFreeMode", "updateFullScreenButtons", "getAllFrameWindows", "", "Lcom/intellij/openapi/wm/IdeFrame;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nMacFullScreenControlsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacFullScreenControlsManager.kt\ncom/intellij/ui/mac/MacFullScreenControlsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,173:1\n1786#2,3:174\n3938#3:177\n4474#3,2:178\n*S KotlinDebug\n*F\n+ 1 MacFullScreenControlsManager.kt\ncom/intellij/ui/mac/MacFullScreenControlsManager\n*L\n100#1:174,3\n172#1:177\n172#1:178,2\n*E\n"})
public final class MacFullScreenControlsManager {
    @NotNull
    public static final MacFullScreenControlsManager INSTANCE = new MacFullScreenControlsManager();

    private MacFullScreenControlsManager() {
    }

    public final boolean enabled() {
        return ExperimentalUI.Companion.isNewUI() && Registry.Companion.is("apple.awt.newFullScreenControls", true);
    }

    public final void configureEnable(@NotNull CoroutineScope coroutineScope, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        RegistryValue rKey = Registry.Companion.get("apple.awt.newFullScreenControls");
        System.setProperty(rKey.getKey(), Boolean.toString(rKey.asBoolean()));
        rKey.addListener(new RegistryValueListener(rKey, block){
            final /* synthetic */ RegistryValue $rKey;
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$rKey = $rKey;
                this.$block = $block;
            }

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                System.setProperty(this.$rKey.getKey(), Boolean.toString(this.$rKey.asBoolean()));
                this.$block.invoke();
            }
        }, coroutineScope);
        if (this.enabled()) {
            this.configureColors();
        }
        if (DistractionFreeModeController.isDistractionFreeModeEnabled() || !UISettings.Companion.getInstance().getShowNewMainToolbar()) {
            this.updateForDistractionFreeMode(true);
        }
    }

    private final void configureColors() {
        JBColor jBColor = JBColor.namedColor((String)"MainWindow.FullScreeControl.Background", (Color)((Color)new JBColor(8027008, 5724764)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        JBColor color = jBColor;
        System.setProperty("apple.awt.newFullScreeControls.background", String.valueOf(color.getRGB()));
        System.setProperty("apple.awt.newFullScreenControls.background", String.valueOf(color.getRGB()));
    }

    public final void updateColors(@NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (this.enabled()) {
            this.configureColors();
            Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> MacFullScreenControlsManager.updateColors$lambda$0(frame));
        }
    }

    public final void updateForCompactMode() {
        this.updateForPresentationMode();
    }

    public final void updateForPresentationMode() {
        if (this.enabled()) {
            ApplicationManager.getApplication().invokeLater(MacFullScreenControlsManager::updateForPresentationMode$lambda$0);
        }
    }

    public final void configureForLightEdit(boolean enterFullScreen) {
        if (this.enabled()) {
            this.configureForDistractionFreeMode(enterFullScreen);
        }
    }

    public final void configureForEmptyToolbarHeader(boolean enter) {
        if (enter) {
            if (this.enabled()) {
                boolean bl;
                block8: {
                    Iterable $this$all$iv = MainToolbarKt.blockingComputeMainActionGroups(CustomActionsSchema.Companion.getInstance());
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (INSTANCE.isEmptyGroup((ActionGroup)it.getFirst())) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.configureForDistractionFreeMode(true);
                }
            }
        } else if (!DistractionFreeModeController.isDistractionFreeModeEnabled() && UISettings.Companion.getInstance().getShowNewMainToolbar()) {
            this.configureForDistractionFreeMode(false);
        }
    }

    private final boolean isEmptyGroup(ActionGroup group2) {
        if (group2 instanceof DefaultActionGroup) {
            AnAction[] anActionArray = ((DefaultActionGroup)group2).getChildActionsOrStubs();
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildActionsOrStubs(...)");
            return ((Object[])anActionArray).length == 0;
        }
        if (group2 instanceof CustomisedActionGroup) {
            AnAction[] anActionArray = ((CustomisedActionGroup)group2).getDefaultChildrenOrStubs();
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getDefaultChildrenOrStubs(...)");
            return ((Object[])anActionArray).length == 0;
        }
        AnAction[] anActionArray = group2.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
        return ((Object[])anActionArray).length == 0;
    }

    private final void configureForDistractionFreeMode(boolean enter) {
        String string = enter ? System.setProperty("apple.awt.distraction.free.mode", "true") : System.clearProperty("apple.awt.distraction.free.mode");
    }

    public final void updateForNewMainToolbar(boolean show2) {
        if (this.enabled()) {
            if (show2) {
                if (!DistractionFreeModeController.isDistractionFreeModeEnabled()) {
                    this.configureForDistractionFreeMode(false);
                    this.updateFullScreenButtons(false);
                }
            } else {
                this.configureForDistractionFreeMode(true);
                this.updateFullScreenButtons(true);
            }
        }
    }

    public final void updateForDistractionFreeMode(boolean enter) {
        if (this.enabled()) {
            if (enter) {
                this.configureForDistractionFreeMode(true);
                this.updateFullScreenButtons(true);
            } else if (UISettings.Companion.getInstance().getShowNewMainToolbar()) {
                this.configureForDistractionFreeMode(false);
                this.updateFullScreenButtons(false);
            }
        }
    }

    private final void updateFullScreenButtons(boolean enter) {
        ApplicationManager.getApplication().invokeLater(() -> MacFullScreenControlsManager.updateFullScreenButtons$lambda$0(enter));
    }

    /*
     * WARNING - void declaration
     */
    private final List<IdeFrame> getAllFrameWindows() {
        void $this$filterTo$iv$iv;
        IdeFrame[] ideFrameArray = WindowManager.getInstance().getAllProjectFrames();
        Intrinsics.checkNotNullExpressionValue((Object)ideFrameArray, (String)"getAllProjectFrames(...)");
        Object[] $this$filter$iv = ideFrameArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            IdeFrame it = (IdeFrame)element$iv$iv;
            boolean bl = false;
            if (!it.isInFullScreen()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void updateColors$lambda$0(JFrame $frame) {
        ID iD = MacUtil.getWindowFromJavaWindow((Window)$frame);
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getWindowFromJavaWindow(...)");
        ID window = iD;
        ID iD2 = Foundation.invoke((ID)window, (String)"delegate", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)iD2, (String)"invoke(...)");
        ID delegate = iD2;
        Object[] objectArray = new Object[]{Foundation.createSelector((String)"updateColors")};
        if (Foundation.invoke((ID)delegate, (String)"respondsToSelector:", (Object[])objectArray).booleanValue()) {
            Foundation.invoke((ID)delegate, (String)"updateColors", (Object[])new Object[0]);
        }
    }

    private static final void updateForPresentationMode$lambda$0$0(List $frames) {
        Pointer selector = Foundation.createSelector((String)"updateFullScreenButtons");
        for (Object e : $frames) {
            ID delegate;
            ID window;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            IdeFrame frameOrTab = (IdeFrame)e;
            Intrinsics.checkNotNullExpressionValue((Object)MacUtil.getWindowFromJavaWindow((Window)((ProjectFrameHelper)frameOrTab).getFrame()), (String)"getWindowFromJavaWindow(...)");
            Intrinsics.checkNotNullExpressionValue((Object)Foundation.invoke((ID)window, (String)"delegate", (Object[])new Object[0]), (String)"invoke(...)");
            Object[] objectArray = new Object[]{selector};
            if (!Foundation.invoke((ID)delegate, (String)"respondsToSelector:", (Object[])objectArray).booleanValue()) continue;
            Foundation.invoke((ID)delegate, (String)"updateFullScreenButtons", (Object[])new Object[0]);
        }
    }

    private static final void updateForPresentationMode$lambda$0() {
        List<IdeFrame> frames = INSTANCE.getAllFrameWindows();
        Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> MacFullScreenControlsManager.updateForPresentationMode$lambda$0$0(frames));
    }

    private static final void updateFullScreenButtons$lambda$0$0(List $frames, boolean $enter) {
        Pointer selector = Foundation.createSelector((String)"updateFullScreenButtons:");
        for (Object e : $frames) {
            ID delegate;
            ID window;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            IdeFrame frameOrTab = (IdeFrame)e;
            Intrinsics.checkNotNullExpressionValue((Object)MacUtil.getWindowFromJavaWindow((Window)((ProjectFrameHelper)frameOrTab).getFrame()), (String)"getWindowFromJavaWindow(...)");
            Intrinsics.checkNotNullExpressionValue((Object)Foundation.invoke((ID)window, (String)"delegate", (Object[])new Object[0]), (String)"invoke(...)");
            Object[] objectArray = new Object[]{selector};
            if (!Foundation.invoke((ID)delegate, (String)"respondsToSelector:", (Object[])objectArray).booleanValue()) continue;
            objectArray = new Object[]{$enter ? 1 : 0};
            Foundation.invoke((ID)delegate, (String)"updateFullScreenButtons:", (Object[])objectArray);
        }
    }

    private static final void updateFullScreenButtons$lambda$0(boolean $enter) {
        List<IdeFrame> frames = INSTANCE.getAllFrameWindows();
        Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> MacFullScreenControlsManager.updateFullScreenButtons$lambda$0$0(frames, $enter));
    }
}

