/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.ssl.CertificateInfoPanel;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateTreeBuilder;
import com.intellij.util.net.ssl.CertificateUtil;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CertificateConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
CertificateListener {
    public static final FileChooserDescriptor CERTIFICATE_DESCRIPTOR = FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(IdeBundle.message((String)"settings.certificate.choose.certificate", (Object[])new Object[0])).withExtensionFilter(IdeBundle.message((String)"settings.certificate.filter.label", (Object[])new Object[0]), new String[]{"crt", "cer", "pem", "der"});
    public static final String EMPTY_PANEL = "empty.panel";
    private JPanel myRootPanel;
    private JBCheckBox myAcceptAutomatically;
    private JPanel myCertificatesListPanel;
    private JPanel myDetailsPanel;
    private JPanel myEmptyPanel;
    private ConfirmingTrustManager.MutableTrustManager myTrustManager;
    private CertificateTreeBuilder myTreeBuilder;
    private final Set<X509Certificate> myCertificates;

    public CertificateConfigurable() {
        this.$$$setupUI$$$();
        this.myCertificates = new HashSet<X509Certificate>();
    }

    private void initializeUI() {
        Tree tree2 = new Tree();
        this.myTreeBuilder = new CertificateTreeBuilder(tree2);
        this.myTrustManager = CertificateManager.getInstance().getCustomTrustManager();
        this.myTrustManager.addListener((CertificateListener)this);
        tree2.getEmptyText().setText(IdeBundle.message((String)"settings.certificate.no.certificates", (Object[])new Object[0]));
        tree2.getSelectionModel().setSelectionMode(1);
        tree2.setRootVisible(false);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)tree2).disableUpDownActions();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                FileChooser.chooseFile((FileChooserDescriptor)CERTIFICATE_DESCRIPTOR, null, null, file2 -> {
                    String path = file2.getPath();
                    X509Certificate certificate = CertificateUtil.loadX509Certificate((String)path);
                    if (certificate == null) {
                        Messages.showErrorDialog((Component)CertificateConfigurable.this.myRootPanel, (String)IdeBundle.message((String)"settings.certificate.malformed.x509.server.certificate", (Object[])new Object[0]), (String)IdeBundle.message((String)"settings.certificate.not.imported", (Object[])new Object[0]));
                    } else if (CertificateConfigurable.this.myCertificates.contains(certificate)) {
                        Messages.showWarningDialog((Component)CertificateConfigurable.this.myRootPanel, (String)IdeBundle.message((String)"settings.certificate.certificate.already.exists", (Object[])new Object[0]), (String)IdeBundle.message((String)"settings.certificate.not.imported", (Object[])new Object[0]));
                    } else {
                        CertificateConfigurable.this.myCertificates.add(certificate);
                        CertificateConfigurable.this.myTreeBuilder.addCertificate(certificate);
                        CertificateConfigurable.this.addCertificatePanel(certificate);
                        CertificateConfigurable.this.myTreeBuilder.selectCertificate(certificate);
                    }
                });
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                for (X509Certificate certificate : CertificateConfigurable.this.myTreeBuilder.getSelectedCertificates(true)) {
                    CertificateConfigurable.this.myCertificates.remove(certificate);
                    CertificateConfigurable.this.myTreeBuilder.removeCertificate(certificate);
                }
                if (CertificateConfigurable.this.myCertificates.isEmpty()) {
                    CertificateConfigurable.this.showCard(CertificateConfigurable.EMPTY_PANEL);
                } else {
                    CertificateConfigurable.this.myTreeBuilder.selectFirstCertificate();
                }
            }
        });
        tree2.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                X509Certificate certificate = CertificateConfigurable.this.myTreeBuilder.getFirstSelectedCertificate(true);
                if (certificate != null) {
                    CertificateConfigurable.this.showCard(CertificateConfigurable.getCardName(certificate));
                }
            }
        });
        this.myCertificatesListPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"settings.certificate.accepted.certificates", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myCertificatesListPanel.add((Component)decorator.createPanel(), "Center");
        TreeUtil.expandAll((JTree)tree2);
    }

    private void showCard(@NotNull String cardName) {
        if (cardName == null) {
            CertificateConfigurable.$$$reportNull$$$0(0);
        }
        ((CardLayout)this.myDetailsPanel.getLayout()).show(this.myDetailsPanel, cardName);
    }

    private void addCertificatePanel(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateConfigurable.$$$reportNull$$$0(1);
        }
        String uniqueName = CertificateConfigurable.getCardName(certificate);
        CertificateInfoPanel infoPanel = new CertificateInfoPanel(certificate);
        UIUtil.addInsets((JComponent)infoPanel, (Insets)UIUtil.PANEL_REGULAR_INSETS);
        JBScrollPane scrollPane = new JBScrollPane((Component)infoPanel);
        this.myDetailsPanel.add((Component)scrollPane, uniqueName);
    }

    private static String getCardName(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateConfigurable.$$$reportNull$$$0(2);
        }
        return certificate.getSubjectX500Principal().getName();
    }

    @NotNull
    public String getId() {
        return "http.certificates";
    }

    @Nls
    public String getDisplayName() {
        return UIBundle.message((String)"configurable.CertificateConfigurable.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.idesettings.server.certificates";
    }

    @Nullable
    public JComponent createComponent() {
        this.initializeUI();
        return this.myRootPanel;
    }

    public boolean isModified() {
        CertificateManager.Config state2 = CertificateManager.getInstance().getState();
        return this.myAcceptAutomatically.isSelected() != state2.ACCEPT_AUTOMATICALLY || !this.myCertificates.equals(new HashSet(this.myTrustManager.getCertificates()));
    }

    public void apply() throws ConfigurationException {
        List existing = this.myTrustManager.getCertificates();
        HashSet<X509Certificate> added = new HashSet<X509Certificate>(this.myCertificates);
        added.removeAll(existing);
        HashSet removed = new HashSet(existing);
        removed.removeAll(this.myCertificates);
        for (X509Certificate certificate : added) {
            if (this.myTrustManager.addCertificate(certificate)) continue;
            throw new ConfigurationException(IdeBundle.message((String)"settings.certificate.cannot.add.certificate.for", (Object[])new Object[]{CertificateUtil.getCommonName((X509Certificate)certificate)}), IdeBundle.message((String)"settings.certificate.cannot.add.certificate", (Object[])new Object[0]));
        }
        for (X509Certificate certificate : removed) {
            if (this.myTrustManager.removeCertificate(certificate)) continue;
            throw new ConfigurationException(IdeBundle.message((String)"settings.certificate.cannot.remove.certificate.for", (Object[])new Object[]{CertificateUtil.getCommonName((X509Certificate)certificate)}), IdeBundle.message((String)"settings.certificate.cannot.remove.certificate", (Object[])new Object[0]));
        }
        CertificateManager.Config state2 = CertificateManager.getInstance().getState();
        state2.ACCEPT_AUTOMATICALLY = this.myAcceptAutomatically.isSelected();
    }

    public void reset() {
        List original = this.myTrustManager.getCertificates();
        this.myTreeBuilder.reset(original);
        this.myCertificates.clear();
        this.myCertificates.addAll(original);
        this.myDetailsPanel.removeAll();
        this.myDetailsPanel.add((Component)this.myEmptyPanel, EMPTY_PANEL);
        for (X509Certificate certificate : original) {
            this.addCertificatePanel(certificate);
        }
        if (!this.myCertificates.isEmpty()) {
            this.myTreeBuilder.selectFirstCertificate();
        }
        CertificateManager.Config state2 = CertificateManager.getInstance().getState();
        this.myAcceptAutomatically.setSelected(state2.ACCEPT_AUTOMATICALLY);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myTreeBuilder);
        this.myTrustManager.removeListener((CertificateListener)this);
    }

    public void certificateAdded(X509Certificate certificate) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myTreeBuilder != null && !this.myCertificates.contains(certificate)) {
                this.myCertificates.add(certificate);
                this.myTreeBuilder.addCertificate(certificate);
                this.addCertificatePanel(certificate);
            }
        });
    }

    public void certificateRemoved(X509Certificate certificate) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myTreeBuilder != null && this.myCertificates.contains(certificate)) {
                this.myCertificates.remove(certificate);
                this.myTreeBuilder.removeCertificate(certificate);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cardName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/net/ssl/CertificateConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showCard";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addCertificatePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCardName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBCheckBox jBCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCertificatesListPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAcceptAutomatically = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", CertificateConfigurable.class).getString("settings.certificate.accept.non.trusted.certificates.automatically"));
        jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDetailsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(499, 24), null));
        this.myEmptyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Card1");
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", CertificateConfigurable.class).getString("settings.certificate.no.certificate.selected"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Splitter splitter2 = new Splitter();
        splitter2.setOrientation(true);
        splitter2.setProportion(0.3f);
        splitter2.setShowDividerControls(false);
        jPanel4.add((Component)splitter2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        splitter2.setFirstComponent((JComponent)jPanel3);
        splitter2.setSecondComponent((JComponent)jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

