/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AnnotationsPanel {
    private final Project myProject;
    private final Set<String> myDefaultAnnotations;
    private final JBTable myTable;
    private final JPanel myComponent;
    private final ComboBox<String> myCombo;
    protected final DefaultTableModel myTableModel;
    private final TableRowSorter<DefaultTableModel> mySorter;

    public AnnotationsPanel(Project project, @Nls String name, List<String> annotations, List<String> defaultAnnotations) {
        this.myProject = project;
        this.myDefaultAnnotations = new HashSet<String>(defaultAnnotations);
        this.myCombo = new ComboBox((Object[])((String[])annotations.stream().sorted().toArray(String[]::new)));
        if (!annotations.contains("")) {
            this.addAnnotationToCombo("");
        }
        this.myCombo.setSelectedItem((Object)"");
        this.myTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        this.myTableModel.setColumnCount(1);
        for (String annotation : annotations) {
            this.addRow(annotation);
        }
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        columnModel.addColumn(new TableColumn(0, 100, (TableCellRenderer)new ColoredTableCellRenderer(){

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/codeInsight/AnnotationsPanel$2", "customizeCellRenderer"));
            }
        }, null));
        this.myTable = new JBTable((TableModel)this.myTableModel, (TableColumnModel)columnModel);
        this.mySorter = new TableRowSorter<DefaultTableModel>(this.myTableModel);
        this.mySorter.setSortKeys(List.of(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        this.myTable.setRowSorter(this.mySorter);
        this.myTable.setTableHeader(null);
        this.mySorter.sort();
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpDownActions().setAddAction(b -> this.chooseAnnotation(name)).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                String selectedValue = AnnotationsPanel.this.getSelectedAnnotation();
                if (selectedValue == null) {
                    return;
                }
                AnnotationsPanel.this.myCombo.removeItem((Object)selectedValue);
                int rowIndex = -1;
                for (int i = 0; i < AnnotationsPanel.this.myTableModel.getDataVector().size(); ++i) {
                    if (!AnnotationsPanel.this.myTableModel.getDataVector().get(i).contains(selectedValue)) continue;
                    rowIndex = i;
                    break;
                }
                if (rowIndex != -1) {
                    AnnotationsPanel.this.myTableModel.removeRow(rowIndex);
                }
            }
        }).setRemoveActionUpdater(e -> !this.myDefaultAnnotations.contains(this.getSelectedAnnotation()));
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setShowGrid(false);
        JPanel tablePanel = UI.PanelFactory.panel((JComponent)toolbarDecorator.createPanel()).withLabel(JavaBundle.message("annotations.panel.title", name)).moveLabelOnTop().resizeY(true).createPanel();
        tablePanel.setPreferredSize((Dimension)new JBDimension(tablePanel.getPreferredSize().width, 200));
        this.myComponent = new JPanel(new GridBagLayout());
        this.myComponent.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.weighty = 1.0;
        this.myComponent.add((Component)tablePanel, constraints);
    }

    protected boolean isAnnotationAccepted(PsiClass annotation) {
        return true;
    }

    private void addRow(String annotation) {
        this.myTableModel.addRow(new Object[]{annotation});
    }

    private Integer selectAnnotation(String annotation) {
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            if (!annotation.equals(this.myTable.getValueAt(i, 0))) continue;
            this.myTable.setRowSelectionInterval(i, i);
            return i;
        }
        return null;
    }

    @NlsSafe
    private String getSelectedAnnotation() {
        int selectedRow = this.myTable.getSelectedRow();
        return selectedRow < 0 ? null : (String)this.myTable.getValueAt(selectedRow, 0);
    }

    private void chooseAnnotation(@NlsSafe String title) {
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance(this.myProject).createNoInnerClassesScopeChooser(JavaBundle.message("dialog.title.choose.annotation", title), GlobalSearchScope.allScope((Project)this.myProject), aClass -> aClass.isAnnotationType() && this.isAnnotationAccepted(aClass), null);
        chooser.showDialog();
        PsiClass selected = chooser.getSelected();
        if (selected == null) {
            return;
        }
        String qualifiedName = selected.getQualifiedName();
        if (this.selectAnnotation(qualifiedName) == null) {
            this.addRow(qualifiedName);
            this.addAnnotationToCombo(qualifiedName);
            this.mySorter.sort();
            Integer added = this.selectAnnotation(qualifiedName);
            assert (added != null);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(added.intValue(), 0, true));
        }
    }

    private void addAnnotationToCombo(@NlsSafe String annotation) {
        int insertAt;
        for (insertAt = 0; insertAt < this.myCombo.getItemCount() && ((String)this.myCombo.getItemAt(insertAt)).compareTo(annotation) < 0; ++insertAt) {
        }
        this.myCombo.insertItemAt((Object)annotation, insertAt);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String[] getAnnotations() {
        int size = this.myTable.getRowCount();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)this.myTable.getValueAt(i, 0);
        }
        return result;
    }

    public void resetAnnotations(List<String> annotations) {
        HashSet<String> set = new HashSet<String>(annotations);
        int row = 0;
        for (String annotation : this.getAnnotations()) {
            if (!set.contains(annotation)) {
                this.myTableModel.removeRow(row);
                continue;
            }
            set.remove(annotation);
            ++row;
        }
        for (String annotation : set) {
            this.addRow(annotation);
        }
    }
}

