/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class MetaAnnotationUtil {
    private static final HashingStrategy<PsiClass> HASHING_STRATEGY = new HashingStrategy<PsiClass>(){

        public int hashCode(PsiClass object) {
            String qualifiedName = object == null ? null : object.getQualifiedName();
            return qualifiedName == null ? 0 : qualifiedName.hashCode();
        }

        public boolean equals(PsiClass o1, PsiClass o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return Objects.equals(o1.getQualifiedName(), o2.getQualifiedName());
        }
    };

    public static @Unmodifiable Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull Module module, String annotationName, boolean includeTests) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(0);
        }
        return MetaAnnotationUtil.getAllAnnotationClassesMap(module).get(Pair.pair((Object)annotationName, (Object)includeTests));
    }

    @NotNull
    private static @Unmodifiable Map<Pair<String, Boolean>, Collection<PsiClass>> getAllAnnotationClassesMap(@NotNull Module module) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(1);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> MetaAnnotationUtil.findAnnotationClasses(module, (String)key.getFirst(), (Boolean)key.getSecond()));
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)module.getProject()), JavaLibraryModificationTracker.getInstance(module.getProject())});
        });
        if (map == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    private static @Unmodifiable Collection<PsiClass> findAnnotationClasses(@NotNull Module module, @NotNull String qualifiedName, boolean includeTests) {
        PsiClass annotationClass;
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(3);
        }
        if (qualifiedName == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(4);
        }
        if ((annotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(qualifiedName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) == null || !annotationClass.isAnnotationType()) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                MetaAnnotationUtil.$$$reportNull$$$0(5);
            }
            return set;
        }
        PsiFile annotationFile = annotationClass.getContainingFile();
        if (annotationFile == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                MetaAnnotationUtil.$$$reportNull$$$0(6);
            }
            return set;
        }
        if (ProjectScope.getLibrariesScope((Project)module.getProject()).contains(annotationFile.getVirtualFile())) {
            Collection<PsiClass> libsTypes = MetaAnnotationUtil.getChildLibraryAnnotations(module, qualifiedName);
            return MetaAnnotationUtil.findAnnotationTypesWithChildren(libsTypes, MetaAnnotationUtil.getAnnotationSourceSearchScope(module, includeTests));
        }
        return MetaAnnotationUtil.findAnnotationTypesWithChildren(List.of(annotationClass), MetaAnnotationUtil.getAnnotationSourceSearchScope(module, includeTests));
    }

    public static @Unmodifiable Collection<String> getAnnotationNamesWithChildren(@NotNull Module module, String annotationName, boolean includeTests) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(7);
        }
        return MetaAnnotationUtil.getAllAnnotationClassNamesMap(module).get(Pair.pair((Object)annotationName, (Object)includeTests));
    }

    private static @Unmodifiable Collection<String> toNames(Collection<PsiClass> classes) {
        return classes.stream().map(PsiClass::getQualifiedName).filter(Objects::nonNull).sorted().toList();
    }

    @NotNull
    private static Map<Pair<String, Boolean>, Collection<String>> getAllAnnotationClassNamesMap(@NotNull Module module) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(8);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> MetaAnnotationUtil.toNames(MetaAnnotationUtil.findAnnotationClasses(module, (String)key.getFirst(), (Boolean)key.getSecond())));
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)module.getProject()), JavaLibraryModificationTracker.getInstance(module.getProject())});
        });
        if (map == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(9);
        }
        return map;
    }

    private static @Unmodifiable Collection<PsiClass> getChildLibraryAnnotations(@NotNull Module module, String annotation) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(10);
        }
        return MetaAnnotationUtil.getLibraryAnnotationClassesMap(module).get(annotation);
    }

    @NotNull
    private static GlobalSearchScope getAnnotationSourceSearchScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(11);
        }
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        if (!includeTests) {
            moduleScope = moduleScope.intersectWith(GlobalSearchScopesCore.projectProductionScope((Project)module.getProject()));
        }
        GlobalSearchScope globalSearchScope = MetaAnnotationUtil.getProjectAnnotationFilesScope(module).intersectWith(moduleScope);
        if (globalSearchScope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @NotNull
    private static Map<String, Collection<PsiClass>> getLibraryAnnotationClassesMap(@NotNull Module module) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(13);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> {
                PsiClass annotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(key, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
                if (annotationClass == null || !annotationClass.isAnnotationType()) {
                    return Collections.emptyList();
                }
                GlobalSearchScope libsScope = GlobalSearchScope.moduleWithLibrariesScope((Module)module).intersectWith(ProjectScope.getLibrariesScope((Project)module.getProject()));
                return MetaAnnotationUtil.findAnnotationTypesWithChildren(List.of(annotationClass), libsScope);
            });
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance(module.getProject())});
        });
        if (map == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(14);
        }
        return map;
    }

    public static @Unmodifiable Set<PsiClass> getChildren(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope scope) {
        if (psiClass == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(16);
        }
        if (AnnotationTargetUtil.findAnnotationTarget((PsiClass)psiClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE}) == null) {
            return Collections.emptySet();
        }
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return Collections.emptySet();
        }
        Set result = CollectionFactory.createCustomHashingStrategySet(HASHING_STRATEGY);
        AnnotatedElementsSearch.searchPsiClasses((PsiClass)psiClass, (SearchScope)scope).forEach(processorResult -> {
            ProgressManager.checkCanceled();
            if (processorResult.isAnnotationType()) {
                result.add(processorResult);
            }
            return true;
        });
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result;
    }

    public static @Unmodifiable Collection<PsiClass> getAnnotatedTypes(@NotNull Module module, @NotNull String annotationName) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(17);
        }
        if (annotationName == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(18);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap factoryMap = ConcurrentFactoryMap.createMap(key -> MetaAnnotationUtil.findAnnotatedTypes(module, key));
            return new CachedValueProvider.Result((Object)factoryMap, new Object[]{UastModificationTracker.getInstance((Project)module.getProject())});
        });
        return (Collection)map.get(annotationName);
    }

    @NotNull
    private static @Unmodifiable Collection<PsiClass> findAnnotatedTypes(@NotNull Module module, @NotNull String annotationName) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(19);
        }
        if (annotationName == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(20);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(annotationName, scope);
        if (psiClass == null || !psiClass.isAnnotationType()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                MetaAnnotationUtil.$$$reportNull$$$0(21);
            }
            return list;
        }
        Set<PsiClass> set = MetaAnnotationUtil.getChildren(psiClass, scope);
        if (set == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    private static @Unmodifiable Collection<PsiClass> findAnnotationTypesWithChildren(Collection<PsiClass> annotationClasses, GlobalSearchScope scope) {
        if (scope == GlobalSearchScope.EMPTY_SCOPE) {
            Collection<PsiClass> collection = annotationClasses;
            if (collection == null) {
                MetaAnnotationUtil.$$$reportNull$$$0(23);
            }
            return collection;
        }
        Set classes = CollectionFactory.createCustomHashingStrategySet(HASHING_STRATEGY);
        for (PsiClass annotationClass : annotationClasses) {
            MetaAnnotationUtil.collectClassWithChildren(annotationClass, classes, scope);
        }
        if (classes.isEmpty()) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                MetaAnnotationUtil.$$$reportNull$$$0(24);
            }
            return set;
        }
        Set set = classes;
        if (set == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(25);
        }
        return set;
    }

    @NotNull
    private static GlobalSearchScope getProjectAnnotationFilesScope(@NotNull Module module) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(26);
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope projectScope = module.getModuleWithDependenciesScope();
            GlobalSearchScope javaScope = GlobalSearchScope.filesScope((Project)module.getProject(), (Collection)ContainerUtil.newHashSet(MetaAnnotationUtil.getJavaAnnotationInheritorIds(module.getProject(), projectScope)));
            GlobalSearchScope otherScope = MetaAnnotationUtil.searchForAnnotationInheritorsInOtherLanguages(module.getProject(), projectScope);
            return CachedValueProvider.Result.createSingleDependency((Object)javaScope.uniteWith(otherScope), (Object)UastModificationTracker.getInstance((Project)module.getProject()));
        });
        if (globalSearchScope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(27);
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope searchForAnnotationInheritorsInOtherLanguages(Project project, GlobalSearchScope scope) {
        HashSet allAnnotationFiles = new HashSet();
        for (PsiClass javaLangAnnotation : JavaPsiFacade.getInstance((Project)project).findClasses("java.lang.annotation.Annotation", GlobalSearchScope.allScope((Project)project))) {
            DirectClassInheritorsSearch.SearchParameters parameters = new DirectClassInheritorsSearch.SearchParameters(javaLangAnnotation, (SearchScope)scope, false, true){

                public boolean shouldSearchInLanguage(@NotNull Language language) {
                    if (language == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return language != JavaLanguage.INSTANCE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/MetaAnnotationUtil$2", "shouldSearchInLanguage"));
                }
            };
            DirectClassInheritorsSearch.search((DirectClassInheritorsSearch.SearchParameters)parameters).forEach(annotationClass -> {
                ProgressManager.checkCanceled();
                ContainerUtil.addIfNotNull((Collection)allAnnotationFiles, (Object)PsiUtilCore.getVirtualFile((PsiElement)annotationClass));
                return true;
            });
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithLibrariesScope((Project)project, allAnnotationFiles);
        if (globalSearchScope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(28);
        }
        return globalSearchScope;
    }

    @NotNull
    private static Iterator<VirtualFile> getJavaAnnotationInheritorIds(Project project, GlobalSearchScope scope) {
        Iterator iterator = StubIndex.getInstance().getContainingFilesIterator(JavaStubIndexKeys.SUPER_CLASSES, (Object)"Annotation", project, scope);
        if (iterator == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(29);
        }
        return iterator;
    }

    private static void collectClassWithChildren(PsiClass psiClass, Set<? super PsiClass> classes, GlobalSearchScope scope) {
        classes.add((PsiClass)psiClass);
        for (PsiClass aClass : MetaAnnotationUtil.getChildren(psiClass, scope)) {
            if (classes.contains(aClass)) continue;
            MetaAnnotationUtil.collectClassWithChildren(aClass, classes, scope);
        }
    }

    public static boolean isMetaAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(30);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(31);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)listOwner, annotations, (int)0)) {
            return true;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner);
        for (String annotationFQN : annotations) {
            for (PsiClass resolvedAnnotation : resolvedAnnotations) {
                if (MetaAnnotationUtil.metaAnnotationCached(resolvedAnnotation, annotationFQN) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(32);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(33);
        }
        return MetaAnnotationUtil.isMetaAnnotatedInHierarchy(listOwner, annotations, new HashSet());
    }

    public static boolean hasMetaAnnotatedMethods(@NotNull PsiClass psiClass, @NotNull Collection<String> annotations) {
        if (psiClass == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(34);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(35);
        }
        return ContainerUtil.or((Object[])psiClass.getMethods(), psiMethod -> MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, annotations));
    }

    private static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, Set<? super PsiMember> visited) {
        block6: {
            block5: {
                if (listOwner == null) {
                    MetaAnnotationUtil.$$$reportNull$$$0(36);
                }
                if (annotations == null) {
                    MetaAnnotationUtil.$$$reportNull$$$0(37);
                }
                if (MetaAnnotationUtil.isMetaAnnotated(listOwner, annotations)) {
                    return true;
                }
                if (!(listOwner instanceof PsiClass)) break block5;
                for (PsiClass superClass : ((PsiClass)listOwner).getSupers()) {
                    if (!visited.add((PsiMember)superClass) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)superClass, annotations, visited)) continue;
                    return true;
                }
                break block6;
            }
            if (!(listOwner instanceof PsiMethod)) break block6;
            for (PsiMethod method : ((PsiMethod)listOwner).findSuperMethods()) {
                if (!visited.add((PsiMember)method) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)method, annotations, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public static Stream<PsiAnnotation> findMetaAnnotationsInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(38);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(39);
        }
        return MetaAnnotationUtil.findMetaAnnotationsInHierarchy(listOwner, annotations, new HashSet<PsiModifierListOwner>());
    }

    private static Stream<PsiAnnotation> findMetaAnnotationsInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, @NotNull Set<PsiModifierListOwner> visited) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(40);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(41);
        }
        if (visited == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(42);
        }
        if (!visited.add(listOwner)) {
            return Stream.empty();
        }
        Stream<PsiAnnotation> stream = MetaAnnotationUtil.findMetaAnnotations(listOwner, annotations);
        if (listOwner instanceof PsiClass) {
            for (PsiClass psiClass : ((PsiClass)listOwner).getSupers()) {
                stream = Stream.concat(stream, MetaAnnotationUtil.findMetaAnnotationsInHierarchy((PsiModifierListOwner)psiClass, annotations, visited));
            }
        } else if (listOwner instanceof PsiMethod) {
            for (PsiClass psiClass : ((PsiMethod)listOwner).findSuperMethods()) {
                stream = Stream.concat(stream, MetaAnnotationUtil.findMetaAnnotationsInHierarchy((PsiModifierListOwner)psiClass, annotations, visited));
            }
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner);
        for (PsiClass annotationClass : resolvedAnnotations) {
            stream = Stream.concat(stream, MetaAnnotationUtil.findMetaAnnotationsInHierarchy((PsiModifierListOwner)annotationClass, annotations, visited));
        }
        return stream;
    }

    @Nullable
    private static PsiAnnotation metaAnnotationCached(PsiClass subjectAnnotation, String annotationToFind) {
        return (PsiAnnotation)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)subjectAnnotation, () -> {
            ConcurrentMap metaAnnotationsMap = ConcurrentFactoryMap.createMap(anno -> MetaAnnotationUtil.findMetaAnnotation(subjectAnnotation, anno, new HashSet()));
            return CachedValueProvider.Result.create((Object)metaAnnotationsMap, (Object[])new Object[]{UastModificationTracker.getInstance((Project)subjectAnnotation.getProject())});
        })).get(annotationToFind);
    }

    @Nullable
    private static PsiAnnotation findMetaAnnotation(PsiClass aClass, String annotation, Set<? super PsiClass> visited) {
        ArrayDeque<PsiClass> stack = new ArrayDeque<PsiClass>();
        stack.push(aClass);
        while (!stack.isEmpty()) {
            PsiClass currentClass = (PsiClass)stack.pop();
            PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)currentClass, (boolean)true, (String[])new String[]{annotation});
            if (directAnnotation != null) {
                return directAnnotation;
            }
            List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList((PsiModifierListOwner)currentClass);
            for (PsiClass resolvedAnnotation : resolvedAnnotations) {
                if (!visited.add((PsiClass)resolvedAnnotation)) continue;
                stack.push(resolvedAnnotation);
            }
        }
        return null;
    }

    @NotNull
    public static Stream<PsiAnnotation> findMetaAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(43);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(44);
        }
        Stream<PsiAnnotation> directAnnotations = Stream.of(AnnotationUtil.findAnnotations((PsiModifierListOwner)listOwner, annotations));
        Stream lazyResolvedAnnotations = Stream.generate(() -> MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner)).limit(1L).flatMap(it -> it.stream());
        Stream<PsiAnnotation> metaAnnotations = lazyResolvedAnnotations.flatMap(psiClass -> annotations.stream().map(annotationFQN -> MetaAnnotationUtil.metaAnnotationCached(psiClass, annotationFQN))).filter(Objects::nonNull);
        Stream<PsiAnnotation> stream = Stream.concat(directAnnotations, metaAnnotations);
        if (stream == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(45);
        }
        return stream;
    }

    @NotNull
    public static Stream<PsiClass> findAnnotationsByMeta(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> metaAnnotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(46);
        }
        if (metaAnnotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(47);
        }
        Stream<PsiClass> directAnnotations = Stream.of(AnnotationUtil.findAnnotations((PsiModifierListOwner)listOwner, metaAnnotations)).map(MetaAnnotationUtil::resolveAnnotationType).filter(Objects::nonNull);
        Stream lazyResolvedAnnotations = Stream.generate(() -> MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner)).limit(1L).flatMap(Collection::stream);
        Stream<PsiClass> indirectAnnotations = lazyResolvedAnnotations.flatMap(psiClass -> metaAnnotations.stream().map(annotationFQN -> {
            PsiAnnotation metaAnnotation = MetaAnnotationUtil.metaAnnotationCached(psiClass, annotationFQN);
            if (metaAnnotation != null) {
                return psiClass;
            }
            return null;
        })).filter(Objects::nonNull);
        Stream<PsiClass> stream = Stream.concat(directAnnotations, indirectAnnotations);
        if (stream == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(48);
        }
        return stream;
    }

    private static @Unmodifiable List<PsiClass> getResolvedClassesInAnnotationsList(PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            return ContainerUtil.mapNotNull((Object[])modifierList.getApplicableAnnotations(), MetaAnnotationUtil::resolveAnnotationType);
        }
        return Collections.emptyList();
    }

    @Nullable
    private static PsiClass resolveAnnotationType(@NotNull PsiAnnotation psiAnnotation) {
        PsiClass psiClass;
        if (psiAnnotation == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(49);
        }
        if ((psiClass = psiAnnotation.resolveAnnotationType()) != null) {
            return psiClass;
        }
        String annotationQualifiedName = psiAnnotation.getQualifiedName();
        if (annotationQualifiedName == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)psiAnnotation.getProject()).findClass(annotationQualifiedName, psiAnnotation.getResolveScope());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 9, 12, 14, 21, 22, 23, 24, 25, 27, 28, 29, 45, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/MetaAnnotationUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 15: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 30: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaAnnotations";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/MetaAnnotationUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotationClassesMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotationClasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotationClassNamesMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationSourceSearchScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryAnnotationClassesMap";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotatedTypes";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotationTypesWithChildren";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectAnnotationFilesScope";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "searchForAnnotationInheritorsInOtherLanguages";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaAnnotationInheritorIds";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findMetaAnnotations";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotationsByMeta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildren";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotationClassesMap";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 45: 
            case 48: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationClasses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationNamesWithChildren";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotationClassNamesMap";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildLibraryAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationSourceSearchScope";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryAnnotationClassesMap";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedTypes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotatedTypes";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getProjectAnnotationFilesScope";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotated";
                break;
            }
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotatedInHierarchy";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasMetaAnnotatedMethods";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findMetaAnnotationsInHierarchy";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findMetaAnnotations";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationsByMeta";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveAnnotationType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 9, 12, 14, 21, 22, 23, 24, 25, 27, 28, 29, 45, 48 -> new IllegalStateException(string);
        };
    }
}

