/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationPanelModel;
import com.intellij.codeInsight.NullableNotNullManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class NullabilityAnnotationPanelModel
implements AnnotationPanelModel {
    final NullableNotNullManager myManager;

    protected NullabilityAnnotationPanelModel(NullableNotNullManager manager) {
        this.myManager = manager;
    }

    @Override
    public boolean hasAdvancedAnnotations() {
        return true;
    }

    static class NotNullModel
    extends NullabilityAnnotationPanelModel {
        NotNullModel(NullableNotNullManager manager) {
            super(manager);
        }

        @Override
        @NotNull
        public String getName() {
            return "NotNull";
        }

        @Override
        @NotNull
        public String getDefaultAnnotation() {
            String string = this.myManager.getDefaultNotNull();
            if (string == null) {
                NotNullModel.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getAnnotations() {
            List list = this.myManager.getNotNulls();
            if (list == null) {
                NotNullModel.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getAdvancedAnnotations() {
            List list = this.myManager.getNotNullsWithNickNames();
            if (list == null) {
                NotNullModel.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getDefaultAnnotations() {
            List list = this.myManager.getDefaultNotNulls();
            if (list == null) {
                NotNullModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        public Set<String> getCheckedAnnotations() {
            return new HashSet<String>(this.myManager.getInstrumentedNotNulls());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/NullabilityAnnotationPanelModel$NotNullModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultAnnotation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdvancedAnnotations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultAnnotations";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class NullableModel
    extends NullabilityAnnotationPanelModel {
        NullableModel(NullableNotNullManager manager) {
            super(manager);
        }

        @Override
        @NotNull
        public String getName() {
            return "Nullable";
        }

        @Override
        @NotNull
        public String getDefaultAnnotation() {
            String string = this.myManager.getDefaultNullable();
            if (string == null) {
                NullableModel.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getAnnotations() {
            List list = this.myManager.getNullables();
            if (list == null) {
                NullableModel.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getAdvancedAnnotations() {
            List list = this.myManager.getNullablesWithNickNames();
            if (list == null) {
                NullableModel.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getDefaultAnnotations() {
            List list = this.myManager.getDefaultNullables();
            if (list == null) {
                NullableModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        public Set<String> getCheckedAnnotations() {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                NullableModel.$$$reportNull$$$0(4);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/NullabilityAnnotationPanelModel$NullableModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultAnnotation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdvancedAnnotations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultAnnotations";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCheckedAnnotations";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

