/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeCanonicalLookupElement
extends LookupElement {
    private final PsiType myType;
    private final String myPresentableText;

    public PsiTypeCanonicalLookupElement(@NotNull PsiType type) {
        if (type == null) {
            PsiTypeCanonicalLookupElement.$$$reportNull$$$0(0);
        }
        this.myType = type;
        this.myPresentableText = this.myType.getPresentableText();
    }

    @NotNull
    public Object getObject() {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null) {
            PsiClass psiClass2 = psiClass;
            if (psiClass2 == null) {
                PsiTypeCanonicalLookupElement.$$$reportNull$$$0(1);
            }
            return psiClass2;
        }
        Object object = super.getObject();
        if (object == null) {
            PsiTypeCanonicalLookupElement.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Nullable
    public PsiClass getPsiClass() {
        return PsiUtil.resolveClassInType((PsiType)this.myType);
    }

    public boolean isValid() {
        return this.myType.isValid() && super.isValid();
    }

    public PsiType getPsiType() {
        return this.myType;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myPresentableText;
        if (string == null) {
            PsiTypeCanonicalLookupElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            PsiTypeCanonicalLookupElement.$$$reportNull$$$0(4);
        }
        context.getEditor().getDocument().replaceString(context.getStartOffset(), context.getStartOffset() + this.getLookupString().length(), (CharSequence)this.getPsiType().getCanonicalText());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiTypeCanonicalLookupElement)) return false;
        PsiTypeCanonicalLookupElement that = (PsiTypeCanonicalLookupElement)((Object)o);
        if (!this.myType.equals(that.myType)) return false;
        return true;
    }

    public int hashCode() {
        return this.myType.hashCode();
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        PsiClass psiClass;
        if (presentation == null) {
            PsiTypeCanonicalLookupElement.$$$reportNull$$$0(5);
        }
        if ((psiClass = this.getPsiClass()) != null) {
            presentation.setIcon(psiClass.getIcon(1));
            presentation.setTailText(" (" + PsiFormatUtil.getPackageDisplayName((PsiClass)psiClass) + ")", true);
        }
        PsiType type = this.getPsiType();
        presentation.setItemText(type.getPresentableText());
        presentation.setItemTextBold(type instanceof PsiPrimitiveType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/util/PsiTypeCanonicalLookupElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/util/PsiTypeCanonicalLookupElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

