/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.CoreAwareIconManager;
import com.intellij.ui.IconManager;
import com.intellij.util.xml.ElementPresentationManager;
import javax.swing.Icon;

public final class IconUtilEx {
    public static Icon getIcon(Object object, @Iconable.IconFlags int flags, Project project) {
        if (object instanceof PsiElement) {
            PsiElement element = (PsiElement)object;
            return element.getIcon(flags);
        }
        if (object instanceof Module) {
            Module module = (Module)object;
            return ModuleType.get((Module)module).getIcon();
        }
        if (object instanceof VirtualFile) {
            VirtualFile file = (VirtualFile)object;
            IconManager iconManager = IconManager.getInstance();
            if (iconManager instanceof CoreAwareIconManager) {
                CoreAwareIconManager manager = (CoreAwareIconManager)iconManager;
                return manager.getIcon(file, flags, project);
            }
        }
        return ElementPresentationManager.getIcon((Object)object);
    }
}

