/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class PackageWrapper {
    private final PsiManager myManager;
    @NotNull
    private final String myQualifiedName;

    public PackageWrapper(PsiManager manager, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PackageWrapper.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    public PackageWrapper(PsiPackage aPackage) {
        this.myManager = aPackage.getManager();
        this.myQualifiedName = aPackage.getQualifiedName();
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public PsiDirectory[] getDirectories() {
        return this.getDirectories(GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
    }

    public PsiDirectory[] getDirectories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PackageWrapper.$$$reportNull$$$0(1);
        }
        String qName = this.myQualifiedName;
        while (qName.endsWith(".")) {
            qName = StringUtil.trimEnd((String)qName, (String)".");
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(qName);
        if (aPackage != null) {
            return aPackage.getDirectories(scope);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public boolean exists() {
        Project project = this.myManager.getProject();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(this.myQualifiedName);
        return aPackage != null && aPackage.getDirectories(GlobalSearchScope.projectScope((Project)project)).length > 0;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            PackageWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean equalToPackage(PsiPackage aPackage) {
        return aPackage != null && this.myQualifiedName.equals(aPackage.getQualifiedName());
    }

    public static PackageWrapper create(PsiPackage aPackage) {
        return new PackageWrapper(aPackage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/PackageWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/PackageWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

