/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors;

import com.intellij.util.descriptors.ConfigFileItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/descriptors/ConfigFileItemSerializer;", "", "serializeConfigFiles", "", "configFiles", "", "Lcom/intellij/util/descriptors/ConfigFileItem;", "rootElement", "Lorg/jdom/Element;", "deserializeConfigFiles", "", "intellij.java"})
public interface ConfigFileItemSerializer {
    default public void serializeConfigFiles(@NotNull List<ConfigFileItem> configFiles, @NotNull Element rootElement) {
        Intrinsics.checkNotNullParameter(configFiles, (String)"configFiles");
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        Element descriptors = new Element("descriptors");
        for (ConfigFileItem configFile : configFiles) {
            Element child = new Element("deploymentDescriptor");
            child.setAttribute("name", configFile.getId());
            child.setAttribute("url", configFile.getUrl());
            descriptors.addContent(child);
        }
        if (descriptors.getContentSize() != 0) {
            rootElement.addContent(descriptors);
        }
    }

    @NotNull
    default public List<ConfigFileItem> deserializeConfigFiles(@Nullable Element rootElement) {
        Element descriptorsElement;
        List configFiles = new ArrayList();
        Element element = rootElement;
        Object object = descriptorsElement = element != null ? element.getChild("descriptors") : null;
        if (descriptorsElement != null) {
            List list = descriptorsElement.getChildren("deploymentDescriptor");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            List children = list;
            for (Element child : children) {
                String url;
                String id = child.getAttributeValue("name");
                if (id == null || (url = child.getAttributeValue("url")) == null) continue;
                configFiles.add(new ConfigFileItem(id, url));
            }
        }
        return configFiles;
    }
}

