/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.java.library.LibraryWithMavenCoordinatesProperties;
import com.intellij.java.library.MavenCoordinates;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryProperties
extends LibraryProperties<RepositoryLibraryProperties>
implements LibraryWithMavenCoordinatesProperties {
    private JpsMavenRepositoryLibraryDescriptor myDescriptor;

    public RepositoryLibraryProperties() {
    }

    public RepositoryLibraryProperties(JpsMavenRepositoryLibraryDescriptor descriptor) {
        this.myDescriptor = descriptor;
    }

    public RepositoryLibraryProperties(String mavenId, boolean includeTransitiveDependencies) {
        this(new JpsMavenRepositoryLibraryDescriptor(mavenId, includeTransitiveDependencies, Collections.emptyList()));
    }

    public RepositoryLibraryProperties(String mavenId, String packaging, boolean includeTransitiveDependencies) {
        this(new JpsMavenRepositoryLibraryDescriptor(mavenId, packaging, includeTransitiveDependencies, Collections.emptyList()));
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(1);
        }
        if (version == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(2);
        }
        this(groupId, artifactId, version, true, ContainerUtil.emptyList());
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies) {
        if (groupId == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(4);
        }
        if (version == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(5);
        }
        if (excludedDependencies == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(6);
        }
        this(new JpsMavenRepositoryLibraryDescriptor(groupId, artifactId, version, includeTransitiveDependencies, excludedDependencies));
    }

    @Override
    @Nullable
    public MavenCoordinates getMavenCoordinates() {
        String groupId = this.getGroupId();
        String artifactId = this.getArtifactId();
        String version = this.getVersion();
        if (groupId != null && artifactId != null && version != null) {
            return new MavenCoordinates(groupId, artifactId, version, this.getPackaging());
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof RepositoryLibraryProperties && Comparing.equal((Object)this.myDescriptor, (Object)((RepositoryLibraryProperties)obj).myDescriptor);
    }

    public int hashCode() {
        return Comparing.hashcode((Object)this.getMavenId());
    }

    public RepositoryLibraryProperties getState() {
        return this;
    }

    public void loadState(@NotNull RepositoryLibraryProperties state) {
        if (state == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(7);
        }
        this.myDescriptor = state.myDescriptor;
    }

    @Attribute(value="maven-id")
    @NlsSafe
    public String getMavenId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getMavenId, null);
    }

    @Attribute(value="packaging")
    public String getPackaging() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getPackaging, "jar");
    }

    public void setMavenId(String mavenId) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(mavenId, this.getPackaging(), this.isIncludeTransitiveDependencies(), this.getExcludedDependencies(), this.getArtifactsVerification(), this.getJarRepositoryId());
    }

    public void setPackaging(String packaging) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), packaging, this.isIncludeTransitiveDependencies(), this.getExcludedDependencies(), this.getArtifactsVerification(), this.getJarRepositoryId());
    }

    @Attribute(value="include-transitive-deps")
    public boolean isIncludeTransitiveDependencies() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::isIncludeTransitiveDependencies, Boolean.TRUE);
    }

    public void setIncludeTransitiveDependencies(boolean includeTransitiveDeps) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), this.getPackaging(), includeTransitiveDeps, this.getExcludedDependencies(), this.getArtifactsVerification(), this.getJarRepositoryId());
    }

    @Attribute(value="jar-repository-id")
    public String getJarRepositoryId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getJarRepositoryId, null);
    }

    public void setJarRepositoryId(String jarRepositoryId) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), this.getPackaging(), this.isIncludeTransitiveDependencies(), this.getExcludedDependencies(), this.getArtifactsVerification(), jarRepositoryId);
    }

    @Transient
    public boolean isEnableSha256Checksum() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::isVerifySha256Checksum, false);
    }

    public String getGroupId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getGroupId, null);
    }

    public String getArtifactId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getArtifactId, null);
    }

    public String getVersion() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getVersion, null);
    }

    public void changeVersion(String version) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getGroupId(), this.getArtifactId(), version, this.getPackaging(), this.isIncludeTransitiveDependencies(), this.getExcludedDependencies(), this.getArtifactsVerification(), this.getJarRepositoryId());
    }

    private <T> T call(Function<? super JpsMavenRepositoryLibraryDescriptor, ? extends T> method, T defaultValue) {
        JpsMavenRepositoryLibraryDescriptor descriptor = this.myDescriptor;
        return descriptor != null ? method.apply((JpsMavenRepositoryLibraryDescriptor)descriptor) : defaultValue;
    }

    @Transient
    public List<String> getExcludedDependencies() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getExcludedDependencies, Collections.emptyList());
    }

    public void setExcludedDependencies(List<String> excludedDeps) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), this.getPackaging(), this.isIncludeTransitiveDependencies(), excludedDeps != null ? excludedDeps : Collections.emptyList(), this.getArtifactsVerification(), this.getJarRepositoryId());
    }

    @Transient
    public List<JpsMavenRepositoryLibraryDescriptor.ArtifactVerification> getArtifactsVerification() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getArtifactsVerification, Collections.emptyList());
    }

    public void setArtifactsVerification(@Nullable List<JpsMavenRepositoryLibraryDescriptor.ArtifactVerification> artifactsVerification) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), this.getPackaging(), this.isIncludeTransitiveDependencies(), this.getExcludedDependencies(), artifactsVerification != null ? artifactsVerification : Collections.emptyList(), this.getJarRepositoryId());
    }

    @XCollection(propertyElementName="exclude", elementName="dependency", valueAttributeName="maven-id")
    public List<String> getExcludedDependenciesBean() {
        return this.myDescriptor != null ? new ArrayList(this.myDescriptor.getExcludedDependencies()) : new ArrayList();
    }

    public void setExcludedDependenciesBean(List<String> dependencyMavenIds) {
        this.setExcludedDependencies(dependencyMavenIds);
    }

    @NotNull
    public JpsMavenRepositoryLibraryDescriptor getRepositoryLibraryDescriptor() {
        return this.myDescriptor != null ? this.myDescriptor : new JpsMavenRepositoryLibraryDescriptor(null, true, Collections.emptyList());
    }

    @XCollection(propertyElementName="verification", style=XCollection.Style.v2)
    public List<ArtifactVerificationProperties> getArtifactsVerificationBean() {
        List<JpsMavenRepositoryLibraryDescriptor.ArtifactVerification> artifactsVerification = this.getArtifactsVerification();
        return artifactsVerification == null ? null : ContainerUtil.map(artifactsVerification, ArtifactVerificationProperties::new);
    }

    public void setArtifactsVerificationBean(@Nullable List<ArtifactVerificationProperties> properties) {
        this.setArtifactsVerification(properties == null ? null : ContainerUtil.map(properties, ArtifactVerificationProperties::getDescriptor));
    }

    public RepositoryLibraryProperties cloneAndChange(Consumer<RepositoryLibraryProperties> transform) {
        RepositoryLibraryProperties newProperties = new RepositoryLibraryProperties(this.myDescriptor);
        transform.accept(newProperties);
        return newProperties;
    }

    public void disableVerification() {
        this.setArtifactsVerification(Collections.emptyList());
    }

    public void unbindRemoteRepository() {
        this.setJarRepositoryId(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDependencies";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag(value="artifact")
    public static class ArtifactVerificationProperties {
        @NotNull
        private JpsMavenRepositoryLibraryDescriptor.ArtifactVerification myDescriptor;

        private ArtifactVerificationProperties() {
            this(new JpsMavenRepositoryLibraryDescriptor.ArtifactVerification("", ""));
        }

        public ArtifactVerificationProperties(@NotNull JpsMavenRepositoryLibraryDescriptor.ArtifactVerification descriptor) {
            if (descriptor == null) {
                ArtifactVerificationProperties.$$$reportNull$$$0(0);
            }
            this.myDescriptor = descriptor;
        }

        @Attribute(value="url")
        public String getUrl() {
            return this.myDescriptor.getUrl();
        }

        public void setUrl(String url) {
            this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor.ArtifactVerification(url, this.getSha256sum());
        }

        @Tag(value="sha256sum")
        public String getSha256sum() {
            return this.myDescriptor.getSha256sum();
        }

        public void setSha256sum(String sha256sum) {
            this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor.ArtifactVerification(this.getUrl(), sha256sum);
        }

        @NotNull
        private JpsMavenRepositoryLibraryDescriptor.ArtifactVerification getDescriptor() {
            assert (!this.myDescriptor.getUrl().isEmpty());
            JpsMavenRepositoryLibraryDescriptor.ArtifactVerification artifactVerification = this.myDescriptor;
            if (artifactVerification == null) {
                ArtifactVerificationProperties.$$$reportNull$$$0(1);
            }
            return artifactVerification;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties$ArtifactVerificationProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties$ArtifactVerificationProperties";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

