/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.fixes.JsonSchemaPropertiesInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0011"}, d2={"collectMissingPropertiesFromSchema", "Lcom/jetbrains/jsonSchema/impl/fixes/JsonSchemaPropertiesInfo;", "objectNodePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "extractPropertiesOfKind", "Lcom/jetbrains/jsonSchema/impl/JsonValidationError$MissingMultiplePropsIssueData;", "foundError", "Lcom/jetbrains/jsonSchema/impl/JsonValidationError;", "kind", "Lcom/jetbrains/jsonSchema/impl/JsonValidationError$FixableIssueKind;", "filterOutUnwantedProperties", "", "Lcom/jetbrains/jsonSchema/impl/JsonValidationError$MissingPropertyIssueData;", "missingProperties", "intellij.json.backend"})
@JvmName(name="missingOptionalPropertiesSearch")
@SourceDebugExtension(value={"SMAP\nmissingOptionalPropertiesSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 missingOptionalPropertiesSearch.kt\ncom/jetbrains/jsonSchema/impl/fixes/missingOptionalPropertiesSearch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1#2:63\n777#3:64\n873#3,2:65\n*S KotlinDebug\n*F\n+ 1 missingOptionalPropertiesSearch.kt\ncom/jetbrains/jsonSchema/impl/fixes/missingOptionalPropertiesSearch\n*L\n49#1:64\n49#1:65,2\n*E\n"})
public final class missingOptionalPropertiesSearch {
    @RequiresReadLock
    @Nullable
    public static final JsonSchemaPropertiesInfo collectMissingPropertiesFromSchema(@NotNull SmartPsiElementPointer<? extends PsiElement> objectNodePointer, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(objectNodePointer, (String)"objectNodePointer");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement psiElement = objectNodePointer.dereference();
        if (psiElement == null) {
            return null;
        }
        PsiElement objectNode = psiElement;
        JsonSchemaObject jsonSchemaObject = JsonSchemaService.Impl.get(project).getSchemaObject(objectNode.getContainingFile());
        if (jsonSchemaObject == null) {
            return null;
        }
        JsonSchemaObject schemaObjectFile = jsonSchemaObject;
        JsonLikePsiWalker jsonLikePsiWalker = JsonLikePsiWalker.getWalker(objectNode, schemaObjectFile);
        if (jsonLikePsiWalker == null) {
            return null;
        }
        JsonLikePsiWalker psiWalker = jsonLikePsiWalker;
        JsonPointerPosition jsonPointerPosition = psiWalker.findPosition(objectNode, true);
        if (jsonPointerPosition == null) {
            return null;
        }
        JsonPointerPosition position = jsonPointerPosition;
        JsonValueAdapter jsonValueAdapter = psiWalker.createValueAdapter(objectNode);
        if (jsonValueAdapter == null) {
            return null;
        }
        JsonValueAdapter valueAdapter = jsonValueAdapter;
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(project, new JsonComplianceCheckerOptions(false, false, true));
        checker.checkObjectBySchemaRecordErrors(schemaObjectFile, valueAdapter, position);
        JsonValidationError jsonValidationError = checker.getErrors().get(objectNode);
        if (jsonValidationError == null) {
            return null;
        }
        JsonValidationError errorsForNode = jsonValidationError;
        JsonValidationError.MissingMultiplePropsIssueData missingRequiredProperties = missingOptionalPropertiesSearch.extractPropertiesOfKind(errorsForNode, JsonValidationError.FixableIssueKind.MissingProperty);
        JsonValidationError.MissingMultiplePropsIssueData missingKnownProperties = missingOptionalPropertiesSearch.extractPropertiesOfKind(errorsForNode, JsonValidationError.FixableIssueKind.MissingOptionalProperty);
        return new JsonSchemaPropertiesInfo(missingRequiredProperties, missingKnownProperties);
    }

    private static final JsonValidationError.MissingMultiplePropsIssueData extractPropertiesOfKind(JsonValidationError foundError, JsonValidationError.FixableIssueKind kind) {
        Collection<JsonValidationError.MissingPropertyIssueData> collection;
        Object object = foundError;
        JsonValidationError it = object;
        boolean bl = false;
        Object object2 = it.getFixableIssueKind() == kind ? object : null;
        JsonValidationError.IssueData issueData = object2 != null ? ((JsonValidationError)object2).getIssueData() : null;
        object = issueData;
        if (object instanceof JsonValidationError.MissingMultiplePropsIssueData) {
            Collection<JsonValidationError.MissingPropertyIssueData> collection2 = ((JsonValidationError.MissingMultiplePropsIssueData)issueData).myMissingPropertyIssues;
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"myMissingPropertyIssues");
            collection = missingOptionalPropertiesSearch.filterOutUnwantedProperties(collection2);
        } else {
            collection = object instanceof JsonValidationError.MissingPropertyIssueData ? missingOptionalPropertiesSearch.filterOutUnwantedProperties(CollectionsKt.listOf((Object)issueData)) : (Collection<JsonValidationError.MissingPropertyIssueData>)CollectionsKt.emptyList();
        }
        Collection<JsonValidationError.MissingPropertyIssueData> filteredProperties = collection;
        return new JsonValidationError.MissingMultiplePropsIssueData(filteredProperties);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<JsonValidationError.MissingPropertyIssueData> filterOutUnwantedProperties(Collection<JsonValidationError.MissingPropertyIssueData> missingProperties) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = missingProperties;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsonValidationError.MissingPropertyIssueData it = (JsonValidationError.MissingPropertyIssueData)element$iv$iv;
            boolean bl = false;
            String string = it.propertyName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"propertyName");
            if (!(!StringsKt.startsWith$default((String)string, (String)"$", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

