/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.util.Range;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diff/comparison/iterables/ExpandedDiffIterable;", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase;", "myIterable", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "myOffset1", "", "myOffset2", "length1", "length2", "<init>", "(Lcom/intellij/diff/comparison/iterables/DiffIterable;IIII)V", "createChangeIterable", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "ShiftedChangeIterable", "intellij.platform.util.diff"})
public final class ExpandedDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final DiffIterable myIterable;
    private final int myOffset1;
    private final int myOffset2;

    public ExpandedDiffIterable(@NotNull DiffIterable myIterable, int myOffset1, int myOffset2, int length1, int length2) {
        Intrinsics.checkNotNullParameter((Object)myIterable, (String)"myIterable");
        super(length1, length2);
        this.myIterable = myIterable;
        this.myOffset1 = myOffset1;
        this.myOffset2 = myOffset2;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new ShiftedChangeIterable(this.myIterable, this.myOffset1, this.myOffset2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/intellij/diff/comparison/iterables/ExpandedDiffIterable$ShiftedChangeIterable;", "Lcom/intellij/diff/comparison/iterables/ChangeDiffIterableBase$ChangeIterable;", "iterable", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "myOffset1", "", "myOffset2", "<init>", "(Lcom/intellij/diff/comparison/iterables/DiffIterable;II)V", "myIterator", "", "Lcom/intellij/diff/util/Range;", "myLast", "valid", "", "next", "", "start1", "getStart1", "()I", "start2", "getStart2", "end1", "getEnd1", "end2", "getEnd2", "intellij.platform.util.diff"})
    private static final class ShiftedChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        private final int myOffset1;
        private final int myOffset2;
        @NotNull
        private final Iterator<Range> myIterator;
        @Nullable
        private Range myLast;

        public ShiftedChangeIterable(@NotNull DiffIterable iterable, int myOffset1, int myOffset2) {
            Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
            this.myOffset1 = myOffset1;
            this.myOffset2 = myOffset2;
            this.myIterator = iterable.changes();
            this.next();
        }

        @Override
        public boolean valid() {
            return this.myLast != null;
        }

        @Override
        public void next() {
            this.myLast = this.myIterator.hasNext() ? this.myIterator.next() : null;
        }

        @Override
        public int getStart1() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.start1 + this.myOffset1;
        }

        @Override
        public int getStart2() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.start2 + this.myOffset2;
        }

        @Override
        public int getEnd1() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.end1 + this.myOffset1;
        }

        @Override
        public int getEnd2() {
            Range range = this.myLast;
            Intrinsics.checkNotNull((Object)range);
            return range.end2 + this.myOffset2;
        }
    }
}

