/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.highlighter;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.ApplicationKt;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0003\u0012\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager;", "", "<init>", "()V", "values", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$CachedHtmlResult;", "obtainCacheKey", "content", "language", "obtainCachedHtml", "key", "cacheHtml", "", "html", "cleanup", "invalidate", "CachedHtmlResult", "InvalidateHtmlCacheLafListener", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nHtmlCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlCacheManager.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,75:1\n540#2:76\n525#2,6:77\n*S KotlinDebug\n*F\n+ 1 HtmlCacheManager.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager\n*L\n48#1:76\n48#1:77,6\n*E\n"})
public final class HtmlCacheManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, CachedHtmlResult> values = new ConcurrentHashMap();
    private static final int expiration = 300000;

    @NotNull
    public final String obtainCacheKey(@NotNull String content2, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return MarkdownUtil.INSTANCE.md5(content2, language);
    }

    @Nullable
    public final String obtainCachedHtml(@NotNull String key) {
        CachedHtmlResult.HtmlResult resolved;
        CachedHtmlResult entry;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CachedHtmlResult cachedHtmlResult = entry = this.values.get(key);
        CachedHtmlResult.HtmlResult htmlResult = resolved = cachedHtmlResult != null ? cachedHtmlResult.resolve() : null;
        if (resolved != null) {
            CachedHtmlResult cachedHtmlResult2 = entry;
            cachedHtmlResult2.setExpires(cachedHtmlResult2.getExpires() + (long)300000);
            return resolved.getHtml();
        }
        this.cleanup();
        return null;
    }

    public final void cacheHtml(@NotNull String key, @NotNull String html2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
        long expires = System.currentTimeMillis() + (long)300000;
        ((Map)this.values).put(key, new CachedHtmlResult(new SoftReference<String>(html2), expires));
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanup() {
        void $this$filterTo$iv$iv;
        long time = System.currentTimeMillis();
        Map $this$filter$iv = this.values;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((CachedHtmlResult)it.getValue()).getExpires() < time)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set expired = destination$iv$iv.keySet();
        for (String key : expired) {
            this.values.remove(key);
        }
    }

    public final void invalidate() {
        this.values.clear();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u001aB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$CachedHtmlResult;", "", "html", "Ljava/lang/ref/SoftReference;", "", "expires", "", "<init>", "(Ljava/lang/ref/SoftReference;J)V", "getHtml", "()Ljava/lang/ref/SoftReference;", "getExpires", "()J", "setExpires", "(J)V", "resolve", "Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$CachedHtmlResult$HtmlResult;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "HtmlResult", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nHtmlCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlCacheManager.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$CachedHtmlResult\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
    private static final class CachedHtmlResult {
        @NotNull
        private final SoftReference<String> html;
        private long expires;

        public CachedHtmlResult(@NotNull SoftReference<String> html2, long expires) {
            Intrinsics.checkNotNullParameter(html2, (String)"html");
            this.html = html2;
            this.expires = expires;
        }

        @NotNull
        public final SoftReference<String> getHtml() {
            return this.html;
        }

        public final long getExpires() {
            return this.expires;
        }

        public final void setExpires(long l) {
            this.expires = l;
        }

        @Nullable
        public final HtmlResult resolve() {
            HtmlResult htmlResult;
            String string = this.html.get();
            if (string != null) {
                String it = string;
                boolean bl = false;
                htmlResult = new HtmlResult(it, this.expires);
            } else {
                htmlResult = null;
            }
            return htmlResult;
        }

        @NotNull
        public final SoftReference<String> component1() {
            return this.html;
        }

        public final long component2() {
            return this.expires;
        }

        @NotNull
        public final CachedHtmlResult copy(@NotNull SoftReference<String> html2, long expires) {
            Intrinsics.checkNotNullParameter(html2, (String)"html");
            return new CachedHtmlResult(html2, expires);
        }

        public static /* synthetic */ CachedHtmlResult copy$default(CachedHtmlResult cachedHtmlResult, SoftReference softReference, long l, int n, Object object) {
            if ((n & 1) != 0) {
                softReference = cachedHtmlResult.html;
            }
            if ((n & 2) != 0) {
                l = cachedHtmlResult.expires;
            }
            return cachedHtmlResult.copy(softReference, l);
        }

        @NotNull
        public String toString() {
            return "CachedHtmlResult(html=" + this.html + ", expires=" + this.expires + ")";
        }

        public int hashCode() {
            int result = this.html.hashCode();
            result = result * 31 + Long.hashCode(this.expires);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedHtmlResult)) {
                return false;
            }
            CachedHtmlResult cachedHtmlResult = (CachedHtmlResult)other;
            if (!Intrinsics.areEqual(this.html, cachedHtmlResult.html)) {
                return false;
            }
            return this.expires == cachedHtmlResult.expires;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$CachedHtmlResult$HtmlResult;", "", "html", "", "expires", "", "<init>", "(Ljava/lang/String;J)V", "getHtml", "()Ljava/lang/String;", "getExpires", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown"})
        public static final class HtmlResult {
            @NotNull
            private final String html;
            private final long expires;

            public HtmlResult(@NotNull String html2, long expires) {
                Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
                this.html = html2;
                this.expires = expires;
            }

            @NotNull
            public final String getHtml() {
                return this.html;
            }

            public final long getExpires() {
                return this.expires;
            }

            @NotNull
            public final String component1() {
                return this.html;
            }

            public final long component2() {
                return this.expires;
            }

            @NotNull
            public final HtmlResult copy(@NotNull String html2, long expires) {
                Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
                return new HtmlResult(html2, expires);
            }

            public static /* synthetic */ HtmlResult copy$default(HtmlResult htmlResult, String string, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    string = htmlResult.html;
                }
                if ((n & 2) != 0) {
                    l = htmlResult.expires;
                }
                return htmlResult.copy(string, l);
            }

            @NotNull
            public String toString() {
                return "HtmlResult(html=" + this.html + ", expires=" + this.expires + ")";
            }

            public int hashCode() {
                int result = this.html.hashCode();
                result = result * 31 + Long.hashCode(this.expires);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof HtmlResult)) {
                    return false;
                }
                HtmlResult htmlResult = (HtmlResult)other;
                if (!Intrinsics.areEqual((Object)this.html, (Object)htmlResult.html)) {
                    return false;
                }
                return this.expires == htmlResult.expires;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$Companion;", "", "<init>", "()V", "expiration", "", "getInstance", "Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager;", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nHtmlCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlCacheManager.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,75:1\n42#2,3:76\n*S KotlinDebug\n*F\n+ 1 HtmlCacheManager.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$Companion\n*L\n71#1:76,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HtmlCacheManager getInstance() {
            boolean $i$f$service = false;
            Class<HtmlCacheManager> serviceClass$iv = HtmlCacheManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (HtmlCacheManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$InvalidateHtmlCacheLafListener;", "Lcom/intellij/ide/ui/LafManagerListener;", "<init>", "()V", "lookAndFeelChanged", "", "source", "Lcom/intellij/ide/ui/LafManager;", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nHtmlCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlCacheManager.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$InvalidateHtmlCacheLafListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,75:1\n58#2:76\n*S KotlinDebug\n*F\n+ 1 HtmlCacheManager.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager$InvalidateHtmlCacheLafListener\n*L\n63#1:76\n*E\n"})
    public static final class InvalidateHtmlCacheLafListener
    implements LafManagerListener {
        public void lookAndFeelChanged(@NotNull LafManager source) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                if (!LoadingState.APP_STARTED.isOccurred()) {
                    return;
                }
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)ApplicationKt.getApplication();
                boolean $i$f$serviceIfCreated = false;
                HtmlCacheManager htmlCacheManager = (HtmlCacheManager)$this$serviceIfCreated$iv.getServiceIfCreated(HtmlCacheManager.class);
                if (htmlCacheManager == null) break block1;
                htmlCacheManager.invalidate();
            }
        }
    }
}

