/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.mermaid;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.util.ApplicationKt;
import java.time.Duration;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.jcef.mermaid.InstallMermaidPluginAction;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\b\u0010\b\u001a\u00020\tH\u0002\u001a\b\u0010\n\u001a\u00020\tH\u0002\u001a\b\u0010\u000b\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\"\u0010\u000f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"mermaidPluginId", "Lcom/intellij/openapi/extensions/PluginId;", "NOTIFICATION_SHOWN", "", "IGNORE_DELAY", "", "shouldShow", "", "markDelayed", "", "markShown", "isMermaidPluginInstalled", "advertiseMermaidPlugin", "project", "Lcom/intellij/openapi/project/Project;", "installMermaidPlugin", "onSuccess", "Lkotlin/Function0;", "intellij.markdown"})
public final class MermaidPluginAdvertisementKt {
    @NotNull
    private static final PluginId mermaidPluginId = PluginId.Companion.getId("com.intellij.mermaid");
    @NotNull
    private static final String NOTIFICATION_SHOWN = "Markdown.Mermaid.Last.Shown";
    private static final long IGNORE_DELAY = Duration.ofDays(7L).toMillis();

    private static final boolean shouldShow() {
        long timestamp = PropertiesComponent.getInstance().getLong(NOTIFICATION_SHOWN, 0L);
        if (timestamp < 0L) {
            return false;
        }
        long current = System.currentTimeMillis();
        return current - timestamp > IGNORE_DELAY;
    }

    private static final void markDelayed() {
        PropertiesComponent.getInstance().setValue(NOTIFICATION_SHOWN, String.valueOf(System.currentTimeMillis()));
    }

    private static final void markShown() {
        PropertiesComponent.getInstance().setValue(NOTIFICATION_SHOWN, "-1");
    }

    public static final boolean isMermaidPluginInstalled() {
        return PluginManager.isPluginInstalled((PluginId)mermaidPluginId);
    }

    public static final void advertiseMermaidPlugin(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (MermaidPluginAdvertisementKt.isMermaidPluginInstalled() || ApplicationKt.getApplication().isUnitTestMode() || !MermaidPluginAdvertisementKt.shouldShow()) {
            return;
        }
        MermaidPluginAdvertisementKt.markDelayed();
        ActionsKt.invokeLater$default(null, () -> MermaidPluginAdvertisementKt.advertiseMermaidPlugin$lambda$0(project), (int)1, null);
    }

    public static final void installMermaidPlugin(@Nullable Project project, @NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        PluginsAdvertiser.installAndEnable$default((Project)project, (Set)SetsKt.setOf((Object)mermaidPluginId), (boolean)true, (boolean)false, null, () -> MermaidPluginAdvertisementKt.installMermaidPlugin$lambda$1(onSuccess), (int)24, null);
    }

    public static /* synthetic */ void installMermaidPlugin$default(Project project, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = MermaidPluginAdvertisementKt::installMermaidPlugin$lambda$0;
        }
        MermaidPluginAdvertisementKt.installMermaidPlugin(project, (Function0<Unit>)function0);
    }

    private static final void advertiseMermaidPlugin$lambda$0$0() {
        MermaidPluginAdvertisementKt.markDelayed();
    }

    private static final void advertiseMermaidPlugin$lambda$0$1() {
        MermaidPluginAdvertisementKt.markShown();
    }

    private static final Unit advertiseMermaidPlugin$lambda$0(Project $project) {
        String string = MarkdownBundle.message("markdown.notification.mermaid.advertisement.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String text2 = string;
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)MarkdownBundle.message("markdown.notification.mermaid.advertisement.remind.later.action.text", new Object[0]), MermaidPluginAdvertisementKt::advertiseMermaidPlugin$lambda$0$0);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        NotificationAction remindLaterAction = notificationAction;
        NotificationAction notificationAction2 = NotificationAction.createSimpleExpiring((String)MarkdownBundle.message("markdown.notification.mermaid.advertisement.ignore.action.text", new Object[0]), MermaidPluginAdvertisementKt::advertiseMermaidPlugin$lambda$0$1);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction2, (String)"createSimpleExpiring(...)");
        NotificationAction ignoreAction = notificationAction2;
        NotificationGroup group = MarkdownNotifications.INSTANCE.getGroup();
        group.createNotification(text2, NotificationType.INFORMATION).setTitle(MarkdownBundle.message("markdown.notification.mermaid.advertisement.title", new Object[0])).addAction((AnAction)new InstallMermaidPluginAction()).addAction((AnAction)remindLaterAction).addAction((AnAction)ignoreAction).setSuggestionType(true).notify($project);
        return Unit.INSTANCE;
    }

    private static final Unit installMermaidPlugin$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void installMermaidPlugin$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

