/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.images.MarkdownImagesBundle;
import org.intellij.plugins.markdown.images.editor.ConfigureImageDialog;
import org.intellij.plugins.markdown.images.editor.ConfigureImageLineMarkerProviderBase;
import org.intellij.plugins.markdown.images.editor.ImagePsiElementFactory;
import org.intellij.plugins.markdown.images.editor.MarkdownImageData;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownImage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/images/editor/ConfigureMarkdownImageLineMarkerProvider;", "Lorg/intellij/plugins/markdown/images/editor/ConfigureImageLineMarkerProviderBase;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownImage;", "<init>", "()V", "obtainPathText", "", "element", "Lcom/intellij/psi/PsiElement;", "obtainLeafElement", "obtainOuterElement", "createDialog", "Lorg/intellij/plugins/markdown/images/editor/ConfigureImageDialog;", "isInsideParagraph", "", "createHtmlReplacement", "imageData", "Lorg/intellij/plugins/markdown/images/editor/MarkdownImageData;", "applyChanges", "", "intellij.markdown.images"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nConfigureMarkdownImageLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureMarkdownImageLineMarkerProvider.kt\norg/intellij/plugins/markdown/images/editor/ConfigureMarkdownImageLineMarkerProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class ConfigureMarkdownImageLineMarkerProvider
extends ConfigureImageLineMarkerProviderBase<MarkdownImage> {
    @Override
    @Nullable
    public String obtainPathText(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownImage markdownImage = this.obtainOuterElement(element2);
        if (markdownImage == null) {
            return null;
        }
        MarkdownImage image = markdownImage;
        MarkdownLinkDestination markdownLinkDestination = image.getLinkDestination();
        return markdownLinkDestination != null ? markdownLinkDestination.getText() : null;
    }

    @Override
    @Nullable
    public PsiElement obtainLeafElement(@NotNull PsiElement element2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownImage outer = MarkdownImage.Companion.getByLeadingExclamationMark(element2);
        PsiElement it = psiElement = element2;
        boolean bl = false;
        return outer != null ? psiElement : null;
    }

    @Override
    @Nullable
    public MarkdownImage obtainOuterElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return element2 instanceof MarkdownImage ? (MarkdownImage)element2 : MarkdownImage.Companion.getByLeadingExclamationMark(element2);
    }

    @Override
    @Nullable
    public ConfigureImageDialog createDialog(@NotNull MarkdownImage element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownImage markdownImage = this.obtainOuterElement((PsiElement)element2);
        if (markdownImage == null) {
            return null;
        }
        MarkdownImage image = markdownImage;
        return new ConfigureImageDialog(image.getProject(), MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.title.text", new Object[0]), this.obtainPathText((PsiElement)element2), null, null, image.collectLinkTitleText(), image.collectLinkDescriptionText(), false, 24, null);
    }

    private final boolean isInsideParagraph(PsiElement element2) {
        Object v0;
        block1: {
            Sequence sequence = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)false);
            for (Object e : sequence) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)MarkdownElementTypes.PARAGRAPH)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private final PsiElement createHtmlReplacement(PsiElement element2, MarkdownImageData imageData) {
        PsiElement psiElement;
        if (this.isInsideParagraph(element2)) {
            Project project = element2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            psiElement = ImagePsiElementFactory.INSTANCE.createHtmlImageTag(project, imageData);
        } else {
            Project project = element2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            psiElement = ImagePsiElementFactory.INSTANCE.createHtmlBlockWithImage(project, imageData);
        }
        return psiElement;
    }

    @Override
    public void applyChanges(@NotNull PsiElement element2, @NotNull MarkdownImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        MarkdownImage markdownImage = this.obtainOuterElement(element2);
        if (markdownImage == null) {
            return;
        }
        MarkdownImage outerElement = markdownImage;
        Project project = outerElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiElement replacement = imageData.getShouldConvertToHtml() ? this.createHtmlReplacement((PsiElement)outerElement, imageData) : ImagePsiElementFactory.INSTANCE.createImage(project2, imageData.getDescription(), imageData.getPath(), imageData.getTitle());
        Runnable action = () -> ConfigureMarkdownImageLineMarkerProvider.applyChanges$lambda$0(outerElement, replacement);
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)MarkdownImagesBundle.INSTANCE.message("markdown.configure.image.title.text", new Object[0]), null, (Runnable)action, (PsiFile[])new PsiFile[0]);
    }

    private static final void applyChanges$lambda$0(MarkdownImage $outerElement, PsiElement $replacement) {
        $outerElement.replace($replacement);
    }
}

