/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor.paste;

import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.Producer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.images.editor.paste.MarkdownFileDropHandler;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/images/editor/paste/FileLinkPasteProvider;", "Lcom/intellij/ide/PasteProvider;", "<init>", "()V", "performPaste", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isPasteEnabled", "", "isPastePossible", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.markdown.images"})
@SourceDebugExtension(value={"SMAP\nFileLinkPasteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileLinkPasteProvider.kt\norg/intellij/plugins/markdown/images/editor/paste/FileLinkPasteProvider\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,60:1\n7#2,6:61\n*S KotlinDebug\n*F\n+ 1 FileLinkPasteProvider.kt\norg/intellij/plugins/markdown/images/editor/paste/FileLinkPasteProvider\n*L\n30#1:61,6\n*E\n"})
public final class FileLinkPasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor2 = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Producer producer = (Producer)dataContext.getData(PasteAction.TRANSFERABLE_PROVIDER);
        if (producer == null) {
            return;
        }
        Producer transferableProvider = producer;
        Transferable transferable = (Transferable)transferableProvider.produce();
        if (transferable == null) {
            return;
        }
        Transferable transferable2 = transferable;
        List list2 = FileCopyPasteUtil.getFiles((Transferable)transferable2);
        if (list2 == null || (list2 = CollectionsKt.asSequence((Iterable)list2)) == null) {
            return;
        }
        List files = list2;
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)editor3);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getPsiFile(...)");
        PsiFile file = psiFile;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        String content2 = MarkdownFileDropHandler.Manager.INSTANCE.buildTextContent((Sequence<? extends Path>)files, file);
        ActionsKt.runWriteAction(() -> FileLinkPasteProvider.performPaste$lambda$0(project2, document2, editor3, content2));
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!((MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState()).getEnableFileDrop()) {
            return false;
        }
        VirtualFile virtualFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        FileType fileType2 = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        if (MarkdownLanguageUtilsKt.isMarkdownType(fileType2)) {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.javaFileListFlavor};
            return CopyPasteManager.getInstance().areDataFlavorsAvailable(dataFlavorArray);
        }
        return false;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final Unit performPaste$lambda$0$0(Project $project, Editor $editor, Document $document, String $content) {
        Project project$iv = $project;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable($editor, $document, $content){
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ String $content$inlined;
            {
                this.$editor$inlined = editor2;
                this.$document$inlined = document;
                this.$content$inlined = string;
            }

            public final void run() {
                boolean bl = false;
                CaretModel caretModel = this.$editor$inlined.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                EditorUtilKt.runForEachCaret(caretModel, true, (Function1<? super Caret, Unit>)((Function1)new Function1<Caret, Unit>(this.$document$inlined, this.$content$inlined){
                    final /* synthetic */ Document $document;
                    final /* synthetic */ String $content;
                    {
                        this.$document = $document;
                        this.$content = $content;
                    }

                    public final void invoke(Caret caret) {
                        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                        int offset = caret.getOffset();
                        this.$document.insertString(offset, (CharSequence)this.$content);
                        caret.moveToOffset(offset + this.$content.length());
                    }
                }));
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    private static final Unit performPaste$lambda$0(Project $project, Document $document, Editor $editor, String $content) {
        MarkdownFileDropHandler.Manager.INSTANCE.handleReadOnlyModificationException($project, $document, (Function0<Unit>)((Function0)() -> FileLinkPasteProvider.performPaste$lambda$0$0($project, $editor, $document, $content)));
        return Unit.INSTANCE;
    }
}

