/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.cache;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.MultiplatformKt;
import org.jetbrains.plugins.textmate.cache.TextMateCache;
import org.jetbrains.plugins.textmate.cache.TextMateCachedValue;
import org.jetbrains.plugins.textmate.concurrent.TextMateLock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\n\b\u0001\u0010\u0003*\u0004\u0018\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u000212BK\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\n0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001bH\u0002J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u00192\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ)\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00028\u00002\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010!J\u001c\u0010\"\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001bH\u0002J\b\u0010#\u001a\u00020\nH\u0002J\b\u0010$\u001a\u00020\nH\u0002J\u001c\u0010%\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001bH\u0002J\u0015\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u0017\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0016\u00a2\u0006\u0004\b,\u0010-J\b\u0010.\u001a\u00020\nH\u0016J\b\u0010/\u001a\u00020\nH\u0016J\b\u00100\u001a\u00020\u0006H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache;", "K", "", "V", "Lorg/jetbrains/plugins/textmate/cache/TextMateCache;", "capacity", "", "computeFn", "Lkotlin/Function1;", "disposeFn", "", "protectedRatio", "", "timeSource", "Lkotlin/time/TimeSource;", "<init>", "(ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;DLkotlin/time/TimeSource;)V", "protectedSize", "probationarySize", "probationaryCache", "Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$LRUSegment;", "protectedCache", "lock", "Lorg/jetbrains/plugins/textmate/concurrent/TextMateLock;", "valueRef", "Lorg/jetbrains/plugins/textmate/cache/TextMateCachedValue;", "entry", "Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;", "get", "key", "(Ljava/lang/Object;)Lorg/jetbrains/plugins/textmate/cache/TextMateCachedValue;", "putToProbation", "newEntry", "(Ljava/lang/Object;Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;)V", "promoteToProtected", "evictFromProtected", "evictFromProbationary", "finalizeEviction", "contains", "", "(Ljava/lang/Object;)Z", "cleanup", "ttl", "Lkotlin/time/Duration;", "cleanup-LRDsOJo", "(J)V", "clear", "close", "size", "Entry", "LRUSegment", "intellij.textmate.core"})
@SourceDebugExtension(value={"SMAP\nSLRUTextMateCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SLRUTextMateCache.kt\norg/jetbrains/plugins/textmate/cache/SLRUTextMateCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,354:1\n1#2:355\n1915#3,2:356\n1915#3,2:358\n1915#3,2:360\n*S KotlinDebug\n*F\n+ 1 SLRUTextMateCache.kt\norg/jetbrains/plugins/textmate/cache/SLRUTextMateCache\n*L\n177#1:356,2\n155#1:358,2\n165#1:360,2\n*E\n"})
public final class SLRUTextMateCache<K, V>
implements TextMateCache<K, V> {
    @NotNull
    private final Function1<K, V> computeFn;
    @NotNull
    private final Function1<V, Unit> disposeFn;
    @NotNull
    private final TimeSource timeSource;
    private final int protectedSize;
    private final int probationarySize;
    @NotNull
    private final LRUSegment<K, V> probationaryCache;
    @NotNull
    private final LRUSegment<K, V> protectedCache;
    @NotNull
    private final TextMateLock lock;

    public SLRUTextMateCache(int capacity, @NotNull Function1<? super K, ? extends V> computeFn, @NotNull Function1<? super V, Unit> disposeFn, double protectedRatio, @NotNull TimeSource timeSource) {
        Intrinsics.checkNotNullParameter(computeFn, (String)"computeFn");
        Intrinsics.checkNotNullParameter(disposeFn, (String)"disposeFn");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this.computeFn = computeFn;
        this.disposeFn = disposeFn;
        this.timeSource = timeSource;
        this.protectedSize = Math.max(1, (int)((double)capacity * protectedRatio));
        this.probationarySize = capacity - this.protectedSize;
        this.probationaryCache = new LRUSegment();
        this.protectedCache = new LRUSegment();
        this.lock = MultiplatformKt.createTextMateLock();
        if (!(capacity > 0)) {
            boolean $i$a$-require-SLRUTextMateCache$52 = false;
            String $i$a$-require-SLRUTextMateCache$52 = "Capacity must be positive";
            throw new IllegalArgumentException($i$a$-require-SLRUTextMateCache$52.toString());
        }
        if (!(0.0 <= protectedRatio ? protectedRatio <= 1.0 : false)) {
            boolean $i$a$-require-SLRUTextMateCache$62 = false;
            String $i$a$-require-SLRUTextMateCache$62 = "Protected ratio must be between 0 and 1";
            throw new IllegalArgumentException($i$a$-require-SLRUTextMateCache$62.toString());
        }
        if (!(this.protectedSize >= 0)) {
            boolean $i$a$-require-SLRUTextMateCache$72 = false;
            String $i$a$-require-SLRUTextMateCache$72 = "Protected size must be positive";
            throw new IllegalArgumentException($i$a$-require-SLRUTextMateCache$72.toString());
        }
        if (!(this.probationarySize >= 0)) {
            boolean bl = false;
            String string = "Probationary size must be positive";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SLRUTextMateCache(int n, Function1 function1, Function1 function12, double d, TimeSource timeSource, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            d = 0.8;
        }
        if ((n2 & 0x10) != 0) {
            timeSource = (TimeSource)TimeSource.Monotonic.INSTANCE;
        }
        this(n, function1, function12, d, timeSource);
    }

    private final TextMateCachedValue<V> valueRef(Entry<K, V> entry) {
        return new TextMateCachedValue<V>(entry, this){
            final /* synthetic */ Entry<K, V> $entry;
            final /* synthetic */ SLRUTextMateCache<K, V> this$0;
            {
                this.$entry = $entry;
                this.this$0 = $receiver;
            }

            public V getValue() {
                return this.$entry.getValue();
            }

            public void close() {
                if (AtomicsKt.decrementAndFetch((AtomicInteger)this.$entry.getRefCount()) == 0 && this.$entry.getEvicted().get()) {
                    SLRUTextMateCache.access$finalizeEviction(this.this$0, this.$entry);
                }
            }
        };
    }

    @Override
    @NotNull
    public TextMateCachedValue<V> get(@NotNull K key) {
        TextMateCachedValue<V> textMateCachedValue;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Entry existingEntry = (Entry)this.lock.withLock(() -> SLRUTextMateCache.get$lambda$0(this, key));
        if (existingEntry != null) {
            textMateCachedValue = this.valueRef(existingEntry);
        } else {
            Object newValue = this.computeFn.invoke(key);
            Entry newEntry = new Entry(key, newValue, new AtomicReference<TimeMark>(this.timeSource.markNow()), new AtomicInteger(1), null, null, null, 112, null);
            Pair pair = (Pair)this.lock.withLock(() -> SLRUTextMateCache.get$lambda$1(this, key, newEntry));
            Entry newOrExistingEntry = (Entry)pair.component1();
            boolean newEntryInserted = (Boolean)pair.component2();
            if (!newEntryInserted) {
                this.disposeFn.invoke(newValue);
            }
            textMateCachedValue = this.valueRef(newOrExistingEntry);
        }
        return textMateCachedValue;
    }

    private final void putToProbation(K key, Entry<K, V> newEntry) {
        while (this.size() >= this.probationarySize + this.protectedSize) {
            this.evictFromProbationary();
        }
        this.probationaryCache.put(key, newEntry);
    }

    private final void promoteToProtected(Entry<K, V> entry) {
        while (this.protectedCache.size() >= this.protectedSize) {
            this.evictFromProtected();
        }
        if (this.probationaryCache.remove(entry.getKey()) != null) {
            this.protectedCache.put(entry.getKey(), entry);
        }
    }

    private final void evictFromProtected() {
        Entry<K, V> entry = this.protectedCache.removeEldest();
        if (entry == null) {
            return;
        }
        Entry<K, V> victim = entry;
        if (victim.getEvicted().compareAndSet(false, true) && victim.getRefCount().get() == 0) {
            this.finalizeEviction(victim);
        }
    }

    private final void evictFromProbationary() {
        Entry<K, V> entry = this.probationaryCache.removeEldest();
        if (entry == null) {
            return;
        }
        Entry<K, V> victim = entry;
        if (victim.getEvicted().compareAndSet(false, true) && victim.getRefCount().get() == 0) {
            this.finalizeEviction(victim);
        }
    }

    private final void finalizeEviction(Entry<K, V> entry) {
        try {
            this.disposeFn.invoke(entry.getValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean contains(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (Boolean)this.lock.withLock(() -> SLRUTextMateCache.contains$lambda$0(this, key));
    }

    @Override
    public void cleanup-LRDsOJo(long ttl) {
        List toEvict = (List)this.lock.withLock(() -> SLRUTextMateCache.cleanup_LRDsOJo$lambda$0(this, ttl));
        Iterable $this$forEach$iv = toEvict;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry entry = (Entry)element$iv;
            boolean bl = false;
            this.finalizeEviction(entry);
        }
    }

    @Override
    public void clear() {
        this.lock.withLock(() -> SLRUTextMateCache.clear$lambda$0(this));
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public int size() {
        return ((Number)this.lock.withLock(() -> SLRUTextMateCache.size$lambda$0(this))).intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Entry get$lambda$0(SLRUTextMateCache this$0, Object $key) {
        Entry entry;
        Entry entry2;
        Entry entry3 = this$0.protectedCache.get($key);
        Entry entry4 = entry3;
        if (entry3 != null) return entry4;
        SLRUTextMateCache $this$get_u24lambda_u240_u240 = this$0;
        boolean bl = false;
        Entry entry5 = $this$get_u24lambda_u240_u240.probationaryCache.get($key);
        if (entry5 == null) return null;
        Entry it = entry2 = entry5;
        boolean bl2 = false;
        $this$get_u24lambda_u240_u240.promoteToProtected(it);
        Entry entry6 = entry2;
        Entry entry7 = entry6;
        if (entry7 == null) return null;
        Entry it2 = entry = entry7;
        boolean bl3 = false;
        if (it2.getEvicted().get()) return null;
        boolean bl4 = true;
        if (!bl4) return null;
        Entry entry8 = entry;
        Entry entry9 = entry8;
        if (entry9 == null) return null;
        Entry existingEntry = entry = entry9;
        boolean bl5 = false;
        AtomicsKt.incrementAndFetch((AtomicInteger)existingEntry.getRefCount());
        existingEntry.getLastAccessed().set(this$0.timeSource.markNow());
        entry4 = entry;
        return entry4;
    }

    private static final Pair get$lambda$1(SLRUTextMateCache this$0, Object $key, Entry $newEntry) {
        Pair pair;
        Entry doubleCheckedExistingEntry;
        Entry entry = this$0.protectedCache.get($key);
        if (entry == null) {
            Entry entry2;
            Entry entry3;
            SLRUTextMateCache $this$get_u24lambda_u241_u240 = this$0;
            boolean bl = false;
            Entry entry4 = $this$get_u24lambda_u241_u240.probationaryCache.get($key);
            if (entry4 != null) {
                Entry entry5;
                Entry it = entry5 = entry4;
                boolean bl2 = false;
                $this$get_u24lambda_u241_u240.promoteToProtected(it);
                entry3 = entry5;
            } else {
                entry3 = null;
            }
            if ((entry2 = entry3) != null) {
                Entry entry6;
                Entry it = entry6 = entry2;
                boolean bl3 = false;
                entry = !it.getEvicted().get() ? entry6 : null;
            } else {
                entry = null;
            }
        }
        if ((doubleCheckedExistingEntry = entry) != null) {
            AtomicsKt.incrementAndFetch((AtomicInteger)doubleCheckedExistingEntry.getRefCount());
            doubleCheckedExistingEntry.getLastAccessed().set(this$0.timeSource.markNow());
            pair = TuplesKt.to(doubleCheckedExistingEntry, (Object)false);
        } else {
            this$0.putToProbation($key, $newEntry);
            pair = TuplesKt.to((Object)$newEntry, (Object)true);
        }
        return pair;
    }

    private static final boolean contains$lambda$0(SLRUTextMateCache this$0, Object $key) {
        return this$0.protectedCache.contains($key) || this$0.probationaryCache.contains($key);
    }

    private static final List cleanup_LRDsOJo$lambda$0(SLRUTextMateCache this$0, long $ttl) {
        Entry it;
        Entry entry;
        List list;
        List $this$cleanup_LRDsOJo_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = this$0.protectedCache.allEntriesCopy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            entry = (Entry)element$iv;
            boolean bl2 = false;
            if (entry.getRefCount().get() != 0 || Duration.compareTo-LRDsOJo((long)entry.getLastAccessed().get().elapsedNow-UwyO8pc(), (long)$ttl) < 0) continue;
            if (this$0.protectedCache.remove(entry.getKey()) == null) continue;
            boolean bl3 = false;
            if (!entry.getEvicted().compareAndSet(false, true)) continue;
            $this$cleanup_LRDsOJo_u24lambda_u240_u240.add(it);
        }
        $this$forEach$iv = this$0.probationaryCache.allEntriesCopy();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            entry = (Entry)element$iv;
            boolean bl4 = false;
            if (entry.getRefCount().get() != 0 || Duration.compareTo-LRDsOJo((long)entry.getLastAccessed().get().elapsedNow-UwyO8pc(), (long)$ttl) < 0) continue;
            if (this$0.probationaryCache.remove(entry.getKey()) == null) continue;
            boolean bl5 = false;
            if (!entry.getEvicted().compareAndSet(false, true)) continue;
            $this$cleanup_LRDsOJo_u24lambda_u240_u240.add(it);
        }
        return CollectionsKt.build((List)list);
    }

    private static final Unit clear$lambda$0(SLRUTextMateCache this$0) {
        List allEntries = CollectionsKt.plus((Collection)this$0.probationaryCache.allEntriesCopy(), (Iterable)this$0.protectedCache.allEntriesCopy());
        for (Entry entry : allEntries) {
            if (!entry.getEvicted().compareAndSet(false, true) || entry.getRefCount().get() != 0) continue;
            this$0.disposeFn.invoke(entry.getValue());
        }
        this$0.probationaryCache.clear();
        this$0.protectedCache.clear();
        return Unit.INSTANCE;
    }

    private static final int size$lambda$0(SLRUTextMateCache this$0) {
        return this$0.probationaryCache.size() + this$0.protectedCache.size();
    }

    public static final /* synthetic */ void access$finalizeEviction(SLRUTextMateCache $this, Entry entry) {
        $this.finalizeEviction(entry);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003Bi\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000\u0012\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010&\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010'\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010)\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010*\u001a\u00020\fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010+\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000H\u00c6\u0003J\u0017\u0010,\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000H\u00c6\u0003J\u0082\u0001\u0010-\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00022\b\b\u0002\u0010\u0005\u001a\u00028\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u00002\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u0003H\u00d6\u0083\u0004J\n\u00102\u001a\u000203H\u00d6\u0081\u0004J\n\u00104\u001a\u000205H\u00d6\u0081\u0004R\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0014\u0010\u0012R\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0013\u0010\t\u001a\u00020\n\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000b\u001a\u00020\f\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR(\u0010\r\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R(\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010!\"\u0004\b%\u0010#\u00a8\u00066"}, d2={"Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;", "K", "V", "", "key", "value", "lastAccessed", "Lkotlin/concurrent/atomics/AtomicReference;", "Lkotlin/time/TimeMark;", "refCount", "Lkotlin/concurrent/atomics/AtomicInt;", "evicted", "Lkotlin/concurrent/atomics/AtomicBoolean;", "prev", "next", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/concurrent/atomic/AtomicReference;Ljava/util/concurrent/atomic/AtomicInteger;Ljava/util/concurrent/atomic/AtomicBoolean;Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "getLastAccessed", "()Ljava/util/concurrent/atomic/AtomicReference;", "setLastAccessed", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "Ljava/util/concurrent/atomic/AtomicReference;", "getRefCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "Ljava/util/concurrent/atomic/AtomicInteger;", "getEvicted", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getPrev", "()Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;", "setPrev", "(Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;)V", "getNext", "setNext", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/concurrent/atomic/AtomicReference;Ljava/util/concurrent/atomic/AtomicInteger;Ljava/util/concurrent/atomic/AtomicBoolean;Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;)Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.textmate.core"})
    private static final class Entry<K, V> {
        private final K key;
        private final V value;
        @NotNull
        private AtomicReference<TimeMark> lastAccessed;
        @NotNull
        private final AtomicInteger refCount;
        @NotNull
        private final AtomicBoolean evicted;
        @Nullable
        private Entry<K, V> prev;
        @Nullable
        private Entry<K, V> next;

        public Entry(K key, V value, @NotNull AtomicReference<TimeMark> lastAccessed, @NotNull AtomicInteger refCount, @NotNull AtomicBoolean evicted, @Nullable Entry<K, V> prev, @Nullable Entry<K, V> next) {
            Intrinsics.checkNotNullParameter(lastAccessed, (String)"lastAccessed");
            Intrinsics.checkNotNullParameter((Object)refCount, (String)"refCount");
            Intrinsics.checkNotNullParameter((Object)evicted, (String)"evicted");
            this.key = key;
            this.value = value;
            this.lastAccessed = lastAccessed;
            this.refCount = refCount;
            this.evicted = evicted;
            this.prev = prev;
            this.next = next;
        }

        public /* synthetic */ Entry(Object object, Object object2, AtomicReference atomicReference, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Entry entry, Entry entry2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                atomicInteger = new AtomicInteger(0);
            }
            if ((n & 0x10) != 0) {
                atomicBoolean = new AtomicBoolean(false);
            }
            if ((n & 0x20) != 0) {
                entry = null;
            }
            if ((n & 0x40) != 0) {
                entry2 = null;
            }
            this(object, object2, atomicReference, atomicInteger, atomicBoolean, entry, entry2);
        }

        public final K getKey() {
            return this.key;
        }

        public final V getValue() {
            return this.value;
        }

        @NotNull
        public final AtomicReference<TimeMark> getLastAccessed() {
            return this.lastAccessed;
        }

        public final void setLastAccessed(@NotNull AtomicReference<TimeMark> atomicReference) {
            Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
            this.lastAccessed = atomicReference;
        }

        @NotNull
        public final AtomicInteger getRefCount() {
            return this.refCount;
        }

        @NotNull
        public final AtomicBoolean getEvicted() {
            return this.evicted;
        }

        @Nullable
        public final Entry<K, V> getPrev() {
            return this.prev;
        }

        public final void setPrev(@Nullable Entry<K, V> entry) {
            this.prev = entry;
        }

        @Nullable
        public final Entry<K, V> getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Entry<K, V> entry) {
            this.next = entry;
        }

        public final K component1() {
            return this.key;
        }

        public final V component2() {
            return this.value;
        }

        @NotNull
        public final AtomicReference<TimeMark> component3() {
            return this.lastAccessed;
        }

        @NotNull
        public final AtomicInteger component4() {
            return this.refCount;
        }

        @NotNull
        public final AtomicBoolean component5() {
            return this.evicted;
        }

        @Nullable
        public final Entry<K, V> component6() {
            return this.prev;
        }

        @Nullable
        public final Entry<K, V> component7() {
            return this.next;
        }

        @NotNull
        public final Entry<K, V> copy(K key, V value, @NotNull AtomicReference<TimeMark> lastAccessed, @NotNull AtomicInteger refCount, @NotNull AtomicBoolean evicted, @Nullable Entry<K, V> prev, @Nullable Entry<K, V> next) {
            Intrinsics.checkNotNullParameter(lastAccessed, (String)"lastAccessed");
            Intrinsics.checkNotNullParameter((Object)refCount, (String)"refCount");
            Intrinsics.checkNotNullParameter((Object)evicted, (String)"evicted");
            return new Entry<K, V>(key, value, lastAccessed, refCount, evicted, prev, next);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, Object object, Object object2, AtomicReference atomicReference, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Entry entry2, Entry entry3, int n, Object object3) {
            if ((n & 1) != 0) {
                object = entry.key;
            }
            if ((n & 2) != 0) {
                object2 = entry.value;
            }
            if ((n & 4) != 0) {
                atomicReference = entry.lastAccessed;
            }
            if ((n & 8) != 0) {
                atomicInteger = entry.refCount;
            }
            if ((n & 0x10) != 0) {
                atomicBoolean = entry.evicted;
            }
            if ((n & 0x20) != 0) {
                entry2 = entry.prev;
            }
            if ((n & 0x40) != 0) {
                entry3 = entry.next;
            }
            return entry.copy(object, object2, atomicReference, atomicInteger, atomicBoolean, entry2, entry3);
        }

        @NotNull
        public String toString() {
            return "Entry(key=" + this.key + ", value=" + this.value + ", lastAccessed=" + this.lastAccessed + ", refCount=" + this.refCount + ", evicted=" + this.evicted + ", prev=" + this.prev + ", next=" + this.next + ")";
        }

        public int hashCode() {
            int result = this.key == null ? 0 : this.key.hashCode();
            result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
            result = result * 31 + this.lastAccessed.hashCode();
            result = result * 31 + this.refCount.hashCode();
            result = result * 31 + this.evicted.hashCode();
            result = result * 31 + (this.prev == null ? 0 : this.prev.hashCode());
            result = result * 31 + (this.next == null ? 0 : this.next.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual(this.key, entry.key)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.value, entry.value)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.lastAccessed, entry.lastAccessed)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refCount, (Object)entry.refCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.evicted, (Object)entry.evicted)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.prev, entry.prev)) {
                return false;
            }
            return Intrinsics.areEqual(this.next, entry.next);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\b2\u0006\u0010\f\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00028\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\b2\u0006\u0010\f\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\bJ\u001a\u0010\u0017\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u000fJ\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b0\u001cJ\u001c\u0010\u001d\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\bH\u0002J\u001c\u0010\u001e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\bH\u0002R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00028\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$LRUSegment;", "K", "V", "", "<init>", "()V", "map", "", "Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;", "head", "tail", "get", "key", "(Ljava/lang/Object;)Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;", "put", "", "entry", "(Ljava/lang/Object;Lorg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$Entry;)V", "contains", "", "(Ljava/lang/Object;)Z", "remove", "removeEldest", "moveToHead", "size", "", "clear", "allEntriesCopy", "", "addToHead", "removeEntry", "intellij.textmate.core"})
    @SourceDebugExtension(value={"SMAP\nSLRUTextMateCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SLRUTextMateCache.kt\norg/jetbrains/plugins/textmate/cache/SLRUTextMateCache$LRUSegment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,354:1\n1#2:355\n*E\n"})
    private static final class LRUSegment<K, V> {
        @NotNull
        private final Map<K, Entry<K, V>> map = new LinkedHashMap();
        @Nullable
        private Entry<K, V> head;
        @Nullable
        private Entry<K, V> tail;

        @Nullable
        public final Entry<K, V> get(K key) {
            Entry<K, V> entry;
            Entry<K, V> entry2 = this.map.get(key);
            if (entry2 != null) {
                Entry<K, V> entry3;
                Entry<K, V> it = entry3 = entry2;
                boolean bl = false;
                this.moveToHead(it);
                entry = entry3;
            } else {
                entry = null;
            }
            return entry;
        }

        public final void put(K key, @NotNull Entry<K, V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"entry");
            Entry<K, V> entry2 = this.map.get(key);
            if (entry2 != null) {
                Entry<K, V> it = entry2;
                boolean bl = false;
                this.removeEntry(it);
            }
            this.map.put(key, entry);
            this.addToHead(entry);
        }

        public final boolean contains(K key) {
            return this.map.containsKey(key);
        }

        @Nullable
        public final Entry<K, V> remove(K key) {
            Entry<K, V> entry;
            Entry<K, V> entry2 = this.map.remove(key);
            if (entry2 != null) {
                Entry<K, V> entry3;
                Entry<K, V> it = entry3 = entry2;
                boolean bl = false;
                this.removeEntry(it);
                entry = entry3;
            } else {
                entry = null;
            }
            return entry;
        }

        @Nullable
        public final Entry<K, V> removeEldest() {
            Entry<K, V> entry;
            Entry<K, V> last = this.tail;
            if (last != null) {
                this.map.remove(last.getKey());
                this.removeEntry(last);
                entry = last;
            } else {
                entry = null;
            }
            return entry;
        }

        public final void moveToHead(@NotNull Entry<K, V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"entry");
            if (Intrinsics.areEqual(this.head, entry)) {
                return;
            }
            Entry<K, V> entry2 = entry.getPrev();
            if (entry2 != null) {
                entry2.setNext(entry.getNext());
            }
            Entry<K, V> entry3 = entry.getNext();
            if (entry3 != null) {
                entry3.setPrev(entry.getPrev());
            }
            if (Intrinsics.areEqual(this.tail, entry)) {
                this.tail = entry.getPrev();
            }
            this.addToHead(entry);
        }

        public final int size() {
            return this.map.size();
        }

        public final void clear() {
            this.map.clear();
            this.head = null;
            this.tail = null;
        }

        @NotNull
        public final List<Entry<K, V>> allEntriesCopy() {
            return CollectionsKt.toList((Iterable)this.map.values());
        }

        private final void addToHead(Entry<K, V> entry) {
            entry.setPrev(null);
            entry.setNext(this.head);
            Entry<K, V> entry2 = this.head;
            if (entry2 != null) {
                entry2.setPrev(entry);
            }
            this.head = entry;
            if (this.tail == null) {
                this.tail = entry;
            }
        }

        private final void removeEntry(Entry<K, V> entry) {
            Entry<K, V> entry2 = entry.getPrev();
            if (entry2 != null) {
                entry2.setNext(entry.getNext());
            }
            Entry<K, V> entry3 = entry.getNext();
            if (entry3 != null) {
                entry3.setPrev(entry.getPrev());
            }
            if (Intrinsics.areEqual(this.head, entry)) {
                this.head = entry.getNext();
            }
            if (Intrinsics.areEqual(this.tail, entry)) {
                this.tail = entry.getPrev();
            }
            entry.setPrev(null);
            entry.setNext(null);
        }
    }
}

