/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypesProvider;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.PROJECT})
@State(name="ProjectType")
public final class ProjectTypeService
implements PersistentStateComponent<ProjectType> {
    private static final Key<CachedValue<Collection<ProjectType>>> PROJECT_TYPES_KEY = Key.create((String)"PROJECT_TYPES");
    private ProjectType myProjectType;

    ProjectTypeService() {
    }

    @Deprecated
    @Nullable
    public static ProjectType getProjectType(@Nullable Project project) {
        ProjectType projectType;
        if (project != null && (projectType = ProjectTypeService.getInstance((Project)project).myProjectType) != null) {
            return projectType;
        }
        Collection<ProjectType> projectTypes = ProjectTypeService.getProjectTypes(project);
        if (!projectTypes.isEmpty()) {
            return projectTypes.iterator().next();
        }
        return null;
    }

    public static @Unmodifiable @NotNull Set<String> getProjectTypeIds(@Nullable Project project) {
        Set set = ContainerUtil.map2Set(ProjectTypeService.getProjectTypes(project), ProjectType::getId);
        if (set == null) {
            ProjectTypeService.$$$reportNull$$$0(0);
        }
        return set;
    }

    public static @Unmodifiable @NotNull Collection<ProjectType> getProjectTypes(@Nullable Project project) {
        if (project == null) {
            List<ProjectType> list = Collections.emptyList();
            if (list == null) {
                ProjectTypeService.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (project.isDefault()) {
            List<ProjectType> list = Collections.emptyList();
            if (list == null) {
                ProjectTypeService.$$$reportNull$$$0(2);
            }
            return list;
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, PROJECT_TYPES_KEY, () -> CachedValueProvider.Result.create(ProjectTypeService.findProjectTypes(project), (Object[])new Object[]{ProjectRootManager.getInstance(project), DumbService.getInstance((Project)project)}), false);
        if (collection == null) {
            ProjectTypeService.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static List<ProjectType> findProjectTypes(Project project) {
        List providers = ProjectTypesProvider.EP_NAME.getExtensionList();
        if (providers.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)ReadAction.nonBlocking(() -> {
            if (DumbService.isDumb((Project)project)) {
                return Collections.emptyList();
            }
            return providers.stream().flatMap(p -> p.inferProjectTypes(project).stream()).toList();
        }).executeSynchronously();
    }

    @Deprecated
    public static void setProjectType(@NotNull Project project, @NotNull ProjectType projectType) {
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(4);
        }
        if (projectType == null) {
            ProjectTypeService.$$$reportNull$$$0(5);
        }
        ProjectTypeService.getInstance(project).loadState(projectType);
    }

    private static ProjectTypeService getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(6);
        }
        return (ProjectTypeService)project.getService(ProjectTypeService.class);
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public ProjectType getState() {
        return this.myProjectType;
    }

    @Override
    @ApiStatus.Internal
    public void loadState(@NotNull ProjectType state) {
        if (state == null) {
            ProjectTypeService.$$$reportNull$$$0(7);
        }
        this.myProjectType = state;
    }

    @TestOnly
    public static void clearFieldsForLightProjectInTests(@NotNull Project project) {
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(8);
        }
        ProjectTypeService.getInstance((Project)project).myProjectType = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/ProjectTypeService";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectTypeIds";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectTypes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/ProjectTypeService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProjectType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearFieldsForLightProjectInTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

