/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserProvider;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

@Service
public final class HeaderParserRepository {
    private final ClearableLazyValue<Map<String, HeaderParser>> myParsers = new ClearableLazyValue<Map<String, HeaderParser>>(this){

        @NotNull
        protected Map<String, HeaderParser> compute() {
            Map map = CollectionFactory.createCaseInsensitiveStringMap();
            for (HeaderParserProvider provider : HeaderParserProvider.EP_NAME.getExtensionList()) {
                map.putAll(provider.getHeaderParsers());
            }
            Map map2 = map;
            if (map2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/HeaderParserRepository$1", "compute"));
        }
    };

    public static HeaderParserRepository getInstance() {
        return (HeaderParserRepository)ApplicationManager.getApplication().getService(HeaderParserRepository.class);
    }

    public HeaderParserRepository() {
        HeaderParserProvider.EP_NAME.addChangeListener(() -> this.myParsers.drop(), null);
    }

    @Nullable
    public HeaderParser getHeaderParser(@Nullable String headerName) {
        return (HeaderParser)((Map)this.myParsers.getValue()).get(headerName);
    }

    @NotNull
    public Set<String> getAllHeaderNames() {
        Set<String> set = ((Map)this.myParsers.getValue()).keySet();
        if (set == null) {
            HeaderParserRepository.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        HeaderParser parser;
        if (header == null) {
            HeaderParserRepository.$$$reportNull$$$0(1);
        }
        return (parser = this.getHeaderParser(header.getName())) != null ? parser.getConvertedValue(header) : null;
    }

    public PsiReference @NotNull [] getReferences(@NotNull HeaderValuePart headerValuePart) {
        HeaderParser parser;
        Header header;
        if (headerValuePart == null) {
            HeaderParserRepository.$$$reportNull$$$0(2);
        }
        if ((header = (Header)PsiTreeUtil.getParentOfType((PsiElement)headerValuePart, Header.class)) != null && (parser = this.getHeaderParser(header.getName())) != null) {
            PsiReference[] psiReferenceArray = parser.getReferences(headerValuePart);
            if (psiReferenceArray == null) {
                HeaderParserRepository.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            HeaderParserRepository.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/lang/manifest/header/HeaderParserRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValuePart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHeaderNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/lang/manifest/header/HeaderParserRepository";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

