/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header.impl;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public class ClassReferenceParser
extends StandardHeaderParser {
    public static final String MAIN_CLASS = "Main-Class";
    public static final String PREMAIN_CLASS = "Premain-Class";
    public static final String AGENT_CLASS = "Agent-Class";
    public static final String LAUNCHER_AGENT_CLASS = "Launcher-Agent-Class";
    public static final HeaderParser INSTANCE = new ClassReferenceParser();

    @Override
    public PsiReference @NotNull [] getReferences(@NotNull HeaderValuePart headerValuePart) {
        Module module;
        if (headerValuePart == null) {
            ClassReferenceParser.$$$reportNull$$$0(0);
        }
        JavaClassReferenceProvider provider = (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)headerValuePart)) != null ? new JavaClassReferenceProvider(this){

            public GlobalSearchScope getScope(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser$1", "getScope"));
            }
        } : new JavaClassReferenceProvider();
        PsiReference[] psiReferenceArray = provider.getReferencesByElement((PsiElement)headerValuePart);
        if (psiReferenceArray == null) {
            ClassReferenceParser.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    @Override
    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        HeaderValue value;
        if (header == null) {
            ClassReferenceParser.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            ClassReferenceParser.$$$reportNull$$$0(3);
        }
        if (!((value = header.getHeaderValue()) instanceof HeaderValuePart)) {
            return false;
        }
        HeaderValuePart valuePart = (HeaderValuePart)value;
        String className = valuePart.getUnwrappedText();
        if (StringUtil.isEmptyOrSpaces((String)className)) {
            holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.reference.invalid", new Object[0])).range(valuePart.getHighlightingRange()).create();
            return true;
        }
        Project project = header.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)header);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(false) : ProjectScope.getAllScope((Project)project);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
        if (aClass == null) {
            String message = JavaErrorBundle.message((String)"error.cannot.resolve.class", (Object[])new Object[]{className});
            holder.newAnnotation(HighlightSeverity.ERROR, message).range(valuePart.getHighlightingRange()).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            return true;
        }
        return this.checkClass(valuePart, aClass, holder);
    }

    protected boolean checkClass(@NotNull HeaderValuePart valuePart, @NotNull PsiClass aClass, @NotNull AnnotationHolder holder) {
        String header;
        if (valuePart == null) {
            ClassReferenceParser.$$$reportNull$$$0(4);
        }
        if (aClass == null) {
            ClassReferenceParser.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            ClassReferenceParser.$$$reportNull$$$0(6);
        }
        if (MAIN_CLASS.equals(header = ((Header)valuePart.getParent()).getName()) && !PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
            holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.main.class.invalid", new Object[0])).range(valuePart.getHighlightingRange()).create();
            return true;
        }
        if (PREMAIN_CLASS.equals(header) && !ClassReferenceParser.hasInstrumenterMethod(aClass, "premain")) {
            holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.pre-main.class.invalid", new Object[0])).range(valuePart.getHighlightingRange()).create();
            return true;
        }
        if ((AGENT_CLASS.equals(header) || LAUNCHER_AGENT_CLASS.equals(header)) && !ClassReferenceParser.hasInstrumenterMethod(aClass, "agentmain")) {
            holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.agent.class.invalid", new Object[0])).range(valuePart.getHighlightingRange()).create();
            return true;
        }
        return false;
    }

    private static boolean hasInstrumenterMethod(PsiClass aClass, String methodName) {
        for (PsiMethod method : aClass.findMethodsByName(methodName, false)) {
            if (!PsiTypes.voidType().equals((Object)method.getReturnType()) || !method.hasModifierProperty("public") || !method.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValuePart";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePart";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

