/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.parser;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;

public class ManifestLexer
extends LexerBase {
    private static final Map<Character, IElementType> SPECIAL_CHARACTERS_TOKEN_MAPPING = new HashMap<Character, IElementType>();
    private CharSequence myBuffer;
    private int myEndOffset;
    private int myTokenStart;
    private int myTokenEnd;
    private boolean myDefaultState;
    private IElementType myTokenType;

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            ManifestLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myEndOffset = endOffset;
        this.myTokenStart = this.myTokenEnd = startOffset;
        this.myDefaultState = initialState == 0;
        this.parseNextToken();
    }

    public void advance() {
        this.myTokenStart = this.myTokenEnd;
        this.parseNextToken();
    }

    public int getState() {
        return this.myDefaultState ? 0 : 1;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            ManifestLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    private void parseNextToken() {
        if (this.myTokenStart >= this.myEndOffset) {
            this.myTokenType = null;
            this.myTokenEnd = this.myTokenStart;
            return;
        }
        boolean atLineStart = this.myTokenStart == 0 || this.myBuffer.charAt(this.myTokenStart - 1) == '\n';
        char c = this.myBuffer.charAt(this.myTokenStart);
        if (atLineStart) {
            this.myDefaultState = true;
            if (c == ' ') {
                this.myTokenType = ManifestTokenType.SIGNIFICANT_SPACE;
                this.myTokenEnd = this.myTokenStart + 1;
            } else if (c == '\n') {
                this.myTokenType = ManifestTokenType.SECTION_END;
                this.myTokenEnd = this.myTokenStart + 1;
            } else {
                int headerEnd;
                for (headerEnd = this.myTokenStart + 1; headerEnd < this.myEndOffset; ++headerEnd) {
                    c = this.myBuffer.charAt(headerEnd);
                    if (c == ':') {
                        this.myDefaultState = false;
                        break;
                    }
                    if (c == '\n') break;
                }
                this.myTokenType = ManifestTokenType.HEADER_NAME;
                this.myTokenEnd = headerEnd;
            }
        } else if (!this.myDefaultState && c == ':') {
            this.myTokenType = ManifestTokenType.COLON;
            this.myTokenEnd = this.myTokenStart + 1;
        } else if (!this.myDefaultState && c == ' ') {
            this.myTokenType = ManifestTokenType.SIGNIFICANT_SPACE;
            this.myTokenEnd = this.myTokenStart + 1;
            this.myDefaultState = true;
        } else {
            this.myDefaultState = true;
            if (c == '\n') {
                this.myTokenType = ManifestTokenType.NEWLINE;
                this.myTokenEnd = this.myTokenStart + 1;
            } else {
                IElementType special = SPECIAL_CHARACTERS_TOKEN_MAPPING.get(Character.valueOf(c));
                if (special != null) {
                    this.myTokenType = special;
                    this.myTokenEnd = this.myTokenStart + 1;
                } else {
                    int valueEnd;
                    for (valueEnd = this.myTokenStart + 1; valueEnd < this.myEndOffset && (c = this.myBuffer.charAt(valueEnd)) != '\n' && !SPECIAL_CHARACTERS_TOKEN_MAPPING.containsKey(Character.valueOf(c)); ++valueEnd) {
                    }
                    this.myTokenType = ManifestTokenType.HEADER_VALUE_PART;
                    this.myTokenEnd = valueEnd;
                }
            }
        }
    }

    static {
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(':'), ManifestTokenType.COLON);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(';'), ManifestTokenType.SEMICOLON);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(','), ManifestTokenType.COMMA);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('='), ManifestTokenType.EQUALS);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('('), ManifestTokenType.OPENING_PARENTHESIS_TOKEN);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(')'), ManifestTokenType.CLOSING_PARENTHESIS_TOKEN);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('['), ManifestTokenType.OPENING_BRACKET_TOKEN);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf(']'), ManifestTokenType.CLOSING_BRACKET_TOKEN);
        SPECIAL_CHARACTERS_TOKEN_MAPPING.put(Character.valueOf('\"'), ManifestTokenType.QUOTE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/lang/manifest/parser/ManifestLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/lang/manifest/parser/ManifestLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

