/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlin.reflect.jvm.KTypesJvm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.AddDataRow;
import org.jetbrains.kotlinx.dataframe.api.AllKt;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnReferenceApiKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.ConcatKt;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.api.ConvertKt;
import org.jetbrains.kotlinx.dataframe.api.ConvertSchemaDsl;
import org.jetbrains.kotlinx.dataframe.api.ConverterScope;
import org.jetbrains.kotlinx.dataframe.api.DataColumnTypeKt;
import org.jetbrains.kotlinx.dataframe.api.ExcessiveColumns;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.IsEmptyKt;
import org.jetbrains.kotlinx.dataframe.api.MapKt;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.codeGen.Marker;
import org.jetbrains.kotlinx.dataframe.codeGen.MarkersExtractor;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.exceptions.ExcessiveColumnsException;
import org.jetbrains.kotlinx.dataframe.exceptions.TypeConversionException;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.api.ConvertSchemaDslImpl;
import org.jetbrains.kotlinx.dataframe.impl.api.Converter;
import org.jetbrains.kotlinx.dataframe.impl.api.Filler;
import org.jetbrains.kotlinx.dataframe.impl.api.InsertKt;
import org.jetbrains.kotlinx.dataframe.impl.api.UpdateKt;
import org.jetbrains.kotlinx.dataframe.impl.schema.DataFrameSchemaImplKt;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001aU\u0010\u0002\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\n\u0012\u0002\b\u00030\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u001f\b\u0002\u0010\u000b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\b\u0010H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "convertToImpl", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "type", "Lkotlin/reflect/KType;", "allowConversion", "", "excessiveColumns", "Lorg/jetbrains/kotlinx/dataframe/api/ExcessiveColumns;", "body", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/dataframe/api/ConvertSchemaDsl;", "", "", "Lkotlin/ExtensionFunctionType;", "core"})
@SourceDebugExtension(value={"SMAP\nconvertTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 convertTo.kt\norg/jetbrains/kotlinx/dataframe/impl/api/ConvertToKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 update.kt\norg/jetbrains/kotlinx/dataframe/api/UpdateKt\n+ 4 add.kt\norg/jetbrains/kotlinx/dataframe/api/AddKt\n+ 5 map.kt\norg/jetbrains/kotlinx/dataframe/api/MapKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,343:1\n1869#2:344\n3301#2,10:345\n1803#2,2:358\n1805#2:364\n1870#2:365\n1563#2:366\n1634#2,3:367\n1617#2,9:370\n1869#2:379\n1563#2:383\n1634#2,3:384\n1563#2:387\n1634#2,3:388\n1563#2:391\n1634#2,3:392\n1870#2:396\n1626#2:397\n1740#2,3:400\n304#3,3:355\n276#4:360\n277#4,2:362\n86#5:361\n48#5,2:380\n1#6:382\n1#6:395\n216#7,2:398\n*S KotlinDebug\n*F\n+ 1 convertTo.kt\norg/jetbrains/kotlinx/dataframe/impl/api/ConvertToKt\n*L\n312#1:344\n317#1:345,10\n323#1:358,2\n323#1:364\n312#1:365\n336#1:366\n336#1:367,3\n116#1:370,9\n116#1:379\n251#1:383\n251#1:384,3\n261#1:387\n261#1:388,3\n265#1:391\n265#1:392,3\n116#1:396\n116#1:397\n246#1:400,3\n320#1:355,3\n324#1:360\n324#1:362,2\n324#1:361\n171#1:380,2\n116#1:395\n282#1:398,2\n*E\n"})
public final class ConvertToKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ConvertToKt::logger$lambda$0);

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @NotNull
    public static final DataFrame<?> convertToImpl(@NotNull DataFrame<?> $this$convertToImpl, @NotNull KType type, boolean allowConversion, @NotNull ExcessiveColumns excessiveColumns, @NotNull Function1<? super ConvertSchemaDsl<Object>, Unit> body) {
        List<String> newPaths;
        Intrinsics.checkNotNullParameter($this$convertToImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)excessiveColumns), (String)"excessiveColumns");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ConvertSchemaDslImpl<Object> dsl = new ConvertSchemaDslImpl<Object>();
        body.invoke(dsl);
        Set missingPaths = new LinkedHashSet();
        KClass clazz = KTypesJvm.getJvmErasure((KType)type);
        Marker marker = MarkersExtractor.get$default(MarkersExtractor.INSTANCE, clazz, false, 2, null);
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = ConvertToKt.convertToImpl$convertToSchema($this$convertToImpl, excessiveColumns, allowConversion, dsl, missingPaths, marker.getSchema(), UtilsKt.emptyPath());
        Iterable $this$forEach$iv = dsl.getFillers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$fold$iv;
            void initial$iv;
            Filler filler = (Filler)element$iv;
            boolean bl = false;
            Set paths = CollectionsKt.toSet((Iterable)UtilsKt.getColumnPaths((DataFrame)result.element, UnresolvedColumnsPolicy.Create, filler.getColumns()));
            Iterable $this$partition$iv = paths;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                ColumnPath it = (ColumnPath)element$iv2;
                boolean bl2 = false;
                boolean bl3 = missingPaths.contains(it) ? first$iv.add(element$iv2) : second$iv.add(element$iv2);
            }
            Pair pair = new Pair(first$iv, second$iv);
            newPaths = (List)pair.component1();
            List existingPaths = (List)pair.component2();
            Object $this$with$iv = org.jetbrains.kotlinx.dataframe.api.UpdateKt.update((DataFrame)result.element, (arg_0, arg_1) -> ConvertToKt.convertToImpl$lambda$3$1(existingPaths, arg_0, arg_1));
            boolean $i$f$with22 = false;
            result.element = UpdateKt.updateImpl($this$with$iv, (Function3)new Function3<AddDataRow<? extends Object>, DataColumn<? extends Object>, Object, Object>(filler){
                final /* synthetic */ Filler $filler$inlined;
                {
                    this.$filler$inlined = filler;
                }

                public final Object invoke(AddDataRow<? extends Object> row, DataColumn<? extends Object> dataColumn, Object value) {
                    Intrinsics.checkNotNullParameter(row, (String)"row");
                    Intrinsics.checkNotNullParameter(dataColumn, (String)"<unused var>");
                    Object object = value;
                    AddDataRow<? extends Object> $this$convertToImpl_u24lambda_u243_u242 = row;
                    boolean bl = false;
                    return this.$filler$inlined.getExpr().invoke($this$convertToImpl_u24lambda_u243_u242, $this$convertToImpl_u24lambda_u243_u242);
                }
            });
            $this$with$iv = newPaths;
            Object $i$f$with22 = result.element;
            Ref.ObjectRef objectRef = result;
            boolean $i$f$fold = false;
            DataFrame accumulator$iv = initial$iv;
            for (Object element$iv3 : $this$fold$iv) {
                void infer$iv$iv;
                void name$iv$iv;
                void $this$mapToColumn$iv$iv;
                void infer$iv;
                void path$iv;
                void $this$add$iv;
                void newPath;
                ColumnPath columnPath = (ColumnPath)element$iv3;
                DataFrame df = accumulator$iv;
                boolean bl4 = false;
                DataFrame dataFrame = df;
                void var31_38 = newPath;
                Infer infer = Infer.Type;
                Function2 expression$iv = (arg_0, arg_1) -> ConvertToKt.convertToImpl$lambda$3$3$0(filler, arg_0, arg_1);
                boolean $i$f$add = false;
                void var35_42 = $this$add$iv;
                String string = path$iv.name();
                void var37_44 = infer$iv;
                Function2 body$iv$iv = expression$iv;
                boolean $i$f$mapToColumn = false;
                DataColumn col$iv = MapKt.mapToColumn((ColumnsContainer)$this$mapToColumn$iv$iv, (String)name$iv$iv, Reflection.nullableTypeOf(Object.class), (Infer)infer$iv$iv, body$iv$iv);
                accumulator$iv = path$iv.size() == 1 ? $this$add$iv.plus(col$iv) : InsertKt.insertImpl($this$add$iv, (ColumnPath)path$iv, col$iv);
            }
            objectRef.element = accumulator$iv;
            CollectionsKt.removeAll((Collection)missingPaths, (Iterable)paths);
        }
        if (!((Collection)missingPaths).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$forEach$iv = missingPaths;
            StringBuilder stringBuilder = new StringBuilder().append("The following columns were not found in DataFrame: ");
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                newPaths = (ColumnPath)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ColumnPath.joinToString$default((ColumnPath)it, null, 1, null));
            }
            String string = stringBuilder.append((List)destination$iv$iv).append(", and their type was not nullable. Use `fill` to initialize these columns").toString();
            throw new IllegalArgumentException(string);
        }
        return (DataFrame)result.element;
    }

    public static /* synthetic */ DataFrame convertToImpl$default(DataFrame dataFrame, KType kType, boolean bl, ExcessiveColumns excessiveColumns, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = ConvertToKt::convertToImpl$lambda$0;
        }
        return ConvertToKt.convertToImpl(dataFrame, kType, bl, excessiveColumns, (Function1<? super ConvertSchemaDsl<Object>, Unit>)function1);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit convertToImpl$lambda$0(ConvertSchemaDsl convertSchemaDsl) {
        Intrinsics.checkNotNullParameter((Object)convertSchemaDsl, (String)"<this>");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final DataFrame<?> convertToImpl$convertToSchema(DataFrame<?> $this$convertToImpl_u24convertToSchema, ExcessiveColumns $excessiveColumns, boolean $allowConversion, ConvertSchemaDslImpl<Object> dsl, Set<ColumnPath> missingPaths, DataFrameSchema schema, ColumnPath path) {
        void $this$mapNotNullTo$iv$iv;
        if (IsEmptyKt.isEmpty($this$convertToImpl_u24convertToSchema)) {
            return org.jetbrains.kotlinx.dataframe.impl.schema.UtilsKt.createEmptyDataFrame(schema);
        }
        Set visited = new LinkedHashSet();
        Iterable $this$mapNotNull$iv = $this$convertToImpl_u24convertToSchema.columns();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            BaseColumn baseColumn;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DataColumn originalColumn = (DataColumn)element$iv$iv;
            boolean bl2 = false;
            ColumnSchema targetSchema = schema.getColumns().get(originalColumn.name());
            if (targetSchema == null) {
                DataColumn dataColumn;
                switch (WhenMappings.$EnumSwitchMapping$0[$excessiveColumns.ordinal()]) {
                    case 1: {
                        throw new ExcessiveColumnsException(CollectionsKt.listOf((Object)ColumnReferenceApiKt.getName(originalColumn)));
                    }
                    case 2: {
                        dataColumn = originalColumn;
                        break;
                    }
                    case 3: {
                        dataColumn = null;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                baseColumn = dataColumn;
            } else {
                visited.add(originalColumn.name());
                ColumnSchema currentSchema = org.jetbrains.kotlinx.dataframe.impl.schema.UtilsKt.extractSchema(originalColumn);
                if (Intrinsics.areEqual((Object)targetSchema, (Object)currentSchema)) {
                    baseColumn = originalColumn;
                } else {
                    DataColumn dataColumn;
                    Iterator values$iv;
                    Iterable iterable2;
                    Iterable it;
                    Object object;
                    Converter converter;
                    Object $this$convertToImpl_u24convertToSchema_u24lambda_u241_u240;
                    if (!$allowConversion) {
                        String originalSchema = DataFrameSchemaImplKt.render(MapsKt.mapOf((Pair)TuplesKt.to((Object)ColumnReferenceApiKt.getName(originalColumn), (Object)currentSchema)), 0, new StringBuilder(), "\t");
                        String targetSchema2 = DataFrameSchemaImplKt.render(MapsKt.mapOf((Pair)TuplesKt.to((Object)ColumnReferenceApiKt.getName(originalColumn), (Object)targetSchema)), 0, new StringBuilder(), "\t");
                        throw new IllegalArgumentException("Column has schema:\n " + originalSchema + "\n that differs from target schema:\n " + targetSchema2);
                    }
                    ColumnPath columnPath = path.plus(ColumnReferenceApiKt.getName(originalColumn));
                    KType from = originalColumn.type();
                    KType to = targetSchema.getType();
                    Object object2 = dsl.getConverter(from, targetSchema);
                    if (object2 == null) {
                        Converter stringConverter;
                        $this$convertToImpl_u24convertToSchema_u24lambda_u241_u240 = $this$convertToImpl_u24convertToSchema;
                        boolean bl3 = false;
                        object2 = !KTypes.isSubtypeOf((KType)from, (KType)Reflection.nullableTypeOf(Character.class)) ? null : (dsl.getConverter(KTypes.withNullability((KType)Reflection.typeOf(String.class), (boolean)from.isMarkedNullable()), targetSchema) == null ? null : new Converter((Function2<? super ConverterScope, Object, ? extends Object>)((Function2)(arg_0, arg_1) -> ConvertToKt.convertToImpl$convertToSchema$lambda$1$0$0(stringConverter, arg_0, arg_1)), stringConverter.getSkipNulls()));
                    }
                    if ((converter = object2) != null) {
                        void type$iv;
                        void $this$map$iv;
                        boolean nullsAllowed = to.isMarkedNullable();
                        $this$convertToImpl_u24convertToSchema_u24lambda_u241_u240 = originalColumn;
                        KType bl3 = to;
                        Infer infer$iv = Infer.Nulls;
                        boolean $i$f$map = false;
                        int n = $this$map$iv.size();
                        Object[] objectArray = new Object[n];
                        for (int i = 0; i < n; ++i) {
                            Iterable result;
                            int n2 = i;
                            Object t = $this$map$iv.get(n2);
                            int n3 = n2;
                            object = objectArray;
                            boolean bl4 = false;
                            Iterable iterable3 = result = it != null || !converter.getSkipNulls() ? converter.getTransform().invoke((Object)new ConverterScope(from, targetSchema), it) : it;
                            if (!nullsAllowed && result == null) {
                                throw new TypeConversionException(it, from, to, originalColumn.path());
                            }
                            object[n3] = iterable2 = result;
                        }
                        values$iv = ArraysKt.asList((Object[])objectArray);
                        dataColumn = CastKt.cast(DataColumn.Companion.createByType($this$map$iv.name(), values$iv, (KType)type$iv, infer$iv));
                    } else {
                        dataColumn = null;
                    }
                    DataColumn convertedColumn = dataColumn;
                    switch (WhenMappings.$EnumSwitchMapping$1[targetSchema.getKind().ordinal()]) {
                        case 2: {
                            DataColumn dataColumn2 = convertedColumn;
                            if (dataColumn2 == null) {
                                dataColumn2 = ConvertKt.convertTo(originalColumn, to);
                            }
                            baseColumn = dataColumn2;
                            break;
                        }
                        case 3: {
                            DataColumn column2;
                            DataColumn dataColumn3 = convertedColumn;
                            if (dataColumn3 == null) {
                                if (DataColumnKt.getKind(originalColumn) == ColumnKind.Value && AllKt.all(originalColumn, ConvertToKt::convertToImpl$convertToSchema$lambda$1$2)) {
                                    void it2;
                                    Iterable iterable4 = originalColumn.values();
                                    String string = ColumnReferenceApiKt.getName(originalColumn);
                                    object = DataColumn.Companion;
                                    boolean bl5 = false;
                                    Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<org.jetbrains.kotlinx.dataframe.DataRow<*>>");
                                    iterable2 = it2;
                                    ColumnGroup columnGroup = ((DataColumn.Companion)object).createColumnGroup(string, ToDataFrameKt.toDataFrameT(iterable2));
                                    Intrinsics.checkNotNull(columnGroup, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataColumn<*>");
                                    dataColumn3 = (DataColumn)((Object)columnGroup);
                                } else if (DataColumnKt.getKind(originalColumn) == ColumnKind.Value && AllKt.allNulls(originalColumn)) {
                                    ColumnGroup<?> columnGroup = DataColumn.Companion.createColumnGroup(ColumnReferenceApiKt.getName(originalColumn), DataFrame.Companion.empty(DataColumnKt.getSize(originalColumn)));
                                    Intrinsics.checkNotNull(columnGroup, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataColumn<*>");
                                    dataColumn3 = (DataColumn)((Object)columnGroup);
                                } else {
                                    dataColumn3 = originalColumn;
                                }
                            }
                            if (!DataColumnTypeKt.isColumnGroup(column2 = dataColumn3)) {
                                boolean $i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$22 = false;
                                String $i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$22 = "Column `" + ColumnReferenceApiKt.getName(column2) + "` is " + (Object)((Object)DataColumnKt.getKind(column2)) + " and can not be converted to `ColumnGroup`";
                                throw new IllegalArgumentException($i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$22.toString());
                            }
                            baseColumn = DataColumn.Companion.createColumnGroup(((ColumnGroup)((Object)column2)).name(), ConvertToKt.convertToImpl$convertToSchema((DataFrame)((Object)column2), $excessiveColumns, $allowConversion, dsl, missingPaths, ((ColumnSchema.Group)targetSchema).getSchema(), columnPath));
                            break;
                        }
                        case 1: {
                            void $this$mapTo$iv$iv;
                            Iterable frames;
                            Object item$iv$iv2;
                            Iterable iterable5;
                            DataColumn dataColumn4 = convertedColumn;
                            if (dataColumn4 == null) {
                                dataColumn4 = originalColumn;
                            }
                            DataColumn column3 = dataColumn4;
                            DataFrameSchema frameSchema = ((ColumnSchema.Frame)targetSchema).getSchema();
                            switch (WhenMappings.$EnumSwitchMapping$1[DataColumnKt.getKind(column3).ordinal()]) {
                                case 1: {
                                    Intrinsics.checkNotNull(column3, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.columns.FrameColumn<*>");
                                    iterable5 = ((FrameColumn)column3).values();
                                    break;
                                }
                                case 2: {
                                    Iterable $this$mapTo$iv$iv2;
                                    if (!AllKt.all(column3, ConvertToKt::convertToImpl$convertToSchema$lambda$1$5)) {
                                        boolean $i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$frames$32 = false;
                                        String $i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$frames$32 = "Column `" + ColumnReferenceApiKt.getName(column3) + "` is ValueColumn and contains objects that can not be converted into `DataFrame`";
                                        throw new IllegalArgumentException($i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$frames$32.toString());
                                    }
                                    Iterable $this$map$iv = column3.values();
                                    boolean $i$f$map = false;
                                    it = $this$map$iv;
                                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    values$iv = $this$mapTo$iv$iv2.iterator();
                                    while (values$iv.hasNext()) {
                                        DataFrame dataFrame;
                                        void it3;
                                        Object t = item$iv$iv2 = values$iv.next();
                                        object = destination$iv$iv2;
                                        boolean bl6 = false;
                                        void var48_72 = it3;
                                        if (var48_72 == null) {
                                            dataFrame = ConstructorsKt.emptyDataFrame();
                                        } else if (var48_72 instanceof DataFrame) {
                                            dataFrame = (DataFrame)it3;
                                        } else {
                                            void v12 = it3;
                                            Intrinsics.checkNotNull((Object)v12, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlinx.dataframe.DataRow<*>?>");
                                            dataFrame = ConcatKt.concatRows((List)v12);
                                        }
                                        object.add(dataFrame);
                                    }
                                    iterable5 = (List)destination$iv$iv2;
                                    break;
                                }
                                case 3: {
                                    Intrinsics.checkNotNull(column3, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.columns.ColumnGroup<*>");
                                    Iterable $this$map$iv = ((ColumnGroup)((Object)column3)).values();
                                    boolean $i$f$map = false;
                                    Iterable $this$mapTo$iv$iv2 = $this$map$iv;
                                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                                        DataRow it3 = (DataRow)item$iv$iv2;
                                        object = destination$iv$iv3;
                                        boolean bl7 = false;
                                        object.add(TypeConversionsKt.toDataFrame(it3));
                                    }
                                    iterable5 = (List)destination$iv$iv3;
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            Iterable $this$map$iv = frames = iterable5;
                            boolean $i$f$map = false;
                            Iterable $i$f$map2 = $this$map$iv;
                            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                                void it4;
                                item$iv$iv2 = (DataFrame)item$iv$iv3;
                                object = destination$iv$iv4;
                                boolean bl8 = false;
                                object.add(ConvertToKt.convertToImpl$convertToSchema(it4, $excessiveColumns, $allowConversion, dsl, missingPaths, frameSchema, columnPath));
                            }
                            List convertedFrames = (List)destination$iv$iv4;
                            baseColumn = DataColumn.Companion.createFrameColumn(column3.name(), convertedFrames, (Lazy<? extends DataFrameSchema>)LazyKt.lazy(() -> ConvertToKt.convertToImpl$convertToSchema$lambda$1$10(frameSchema)));
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
            }
            if (baseColumn == null) continue;
            BaseColumn it$iv$iv = baseColumn;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List newColumns = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        int size = DataFrameKt.getSize($this$convertToImpl_u24convertToSchema).getNrow();
        Map<String, ColumnSchema> $this$forEach$iv = schema.getColumns();
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<String, ColumnSchema>> iterator3 = $this$forEach$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<String, ColumnSchema> element$iv;
            Map.Entry<String, ColumnSchema> entry = element$iv = iterator3.next();
            boolean bl = false;
            String name = entry.getKey();
            ColumnSchema targetColumn = entry.getValue();
            if (visited.contains(name)) continue;
            try {
                ((Collection)newColumns).add(org.jetbrains.kotlinx.dataframe.impl.schema.UtilsKt.createNullFilledColumn(targetColumn, name, size));
            }
            catch (IllegalStateException e) {
                logger.debug((Throwable)e, ConvertToKt::convertToImpl$convertToSchema$lambda$2$0);
                missingPaths.add(path.plus(name));
            }
        }
        return ToDataFrameKt.toDataFrameAnyColumn(newColumns);
    }

    private static final Object convertToImpl$convertToSchema$lambda$1$0$0(Converter $stringConverter, ConverterScope $this$Converter, Object it) {
        Intrinsics.checkNotNullParameter((Object)$this$Converter, (String)"$this$Converter");
        Character c = (Character)it;
        return $stringConverter.getTransform().invoke((Object)$this$Converter, (Object)(c != null ? String.valueOf(c.charValue()) : null));
    }

    private static final boolean convertToImpl$convertToSchema$lambda$1$2(Object it) {
        return it instanceof DataRow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean convertToImpl$convertToSchema$lambda$1$5(Object it) {
        Object t;
        if (it == null) return true;
        if (it instanceof DataFrame) return true;
        if (!(it instanceof List)) return false;
        Iterable $this$all$iv = (Iterable)it;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            Object it2 = element$iv = iterator2.next();
            boolean bl = false;
            t = it2;
        } while (t == null ? true : t instanceof DataRow);
        return false;
    }

    private static final DataFrameSchema convertToImpl$convertToSchema$lambda$1$10(DataFrameSchema $frameSchema) {
        return $frameSchema;
    }

    private static final Object convertToImpl$convertToSchema$lambda$2$0() {
        return "";
    }

    private static final ColumnsResolver convertToImpl$lambda$3$1(List $existingPaths, ColumnsSelectionDsl $this$update, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return org.jetbrains.kotlinx.dataframe.columns.ConstructorsKt.toColumnSetColumnPath($existingPaths);
    }

    private static final Object convertToImpl$lambda$3$3$0(Filler $filler, AddDataRow $this$add, AddDataRow it) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $filler.getExpr().invoke((Object)$this$add, (Object)$this$add);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExcessiveColumns.values().length];
            try {
                nArray[ExcessiveColumns.Fail.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExcessiveColumns.Keep.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExcessiveColumns.Remove.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ColumnKind.values().length];
            try {
                nArray[ColumnKind.Frame.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnKind.Value.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnKind.Group.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

