/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.columns;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/columns/RenamedSingleColumn;", "C", "Lorg/jetbrains/kotlinx/dataframe/columns/SingleColumn;", "source", "name", "", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/columns/SingleColumn;Ljava/lang/String;)V", "getSource", "()Lorg/jetbrains/kotlinx/dataframe/columns/SingleColumn;", "getName", "()Ljava/lang/String;", "resolveSingle", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "core"})
public final class RenamedSingleColumn<C>
implements SingleColumn<C> {
    @NotNull
    private final SingleColumn<C> source;
    @NotNull
    private final String name;

    public RenamedSingleColumn(@NotNull SingleColumn<? extends C> source, @NotNull String name) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.source = source;
        this.name = name;
    }

    @NotNull
    public final SingleColumn<C> getSource() {
        return this.source;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public ColumnWithPath<C> resolveSingle(@NotNull ColumnResolutionContext context) {
        ColumnWithPath columnWithPath;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ColumnWithPath<C> columnWithPath2 = this.source.resolveSingle(context);
        if (columnWithPath2 != null) {
            ColumnWithPath<C> it = columnWithPath2;
            boolean bl = false;
            columnWithPath = UtilsKt.addPath((BaseColumn)it.getData().rename(this.name), it.getPath());
        } else {
            columnWithPath = null;
        }
        return columnWithPath;
    }
}

