/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.InlineClassDeclarationLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InlineClassDeclarationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "processDelegatedInlineClassMember", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "transformFlat", "", "transformConstructor", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "transformMethodFlat", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "transformPrimaryConstructor", "transformConstructorBody", "staticMethod", "transformMethodBodyFlat", "delegateToStaticMethod", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nInlineClassDeclarationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineClassDeclarationLowering.kt\norg/jetbrains/kotlin/backend/common/lower/InlineClassDeclarationLowering\n+ 2 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 5 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 9 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n*L\n1#1,369:1\n98#2:370\n98#2:399\n247#3,5:371\n247#3,5:400\n76#4:376\n77#4:397\n76#4:405\n77#4:414\n76#4:425\n77#4:430\n17#5,16:377\n33#5:394\n19#6:393\n1915#7,2:395\n1220#7,2:406\n1249#7,4:408\n1915#7,2:412\n1586#7:426\n1661#7,3:427\n1#8:398\n448#9,10:415\n*S KotlinDebug\n*F\n+ 1 InlineClassDeclarationLowering.kt\norg/jetbrains/kotlin/backend/common/lower/InlineClassDeclarationLowering\n*L\n87#1:370\n168#1:399\n87#1:371,5\n168#1:400,5\n87#1:376\n87#1:397\n168#1:405\n168#1:414\n284#1:425\n284#1:430\n94#1:377,16\n94#1:394\n94#1:393\n94#1:395,2\n173#1:406,2\n173#1:408,4\n177#1:412,2\n287#1:426\n287#1:427,3\n284#1:415,10\n*E\n"})
public class InlineClassDeclarationLowering
implements DeclarationTransformer {
    @NotNull
    private final CommonBackendContext context;

    public InlineClassDeclarationLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    protected void processDelegatedInlineClassMember(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass == null) {
            return null;
        }
        IrClass irClass2 = irClass;
        if (!this.context.getInlineClassesUtils().isClassInlineLike(irClass2)) {
            return null;
        }
        IrDeclaration irDeclaration = declaration;
        return irDeclaration instanceof IrConstructor ? this.transformConstructor((IrConstructor)declaration) : (irDeclaration instanceof IrSimpleFunction ? this.transformMethodFlat((IrSimpleFunction)declaration) : null);
    }

    private final List<IrDeclaration> transformConstructor(IrConstructor irConstructor) {
        if (irConstructor.isPrimary()) {
            return this.transformPrimaryConstructor(irConstructor);
        }
        IrSimpleFunction result = InlineClassDeclarationLoweringKt.access$getOrCreateStaticMethod(this.context, irConstructor);
        this.transformConstructorBody(irConstructor, result);
        return CollectionsKt.listOf((Object)result);
    }

    private final List<IrDeclaration> transformMethodFlat(IrSimpleFunction function) {
        if (IrDeclarationsKt.isStaticMethodOfClass(function) || !AdditionalIrUtilsKt.isReal(function)) {
            return null;
        }
        IrSimpleFunction staticMethod = InlineClassDeclarationLoweringKt.access$getOrCreateStaticMethod(this.context, function);
        this.transformMethodBodyFlat(function, staticMethod);
        this.processDelegatedInlineClassMember(function);
        function.setBody(this.delegateToStaticMethod(function, staticMethod));
        if (function.getOverriddenSymbols().isEmpty()) {
            return CollectionsKt.listOf((Object)staticMethod);
        }
        Object[] objectArray = new IrSimpleFunction[]{function, staticMethod};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> transformPrimaryConstructor(IrConstructor irConstructor) {
        IrBlockBody irBlockBody;
        IrSimpleFunction irSimpleFunction;
        IrClass klass = IrUtilsKt.getParentAsClass(irConstructor);
        IrSimpleType inlineClassType = IrUtilsKt.getDefaultType(klass);
        IrSimpleFunction it = irSimpleFunction = InlineClassDeclarationLoweringKt.access$getOrCreateStaticMethod(this.context, irConstructor);
        boolean bl = false;
        it.setReturnType(inlineClassType);
        IrSimpleFunction initFunction = irSimpleFunction;
        Ref.ObjectRef delegatingCtorCall = new Ref.ObjectRef();
        Ref.ObjectRef setMemberField = new Ref.ObjectRef();
        IrSimpleFunction irSimpleFunction2 = initFunction;
        IrBody irBody = irConstructor.getBody();
        if (irBody != null) {
            void body;
            IrBody irBody2 = irBody;
            IrSimpleFunction irSimpleFunction3 = irSimpleFunction2;
            boolean bl2 = false;
            irBlockBody = IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> InlineClassDeclarationLowering.transformPrimaryConstructor$lambda$1$0(irConstructor, this, initFunction, (IrBody)body, delegatingCtorCall, klass, setMemberField, arg_0)));
            irSimpleFunction2 = irSimpleFunction3;
        } else {
            irBlockBody = null;
        }
        irSimpleFunction2.setBody(irBlockBody);
        if (irConstructor.getBody() != null) {
            irConstructor.setBody(IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> InlineClassDeclarationLowering.transformPrimaryConstructor$lambda$2(delegatingCtorCall, setMemberField, arg_0))));
        }
        Object[] objectArray = new IrFunction[]{irConstructor, initFunction};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final void transformConstructorBody(IrConstructor irConstructor, IrSimpleFunction staticMethod) {
        IrBlockBody irBlockBody;
        if (irConstructor.isPrimary()) {
            return;
        }
        IrClass irClass = IrUtilsKt.getParentAsClass(irConstructor);
        IrSimpleFunction irSimpleFunction = staticMethod;
        IrBody irBody = irConstructor.getBody();
        if (irBody != null) {
            void constructorBody;
            IrBody irBody2 = irBody;
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
            boolean bl = false;
            irBlockBody = IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> InlineClassDeclarationLowering.transformConstructorBody$lambda$0$0(this, staticMethod, (IrBody)constructorBody, irConstructor, irClass, arg_0)));
            irSimpleFunction = irSimpleFunction2;
        } else {
            irBlockBody = null;
        }
        irSimpleFunction.setBody(irBlockBody);
    }

    /*
     * WARNING - void declaration
     */
    private final void transformMethodBodyFlat(IrSimpleFunction function, IrSimpleFunction staticMethod) {
        IrBlockBody irBlockBody;
        if (IrDeclarationsKt.isStaticMethodOfClass(function) || !AdditionalIrUtilsKt.isReal(function)) {
            return;
        }
        IrSimpleFunction irSimpleFunction = staticMethod;
        IrBody irBody = function.getBody();
        if (irBody != null) {
            void functionBody;
            IrBody irBody2 = irBody;
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
            boolean bl = false;
            irBlockBody = IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> InlineClassDeclarationLowering.transformMethodBodyFlat$lambda$0$0((IrBody)functionBody, function, staticMethod, this, arg_0)));
            irSimpleFunction = irSimpleFunction2;
        } else {
            irBlockBody = null;
        }
        irSimpleFunction.setBody(irBlockBody);
    }

    private final IrBlockBody delegateToStaticMethod(IrSimpleFunction function, IrSimpleFunction staticMethod) {
        return IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> InlineClassDeclarationLowering.delegateToStaticMethod$lambda$0(this, function, staticMethod, arg_0)));
    }

    private static final IrTypeOperatorCallImpl transformPrimaryConstructor$lambda$1$0$0$unboxedInlineClassValue(IrBlockBodyBuilder builder2, IrSimpleFunction initFunction, IrClass klass) {
        return ExpressionHelpersKt.irReinterpretCast(builder2, ExpressionHelpersKt.irGet(builder2, (IrValueDeclaration)CollectionsKt.single(initFunction.getParameters())), IrUtilsKt.getDefaultType(klass));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit transformPrimaryConstructor$lambda$1$0(IrConstructor $irConstructor, InlineClassDeclarationLowering this$0, IrSimpleFunction $initFunction, IrBody $body, Ref.ObjectRef $delegatingCtorCall, IrClass $klass, Ref.ObjectRef $setMemberField, IrBlockBody $this$createBlockBody) {
        void $this$deepCopyWithSymbols_u24default$iv;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        IrValueParameterSymbol origParameterSymbol = ((IrValueParameter)CollectionsKt.single($irConstructor.getParameters())).getSymbol();
        Collection collection = $this$createBlockBody.getStatements();
        Object object = LowerUtilsKt.createIrBuilder$default(this$0.context, (IrSymbol)$initFunction.getSymbol(), 0, 0, 6, null);
        IrElement irElement$iv = $initFunction;
        boolean $i$f$irBlockBody = false;
        void var13_13 = $this$irBlockBody$iv;
        int n = irElement$iv.getStartOffset();
        int endOffset$iv$iv = irElement$iv.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void $this$transformPrimaryConstructor_u24lambda_u241_u240_u240 = this_$iv$iv$iv;
        boolean bl = false;
        void builder2 = $this$transformPrimaryConstructor_u24lambda_u241_u240_u240;
        Intrinsics.checkNotNull((Object)$body, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        IrElement irElement = (IrBlockBody)$body;
        IrDeclarationParent initialParent$iv = $initFunction;
        boolean $i$f$deepCopyWithSymbols = false;
        void $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
        boolean $i$f$deepCopyImpl = false;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
        boolean bl2 = false;
        ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
        TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
        IrElement irElement2 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
        if (irElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        }
        Iterable $this$forEach$iv = ((IrBlockBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrBlockBody)irElement2), initialParent$iv)).getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement statement = (IrStatement)element$iv;
            boolean bl3 = false;
            $this$transformPrimaryConstructor_u24lambda_u241_u240_u240.unaryPlus(IrElementsKt.transformStatement(statement, new IrElementTransformerVoid((Ref.ObjectRef<IrDelegatingConstructorCall>)$delegatingCtorCall, $irConstructor, (IrBlockBodyBuilder)builder2, $klass, (Ref.ObjectRef<IrSetField>)$setMemberField, $initFunction, origParameterSymbol){
                final /* synthetic */ Ref.ObjectRef<IrDelegatingConstructorCall> $delegatingCtorCall;
                final /* synthetic */ IrConstructor $irConstructor;
                final /* synthetic */ IrBlockBodyBuilder $builder;
                final /* synthetic */ IrClass $klass;
                final /* synthetic */ Ref.ObjectRef<IrSetField> $setMemberField;
                final /* synthetic */ IrSimpleFunction $initFunction;
                final /* synthetic */ IrValueParameterSymbol $origParameterSymbol;
                {
                    this.$delegatingCtorCall = $delegatingCtorCall;
                    this.$irConstructor = $irConstructor;
                    this.$builder = $builder;
                    this.$klass = $klass;
                    this.$setMemberField = $setMemberField;
                    this.$initFunction = $initFunction;
                    this.$origParameterSymbol = $origParameterSymbol;
                }

                /*
                 * WARNING - void declaration
                 */
                public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression) {
                    void this_$iv$iv;
                    void $this$deepCopyWithSymbols_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    IrElement irElement = expression;
                    IrDeclarationParent initialParent$iv = this.$irConstructor;
                    boolean $i$f$deepCopyWithSymbols = false;
                    void $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                    boolean $i$f$deepCopyImpl = false;
                    Object symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                    IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, (IrVisitorVoid)symbolRemapper$iv$iv);
                    DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                    Ref.ObjectRef<IrDelegatingConstructorCall> objectRef = this.$delegatingCtorCall;
                    boolean bl = false;
                    ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                    TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                    IrElement irElement2 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
                    if (irElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall");
                    }
                    objectRef.element = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrDelegatingConstructorCall)irElement2), initialParent$iv);
                    IrBuilderWithScope $this$irBlock_u24default$iv = this.$builder;
                    int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                    int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                    IrStatementOrigin origin$iv = null;
                    IrType resultType$iv = null;
                    boolean $i$f$irBlock = false;
                    symbolRemapper$iv$iv = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                    boolean $i$f$block = false;
                    void $this$visitDelegatingConstructorCall_u24lambda_u240 = this_$iv$iv;
                    boolean bl2 = false;
                    return (IrExpression)this_$iv$iv.doBuild();
                }

                /*
                 * WARNING - void declaration
                 */
                public IrExpression visitSetField(IrSetField expression) {
                    Object typeRemapper$iv$iv;
                    IrBuilderWithScope $this$deepCopyWithSymbols_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    boolean isMemberFieldSet = Intrinsics.areEqual((Object)((IrField)expression.getSymbol().getOwner()).getParent(), (Object)this.$klass);
                    if (isMemberFieldSet) {
                        IrElement irElement = expression;
                        IrDeclarationParent initialParent$iv = this.$irConstructor;
                        boolean $i$f$deepCopyWithSymbols = false;
                        IrBuilderWithScope $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                        boolean $i$f$deepCopyImpl = false;
                        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                        IrVisitorsKt.acceptVoid((IrElement)((Object)$this$deepCopyImpl$iv$iv), symbolRemapper$iv$iv);
                        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                        Ref.ObjectRef<IrSetField> objectRef = this.$setMemberField;
                        boolean bl = false;
                        ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                        typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                        IrElement irElement2 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, (TypeRemapper)typeRemapper$iv$iv), null);
                        if (irElement2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrSetField");
                        }
                        objectRef.element = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrSetField)irElement2), initialParent$iv);
                    }
                    this.transformChildrenVoid(expression);
                    if (isMemberFieldSet) {
                        void this_$iv$iv;
                        void $this$irBlock_u24default$iv;
                        $this$deepCopyWithSymbols_u24default$iv = this.$builder;
                        IrBlockBodyBuilder irBlockBodyBuilder = this.$builder;
                        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                        IrStatementOrigin origin$iv = null;
                        IrType resultType$iv = null;
                        boolean $i$f$irBlock = false;
                        typeRemapper$iv$iv = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                        boolean $i$f$block = false;
                        void $this$visitSetField_u24lambda_u241 = this_$iv$iv;
                        boolean bl = false;
                        if (!org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(expression.getValue(), true, false, null, 6, null)) {
                            void this_$iv$iv2;
                            $this$visitSetField_u24lambda_u241.unaryPlus(expression.getValue());
                            IrBuilderWithScope $this$irBlock_u24default$iv2 = irBlockBodyBuilder;
                            int startOffset$iv2 = $this$irBlock_u24default$iv2.getStartOffset();
                            int endOffset$iv2 = $this$irBlock_u24default$iv2.getEndOffset();
                            IrStatementOrigin origin$iv2 = null;
                            IrType resultType$iv2 = null;
                            boolean $i$f$irBlock2 = false;
                            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv2.getContext(), $this$irBlock_u24default$iv2.getScope(), startOffset$iv2, endOffset$iv2, origin$iv2, resultType$iv2, false, 64, null);
                            boolean $i$f$block2 = false;
                            void var22_27 = this_$iv$iv2;
                            void var23_28 = $this$visitSetField_u24lambda_u241;
                            boolean bl2 = false;
                            var23_28.unaryPlus((IrStatement)this_$iv$iv2.doBuild());
                        }
                        return (IrExpression)this_$iv$iv.doBuild();
                    }
                    return expression;
                }

                public IrExpression visitGetField(IrGetField expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.transformChildrenVoid(expression);
                    if (Intrinsics.areEqual((Object)((IrField)expression.getSymbol().getOwner()).getParent(), (Object)this.$klass)) {
                        return ExpressionHelpersKt.irGet(this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getParameters()));
                    }
                    return expression;
                }

                public IrExpression visitGetValue(IrGetValue expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.transformChildrenVoid(expression);
                    if (Intrinsics.areEqual((Object)expression.getSymbol().getOwner().getParent(), (Object)this.$klass)) {
                        return InlineClassDeclarationLowering.access$transformPrimaryConstructor$lambda$1$0$0$unboxedInlineClassValue(this.$builder, this.$initFunction, this.$klass);
                    }
                    if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)this.$origParameterSymbol)) {
                        return ExpressionHelpersKt.irGet(this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getParameters()));
                    }
                    return expression;
                }

                public IrExpression visitSetValue(IrSetValue expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.transformChildrenVoid(expression);
                    if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)this.$origParameterSymbol)) {
                        return ExpressionHelpersKt.irSet$default((IrBuilder)this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getParameters()), expression.getValue(), null, 4, null);
                    }
                    return expression;
                }
            }));
        }
        $this$transformPrimaryConstructor_u24lambda_u241_u240_u240.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformPrimaryConstructor_u24lambda_u241_u240_u240, InlineClassDeclarationLowering.transformPrimaryConstructor$lambda$1$0$0$unboxedInlineClassValue((IrBlockBodyBuilder)builder2, $initFunction, $klass)));
        object = this_$iv$iv$iv.doBuild().getStatements();
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
        return Unit.INSTANCE;
    }

    private static final Unit transformPrimaryConstructor$lambda$2(Ref.ObjectRef $delegatingCtorCall, Ref.ObjectRef $setMemberField, IrBlockBody $this$createBlockBody) {
        block1: {
            IrDeclarationReference it;
            Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
            IrDelegatingConstructorCall irDelegatingConstructorCall = (IrDelegatingConstructorCall)$delegatingCtorCall.element;
            if (irDelegatingConstructorCall != null) {
                it = irDelegatingConstructorCall;
                boolean bl = false;
                ((Collection)$this$createBlockBody.getStatements()).add(it);
            }
            IrSetField irSetField = (IrSetField)$setMemberField.element;
            if (irSetField == null) break block1;
            it = irSetField;
            boolean bl = false;
            ((Collection)$this$createBlockBody.getStatements()).add(it);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit transformConstructorBody$lambda$0$0(InlineClassDeclarationLowering this$0, IrSimpleFunction $staticMethod, IrBody $constructorBody, IrConstructor $irConstructor, IrClass $irClass, IrBlockBody $this$createBlockBody) {
        IrVariable irVariable;
        void $this$associateByTo$iv$iv;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        Collection collection = $this$createBlockBody.getStatements();
        Object object = LowerUtilsKt.createIrBuilder$default(this$0.context, (IrSymbol)$staticMethod.getSymbol(), 0, 0, 6, null);
        IrElement irElement$iv = $staticMethod;
        boolean $i$f$irBlockBody = false;
        void var10_10 = $this$irBlockBody$iv;
        int n = irElement$iv.getStartOffset();
        int endOffset$iv$iv = irElement$iv.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void $this$transformConstructorBody_u24lambda_u240_u240_u240 = this_$iv$iv$iv;
        boolean bl = false;
        Ref.ObjectRef thisVar = new Ref.ObjectRef();
        Iterable $this$associateBy$iv = $staticMethod.getParameters();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            map.put($irConstructor.getParameters().get(it.getIndexInParameters()).getSymbol(), element$iv$iv);
        }
        Map parameterMapping = destination$iv$iv;
        Intrinsics.checkNotNull((Object)$constructorBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        Iterable $this$forEach$iv = ((IrBlockBody)$constructorBody).getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement statement = (IrStatement)element$iv;
            boolean bl3 = false;
            $this$transformConstructorBody_u24lambda_u240_u240_u240.unaryPlus(IrElementsKt.transformStatement(statement, new IrElementTransformerVoid($irClass, (IrBlockBodyBuilder)$this$transformConstructorBody_u24lambda_u240_u240_u240, (Ref.ObjectRef<IrVariable>)thisVar, $staticMethod, parameterMapping, $irConstructor){
                final /* synthetic */ IrClass $irClass;
                final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                final /* synthetic */ Ref.ObjectRef<IrVariable> $thisVar;
                final /* synthetic */ IrSimpleFunction $staticMethod;
                final /* synthetic */ Map<IrValueParameterSymbol, IrValueParameter> $parameterMapping;
                final /* synthetic */ IrConstructor $irConstructor;
                {
                    this.$irClass = $irClass;
                    this.$this_irBlockBody = $this_irBlockBody;
                    this.$thisVar = $thisVar;
                    this.$staticMethod = $staticMethod;
                    this.$parameterMapping = $parameterMapping;
                    this.$irConstructor = $irConstructor;
                }

                /*
                 * WARNING - void declaration
                 */
                public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression) {
                    IrVariable irVariable;
                    void this_$iv$iv$iv;
                    void origin$iv$iv;
                    void endOffset$iv$iv;
                    void startOffset$iv$iv;
                    void $this$irBlock$iv$iv;
                    void $this$irBlock_u24default$iv;
                    void expression$iv;
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.transformChildrenVoid(expression);
                    expression.setType(IrUtilsKt.getDefaultType(this.$irClass));
                    IrGeneratorWithScope irGeneratorWithScope = this.$this_irBlockBody;
                    IrExpression irExpression = expression;
                    Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                    IrClass irClass = this.$irClass;
                    IrSimpleFunction irSimpleFunction = this.$staticMethod;
                    Object origin$iv = null;
                    IrType resultType$iv = expression$iv.getType();
                    int startOffset$iv = expression$iv.getStartOffset();
                    int endOffset$iv = expression$iv.getEndOffset();
                    boolean $i$f$irBlock = false;
                    void var12_12 = $this$irBlock_u24default$iv;
                    int n = startOffset$iv;
                    int n2 = endOffset$iv;
                    Object var15_15 = origin$iv;
                    IrType resultType$iv$iv = resultType$iv;
                    boolean $i$f$irBlock2 = false;
                    IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, (int)endOffset$iv$iv, (IrStatementOrigin)origin$iv$iv, resultType$iv$iv, false, 64, null);
                    boolean $i$f$block = false;
                    void $this$visitDelegatingConstructorCall_u24lambda_u240 = this_$iv$iv$iv;
                    boolean bl = false;
                    objectRef.element = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$visitDelegatingConstructorCall_u24lambda_u240, expression, null, false, null, IrUtilsKt.getDefaultType(irClass), 14, null);
                    if (objectRef.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                        irVariable = null;
                    } else {
                        irVariable = (IrVariable)objectRef.element;
                    }
                    irVariable.setParent(irSimpleFunction);
                    return (IrExpression)this_$iv$iv$iv.doBuild();
                }

                public IrExpression visitGetValue(IrGetValue expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.transformChildrenVoid(expression);
                    IrValueParameter irValueParameter = this.$irClass.getThisReceiver();
                    if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)(irValueParameter != null ? irValueParameter.getSymbol() : null))) {
                        IrVariable irVariable;
                        IrBuilder irBuilder = this.$this_irBlockBody;
                        if (this.$thisVar.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                            irVariable = null;
                        } else {
                            irVariable = (IrVariable)this.$thisVar.element;
                        }
                        return ExpressionHelpersKt.irGet(irBuilder, irVariable);
                    }
                    IrValueParameter irValueParameter2 = this.$parameterMapping.get(expression.getSymbol());
                    if (irValueParameter2 != null) {
                        IrValueParameter irValueParameter3 = irValueParameter2;
                        IrBlockBodyBuilder irBlockBodyBuilder = this.$this_irBlockBody;
                        IrValueParameter it = irValueParameter3;
                        boolean bl = false;
                        return ExpressionHelpersKt.irGet(irBlockBodyBuilder, it);
                    }
                    return expression;
                }

                public IrExpression visitSetValue(IrSetValue expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.transformChildrenVoid(expression);
                    IrValueParameter irValueParameter = this.$parameterMapping.get(expression.getSymbol());
                    if (irValueParameter != null) {
                        IrValueParameter irValueParameter2 = irValueParameter;
                        IrBlockBodyBuilder irBlockBodyBuilder = this.$this_irBlockBody;
                        IrValueParameter it = irValueParameter2;
                        boolean bl = false;
                        return ExpressionHelpersKt.irSet$default((IrBuilder)irBlockBodyBuilder, it.getSymbol(), expression.getValue(), null, 4, null);
                    }
                    return expression;
                }

                public IrStatement visitDeclaration(IrDeclarationBase declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                    if (Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$irConstructor)) {
                        declaration.setParent(this.$staticMethod);
                    }
                    return declaration;
                }

                /*
                 * WARNING - void declaration
                 */
                public IrExpression visitReturn(IrReturn expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.transformChildrenVoid(expression);
                    if (Intrinsics.areEqual((Object)expression.getReturnTargetSymbol(), (Object)this.$irConstructor.getSymbol())) {
                        IrVariable irVariable;
                        void $this$visitReturn_u24lambda_u243;
                        void this_$iv$iv;
                        void endOffset$iv;
                        void startOffset$iv;
                        void $this$irBlock_u24default$iv;
                        IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                        int n = expression.getStartOffset();
                        int n2 = expression.getEndOffset();
                        Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                        IrStatementOrigin origin$iv = null;
                        IrType resultType$iv = null;
                        boolean $i$f$irBlock = false;
                        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                        boolean $i$f$block = false;
                        void var11_11 = this_$iv$iv;
                        IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody;
                        boolean bl = false;
                        $this$visitReturn_u24lambda_u243.unaryPlus(expression.getValue());
                        IrBuilder irBuilder = (IrBuilder)$this$visitReturn_u24lambda_u243;
                        if (objectRef.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                            irVariable = null;
                        } else {
                            irVariable = (IrVariable)objectRef.element;
                        }
                        $this$visitReturn_u24lambda_u243.unaryPlus(ExpressionHelpersKt.irGet(irBuilder, irVariable));
                        return ExpressionHelpersKt.irReturn(irBuilderWithScope2, (IrExpression)this_$iv$iv.doBuild());
                    }
                    return expression;
                }
            }));
        }
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$transformConstructorBody_u24lambda_u240_u240_u240;
        IrBuilder irBuilder = (IrBuilder)$this$transformConstructorBody_u24lambda_u240_u240_u240;
        if (thisVar.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
            irVariable = null;
        } else {
            irVariable = (IrVariable)thisVar.element;
        }
        $this$transformConstructorBody_u24lambda_u240_u240_u240.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilder, irVariable)));
        object = this_$iv$iv$iv.doBuild().getStatements();
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
        return Unit.INSTANCE;
    }

    private static final Unit transformMethodBodyFlat$lambda$0$0(IrBody $functionBody, IrSimpleFunction $function, IrSimpleFunction $staticMethod, InlineClassDeclarationLowering this$0, IrBlockBody $this$createBlockBody) {
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        List<IrStatement> list = $this$createBlockBody.getStatements();
        Intrinsics.checkNotNull((Object)$functionBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        list.addAll((Collection<IrStatement>)((IrBlockBody)$functionBody).getStatements());
        IrElementTransformerVoidKt.transformChildrenVoid($this$createBlockBody, new IrElementTransformerVoid($function, $staticMethod, this$0){
            final /* synthetic */ IrSimpleFunction $function;
            final /* synthetic */ IrSimpleFunction $staticMethod;
            final /* synthetic */ InlineClassDeclarationLowering this$0;
            {
                this.$function = $function;
                this.$staticMethod = $staticMethod;
                this.this$0 = $receiver;
            }

            public IrStatement visitDeclaration(IrDeclarationBase declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                if (Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$function)) {
                    declaration.setParent(this.$staticMethod);
                }
                return declaration;
            }

            public IrExpression visitGetValue(IrGetValue expression) {
                IrValueParameter irValueParameter;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                IrValueDeclaration irValueDeclaration = expression.getSymbol().getOwner();
                IrValueParameter irValueParameter2 = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                if (irValueParameter2 == null) {
                    return super.visitGetValue(expression);
                }
                IrValueParameter valueDeclaration = irValueParameter2;
                IrBuilder irBuilder = LowerUtilsKt.createIrBuilder$default(InlineClassDeclarationLowering.access$getContext$p(this.this$0), (IrSymbol)this.$staticMethod.getSymbol(), 0, 0, 6, null);
                IrValueParameter irValueParameter3 = valueDeclaration;
                if (Intrinsics.areEqual((Object)irValueParameter3, (Object)IrUtilsKt.getParentAsClass(this.$function).getThisReceiver())) {
                    irValueParameter = this.$staticMethod.getParameters().get(0);
                } else if (this.$function.getParameters().contains(irValueParameter3)) {
                    irValueParameter = this.$staticMethod.getParameters().get(valueDeclaration.getIndexInParameters());
                } else {
                    return expression;
                }
                return ExpressionHelpersKt.irGet(irBuilder, irValueParameter);
            }

            public IrExpression visitSetValue(IrSetValue expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                IrValueDeclaration irValueDeclaration = expression.getSymbol().getOwner();
                IrValueParameter irValueParameter = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                if (irValueParameter == null) {
                    return super.visitSetValue(expression);
                }
                IrValueParameter valueDeclaration = irValueParameter;
                this.transformChildrenVoid(expression);
                IrValueParameter irValueParameter2 = valueDeclaration;
                if (!this.$function.getParameters().contains(irValueParameter2)) {
                    return expression;
                }
                return ExpressionHelpersKt.irSet$default((IrBuilder)LowerUtilsKt.createIrBuilder$default(InlineClassDeclarationLowering.access$getContext$p(this.this$0), (IrSymbol)this.$staticMethod.getSymbol(), 0, 0, 6, null), this.$staticMethod.getParameters().get(valueDeclaration.getIndexInParameters()).getSymbol(), expression.getValue(), null, 4, null);
            }
        });
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit delegateToStaticMethod$lambda$0(InlineClassDeclarationLowering this$0, IrSimpleFunction $function, IrSimpleFunction $staticMethod, IrBlockBody $this$createBlockBody) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$delegateToStaticMethod_u24lambda_u240_u240_u240;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        Collection collection = $this$createBlockBody.getStatements();
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this$0.context, (IrSymbol)$function.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void $this$delegateToStaticMethod_u24lambda_u240_u240 = this_$iv$iv;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$delegateToStaticMethod_u24lambda_u240_u240, $staticMethod);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$delegateToStaticMethod_u24lambda_u240_u240;
        void var16_16 = $this$delegateToStaticMethod_u24lambda_u240_u240;
        boolean bl2 = false;
        Iterable iterable = $function.getParameters();
        List list = $this$delegateToStaticMethod_u24lambda_u240_u240_u240.getArguments();
        boolean $i$f$map = false;
        void var21_22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl3 = false;
            collection2.add(ExpressionHelpersKt.irGet((IrBuilder)$this$delegateToStaticMethod_u24lambda_u240_u240, (IrValueDeclaration)it));
        }
        AddToStdlibKt.assignFrom((List)list, (Collection)((List)destination$iv$iv));
        List typeParameters = CollectionsKt.plus((Collection)IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass($function)), (Iterable)$function.getTypeParameters());
        Iterator iterator = ((Iterable)typeParameters).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            IrTypeParameter typeParameter = (IrTypeParameter)iterator.next();
            $this$delegateToStaticMethod_u24lambda_u240_u240_u240.getTypeArguments().set(index, IrSimpleTypeImplKt.IrSimpleTypeImpl$default(typeParameter.getSymbol(), SimpleTypeNullability.NOT_SPECIFIED, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 16, null));
        }
        Unit unit = Unit.INSTANCE;
        var16_16.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irFunctionAccessExpression));
        Iterable iterable2 = this_$iv$iv.doBuild().getStatements();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ IrTypeOperatorCallImpl access$transformPrimaryConstructor$lambda$1$0$0$unboxedInlineClassValue(IrBlockBodyBuilder builder2, IrSimpleFunction initFunction, IrClass klass) {
        return InlineClassDeclarationLowering.transformPrimaryConstructor$lambda$1$0$0$unboxedInlineClassValue(builder2, initFunction, klass);
    }

    public static final /* synthetic */ CommonBackendContext access$getContext$p(InlineClassDeclarationLowering $this) {
        return $this.context;
    }
}

