/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.InventNamesForLocalFunctionsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.ScopeWithCounter;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH$J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "<init>", "()V", "suggestUniqueNames", "", "getSuggestUniqueNames", "()Z", "compatibilityModeForInlinedLocalDelegatedPropertyAccessors", "getCompatibilityModeForInlinedLocalDelegatedPropertyAccessors", "sanitizeNameIfNeeded", "", "name", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "localFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions$LocalFunctionContext;", "declarationScopesWithCounter", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$DeclarationKeyForScope;", "Lorg/jetbrains/kotlin/backend/common/lower/ScopeWithCounter;", "LocalFunctionContext", "NameInventor", "Data", "Companion", "ir.backend.common"})
public abstract class InventNamesForLocalFunctions
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<IrFunction, LocalFunctionContext> localFunctions = new LinkedHashMap();
    @NotNull
    private final Map<IrClass, Map<LocalDeclarationsLowering.DeclarationKeyForScope, ScopeWithCounter>> declarationScopesWithCounter = new LinkedHashMap();

    protected abstract boolean getSuggestUniqueNames();

    protected abstract boolean getCompatibilityModeForInlinedLocalDelegatedPropertyAccessors();

    @NotNull
    protected abstract String sanitizeNameIfNeeded(@NotNull String var1);

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        irBody.accept(new NameInventor(container), new Data(null, false, false));
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions$Companion;", "", "<init>", "()V", "isLambda", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isLambda(IrFunction $this$isLambda) {
            return Intrinsics.areEqual((Object)$this$isLambda.getOrigin(), (Object)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA()) || Intrinsics.areEqual((Object)$this$isLambda.getOrigin(), (Object)IrDeclarationOrigin.Companion.getINLINE_LAMBDA());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions$Data;", "", "currentScope", "Lorg/jetbrains/kotlin/backend/common/lower/ScopeWithCounter;", "isInInlineFunction", "", "isInLambdaFunction", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/ScopeWithCounter;ZZ)V", "getCurrentScope", "()Lorg/jetbrains/kotlin/backend/common/lower/ScopeWithCounter;", "()Z", "withCurrentClass", "currentClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "withCurrentFunction", "currentFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "withInline", "isInline", "ir.backend.common"})
    private static final class Data {
        @Nullable
        private final ScopeWithCounter currentScope;
        private final boolean isInInlineFunction;
        private final boolean isInLambdaFunction;

        public Data(@Nullable ScopeWithCounter currentScope, boolean isInInlineFunction, boolean isInLambdaFunction) {
            this.currentScope = currentScope;
            this.isInInlineFunction = isInInlineFunction;
            this.isInLambdaFunction = isInLambdaFunction;
        }

        @Nullable
        public final ScopeWithCounter getCurrentScope() {
            return this.currentScope;
        }

        public final boolean isInInlineFunction() {
            return this.isInInlineFunction;
        }

        public final boolean isInLambdaFunction() {
            return this.isInLambdaFunction;
        }

        @NotNull
        public final Data withCurrentClass(@NotNull IrClass currentClass) {
            Intrinsics.checkNotNullParameter((Object)currentClass, (String)"currentClass");
            return new Data(new ScopeWithCounter(currentClass), this.isInInlineFunction, false);
        }

        @NotNull
        public final Data withCurrentFunction(@NotNull IrFunction currentFunction) {
            Intrinsics.checkNotNullParameter((Object)currentFunction, (String)"currentFunction");
            return new Data(new ScopeWithCounter(currentFunction), this.isInInlineFunction, Companion.isLambda(currentFunction));
        }

        @NotNull
        public final Data withInline(boolean isInline) {
            return isInline && !this.isInInlineFunction ? new Data(this.currentScope, true, false) : this;
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions$LocalFunctionContext;", "", "index", "", "newOwnerForLiftedUpFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "isNestedInLambda", "", "<init>", "(ILorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;Z)V", "getIndex", "()I", "getNewOwnerForLiftedUpFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "()Z", "ir.backend.common"})
    private static final class LocalFunctionContext {
        private final int index;
        @NotNull
        private final IrDeclarationContainer newOwnerForLiftedUpFunction;
        private final boolean isNestedInLambda;

        public LocalFunctionContext(int index, @NotNull IrDeclarationContainer newOwnerForLiftedUpFunction, boolean isNestedInLambda) {
            Intrinsics.checkNotNullParameter((Object)newOwnerForLiftedUpFunction, (String)"newOwnerForLiftedUpFunction");
            this.index = index;
            this.newOwnerForLiftedUpFunction = newOwnerForLiftedUpFunction;
            this.isNestedInLambda = isNestedInLambda;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final IrDeclarationContainer getNewOwnerForLiftedUpFunction() {
            return this.newOwnerForLiftedUpFunction;
        }

        public final boolean isNestedInLambda() {
            return this.isNestedInLambda;
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010*\u001a\u000204H\u0002J\f\u00105\u001a\u000206*\u000207H\u0002J\u000e\u00105\u001a\u0004\u0018\u000106*\u00020\u0011H\u0002J\u000e\u00105\u001a\u0004\u0018\u000106*\u00020\u0016H\u0002J\u001c\u00108\u001a\u0004\u0018\u0001H9\"\n\b\u0000\u00109\u0018\u0001*\u00020!H\u0082\b\u00a2\u0006\u0002\u0010:R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions$NameInventor;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions$Data;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "enclosingClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getEnclosingClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "enclosingClass$delegate", "Lkotlin/Lazy;", "enclosingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getEnclosingField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "enclosingField$delegate", "enclosingFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getEnclosingFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "enclosingFunction$delegate", "enclosingPackageFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "getEnclosingPackageFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "enclosingPackageFragment$delegate", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "data", "visitInlinedFunctionBlock", "inlinedBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "visitFunctionExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitClass", "generateNameForLiftedFunction", "Lorg/jetbrains/kotlin/name/Name;", "function", "newOwnerForLiftedUpFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "suggestLocalName", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getOrCreateScopeWithCounter", "Lorg/jetbrains/kotlin/backend/common/lower/ScopeWithCounter;", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getEnclosing", "T", "()Lorg/jetbrains/kotlin/ir/IrElement;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nInventNamesForLocalFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InventNamesForLocalFunctions.kt\norg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions$NameInventor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,268:1\n208#1,6:298\n208#1,6:304\n208#1,6:310\n1#2:269\n460#3,7:270\n460#3,7:277\n460#3,7:284\n460#3,7:291\n*S KotlinDebug\n*F\n+ 1 InventNamesForLocalFunctions.kt\norg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalFunctions$NameInventor\n*L\n82#1:298,6\n83#1:304,6\n84#1:310,6\n197#1:270,7\n198#1:277,7\n203#1:284,7\n204#1:291,7\n*E\n"})
    private final class NameInventor
    extends IrVisitor<Unit, Data> {
        @NotNull
        private final IrDeclaration container;
        @NotNull
        private final Lazy enclosingClass$delegate;
        @NotNull
        private final Lazy enclosingField$delegate;
        @NotNull
        private final Lazy enclosingFunction$delegate;
        @NotNull
        private final Lazy enclosingPackageFragment$delegate;

        public NameInventor(IrDeclaration container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            this.container = container;
            this.enclosingClass$delegate = LazyKt.lazy(() -> NameInventor.enclosingClass_delegate$lambda$0(this));
            this.enclosingField$delegate = LazyKt.lazy(() -> NameInventor.enclosingField_delegate$lambda$0(this));
            this.enclosingFunction$delegate = LazyKt.lazy(() -> NameInventor.enclosingFunction_delegate$lambda$0(this));
            this.enclosingPackageFragment$delegate = LazyKt.lazy(() -> NameInventor.enclosingPackageFragment_delegate$lambda$0(this));
        }

        @NotNull
        public final IrDeclaration getContainer() {
            return this.container;
        }

        @Nullable
        public final IrClass getEnclosingClass() {
            Lazy lazy = this.enclosingClass$delegate;
            return (IrClass)lazy.getValue();
        }

        @Nullable
        public final IrField getEnclosingField() {
            Lazy lazy = this.enclosingField$delegate;
            return (IrField)lazy.getValue();
        }

        @Nullable
        public final IrFunction getEnclosingFunction() {
            Lazy lazy = this.enclosingFunction$delegate;
            return (IrFunction)lazy.getValue();
        }

        @NotNull
        public final IrPackageFragment getEnclosingPackageFragment() {
            Lazy lazy = this.enclosingPackageFragment$delegate;
            return (IrPackageFragment)lazy.getValue();
        }

        @Override
        public void visitElement(@NotNull IrElement element, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            element.acceptChildren(this, data);
        }

        @Override
        public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)inlinedBlock, (String)"inlinedBlock");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super.visitInlinedFunctionBlock(inlinedBlock, data.withInline(IrInlineUtilsKt.isFunctionInlining(inlinedBlock)));
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression.getFunction().acceptChildren(this, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull Data data) {
            block21: {
                Object object;
                int index;
                ScopeWithCounter enclosingScope;
                block23: {
                    Object object2;
                    block22: {
                        IrDeclarationContainer irDeclarationContainer;
                        int n;
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        if (!Intrinsics.areEqual((Object)declaration.getVisibility(), (Object)DescriptorVisibilities.LOCAL)) break block21;
                        ScopeWithCounter scopeWithCounter = data.getCurrentScope();
                        if (scopeWithCounter == null) {
                            IrField irField = this.getEnclosingField();
                            scopeWithCounter = irField != null ? this.getOrCreateScopeWithCounter(irField) : null;
                            if (scopeWithCounter == null) {
                                IrFunction irFunction = this.getEnclosingFunction();
                                scopeWithCounter = irFunction != null ? this.getOrCreateScopeWithCounter(irFunction) : null;
                                if (scopeWithCounter == null) {
                                    IrClass irClass = this.getEnclosingClass();
                                    scopeWithCounter = irClass != null ? this.getOrCreateScopeWithCounter(irClass) : null;
                                    if (scopeWithCounter == null) {
                                        scopeWithCounter = enclosingScope = this.getOrCreateScopeWithCounter(this.getEnclosingPackageFragment());
                                    }
                                }
                            }
                        }
                        if (declaration.getName().isSpecial() || enclosingScope.getUsedLocalFunctionNames().contains(declaration.getName())) {
                            int n2 = enclosingScope.getCounter();
                            enclosingScope.setCounter(n2 + 1);
                            n = n2;
                        } else {
                            n = index = -1;
                        }
                        if ((object = data.getCurrentScope()) == null) break block22;
                        ScopeWithCounter scopeWithCounter2 = object;
                        object2 = InventNamesForLocalFunctions.this;
                        ScopeWithCounter it = scopeWithCounter2;
                        boolean bl = false;
                        IrElement irElement = it.getIrElement();
                        if (irElement instanceof IrDeclarationContainer) {
                            irDeclarationContainer = (IrDeclarationContainer)it.getIrElement();
                        } else if (irElement instanceof IrField) {
                            IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)it.getIrElement());
                            Intrinsics.checkNotNull((Object)irClass);
                            irDeclarationContainer = irClass;
                        } else if (irElement instanceof IrFunction) {
                            Object v = ((InventNamesForLocalFunctions)object2).localFunctions.get(enclosingScope.getIrElement());
                            Intrinsics.checkNotNull(v);
                            irDeclarationContainer = ((LocalFunctionContext)v).getNewOwnerForLiftedUpFunction();
                        } else {
                            throw new IllegalStateException("Unknown owner for lowered declaration".toString());
                        }
                        object = irDeclarationContainer;
                        if (irDeclarationContainer != null) break block23;
                    }
                    IrField irField = (object2 = enclosingScope.getIrElement()) instanceof IrField ? (IrField)object2 : null;
                    if (irField != null) {
                        IrField enclosingField = irField;
                        boolean bl = false;
                        IrClass irClass = IrUtilsKt.getParentClassOrNull(enclosingField);
                        Intrinsics.checkNotNull((Object)irClass);
                        object = irClass;
                    } else {
                        IrClass irClass;
                        IrElement irElement = enclosingScope.getIrElement();
                        IrFunction irFunction = irElement instanceof IrFunction ? (IrFunction)irElement : null;
                        if (irFunction != null) {
                            IrFunction enclosingFunction = irFunction;
                            boolean bl = false;
                            IrClass irClass2 = IrUtilsKt.getParentClassOrNull(enclosingFunction);
                            irClass = irClass2;
                            Intrinsics.checkNotNull((Object)irClass2);
                        } else {
                            irClass = null;
                        }
                        if (irClass != null) {
                            object = irClass;
                        } else {
                            IrElement irElement2 = enclosingScope.getIrElement();
                            Intrinsics.checkNotNull((Object)irElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                            object = (IrDeclarationContainer)irElement2;
                        }
                    }
                }
                Object newOwnerForLiftedUpFunction = object;
                LocalFunctionContext functionContext = new LocalFunctionContext(index, (IrDeclarationContainer)newOwnerForLiftedUpFunction, data.isInLambdaFunction());
                InventNamesForLocalFunctions.this.localFunctions.put(declaration, functionContext);
                enclosingScope.getUsedLocalFunctionNames().add(declaration.getName());
                InventNamesForLocalFunctionsKt.setInventedNameForLocalFunction(declaration, this.generateNameForLiftedFunction(declaration, functionContext.getNewOwnerForLiftedUpFunction()));
            }
            Data newData = data.withInline(declaration.isInline());
            super.visitSimpleFunction(declaration, Companion.isLambda(declaration) ? newData.withCurrentFunction(declaration) : newData);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super.visitClass(declaration, data.withCurrentClass(declaration));
        }

        private final Name generateNameForLiftedFunction(IrSimpleFunction function, IrDeclarationParent newOwnerForLiftedUpFunction) {
            Name name;
            List parents = CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.takeWhile(IrUtilsKt.getParentsWithSelf(function), arg_0 -> NameInventor.generateNameForLiftedFunction$lambda$0(newOwnerForLiftedUpFunction, arg_0))));
            String nameFromParents = CollectionsKt.joinToString$default((Iterable)parents, (CharSequence)"$", null, null, (int)0, null, arg_0 -> NameInventor.generateNameForLiftedFunction$lambda$1(this, arg_0), (int)30, null);
            if (parents.size() == 1 && function.getParent() instanceof IrClass) {
                Name name2 = Name.identifier((String)("_init_$" + nameFromParents));
                name = name2;
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            } else {
                Name name3 = Name.identifier((String)nameFromParents);
                name = name3;
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
            }
            return name;
        }

        private final String suggestLocalName(IrDeclarationWithName declaration) {
            String baseName;
            String string;
            LocalFunctionContext localFunctionContext = (LocalFunctionContext)InventNamesForLocalFunctions.this.localFunctions.get(declaration);
            if (localFunctionContext == null) {
                String string2 = declaration.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                return InventNamesForLocalFunctions.this.sanitizeNameIfNeeded(string2);
            }
            LocalFunctionContext functionContext = localFunctionContext;
            if (functionContext.getIndex() < 0) {
                String string3 = declaration.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                return InventNamesForLocalFunctions.this.sanitizeNameIfNeeded(string3);
            }
            if (declaration.getName().isSpecial()) {
                string = functionContext.isNestedInLambda() ? "" : "lambda";
            } else {
                String string4 = declaration.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
                string = baseName = InventNamesForLocalFunctions.this.sanitizeNameIfNeeded(string4);
            }
            if (!InventNamesForLocalFunctions.this.getSuggestUniqueNames()) {
                return baseName;
            }
            String separator = InventNamesForLocalFunctions.this.getCompatibilityModeForInlinedLocalDelegatedPropertyAccessors() && Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDELEGATED_PROPERTY_ACCESSOR()) && this.container instanceof IrFunction && ((IrFunction)this.container).isInline() ? "-" : (((CharSequence)baseName).length() == 0 ? "" : "$");
            return baseName + separator + functionContext.getIndex();
        }

        private final ScopeWithCounter getOrCreateScopeWithCounter(IrSymbolOwner $this$getOrCreateScopeWithCounter) {
            ScopeWithCounter scopeWithCounter = InventNamesForLocalFunctionsKt.access$getScopeWithCounter($this$getOrCreateScopeWithCounter);
            if (scopeWithCounter == null) {
                ScopeWithCounter scopeWithCounter2;
                ScopeWithCounter it = scopeWithCounter2 = new ScopeWithCounter($this$getOrCreateScopeWithCounter);
                boolean bl = false;
                InventNamesForLocalFunctionsKt.access$setScopeWithCounter($this$getOrCreateScopeWithCounter, it);
                scopeWithCounter = scopeWithCounter2;
            }
            return scopeWithCounter;
        }

        private final ScopeWithCounter getOrCreateScopeWithCounter(IrField $this$getOrCreateScopeWithCounter) {
            Object object;
            Object object2;
            Map $this$getOrPut$iv;
            IrClass irClass = IrUtilsKt.getParentClassOrNull($this$getOrCreateScopeWithCounter);
            if (irClass == null) {
                return null;
            }
            IrClass klass = irClass;
            Map map = InventNamesForLocalFunctions.this.declarationScopesWithCounter;
            Object key$iv = klass;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Map answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            $this$getOrPut$iv = (Map)object2;
            key$iv = LocalDeclarationsLowering.DeclarationKeyForScope.box-impl(LocalDeclarationsLowering.DeclarationKeyForScope.Companion.createDeclarationKeyForScopeBySanitizedName-hBm_5nc($this$getOrCreateScopeWithCounter.getName(), (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)InventNamesForLocalFunctions.this){

                public final String invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((InventNamesForLocalFunctions)this.receiver).sanitizeNameIfNeeded(p0);
                }
            })));
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ScopeWithCounter answer$iv = new ScopeWithCounter($this$getOrCreateScopeWithCounter);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (ScopeWithCounter)object;
        }

        private final ScopeWithCounter getOrCreateScopeWithCounter(IrFunction $this$getOrCreateScopeWithCounter) {
            Object object;
            Object object2;
            Map $this$getOrPut$iv;
            IrClass irClass = IrUtilsKt.getParentClassOrNull($this$getOrCreateScopeWithCounter);
            if (irClass == null) {
                return null;
            }
            IrClass klass = irClass;
            Map map = InventNamesForLocalFunctions.this.declarationScopesWithCounter;
            Object key$iv = klass;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Map answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            $this$getOrPut$iv = (Map)object2;
            key$iv = LocalDeclarationsLowering.DeclarationKeyForScope.box-impl(LocalDeclarationsLowering.DeclarationKeyForScope.Companion.createDeclarationKeyForScopeBySanitizedName-hBm_5nc($this$getOrCreateScopeWithCounter.getName(), (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)InventNamesForLocalFunctions.this){

                public final String invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((InventNamesForLocalFunctions)this.receiver).sanitizeNameIfNeeded(p0);
                }
            })));
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ScopeWithCounter answer$iv = new ScopeWithCounter($this$getOrCreateScopeWithCounter);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (ScopeWithCounter)object;
        }

        private final /* synthetic */ <T extends IrElement> T getEnclosing() {
            IrElement currentParent;
            boolean $i$f$getEnclosing = false;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            IrElement irElement = this.container;
            IrElement irElement2 = currentParent = irElement != null ? irElement : (IrElement)this.container.getParent();
            while (currentParent instanceof IrDeclaration) {
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (currentParent instanceof IrElement) break;
                currentParent = ((IrDeclaration)currentParent).getParent();
            }
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            return (T)currentParent;
        }

        private static final IrClass enclosingClass_delegate$lambda$0(NameInventor this$0) {
            IrElement currentParent$iv;
            IrElement irElement;
            NameInventor this_$iv = this$0;
            boolean $i$f$getEnclosing = false;
            IrDeclaration irDeclaration = this_$iv.container;
            if (!(irDeclaration instanceof IrClass)) {
                irDeclaration = null;
            }
            if ((irElement = (IrElement)((IrClass)irDeclaration)) == null) {
                irElement = currentParent$iv = (IrElement)this_$iv.container.getParent();
            }
            while (currentParent$iv instanceof IrDeclaration && !(currentParent$iv instanceof IrClass)) {
                currentParent$iv = ((IrDeclaration)currentParent$iv).getParent();
            }
            IrElement irElement2 = currentParent$iv;
            if (!(irElement2 instanceof IrClass)) {
                irElement2 = null;
            }
            return (IrClass)((IrElement)((IrClass)irElement2));
        }

        private static final IrField enclosingField_delegate$lambda$0(NameInventor this$0) {
            IrElement currentParent$iv;
            IrElement irElement;
            NameInventor this_$iv = this$0;
            boolean $i$f$getEnclosing = false;
            IrDeclaration irDeclaration = this_$iv.container;
            if (!(irDeclaration instanceof IrField)) {
                irDeclaration = null;
            }
            if ((irElement = (IrElement)((IrField)irDeclaration)) == null) {
                irElement = currentParent$iv = (IrElement)this_$iv.container.getParent();
            }
            while (currentParent$iv instanceof IrDeclaration && !(currentParent$iv instanceof IrField)) {
                currentParent$iv = ((IrDeclaration)currentParent$iv).getParent();
            }
            IrElement irElement2 = currentParent$iv;
            if (!(irElement2 instanceof IrField)) {
                irElement2 = null;
            }
            IrElement irElement3 = (IrField)irElement2;
            IrField it = (IrField)irElement3;
            boolean bl = false;
            IrField irField = it;
            return (IrField)((irField != null ? IrUtilsKt.getParentClassOrNull(irField) : null) != null ? irElement3 : null);
        }

        /*
         * Unable to fully structure code
         */
        private static final IrFunction enclosingFunction_delegate$lambda$0(NameInventor this$0) {
            this_$iv = this$0;
            $i$f$getEnclosing = false;
            v0 = this_$iv.container;
            if (!(v0 instanceof IrFunction)) {
                v0 = null;
            }
            if ((v1 = (IrElement)((IrFunction)v0)) == null) {
                v1 = currentParent$iv = (IrElement)this_$iv.container.getParent();
            }
            while (currentParent$iv instanceof IrDeclaration && !(currentParent$iv instanceof IrFunction)) {
                currentParent$iv = ((IrDeclaration)currentParent$iv).getParent();
            }
            v2 = currentParent$iv;
            if (!(v2 instanceof IrFunction)) {
                v2 = null;
            }
            var1_1 = (IrFunction)v2;
            it = (IrFunction)var1_1;
            $i$a$-takeIf-InventNamesForLocalFunctions$NameInventor$enclosingFunction$2$1 = false;
            if (it instanceof IrConstructor) ** GOTO lbl-1000
            v3 = it;
            if ((v3 != null ? IrUtilsKt.getParentClassOrNull(v3) : null) != null) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            return (IrFunction)(v4 != false ? var1_1 : null);
        }

        private static final IrPackageFragment enclosingPackageFragment_delegate$lambda$0(NameInventor this$0) {
            return IrUtilsKt.getPackageFragment(this$0.container);
        }

        private static final boolean generateNameForLiftedFunction$lambda$0(IrDeclarationParent $newOwnerForLiftedUpFunction, IrDeclarationParent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !Intrinsics.areEqual((Object)it, (Object)$newOwnerForLiftedUpFunction);
        }

        private static final CharSequence generateNameForLiftedFunction$lambda$1(NameInventor this$0, IrDeclarationParent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.suggestLocalName((IrDeclarationWithName)((Object)it));
        }
    }
}

