/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableHeaderInfo;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/DefaultIterableHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoHandler;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "iterableClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "matchIterable", "", "expression", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "data", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nDefaultIterableHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultIterableHandler.kt\norg/jetbrains/kotlin/backend/common/lower/loops/handlers/DefaultIterableHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1#2:41\n*E\n"})
public final class DefaultIterableHandler
implements HeaderInfoHandler {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrClassSymbol iterableClassSymbol;

    public DefaultIterableHandler(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.iterableClassSymbol = this.context.getIrBuiltIns().getIterableClass();
    }

    public boolean matchIterable(@NotNull IrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return IrTypeUtilsKt.isSubtypeOfClass(expression.getType(), this.iterableClassSymbol);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public HeaderInfo build(@NotNull IrExpression expression, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        void $this$build_u24lambda_u240_u240;
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        DeclarationIrBuilder $this$build_u24lambda_u240 = LowerUtilsKt.createIrBuilder(this.context, scopeOwner, expression.getStartOffset(), expression.getEndOffset());
        boolean bl = false;
        String string = OperatorNameConventions.ITERATOR.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(this.iterableClassSymbol, string);
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        IrSimpleFunction iteratorFun = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$build_u24lambda_u240, iteratorFun);
        Scope scope = $this$build_u24lambda_u240.getScope();
        boolean bl2 = false;
        $this$build_u24lambda_u240_u240.setDispatchReceiver(expression);
        IrVariable irVariable = Scope.createTemporaryVariable$default(scope, irFunctionAccessExpression, "iterator", false, null, null, 0, 0, false, 124, null);
        return new IterableHeaderInfo(irVariable);
    }
}

