/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.serialization;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.mangle.SpecialDeclarationType;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.load.java.descriptors.JavaForKotlinOverridePropertyDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00060\u0007R\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0014J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;)V", "createSignatureBuilder", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor$DescriptorBasedSignatureBuilder;", "type", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;", "withFileSignature", "", "fileSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "body", "Lkotlin/Function0;", "externallyGivenFileSignature", "JvmDescriptorBasedSignatureBuilder", "ir.serialization.jvm"})
public final class JvmIdSignatureDescriptor
extends IdSignatureDescriptor {
    @Nullable
    private IdSignature.FileSignature externallyGivenFileSignature;

    public JvmIdSignatureDescriptor(@NotNull KotlinMangler.DescriptorMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        super(mangler);
    }

    @Override
    @NotNull
    protected IdSignatureDescriptor.DescriptorBasedSignatureBuilder createSignatureBuilder(@NotNull SpecialDeclarationType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new JvmDescriptorBasedSignatureBuilder(type);
    }

    @Override
    public void withFileSignature(@NotNull IdSignature.FileSignature fileSignature, @NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter((Object)fileSignature, (String)"fileSignature");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.externallyGivenFileSignature = fileSignature;
        body.invoke();
        this.externallyGivenFileSignature = null;
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020 H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\"H\u0002R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010#\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\n\"\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor$JvmDescriptorBasedSignatureBuilder;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor$DescriptorBasedSignatureBuilder;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor;", "type", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;)V", "currentFileSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "getCurrentFileSignature", "()Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "platformSpecificFunction", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "platformSpecificClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "platformSpecificProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "platformSpecificGetter", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "platformSpecificSetter", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "platformSpecificAlias", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "platformSpecificModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "keepTrackOfOverridesForPossiblyClashingFakeOverride", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isCapturingTypeParameter", "", "member", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "computeStoredFileSignature", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "storedFileSignature", "getStoredFileSignature", "setStoredFileSignature", "(Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;)V", "ir.serialization.jvm"})
    @SourceDebugExtension(value={"SMAP\nJvmIdSignatureDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmIdSignatureDescriptor.kt\norg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor$JvmDescriptorBasedSignatureBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1068#2:129\n1807#2,3:130\n*S KotlinDebug\n*F\n+ 1 JvmIdSignatureDescriptor.kt\norg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor$JvmDescriptorBasedSignatureBuilder\n*L\n87#1:129\n95#1:130,3\n*E\n"})
    private final class JvmDescriptorBasedSignatureBuilder
    extends IdSignatureDescriptor.DescriptorBasedSignatureBuilder {
        @Nullable
        private IdSignature.FileSignature storedFileSignature;

        public JvmDescriptorBasedSignatureBuilder(SpecialDeclarationType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(type);
        }

        @Override
        @Nullable
        protected IdSignature.FileSignature getCurrentFileSignature() {
            IdSignature.FileSignature fileSignature = JvmIdSignatureDescriptor.this.externallyGivenFileSignature;
            if (fileSignature == null) {
                fileSignature = this.storedFileSignature;
            }
            return fileSignature;
        }

        @Override
        protected void platformSpecificFunction(@NotNull FunctionDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride((CallableMemberDescriptor)descriptor);
            this.computeStoredFileSignature((DeclarationDescriptorWithSource)descriptor);
        }

        @Override
        protected void platformSpecificClass(@NotNull ClassDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.computeStoredFileSignature((DeclarationDescriptorWithSource)descriptor);
        }

        @Override
        protected void platformSpecificProperty(@NotNull PropertyDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.setSpecialJavaProperty(descriptor instanceof JavaForKotlinOverridePropertyDescriptor);
            this.setSyntheticJavaProperty(descriptor instanceof SyntheticJavaPropertyDescriptor);
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride((CallableMemberDescriptor)descriptor);
            this.computeStoredFileSignature((DeclarationDescriptorWithSource)descriptor);
        }

        @Override
        protected void platformSpecificGetter(@NotNull PropertyGetterDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride((CallableMemberDescriptor)descriptor);
            this.computeStoredFileSignature((DeclarationDescriptorWithSource)descriptor);
        }

        @Override
        protected void platformSpecificSetter(@NotNull PropertySetterDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride((CallableMemberDescriptor)descriptor);
            this.computeStoredFileSignature((DeclarationDescriptorWithSource)descriptor);
        }

        @Override
        protected void platformSpecificAlias(@NotNull TypeAliasDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.computeStoredFileSignature((DeclarationDescriptorWithSource)descriptor);
        }

        @Override
        protected void platformSpecificModule(@NotNull ModuleDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        }

        private final void keepTrackOfOverridesForPossiblyClashingFakeOverride(CallableMemberDescriptor descriptor) {
            Collection collection;
            if (descriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor containingClass = classDescriptor;
            declarationDescriptor = descriptor;
            if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
                MemberScope memberScope = containingClass.getUnsubstitutedMemberScope();
                Name name = ((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty().getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                collection = memberScope.getContributedVariables(name, (LookupLocation)NoLookupLocation.FROM_BACKEND);
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                MemberScope memberScope = containingClass.getUnsubstitutedMemberScope();
                Name name = ((PropertyDescriptor)descriptor).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                collection = memberScope.getContributedVariables(name, (LookupLocation)NoLookupLocation.FROM_BACKEND);
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                MemberScope memberScope = containingClass.getUnsubstitutedMemberScope();
                Name name = ((FunctionDescriptor)descriptor).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                collection = memberScope.getContributedFunctions(name, (LookupLocation)NoLookupLocation.FROM_BACKEND);
            } else {
                throw new AssertionError((Object)("Unexpected CallableMemberDescriptor: " + descriptor));
            }
            Collection possiblyClashingMembers = collection;
            if (possiblyClashingMembers.size() <= 1) {
                return;
            }
            List capturingOverrides = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)DescriptorUtilsKt.overriddenTreeAsSequence((CallableMemberDescriptor)descriptor, (boolean)true), arg_0 -> JvmDescriptorBasedSignatureBuilder.keepTrackOfOverridesForPossiblyClashingFakeOverride$lambda$0(this, arg_0)));
            if (!((Collection)capturingOverrides).isEmpty()) {
                Iterable $this$sortedBy$iv = capturingOverrides;
                boolean $i$f$sortedBy = false;
                this.setOverridden(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)a;
                        boolean bl = false;
                        DeclarationDescriptor declarationDescriptor = it.getContainingDeclaration();
                        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        it = (CallableMemberDescriptor)b;
                        Comparable comparable = (Comparable)((Object)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)((ClassDescriptor)declarationDescriptor))).asString());
                        bl = false;
                        DeclarationDescriptor declarationDescriptor2 = it.getContainingDeclaration();
                        Intrinsics.checkNotNull((Object)declarationDescriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)((ClassDescriptor)declarationDescriptor2))).asString())));
                    }
                }));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCapturingTypeParameter(CallableMemberDescriptor member) {
            ValueParameterDescriptor it;
            boolean bl;
            ReceiverParameterDescriptor receiverParameterDescriptor = member.getExtensionReceiverParameter();
            if (receiverParameterDescriptor != null) {
                if (this.isCapturingTypeParameter((ParameterDescriptor)receiverParameterDescriptor)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            List list = member.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (ValueParameterDescriptor)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
            } while (!this.isCapturingTypeParameter((ParameterDescriptor)it));
            return true;
        }

        private final boolean isCapturingTypeParameter(ParameterDescriptor $this$isCapturingTypeParameter) {
            KotlinType kotlinType = $this$isCapturingTypeParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            return TypeUtilsKt.contains((KotlinType)kotlinType, JvmDescriptorBasedSignatureBuilder::isCapturingTypeParameter$lambda$1);
        }

        private final void computeStoredFileSignature(DeclarationDescriptorWithSource descriptor) {
            if (this.isTopLevelPrivate() && JvmIdSignatureDescriptor.this.externallyGivenFileSignature == null) {
                String string;
                SourceFile sourceFile = descriptor.getSource().getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)sourceFile, (String)"getContainingFile(...)");
                FqName fqName = DescriptorUtilKt.containingPackage((DeclarationDescriptor)((DeclarationDescriptor)descriptor));
                if (fqName == null) {
                    fqName = FqName.ROOT;
                }
                if ((string = descriptor.getSource().getContainingFile().getName()) == null) {
                    string = "unknown";
                }
                this.storedFileSignature = new IdSignature.FileSignature(sourceFile, fqName, string);
            }
        }

        @Nullable
        public final IdSignature.FileSignature getStoredFileSignature() {
            return this.storedFileSignature;
        }

        public final void setStoredFileSignature(@Nullable IdSignature.FileSignature fileSignature) {
            this.storedFileSignature = fileSignature;
        }

        private static final boolean keepTrackOfOverridesForPossiblyClashingFakeOverride$lambda$0(JvmDescriptorBasedSignatureBuilder this$0, CallableMemberDescriptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && this$0.isCapturingTypeParameter(it);
        }

        private static final boolean isCapturingTypeParameter$lambda$1(UnwrappedType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ClassifierDescriptor descriptor = it.getConstructor().getDeclarationDescriptor();
            return descriptor instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)descriptor).getContainingDeclaration() instanceof ClassDescriptor;
        }
    }
}

