/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.rendering.ContextIndependentParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/IrDiagnosticRenderers;", "", "<init>", "()V", "SYMBOL_OWNER_DECLARATION_FQ_NAME", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getSYMBOL_OWNER_DECLARATION_FQ_NAME", "()Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getDECLARATION_NAME", "DECLARATION_KIND", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getDECLARATION_KIND", "DECLARATION_KIND_AND_NAME", "getDECLARATION_KIND_AND_NAME", "ir.tree"})
public final class IrDiagnosticRenderers {
    @NotNull
    public static final IrDiagnosticRenderers INSTANCE = new IrDiagnosticRenderers();
    @NotNull
    private static final ContextIndependentParameterRenderer<IrSymbol> SYMBOL_OWNER_DECLARATION_FQ_NAME = DiagnosticParameterRendererKt.Renderer(IrDiagnosticRenderers::SYMBOL_OWNER_DECLARATION_FQ_NAME$lambda$0);
    @NotNull
    private static final ContextIndependentParameterRenderer<IrDeclarationWithName> DECLARATION_NAME = DiagnosticParameterRendererKt.Renderer(IrDiagnosticRenderers::DECLARATION_NAME$lambda$0);
    @NotNull
    private static final ContextIndependentParameterRenderer<IrDeclaration> DECLARATION_KIND = DiagnosticParameterRendererKt.Renderer(IrDiagnosticRenderers::DECLARATION_KIND$lambda$0);
    @NotNull
    private static final ContextIndependentParameterRenderer<IrDeclaration> DECLARATION_KIND_AND_NAME = DiagnosticParameterRendererKt.Renderer(IrDiagnosticRenderers::DECLARATION_KIND_AND_NAME$lambda$0);

    private IrDiagnosticRenderers() {
    }

    @NotNull
    public final ContextIndependentParameterRenderer<IrSymbol> getSYMBOL_OWNER_DECLARATION_FQ_NAME() {
        return SYMBOL_OWNER_DECLARATION_FQ_NAME;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<IrDeclarationWithName> getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<IrDeclaration> getDECLARATION_KIND() {
        return DECLARATION_KIND;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<IrDeclaration> getDECLARATION_KIND_AND_NAME() {
        return DECLARATION_KIND_AND_NAME;
    }

    private static final String SYMBOL_OWNER_DECLARATION_FQ_NAME$lambda$0(IrSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrSymbolOwner irSymbolOwner = it.getOwner();
        Object object = irSymbolOwner instanceof IrDeclarationWithName ? (IrDeclarationWithName)irSymbolOwner : null;
        if (object == null || (object = IrUtilsKt.getFqNameWithoutFileClassesWhenAvailable((IrDeclarationWithName)object)) == null || (object = object.asString()) == null) {
            object = "unknown name";
        }
        return object;
    }

    private static final String DECLARATION_NAME$lambda$0(IrDeclarationWithName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final String DECLARATION_KIND$lambda$0(IrDeclaration declaration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrDeclaration irDeclaration = declaration;
        if (irDeclaration instanceof IrSimpleFunction) {
            string = IrDeclarationsKt.isPropertyAccessor((IrFunction)declaration) ? "property accessor" : "function";
        } else if (irDeclaration instanceof IrConstructor) {
            string = "constructor";
        } else if (irDeclaration instanceof IrProperty) {
            string = "property";
        } else if (irDeclaration instanceof IrClass) {
            string = ((IrClass)declaration).getKind().getCodeRepresentation();
            if (string == null) {
                string = "declaration";
            }
        } else {
            string = "declaration";
        }
        return string;
    }

    private static final String DECLARATION_KIND_AND_NAME$lambda$0(IrDeclaration declaration) {
        IrDeclarationWithName irDeclarationWithName;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return DECLARATION_KIND.render((Object)declaration) + " '" + ((irDeclarationWithName = declaration instanceof IrDeclarationWithName ? (IrDeclarationWithName)declaration : null) != null && (irDeclarationWithName = IrUtilsKt.getFqNameWhenAvailable(irDeclarationWithName)) != null ? irDeclarationWithName.asString() : null) + '\'';
    }
}

