/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.IrVerificationMode;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.SourceRangeInfo;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.validation.IrValidationError;
import org.jetbrains.kotlin.ir.validation.IrValidationException;
import org.jetbrains.kotlin.ir.validation.IrValidator;
import org.jetbrains.kotlin.ir.validation.IrValidatorConfig;
import org.jetbrains.kotlin.ir.validation.checkers.CheckTreeConsistencyVisitorKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrTreeConsistencyException;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 4, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t\u001aT\u0010\u0000\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u001aF\u0010\u0000\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u001a.\u0010\u0015\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u001a\u001e\u0010\u0018\u001a\u00020\u0011*\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a8\u0006\u0019"}, d2={"validateIr", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "validatorConfig", "Lorg/jetbrains/kotlin/ir/validation/IrValidatorConfig;", "reportError", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/validation/IrValidationError;", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "phaseName", "", "customMessagePrefix", "mode", "Lorg/jetbrains/kotlin/config/IrVerificationMode;", "report", "error", "severity", "render", "ir.validation"})
public final class IrValidatorKt {
    public static final void validateIr(@NotNull IrElement element, @NotNull IrBuiltIns irBuiltIns, @NotNull IrValidatorConfig validatorConfig, @NotNull Function1<? super IrValidationError, Unit> reportError) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)validatorConfig, (String)"validatorConfig");
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        if (validatorConfig.getCheckTreeConsistency() || validatorConfig.getCheckUnboundSymbols()) {
            try {
                CheckTreeConsistencyVisitorKt.checkTreeConsistency(element, reportError, validatorConfig);
            }
            catch (IrTreeConsistencyException irTreeConsistencyException) {
                return;
            }
        }
        if (!((Collection)validatorConfig.getCheckers()).isEmpty()) {
            IrValidator validator = new IrValidator(validatorConfig, irBuiltIns, reportError);
            IrVisitorsKt.acceptVoid(element, validator);
        }
    }

    public static final boolean validateIr(@NotNull IrElement element, @NotNull IrBuiltIns irBuiltIns, @NotNull IrValidatorConfig validatorConfig, @NotNull MessageCollector messageCollector, @NotNull Function1<? super IrValidationError, ? extends CompilerMessageSeverity> getSeverity, @Nullable String phaseName, @Nullable String customMessagePrefix) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)validatorConfig, (String)"validatorConfig");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter(getSeverity, (String)"getSeverity");
        Ref.BooleanRef hasAnyViolations = new Ref.BooleanRef();
        Ref.BooleanRef hasAnyErrors = new Ref.BooleanRef();
        IrValidatorKt.validateIr(element, irBuiltIns, validatorConfig, (Function1<? super IrValidationError, Unit>)((Function1)arg_0 -> IrValidatorKt.validateIr$lambda$0(getSeverity, phaseName, messageCollector, customMessagePrefix, hasAnyViolations, hasAnyErrors, arg_0)));
        if (hasAnyErrors.element) {
            throw new IrValidationException(null, null, 3, null);
        }
        return hasAnyViolations.element;
    }

    public static /* synthetic */ boolean validateIr$default(IrElement irElement, IrBuiltIns irBuiltIns, IrValidatorConfig irValidatorConfig, MessageCollector messageCollector, Function1 function1, String string, String string2, int n, Object object) {
        if ((n & 0x20) != 0) {
            string = null;
        }
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        return IrValidatorKt.validateIr(irElement, irBuiltIns, irValidatorConfig, messageCollector, (Function1<? super IrValidationError, ? extends CompilerMessageSeverity>)function1, string, string2);
    }

    public static final boolean validateIr(@NotNull IrElement element, @NotNull IrBuiltIns irBuiltIns, @NotNull IrValidatorConfig validatorConfig, @NotNull MessageCollector messageCollector, @NotNull IrVerificationMode mode, @Nullable String phaseName, @Nullable String customMessagePrefix) {
        CompilerMessageSeverity compilerMessageSeverity;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)validatorConfig, (String)"validatorConfig");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                break;
            }
            case 3: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        CompilerMessageSeverity severity = compilerMessageSeverity;
        return IrValidatorKt.validateIr(element, irBuiltIns, validatorConfig, messageCollector, (Function1<? super IrValidationError, ? extends CompilerMessageSeverity>)((Function1)arg_0 -> IrValidatorKt.validateIr$lambda$1(severity, arg_0)), phaseName, customMessagePrefix);
    }

    public static /* synthetic */ boolean validateIr$default(IrElement irElement, IrBuiltIns irBuiltIns, IrValidatorConfig irValidatorConfig, MessageCollector messageCollector, IrVerificationMode irVerificationMode, String string, String string2, int n, Object object) {
        if ((n & 0x20) != 0) {
            string = null;
        }
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        return IrValidatorKt.validateIr(irElement, irBuiltIns, irValidatorConfig, messageCollector, irVerificationMode, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void report(@NotNull MessageCollector $this$report, @NotNull IrValidationError error, @NotNull CompilerMessageSeverity severity, @Nullable String phaseName, @Nullable String customMessagePrefix) {
        CompilerMessageLocation compilerMessageLocation;
        Intrinsics.checkNotNullParameter((Object)$this$report, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        MessageCollector messageCollector = $this$report;
        CompilerMessageSeverity compilerMessageSeverity = severity;
        String string = IrValidatorKt.render(error, phaseName, customMessagePrefix);
        IrFile irFile = error.getFile();
        if (irFile != null) {
            void it;
            IrFile irFile2 = irFile;
            String string2 = string;
            CompilerMessageSeverity compilerMessageSeverity2 = compilerMessageSeverity;
            MessageCollector messageCollector2 = messageCollector;
            boolean bl = false;
            SourceRangeInfo sourceRangeInfo = it.getFileEntry().getSourceRangeInfo(error.getElement().getStartOffset(), error.getElement().getEndOffset());
            CompilerMessageLocation compilerMessageLocation2 = CompilerMessageLocation.Companion.create(sourceRangeInfo.getFilePath(), sourceRangeInfo.getStartLineNumber() + 1, sourceRangeInfo.getStartColumnNumber() + 1, null);
            messageCollector = messageCollector2;
            compilerMessageSeverity = compilerMessageSeverity2;
            string = string2;
            compilerMessageLocation = compilerMessageLocation2;
        } else {
            compilerMessageLocation = null;
        }
        messageCollector.report(compilerMessageSeverity, string, (CompilerMessageSourceLocation)compilerMessageLocation);
    }

    @NotNull
    public static final String render(@NotNull IrValidationError $this$render, @Nullable String phaseName, @Nullable String customMessagePrefix) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        StringBuilder $this$render_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        CharSequence charSequence = phaseName;
        String phaseMessage = !(charSequence == null || charSequence.length() == 0) ? phaseName + ": " : "";
        String customMessagePrefix2 = customMessagePrefix;
        if (customMessagePrefix2 == null) {
            $this$render_u24lambda_u240.append("[IR VALIDATION] ");
            stringBuilder = $this$render_u24lambda_u240.append(phaseMessage);
        } else {
            $this$render_u24lambda_u240.append(customMessagePrefix2);
            stringBuilder = $this$render_u24lambda_u240.append(" ");
        }
        $this$render_u24lambda_u240.append($this$render.getMessage()).append('\n');
        $this$render_u24lambda_u240.append(RenderIrElementKt.render$default($this$render.getElement(), null, 1, null));
        Iterator iterator = ((Iterable)CollectionsKt.asReversed($this$render.getParentChain())).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            IrElement parent = (IrElement)iterator.next();
            $this$render_u24lambda_u240.append('\n');
            $this$render_u24lambda_u240.append(StringsKt.repeat((CharSequence)"  ", (int)(i + 1)));
            $this$render_u24lambda_u240.append("inside ");
            $this$render_u24lambda_u240.append(RenderIrElementKt.render$default(parent, null, 1, null));
        }
        return stringBuilder2.toString();
    }

    private static final Unit validateIr$lambda$0(Function1 $getSeverity, String $phaseName, MessageCollector $messageCollector, String $customMessagePrefix, Ref.BooleanRef $hasAnyViolations, Ref.BooleanRef $hasAnyErrors, IrValidationError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        CompilerMessageSeverity severity = (CompilerMessageSeverity)$getSeverity.invoke((Object)error);
        if (severity != null) {
            CharSequence charSequence = $phaseName;
            String phaseMessage = !(charSequence == null || charSequence.length() == 0) ? $phaseName + ": " : "";
            IrValidatorKt.report($messageCollector, error, severity, $phaseName, $customMessagePrefix);
            $hasAnyViolations.element = true;
        }
        if (severity == CompilerMessageSeverity.ERROR) {
            $hasAnyErrors.element = true;
        }
        return Unit.INSTANCE;
    }

    private static final CompilerMessageSeverity validateIr$lambda$1(CompilerMessageSeverity $severity, IrValidationError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $severity;
    }

    @Metadata(mv={2, 4, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrVerificationMode.values().length];
            try {
                nArray[IrVerificationMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrVerificationMode.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrVerificationMode.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

