/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.validation.checkers.CheckerUtilsKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrElementChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/expression/IrCallTypeChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrElementChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "<init>", "()V", "check", "", "element", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "ir.validation"})
public final class IrCallTypeChecker
extends IrElementChecker<IrCall> {
    @NotNull
    public static final IrCallTypeChecker INSTANCE = new IrCallTypeChecker();

    private IrCallTypeChecker() {
        super(Reflection.getOrCreateKotlinClass(IrCall.class));
    }

    @Override
    public void check(@NotNull IrCall element, @NotNull CheckerContext context2) {
        IrSimpleFunction actualCallee;
        IrType returnType;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrSimpleFunction callee = (IrSimpleFunction)element.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrOverridableDeclaration)callee, IrCallTypeChecker::check$lambda$0);
        if (irSimpleFunction == null) {
            irSimpleFunction = callee;
        }
        if ((returnType = (actualCallee = irSimpleFunction).getReturnType()) instanceof IrSimpleType && ((IrSimpleType)returnType).getClassifier() instanceof IrClassSymbol && ((IrSimpleType)returnType).getArguments().isEmpty()) {
            CheckerUtilsKt.ensureTypeIs(this, element, callee.getReturnType(), context2);
        }
    }

    private static final boolean check$lambda$0(IrSimpleFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFakeOverride() || !(IrTypesKt.getClassifierOrNull(it.getReturnType()) instanceof IrTypeParameterSymbol);
    }
}

